/* pbmtocbm.c - read a portable bitmap and produce a compact bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits;
    int rows, cols, row, col;

    if ( argc > 2 )
	{
	fprintf( stderr, "usage:  %s [pbmfile]\n", argv[0] );
	exit( 1 );
	}

    if ( argc == 2 )
	{
        ifd = fopen( argv[1], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[1] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;

    bits = pbm_readpbm( ifd, &cols, &rows );

    if ( ifd != stdin )
	fclose( ifd );
    
    putchar( (char) 42 );
    putchar( (char) 23 );
    putchar( (char) ( ( cols >> 8 ) & 0xff ) );
    putchar( (char) ( cols & 0xff ) );
    putchar( (char) ( ( rows >> 8 ) & 0xff ) );
    putchar( (char) ( rows & 0xff ) );

    putinit( );
    for ( row = 0; row < rows; row++ )
        for ( col = 0; col < cols; col++ )
	    putbit( bits[row][col] );
    putrest( );

    exit( 0 );
    }


int item, bitsperitem, bitshift;

putinit( )
    {
    bitsperitem = 0;
    item = 0;
    bitshift = 7;
    }

putbit( b )
bit b;
    {
    if ( bitsperitem == 8 )
	putitem( );
    bitsperitem++;
    if ( b )
	item += 1 << bitshift;
    bitshift--;
    }

putrest( )
    {
    if ( bitsperitem > 0 )
	putitem( );
    }

putitem( )
    {
    putchar( (char) item );
    bitsperitem = 0;
    item = 0;
    bitshift = 7;
    }
