/* pbmpaste.c - paste a rectangle into a portable bitmap
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    FILE *ifd;
    bit **bits1, **bits2;
    int rows1, cols1, x, y, rows2, cols2, row, col;
    char *usage = "usage:  %s frompbmfile x y [intopbmfile]\n";


    if ( argc < 4 || argc > 5 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    ifd = fopen( argv[1], "r" );
    if ( ifd == NULL )
	{
	fprintf( stderr, "%s: can't open.\n", argv[1] );
	exit( 1 );
	}
    bits1 = pbm_readpbm( ifd, &cols1, &rows1 );
    fclose( ifd );

    if ( sscanf( argv[2], "%d", &x ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[3], "%d", &y ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    if ( x < 0 )
	{
	fprintf( stderr, "x is less than 0\n" );
	exit( 1 );
	}
    if ( y < 0 )
	{
	fprintf( stderr, "y is less than 0\n" );
	exit( 1 );
	}

    if ( argc == 5 )
	{
        ifd = fopen( argv[4], "r" );
        if ( ifd == NULL )
	    {
	    fprintf( stderr, "%s: can't open.\n", argv[4] );
	    exit( 1 );
	    }
	}
    else
	ifd = stdin;
    bits2 = pbm_readpbm( ifd, &cols2, &rows2 );
    if ( ifd != stdin )
	fclose( ifd );

    if ( x >= cols2 )
	{
	fprintf(
	    stderr, "x is too large -- the second bitmap has only %d cols\n",
	    cols2 );
	exit( 1 );
	}
    if ( y >= rows2 )
	{
	fprintf(
	    stderr, "y is too large -- the second bitmap has only %d rows\n",
	    rows2 );
	exit( 1 );
	}
    if ( x + cols1 > cols2 )
	{
	fprintf(
	    stderr, "x + width is too large by %d pixels\n",
	    x + cols1 - cols2 );
	exit( 1 );
	}
    if ( y + rows1 > rows2 )
	{
	fprintf(
	    stderr, "y + height is too large by %d pixels\n",
	    y + rows1 - rows2 );
	exit( 1 );
	}

    for ( row = 0; row < rows1; row++ )
        for ( col = 0; col < cols1; col++ )
	    bits2[row+y][col+x] = bits1[row][col];

    pbm_writepbm( stdout, bits2, cols2, rows2 );

    exit( 0 );
    }
