/* pbmmake.c - create a blank bitmap of a specified size
**
** Copyright (C) 1988 by Jef Poskanzer.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>
#include "pbm.h"

main( argc, argv )
int argc;
char *argv[];
    {
    bit **bits;
    int rows, cols, row, col;
    char *usage = "usage:  %s <width> <height>\n";

    if ( argc != 3 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    if ( sscanf( argv[1], "%d", &cols ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}
    if ( sscanf( argv[2], "%d", &rows ) != 1 )
	{
	fprintf( stderr, usage, argv[0] );
	exit( 1 );
	}

    bits = pbm_allocarray( cols, rows );

    for ( row = 0; row < rows; row++ )
        for ( col = 0; col < cols; col++ )
	    bits[row][col] = 0;

    pbm_writepbm( stdout, bits, cols, rows );

    exit( 0 );
    }
