/**************************************************************************
 *      name - prints random names                                        * 
 *  Copyright 1988 by Brett Slocum.  All rights reserved.                 *
 *  Permission is granted to distribute, modify, or use portions of this  *
 *  code in other programs, as long as this copyright notice remains      *
 *  intact.  This program may not be sold for profit without permission.  *
 **************************************************************************/

#ifdef SYSV
#include <string.h>
#define srandom srand48
#define random lrand48
#else
#include <strings.h>
#endif

#define YES 1
#define NO 0
#define MAXNAME 100
#define MINLENGTH 3
#define RANGE 6

 char vowels[] = "aeiouy";
 char cons[] = "bcdfghjklmnpqrstvwxyz";

main(argc, argv)  
int argc;
char *argv[];
{
     int n, letters, vowel;
     char name[MAXNAME];

     if (argc == 2) {
         srandom(time(0L));
         for (n = atoi(argv[1]); n > 0; n--) {
             strcpy(name, "");
             vowel =  (rnd(2) ? YES : NO);
             for (letters = rnd(RANGE) + MINLENGTH; letters > 0; letters--) {
                 if (vowel) 
                     chrcat(name, vowels[rnd(strlen(vowels))]);
                 else 
                     chrcat(name, cons[rnd(strlen(cons))]);
                 vowel = ( vowel ? NO : YES );
             }
             name[0] = upper(name[0]);
             printf("%s\n", name);
         }
     }
     else 
         usage();
}

chrcat(str, chr)  /* concat a string with a char */
char str[], chr;
{
     int i;

     i = strlen(str);
     str[i++] = chr;
     str[i] = '\0';
}

rnd(num)  /* generates a random number between 0 and num-1 */
int num;
{
     long random();

     return((unsigned) random() % (unsigned) num);
}

upper(c)  /* return upper case of c */
int c;
{
     if (c >= 'a' && c <= 'z')
         return(c-'a'+'A');
     else
         return(c);
}

usage()  /* print usage statement */
{
     printf("Usage: name [number-of-names]\n");
}
