extern	char	xstr[];
/* CURSIVE FONT FILE
 *
 * This font is copyrighted by Jan Wolter.  See notes in "cursive.c".
 *
 * Several of the letters are rather ugly, but the wonder is not how
 * well it sings.  A few uppercase letters are a bit too tall.  The
 * font has to some extent been chosen to make my name look good to me.
 * Those of you with different names will have to take pot luck, or fix
 * it to taste.  Editing this file must be done with some care.  The
 * numbers on the defines must match the index numbers of the letter
 * in the list[] structure.  The six numbers after the character are how
 * many blank spaces must be added to the beginning of each of the six
 * scan lines to make them line up.  The last two numbers are the scan
 * line numbers in which the character is connected to the preceeding and
 * succeeding characters.  -1 means it isn't.  There are two versions of
 * each lower case letter, one with the line coming in on line 2, and one
 * with the line coming in on line 3.
 */

#include "cursive.h"

struct letter list[] = {

#define LA  0		/* a type 1 */ 
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[1]),
	(&xstr[5]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LB  1		/* b type 1 */
	{ {
	(&xstr[0]),
	  (&xstr[10]),
 	 (&xstr[12]),
	(&xstr[15]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	3,2
	},

#define LC  2		/* c type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[2]),
	(&xstr[19]),
	(&xstr[0]),
	(&xstr[0])}
	,
	{0,0,1,0,0,0},
	3,3
	},

#define LD  3		/* d type 1 */
	{ {
	(&xstr[0]),
	    (&xstr[10]),
	 (&xstr[22]),
	(&xstr[26]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,4,1,0,0,0},
	3,3
	},

#define LE  4		/* e type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[20]),
	(&xstr[30]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LF  5		/* f type 1 */
	{ {
	(&xstr[0]),
	    (&xstr[33]),
	   (&xstr[36]),
	  (&xstr[40]),
	 (&xstr[43]),
	(&xstr[46])
	},
	{0,4,3,2,1,0},
	3,3
	},

#define LG  6		/* g type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[50]),
	(&xstr[53]),
	 (&xstr[7]),
	(&xstr[57])
	},
	{0,0,1,0,1,0},
	3,3
	},

#define LH  7		/* h type 1 */
	{ {
	(&xstr[0]),
	  (&xstr[58]),
	 (&xstr[12]),
	(&xstr[60]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	3,3
	},

#define LI  8		/* i type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[64]),
	(&xstr[66]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LJ  9		/* j type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	    (&xstr[64]),
	   (&xstr[62]),
	  (&xstr[62]),
	(&xstr[68])
	},
	{0,0,4,3,2,0},
	3,3
	},

#define LK 10		/* k type 1 */
	{ {
	(&xstr[0]),
	  (&xstr[62]),
	 (&xstr[71]),
	(&xstr[75]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	3,3
	},

#define LL 11		/* l type 1 */
	{ {
	   (&xstr[20]),
	  (&xstr[40]),
	 (&xstr[40]),
	(&xstr[30]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	3,3
	},

#define LM 12		/* m type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[79]),
	(&xstr[86]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LN 13		/* n type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[81]),
	(&xstr[88]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LO 14		/* o type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[84]),
	(&xstr[53]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,2
	},

#define LP 15		/* p type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	   (&xstr[84]),
	  (&xstr[15]),
	 (&xstr[62]),
	(&xstr[69])
	},
	{0,0,3,2,1,0},
	3,3
	},

#define LQ 16		/* q type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[50]),
	(&xstr[53]),
	 (&xstr[43]),
	(&xstr[57])
	},
	{0,0,1,0,1,0},
	3,3
	},

#define LR 17		/* r type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[83]),
	(&xstr[94]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LS 18		/* s type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[84]),
	(&xstr[15]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LT 19		/* t type 1 */
	{ {
	(&xstr[0]),
	 (&xstr[98]),
	 (&xstr[62]),
	(&xstr[102]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,1,1,0,0,0},
	3,3
	},

#define LU 20		/* u type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[105]),
	(&xstr[26]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LV 21		/* v type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[109]),
	(&xstr[112]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	3,2
	},

#define LW 22		/* w type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[115]),
	(&xstr[121]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LX 23		/* x type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[127]),
	(&xstr[131]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	3,3
	},

#define LY 24		/* y type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[136]),
	(&xstr[142]),
	   (&xstr[146]),
	  (&xstr[69])
	 },
	{0,0,1,0,3,2},
	3,3
	},

#define LZ 25		/* z type 1 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[1]),
	(&xstr[148]),
	  (&xstr[153]),
	(&xstr[0])
	},
	{0,0,1,0,2,0},
	3,3
	},

#define NA 26		/* a type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[1]),
	(&xstr[5]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	2,3
	},

#define NB 27		/* b type 2 */
	{ {
	(&xstr[0]),
	  (&xstr[146]),
	 (&xstr[99]),
	(&xstr[15]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	2,2
	},

#define NC 28		/* c type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[1]),
	(&xstr[19]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define ND 29		/* d type 2 */
	{ {
	(&xstr[0]),
	    (&xstr[146]),
	(&xstr[156]),
	(&xstr[144]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,4,0,0,0,0},
	2,3
	},

#define NE 30		/* e type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[43]),
	(&xstr[19]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	2,3
	},

#define NF 31		/* f type 2 */
	{ {
	(&xstr[0]),
	    (&xstr[33]),
	   (&xstr[40]),
	  (&xstr[99]),
	 (&xstr[43]),
	(&xstr[30])
	},
	{0,4,3,2,1,0},
	2,3
	},

#define NG 32		/* g type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[161]),
	(&xstr[53]),
	 (&xstr[7]),
	(&xstr[57])
	},
	{0,0,0,0,1,0},
	2,3
	},

#define NH 33		/* h type 2 */
	{ {
	(&xstr[0]),
	  (&xstr[159]),
	 (&xstr[99]),
	(&xstr[60]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	2,3
	},

#define NI 34		/* i type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	 (&xstr[64]),
	(&xstr[102]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,1,0,0,0},
	2,3
	},

#define NJ 35		/* j type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	   (&xstr[165]),
	   (&xstr[99]),
	  (&xstr[159]),
	(&xstr[68])
	},
	{0,0,3,3,2,0},
	2,3
	},

#define NK 36		/* k type 2 */
	{ {
	(&xstr[0]),
	  (&xstr[159]),
	 (&xstr[99]),
	(&xstr[90]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	2,3
	},

#define NL 37		/* l type 2 */
	{ {
	  (&xstr[103]),
	 (&xstr[40]),
	(&xstr[57]),
	 (&xstr[134]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,1,0,1,0,0},
	2,3
	},

#define NM 38		/* m type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[168]),
	(&xstr[86]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define NN 39		/* n type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[170]),
	(&xstr[88]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define NO 40		/* o type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[172]),
	(&xstr[53]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,2
	},

#define NP 41		/* p type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	  (&xstr[173]),
	  (&xstr[15]),
	 (&xstr[159]),
	(&xstr[69])
	},
	{0,0,2,2,1,0},
	2,3
	},

#define NQ 42		/* q type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[161]),
	(&xstr[53]),
	 (&xstr[43]),
	(&xstr[57])
	},
	{0,0,0,0,1,0},
	2,3
	},

#define NR 43		/* r type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[176]),
	 (&xstr[96]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,1,0,0},
	2,3
	},

#define NS 44		/* s type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[179]),
	 (&xstr[184]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,1,0,0},
	2,3
	},

#define NT 45		/* t type 2 */
	{ {
	(&xstr[0]),
	 (&xstr[98]),
	(&xstr[158]),
	(&xstr[19]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,1,0,0,0,0},
	2,3
	},

#define NU 46		/* u type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[189]),
	(&xstr[144]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define NV 47		/* v type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[194]),
	(&xstr[112]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define NW 48		/* w type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[198]),
	(&xstr[121]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	2,3
	},

#define NX 49		/* x type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[127]),
	 (&xstr[133]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,1,0,0},
	2,3
	},

#define NY 50		/* y type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[137]),
	(&xstr[205]),
	 (&xstr[159]),
	(&xstr[69])
	},
	{0,0,0,0,1,0},
	2,3
	},

#define NZ 51		/* z type 2 */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[1]),
	  (&xstr[154]),
	 (&xstr[153]),
	(&xstr[0])
	},
	{0,0,0,2,1,0},
	2,3
	},

#define UA 52		/* A */
	{ {
	   (&xstr[208]),
	  (&xstr[211]),
	 (&xstr[216]),
	(&xstr[221]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	3,3
	},

#define UB 53		/* B  */
	{ {
	   (&xstr[208]),
	  (&xstr[211]),
	 (&xstr[226]),
	(&xstr[231]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	3,3
	},

#define UC 54		/* C */
	{ {
	   (&xstr[208]),
	  (&xstr[211]),
	 (&xstr[235]),
	(&xstr[237]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	-1,-1
	},

#define UD 55		/* D  */
	{ {
	   (&xstr[208]),
	  (&xstr[211]),
	 (&xstr[242]),
	(&xstr[247]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	3,3
	},

#define UE 56		/* E */
	{ {
	   (&xstr[208]),
	  (&xstr[252]),
	 (&xstr[257]),
	(&xstr[261]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	-1,-1
	},

#define UF 57		/* F */
	{ {
	   (&xstr[170]),
	   (&xstr[267]),
	 (&xstr[273]),
	(&xstr[144]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,3,1,0,0,0},
	-1,-1
	},

#define UG 58		/* G */
	{ {
	  (&xstr[279]),
	  (&xstr[285]),
	 (&xstr[291]),
	(&xstr[297]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,2,1,0,0,0},
	-1,3
	},

#define UH 59		/* H */
	{ {
	 (&xstr[303]),
	(&xstr[310]),
	 (&xstr[216]),
	(&xstr[221]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,3
	},

#define UI 60		/* I */
	{ {
	     (&xstr[209]),
	    (&xstr[317]),
	(&xstr[321]),
	 (&xstr[328]),
	(&xstr[0]),
	(&xstr[0])
	},
	{5,4,0,1,0,0},
	-1,3
	},

#define UJ 61		/* J */
	{ {
	  (&xstr[172]),
	 (&xstr[334]),
	  (&xstr[248]),
	 (&xstr[60]),
	(&xstr[340]),
	(&xstr[0])
	},
	{2,1,2,1,0,0},
	-1,2
	},

#define UK 62		/* K */
	{ {
	 (&xstr[344]),
	(&xstr[350]),
	 (&xstr[356]),
	(&xstr[360]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,-1
	},

#define UL 63		/* L */
	{ {
	   (&xstr[209]),
	 (&xstr[366]),
	 (&xstr[368]),
	(&xstr[370]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,1,1,0,0,0},
	-1,-1
	},

#define UM 64		/* M */
	{ {
	 (&xstr[375]),
	(&xstr[381]),
	 (&xstr[389]),
	(&xstr[395]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,3
	},

#define UN 65		/* N */
	{ {
	 (&xstr[401]),
	(&xstr[406]),
	 (&xstr[242]),
	(&xstr[221]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,3
	},

#define UO 66		/* O */
	{ {
	   (&xstr[403]),
	  (&xstr[413]),
	 (&xstr[242]),
	(&xstr[237]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	-1,-1
	},

#define UP 67		/* P */
	{ {
	 (&xstr[401]),
	(&xstr[406]),
	 (&xstr[418]),
	(&xstr[393]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,-1
	},

#define UQ 68		/* Q */
	{ {
	   (&xstr[403]),
	  (&xstr[211]),
	 (&xstr[242]),
	(&xstr[423]),
	   (&xstr[255]),
	(&xstr[0])
	},
	{3,2,1,0,3,0},
	-1,-1
	},

#define UR 69		/* R */
	{ {
	 (&xstr[401]),
	(&xstr[406]),
	 (&xstr[418]),
	(&xstr[428]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,3
	},

#define US 70		/* S */
	{ {
	  (&xstr[433]),
	  (&xstr[133]),
	 (&xstr[211]),
	(&xstr[436]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,2,1,0,0,0},
	-1,3
	},

#define UT 71		/* T */
	{ {
	  (&xstr[169]),
	    (&xstr[442]),
	 (&xstr[217]),
	(&xstr[144]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,4,1,0,0,0},
	-1,-1
	},

#define UU 72		/* U */
	{ {
	 (&xstr[446]),
	(&xstr[310]),
	 (&xstr[242]),
	(&xstr[237]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,0
	},

#define UV 73		/* V */
	{ {
	 (&xstr[453]),
	(&xstr[310]),
	 (&xstr[459]),
	  (&xstr[425]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,2,0,0},
	-1,0
	},

#define UW 74		/* W */
	{ {
	 (&xstr[464]),
	(&xstr[471]),
	 (&xstr[389]),
	(&xstr[121]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,1,0,0,0},
	-1,0
	},

#define UX 75		/* X */
	{ {
	 (&xstr[344]),
	(&xstr[479]),
	   (&xstr[485]),
	  (&xstr[330]),
	(&xstr[0]),
	(&xstr[0])
	},
	{1,0,3,2,0,0},
	-1,3
	},

#define UY 76		/* Y */
	{ {
	 (&xstr[303]),
	(&xstr[310]),
	 (&xstr[242]),
	(&xstr[237]),
	 (&xstr[367]),
	(&xstr[487])
	},
	{1,0,1,0,1,0},
	-1,3
	},

#define UZ 77		/* Z */
	{ {
	(&xstr[371]),
	  (&xstr[488]),
	 (&xstr[488]),
	(&xstr[207]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,1,0,0,0},
	-1,-1
	},

#define PE 78	 	/* ! */
	{ {
	   (&xstr[488]),
	  (&xstr[488]),
	 (&xstr[421]),
	(&xstr[166]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,2,1,0,0,0},
	-1,-1
	},

#define PU 79		/* " */
	{ {
	(&xstr[490]),
	(&xstr[494]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	},

#define PX 80		/* # */
	{ {
	   (&xstr[391]),
	 (&xstr[498]),
	(&xstr[498]),
	(&xstr[391]),
	(&xstr[0]),
	(&xstr[0])
	},
	{3,1,0,0,0,0},
	-1,-1
	},

#define PK 81		/* $ */
	{ {
	  (&xstr[504]),
	 (&xstr[144]),
	  (&xstr[509]),
	(&xstr[513]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,1,2,0,0,0},
	-1,-1
	},

#define PF 82		/* ' */
	{ {
	(&xstr[492]),
	(&xstr[516]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	},

#define PC 83		/* , */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[492]),
	(&xstr[516]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	},

#define PM 84		/* - */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[518]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	},

#define PP 85		/* . */
	{ {
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[492]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	},

#define PD 86		/* : */
	{ {
	(&xstr[0]),
	  (&xstr[492]),
	(&xstr[0]),
	(&xstr[492]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,2,0,0,0,0},
	-1,-1
	},

#define PS 87		/* ; */
	{ {
	(&xstr[0]),
	  (&xstr[492]),
	(&xstr[0]),
	(&xstr[492]),
	(&xstr[516]),
	(&xstr[0])
	},
	{0,2,0,0,0,0},
	-1,-1
	},

#define PQ 88		/* ? */
	{ {
	  (&xstr[403]),
	  (&xstr[522]),
	 (&xstr[488]),
	(&xstr[492]),
	(&xstr[0]),
	(&xstr[0])
	},
	{2,2,1,0,0,0},
	-1,-1
	},

#define PB 89		/* ` */
	{ {
	(&xstr[492]),
	(&xstr[255]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0]),
	(&xstr[0])
	},
	{0,0,0,0,0,0},
	-1,-1
	}
	};

short code1[] = {
     /*  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 */
	XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX,
	XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX,
	SP, PE, PU, PX, PK, XX, XX, PF, XX, XX, XX, XX, PC, PM, PP, XX,
	SN, SN, SN, SN, SN, SN, SN, SN, SN, SN, PD, PS, XX, XX, XX, PQ,
	XX, UA, UB, UC, UD, UE, UF, UG, UH, UI, UJ, UK, UL, UM, UN, UO,
	UP, UQ, UR, US, UT, UU, UV, UW, UX, UY, UZ, XX, XX, XX, XX, ST,
	PB, LA, LB, LC, LD, LE, LF, LG, LH, LI, LJ, LK, LL, LM, LN, LO,
	LP, LQ, LR, LS, LT, LU, LV, LW, LX, LY, LZ, XX, XX, XX, XX, XX };

short code2[] = {
     /*  0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 */
	XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX,
	XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX, XX,
	SP, PE, PU, PX, PK, XX, XX, PF, XX, XX, XX, XX, PC, PM, PP, XX,
	SN, SN, SN, SN, SN, SN, SN, SN, SN, SN, PD, PS, XX, XX, XX, PQ,
	XX, UA, UB, UC, UD, UE, UF, UG, UH, UI, UJ, UK, UL, UM, UN, UO,
	UP, UQ, UR, US, UT, UU, UV, UW, UX, UY, UZ, XX, XX, XX, XX, ST,
	PB, NA, NB, NC, ND, NE, NF, NG, NH, NI, NJ, NK, NL, NM, NN, NO,
	NP, NQ, NR, NS, NT, NU, NV, NW, NX, NY, NZ, XX, XX, XX, XX, XX };
