/*
 * main.c
 *
 * Frotz V2.01 main function
 *
 * This is an interpreter for Infocom V1 to V6 games. It also supports
 * the recently defined V7 and V8 games. Please report bugs to
 *
 *    jokisch@ls7.informatik.uni-dortmund.de
 *
 * Frotz is freeware. It may be used and distributed freely provided
 * no commercial profit is involved. (c) 1995, 1996 Stefan Jokisch
 *
 */

#include "frotz.h"

#ifdef __MSDOS__
#define CDECL cdecl
#else
#define CDECL
#endif

#define DEFAULT_ATTRIBUTE_TESTING 0
#define DEFAULT_ATTRIBUTE_ASSIGNMENT 0
#define DEFAULT_CONTEXT_LINES 0
#define DEFAULT_OBJECT_LOCATING	0
#define DEFAULT_OBJECT_MOVEMENT 0
#define DEFAULT_LEFT_MARGIN 0
#define DEFAULT_RIGHT_MARGIN 0
#define DEFAULT_PIRACY 0
#define DEFAULT_UNDO_SLOTS 20

/* Story file header data */

zbyte h_version = 0;
zbyte h_config = 0;
zword h_release = 0;
zword h_resident_size = 0;
zword h_start_pc = 0;
zword h_dictionary = 0;
zword h_objects = 0;
zword h_globals = 0;
zword h_dynamic_size = 0;
zword h_flags = 0;
zbyte h_serial[6] = { 0, 0, 0, 0, 0, 0 };
zword h_abbreviations = 0;
zword h_file_size = 0;
zword h_checksum = 0;
zbyte h_interpreter_number = 0;
zbyte h_interpreter_version = 0;
zbyte h_screen_rows = 0;
zbyte h_screen_cols = 0;
zword h_screen_width = 0;
zword h_screen_height = 0;
zbyte h_font_height = 1;
zbyte h_font_width = 1;
zword h_functions_offset = 0;
zword h_strings_offset = 0;
zbyte h_default_background = 0;
zbyte h_default_foreground = 0;
zword h_terminating_keys = 0;
zword h_line_width = 0;
zbyte h_standard_high = 0;
zbyte h_standard_low = 2;
zword h_alphabet = 0;
zword h_mouse_table = 0;
zbyte h_user_name[8] = { 0, 0, 0, 0, 0, 0, 0, 0 };

/* Story file name and size */

char *story_name = 0;
long story_size = 0;

/* Stack data */

zword stack[STACK_SIZE];
zword sp = 0;
zword fp = 0;

/* Mouse data */

int mouse_x = 0;
int mouse_y = 0;

/* Workarounds for specific problems */

int german_zork_flag = 0;
int beyond_zork_flag = 0;
int input_flag = 0;
int undo_flag = 0;

/* Window attributes */

int enable_wrapping = 0;
int enable_scripting = 0;
int enable_scrolling = 0;
int enable_buffering = 0;

/* Current window */

int cwin = 0;

/* User options */

int option_attribute_assignment = DEFAULT_ATTRIBUTE_ASSIGNMENT;
int option_attribute_testing = DEFAULT_ATTRIBUTE_TESTING;
int option_context_lines = DEFAULT_CONTEXT_LINES;
int option_object_locating = DEFAULT_OBJECT_LOCATING;
int option_object_movement = DEFAULT_OBJECT_MOVEMENT;
int option_left_margin = DEFAULT_LEFT_MARGIN;
int option_right_margin = DEFAULT_RIGHT_MARGIN;
int option_piracy = DEFAULT_PIRACY;
int option_undo_slots = DEFAULT_UNDO_SLOTS;

/* Size of memory to reserve (in bytes) */

long reserve_mem = 0;

/*
 * z_piracy
 *
 * Branch if the story file is not a pirated copy. This opcode was
 * never actually used by any game (the other unused opcodes being
 * art_shift and nop).
 *
 */

void z_piracy (void)
{

    branch (option_piracy == 0);

}/* z_piracy */

/*
 * main
 *
 * Prepare and run the game.
 *
 */

int CDECL main (int argc, char *argv[])
{

    os_process_arguments (argc, argv);

    init_memory ();

    os_init_screen ();

    init_undo ();

    z_restart ();

    interpret ();

    reset_memory ();

    os_reset_screen ();

    reset_undo ();

    return 0;

}/* main */
