/* Automatically generated by Scott2Java */
import java.util.Random;

public class AdventureGame {
	/* Game Data */
	final boolean ScottLight=false;
	final boolean Trash80=false;
	final boolean OldLamp=false;
	final boolean UseYou=false;

	final char PlayerRoom=1;
	final int Actions=190;
	final int NumNouns=90;
	final int NumVerbs=90;
	final int NumRooms=26;
	final int Carry=9;
	final int Treasures=0;
	final int WordLength=3;
	final int LightRefill=15000;
	final int NumMessages=100;
	final char TreasureRoom=0;
	final int NumObjects=66;

	final char[] ObjectStarts={
		4,0,8,5,2,3,0,12,
		2,0,9,0,15,0,0,19,
		7,1,6,0,10,14,13,0,
		4,0,17,0,0,0,8,0,
		16,12,0,18,17,0,17,11,
		0,0,0,15,22,0,14,0,
		0,19,0,0,0,20,0,0,
		11,12,21,0,21,8,8,0,
		23,0
	};
	final String[] ObjectNames={
		"Bloody Knife", 
		"Ledge", 
		"Plaque", 
		"Animal heads", 
		"Broken glass", 
		"Big kettle", 
		"Dark hole", 
		"Shield", 
		"Stairs", 
		"Brightly glowing idol", 
		"Open Window", 
		"Dark Chimney", 
		"Closed Flue", 
		"Open Flue", 
		"Four leaf clover", 
		"GrAves", 
		"Cast iron pot", 
		"Closed Coffin", 
		"Crystal Ball", 
		"Closed Window", 
		"Large fireplace", 
		"Soot", 
		"Tiny open door", 
		"Spirit Medium", 
		"Massive stone door with a SAPPHIRE set into it", 
		"Sapphire ring", 
		"Ju-Ju bag", 
		"Open Coffin", 
		"Slick chute leading downward", 
		"Ju-Ju man", 
		"Slippery chute leading up", 
		"Wide crack in the wall", 
		"Rabbit's foot", 
		"Dull & broken sword", 
		"Open SAfe", 
		"Stuck Chimney Sweep", 
		"Chem tubes", 
		"Closed SAfe", 
		"Labeled chemicals", 
		"Pocket Shovel", 
		"Mixed Chemicals", 
		"Wide open door", 
		"Nails", 
		"Dusty Idol", 
		"Doll", 
		"Wooden boards", 
		"Wood boards nailed to chimney wall", 
		"Antique hammer", 
		"GrAting", 
		"Rusting SAW", 
		"Button in the wall", 
		"Paper", 
		"Voodoo book", 
		"Ju-Ju man statue", 
		"Stick", 
		"Open wall", 
		"Open jail cell", 
		"Knight's Suit of Armor", 
		"Closed cell door", 
		"Broken grating", 
		"Advertising leaflet", 
		"Crack in the wall", 
		"Hole in the wall", 
		"Pieces of rock", 
		"Page torn from a book", 
		"Smiling Count Cristo"
	};
	final char[] AutoGets={
		7,0,25,40,31,0,0,27,
		0,9,0,0,0,0,16,0,
		66,0,0,0,0,38,0,0,
		0,32,44,0,0,0,0,0,
		47,13,0,0,33,0,42,50,
		42,0,75,9,55,56,0,57,
		0,46,0,51,63,43,61,0,
		0,0,0,20,87,0,0,79,
		89,0
	};
	final String[] Messages={
		"", 
		"Count Cristo's been CURSED! There's one way for him to flee!\nFind it, and he'll go FREE!", 
		"It belongs to the medium", 
		"Spirit vibrations drive me from room.", 
		"Prints too small for the unaided eye.", 
		"I can't do that", 
		"Nothing happened", 
		"Windows open", 
		"Window just slAmmed shut", 
		"For a reading just \"SUMMON MEDIUM MAEGEN\" today!!", 
		"I see nothing very special.", 
		"Phosphorescent letters are very hard to read in bright light!", 
		"Amongst the GRAVES is a four leaf clover.", 
		"Raven crys something outside", 
		"One of the test tubes EXPLODED!", 
		"This glass can't be broken", 
		".", 
		"They appear to be mixable.", 
		"There's something written there", 
		"A sepulchral voice says:", 
		"OK", 
		"Safe's combination lock is numbered from 33 to 38.", 
		"Ring glows briefly & door vanishes", 
		"OUCH", 
		"A sign here says:", 
		"There's a man here", 
		"Wearing a sapphire ring", 
		"I slide back down", 
		"A beam of light shines on grave", 
		"Pins fall out of doll", 
		"Plaque says: \"safe --> 38 33\"", 
		"This grAve reserved for you!", 
		"There's a CLAP OF THUNDER!", 
		"Ju-Ju man says:\"My bag is now yours! Its magic will help you\n -CRACK- the curse!\".", 
		"HURRAH! Look who is in the room!", 
		"I'm now 4 feet tall!", 
		"It's much to heavy to LIFT!", 
		"I'm too big", 
		"You startled medium & she vanished", 
		"On what?", 
		"Maid chased me with broom for tracking soot through the Ball-\nroom. I wonder where I am?", 
		"Sweep pops out, thanks me, hands me a piece of paper then\nvanishes!", 
		"As I dust of the Idol it begins to glow!", 
		"He's wearing a rabbit's foot", 
		".", 
		"HELP ME, I'm stuck!", 
		"Luck wasn't with me!", 
		"Doll looks like Count Cristo. There're pins in it!", 
		".", 
		"Bird says: \"ask for ADVENTURE 5, -THE COUNT- at your\n favorite computer dealer. It will be LOVE AT FIRST BYTE!\"\n", 
		"There's some soup here.", 
		"I see a hole under it!", 
		"Nails were rusted but I got them out.", 
		"It's hArd work but it seems to be coming loose", 
		"I hear strange sounds, as if someone were moaning.", 
		"I've got it!", 
		"Heavy duty exhaust fan comes on & sucks me up!", 
		".", 
		"says: \"SAY ZAP   to restore someone changed to stone!\"", 
		"Statue is made of stone", 
		"I hear nothing.", 
		"won't budge!", 
		"I'll need something to pry it off the wall!", 
		"It's a book on removing curses. Says: \"With knife in hand you\ntake a stand. Circle coffin and...\" The rest of the page is\nmissing!!!", 
		"Its very dark, the only light is from the idol.", 
		"That's illegal!", 
		"Double bubble toil & trouble the encAntAtions Are About to peAk!", 
		"There's an antique hammer here", 
		"There's a Clap of Thunder & then suddenly the stone statue\nbegins to crack. I may be in trouble now, there's someone in\nthe room with me!", 
		"Looks almost like lemonade. Yummy!", 
		"You've been turned into a broomstick & a witch rides off on you!", 
		"There's witch's brew there", 
		"Cell door slams shut", 
		"You've been sprung", 
		"...wave the stick and hold the lamp and don't forget to yell\n\"CHANT\"! Oh yes, to help it succeed, a doll you'll need...", 
		"Welcome to ADVENTURE:4, \"VOODOO CASTLE\" by Alexis ADAMS.\nDedicated to all MOMS!", 
		"how?", 
		"It appears stuck to the floor!", 
		"There's no room in there for me!", 
		"My idol acted strange", 
		"I've no container.", 
		"Some dust fell off it and it glowed briefly.", 
		"Its very faint.", 
		"Its much louder up here.", 
		"There's a book there.", 
		"There's a stick there.", 
		"Boy it looks dusty.", 
		"Its glowing.", 
		"Strange hobby you have", 
		"Check out the fireplace.", 
		"Its empty.", 
		"I hear someone mumbling.", 
		".", 
		"Saw grating!", 
		"I haven't got a knife!", 
		"Inscription on ring says: \"WAVE ME!\"", 
		"Medium appears, says: \"Keep a good luck charm on you & your\nfriend. I also see a -moving- bag helping you through a tight\nsqueeze!\"", 
		"It will take some strong magic to get me through that!", 
		"Use a number!", 
		"Knife made no impression on it!"
	};
	final String[] Rooms={
		"", 
		"chapel", 
		"Dingy Looking Stairwell", 
		"room in the castle", 
		"Tunnel", 
		"room in the castle", 
		"*I'm in Medium Maegen's Mad Room", 
		"room in the castle", 
		"room in the castle", 
		"room in the castle", 
		"Ballroom", 
		"dungeon", 
		"*I'm in the Armory", 
		"torture chamber", 
		"Chimney", 
		"large fireplace", 
		"room in the castle", 
		"Lab", 
		"narrow part of the chimney", 
		"Graveyard", 
		"parlor", 
		"Jail Cell", 
		"*I'm on a ledge", 
		"hidden VOODOO room", 
		"room in the castle", 
		"lot of TROUBLE!"
	};
	final String[] Verbs={
		"AUT", 
		"GO", 
		"*EN", 
		"*WA", 
		"*CL", 
		"*RU", 
		".", 
		"", 
		"", 
		"", 
		"GET", 
		"*TA", 
		"*PI", 
		"*RE", 
		"*PU", 
		"HEL", 
		"*RE", 
		".", 
		"DRO", 
		"*PU", 
		"*LE", 
		"*TH", 
		"DIG", 
		"ON", 
		"WAV", 
		"DUS", 
		"*CL", 
		"PRE", 
		"*PU", 
		"MOV", 
		"*SH", 
		"*KI", 
		"BRE", 
		"*SM", 
		"SAV", 
		"REA", 
		".", 
		"", 
		"OPE", 
		"CLO", 
		"TUR", 
		"*DI", 
		"LOO", 
		"*EX", 
		"INV", 
		"CIR", 
		".", 
		"QUI", 
		"DRI", 
		"*EA", 
		"SAW", 
		"MIX", 
		"HAM", 
		".", 
		"SHR", 
		".", 
		"LIS", 
		"*HE", 
		"STA", 
		"", 
		"SHA", 
		"", 
		"SLI", 
		"DAN", 
		"YEL", 
		"*SC", 
		"*SU", 
		"*SA", 
		"*CR", 
		"CUT", 
		"*ST", 
		"", 
		"RUB", 
		"SMO", 
		".", 
		"HUG", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		"", 
		""
	};
	final String[] Nouns={
		"ANY", 
		"NOR", 
		"SOU", 
		"EAS", 
		"WES", 
		"UP", 
		"DOW", 
		"KNI", 
		"COF", 
		"IDO", 
		"INV", 
		"KET", 
		"HOL", 
		"SWO", 
		"PAT", 
		"WIN", 
		"CLO", 
		"DOO", 
		"CHU", 
		"LAB", 
		"GRA", 
		"WAL", 
		"BAL", 
		"MED", 
		"CHI", 
		"WRI", 
		"*PL", 
		"SHI", 
		"SAF", 
		"BRE", 
		"ARM", 
		"GLA", 
		"RIN", 
		"TUB", 
		"FIR", 
		"FLU", 
		"*CH", 
		"38", 
		"SOO", 
		"33", 
		"HEA", 
		"*AN", 
		"CHE", 
		"STA", 
		"BAG", 
		"PIN", 
		"SAW", 
		"FOO", 
		"*RA", 
		"GAM", 
		"SHO", 
		"PAP", 
		"SWE", 
		"MAN", 
		"*CR", 
		"DOL", 
		"BOA", 
		"HAM", 
		"GRA", 
		"BUT", 
		"PUP", 
		"STI", 
		"STA", 
		"BOO", 
		"CHA", 
		"ZAP", 
		"POT", 
		"CEL", 
		"BAR", 
		"LOC", 
		"LED", 
		"WOO", 
		"VOI", 
		"SIG", 
		"FLO", 
		"NAI", 
		"MUM", 
		"CRA", 
		"SAP", 
		"ROC", 
		"ARO", 
		"CRY", 
		"*RA", 
		"34", 
		"35", 
		"36", 
		"37", 
		"LEA", 
		"MOA", 
		"PAG"
	};
	final char[] GameCode = {
		25,202,0,0,0,0,1950,0,
		100,184,202,292,200,380,1272,0,
		100,187,393,200,380,0,10800,0,
		0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,
		45,384,294,0,0,0,4200,0,
		30,723,146,500,0,0,8164,2173,
		0,0,0,0,0,0,3631,0,
		30,723,141,0,0,0,2100,0,
		0,0,0,0,0,0,0,0,
		100,304,308,0,0,0,8626,0,
		50,421,220,204,0,0,6054,0,
		100,64,308,0,0,0,8626,0,
		0,0,0,0,0,0,0,0,
		100,364,713,0,0,0,15600,0,
		35,284,713,0,0,0,15600,0,
		35,304,713,0,0,0,15600,0,
		100,504,0,0,0,0,6963,0,
		100,149,140,0,0,0,18808,0,
		7,861,0,0,0,0,19481,0,
		35,583,0,0,0,0,21150,0,
		0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0,
		1552,702,0,0,0,0,16650,0,
		1520,1183,1180,0,0,0,3052,0,
		3644,164,634,523,620,1220,4888,13272,
		5767,286,0,0,0,0,750,0,
		217,1122,285,420,0,0,10622,8164,
		6325,43,0,0,0,0,2700,0,
		1510,0,0,0,0,0,9900,0,
		4815,382,0,0,0,0,2250,0,
		4361,102,125,120,0,0,7970,0,
		1522,362,0,0,0,0,2852,0,
		1516,282,280,0,0,0,7800,0,
		6320,302,294,0,0,0,1824,4650,
		1516,294,384,280,0,0,7820,0,
		6320,302,293,0,0,0,3631,0,
		193,162,400,0,0,0,10554,9600,
		6328,742,0,0,0,0,3150,0,
		6328,682,940,954,0,0,8067,0,
		5735,242,240,260,220,0,10820,7950,
		5885,262,240,260,220,0,10820,8850,
		162,122,320,0,0,0,8156,10564,
		185,304,262,280,0,0,8454,10564,
		6387,1203,0,0,0,0,2700,0,
		6322,124,362,80,0,0,1554,11403,
		0,0,0,0,0,0,0,0,
		184,402,300,0,0,0,8176,0,
		5717,264,0,0,0,0,3000,0,
		3632,482,501,560,480,0,10822,0,
		168,562,160,0,0,0,3054,11400,
		1532,542,514,500,0,0,7820,0,
		7229,323,0,0,0,0,4888,18063,
		5708,342,340,540,0,0,10820,0,
		5858,542,340,540,0,0,10820,0,
		1530,1142,0,0,0,0,786,0,
		4822,124,0,0,0,0,9178,4713,
		5717,482,0,0,0,0,861,0,
		1544,523,593,520,0,0,7820,0,
		5275,43,83,308,0,0,4500,0,
		168,562,160,0,0,0,8176,0,
		168,602,0,0,0,0,4050,0,
		6344,523,1054,1093,0,0,20100,0,
		6758,0,24,0,0,0,10970,988,
		0,654,183,1,60,0,8732,8514,
		6342,803,0,0,0,0,17850,0,
		1540,9,663,60,740,62,7853,3067,
		5728,104,682,0,0,0,3000,0,
		6328,104,682,953,0,0,3140,0,
		1540,8,63,60,0,0,7820,0,
		6037,29,742,20,0,0,8720,0,
		6039,28,742,680,740,0,10820,0,
		6344,523,1094,1054,593,0,20235,0,
		5313,1043,0,0,0,0,16950,0,
		9623,474,124,460,0,0,3085,8096,
		174,262,280,0,0,0,8156,11400,
		5269,763,0,0,0,0,2550,0,
		7242,803,820,440,760,0,4873,10859,
		0,800,0,0,0,0,8938,13235,
		9665,1063,1060,580,0,0,8903,11035,
		0,0,0,0,0,0,17841,0,
		5149,0,0,0,0,0,10650,0,
		1511,102,0,0,0,0,786,0,
		167,442,0,0,0,0,787,22050,
		6600,0,0,0,0,0,9900,0,
		1540,9,63,0,0,0,16762,0,
		2747,641,0,0,0,0,5850,0,
		3503,643,640,542,0,0,3032,8850,
		1545,882,0,0,0,0,861,0,
		4102,364,702,700,1020,0,6205,11100,
		5301,1023,0,0,0,0,16200,0,
		6355,883,0,0,0,0,7050,0,
		6308,542,0,0,0,0,3601,10975,
		0,654,0,0,0,0,6450,0,
		0,514,0,0,0,0,3900,0,
		9664,24,183,283,128,883,10982,13229,
		0,1300,0,0,0,0,8026,5163,
		1575,843,840,0,0,0,3052,0,
		216,1122,0,0,0,0,3000,0,
		6342,763,0,0,0,0,2550,0,
		6366,323,0,0,0,0,18150,0,
		1547,654,542,640,0,0,7820,0,
		1547,643,640,0,0,0,7820,0,
		165,202,440,0,0,0,8120,11400,
		3759,863,180,860,0,0,6372,11400,
		4361,122,120,122,0,0,8850,0,
		6311,102,64,134,0,0,3051,7500,
		5867,0,0,0,0,0,16650,0,
		7202,102,900,0,0,0,3055,0,
		3661,883,0,0,0,0,10970,988,
		0,183,24,68,120,0,13232,17458,
		7520,962,981,960,0,0,15470,11005,
		0,1000,1180,0,0,0,8055,11100,
		4109,1002,360,0,0,0,15954,11400,
		7050,0,0,0,0,0,9450,0,
		227,622,460,0,0,0,3054,11400,
		6343,1063,0,0,0,0,16350,0,
		8400,583,0,0,0,0,4950,0,
		1557,943,940,0,0,0,7820,0,
		1557,682,109,940,100,0,7820,8700,
		5339,1283,0,0,0,0,18600,0,
		3600,0,0,0,0,0,3006,0,
		8100,0,0,0,0,0,18900,0,
		5275,43,92,0,0,0,754,0,
		5744,593,523,0,0,0,3000,0,
		6367,224,0,0,0,0,1500,0,
		4380,1143,0,0,0,0,3000,0,
		1544,522,0,0,0,0,19050,0,
		5275,43,83,0,0,0,761,0,
		220,184,22,0,0,0,7350,0,
		8400,304,713,0,0,0,15732,0,
		8400,713,284,0,0,0,15733,0,
		158,542,0,0,0,0,19200,0,
		1502,102,0,0,0,0,19500,0,
		162,1242,120,460,0,0,8176,5759,
		6332,503,0,0,0,0,2700,0,
		10359,863,3,0,0,0,19481,0,
		10350,3,0,0,0,0,3006,22350,
		6344,1053,1094,593,523,0,20250,0,
		1563,523,593,1040,1054,0,7820,0,
		1563,1043,1040,0,0,0,7820,0,
		1561,523,1094,1080,593,0,7820,0,
		1561,1083,1080,0,0,0,7820,0,
		167,822,380,0,0,0,8176,0,
		9013,4,0,0,0,0,0,0,
		6309,863,0,0,0,0,20410,0,
		6309,183,0,0,0,0,20550,0,
		3320,783,0,0,0,0,2988,0,
		7500,981,1162,220,0,0,18504,9600,
		8481,184,0,0,0,0,7350,0,
		5715,4,0,0,0,0,0,0,
		9300,562,160,0,0,0,8176,0,
		8400,702,0,0,0,0,6750,0,
		2250,204,0,0,0,0,20850,0,
		9450,0,0,0,0,0,3006,0,
		9600,0,0,0,0,0,3085,900,
		1575,922,941,920,900,840,15372,11100,
		3524,641,640,0,0,0,7970,0,
		1556,903,900,169,960,160,7853,8700,
		1556,903,900,0,0,0,7820,0,
		1529,0,0,0,0,0,19500,0,
		2250,962,0,0,0,0,21450,0,
		7692,763,800,760,0,0,10820,0,
		2302,702,0,0,0,0,18900,0,
		10809,863,0,0,0,0,19481,0,
		6300,0,0,0,0,0,11410,0,
		10350,6,0,0,0,0,894,0,
		8400,0,0,0,0,0,16500,0,
		1532,502,500,0,0,0,7820,0,
		11016,0,0,0,0,0,17250,0,
		4833,723,146,500,0,0,8164,2173,
		7500,981,0,0,0,0,3006,0,
		5337,1203,0,0,0,0,3009,0,
		3300,783,0,0,0,0,3006,0,
		227,1222,0,0,0,0,787,22050,
		2250,0,0,0,0,0,900,0,
		5728,742,0,0,0,0,3150,0,
		4843,1063,1060,1260,0,0,3072,0,
		6083,742,20,0,0,0,9020,0,
		6084,742,20,0,0,0,9020,0,
		6085,742,20,0,0,0,9020,0,
		6086,742,20,0,0,0,9020,0,
		5282,503,0,0,0,0,21750,0,
		5715,382,0,0,0,0,16650,0,
		10832,503,0,0,0,0,2700,0,
		10800,0,0,0,0,0,3006,0,
		6069,742,0,0,0,0,22200,0,
		6039,742,20,0,0,0,9020,0,
		6037,742,20,0,0,0,9020,0,
		11305,883,0,0,0,0,3450,0
	};
	final char[] ExitMap = {
		0,0,0,0,0,0,
		9,2,4,10,0,0,
		1,24,3,11,0,0,
		5,0,0,2,0,0,
		0,0,0,1,0,0,
		0,3,7,0,0,0,
		0,0,0,8,0,0,
		0,0,17,5,0,0,
		0,0,0,0,0,0,
		0,1,0,0,0,0,
		0,0,1,0,0,0,
		0,13,2,0,0,0,
		0,0,0,13,0,0,
		11,0,12,0,0,0,
		0,0,0,0,0,15,
		0,10,0,0,0,0,
		0,0,0,0,3,0,
		0,0,0,7,0,0,
		0,0,0,0,0,14,
		0,0,13,0,0,0,
		0,0,0,0,0,2,
		0,0,0,0,0,0,
		0,9,0,0,0,0,
		0,8,0,0,0,0,
		2,0,0,0,0,0,
		0,0,0,0,0,0
	};

	static String[] ExitNames = { "North", "East", "South", "West", "Up", "Down" };
	static String[] Quickies = { "", "N", "E", "S", "W", "U", "D" };

	/* Constants */
	final char Carried = 255;
	final char Destroyed = 0;
	final char Lamp = 9;
	final int DarkFlag = 15;
	final int LightOutFlag = 16;

	final char NoWord = 1000;	/* Can't occur in real game */
	final char AnyWord = 0;
	final char VerbGo = 1;
	final char VerbGet = 10;
	final char VerbDrop = 18;
	final char DirNorth = 1;
	final char DirDown = 6;

	/* Per game instance */
	boolean[] Flags;
	int[] Counters;
	char[] Yoho;
	char Location;
	int CurCounter;		/* Value not instance */
	char CurYoho;
	int LightTime;
	char[] Objects;

	/* Execution Environment */
	char[] Params;
	int ParamPtr;
	boolean Continuation;
	boolean Ended;
	boolean Redraw;		/* Pending redraw */
	Random Rng;

	/* Parser */
	String VerbString;
	String NounString;
	char NounCode;
	char VerbCode;

	/* Output Subsystem */
	ScottCanvas DrawingAgent;
	ScottCanvas TopDrawingAgent;

	public AdventureGame(ScottCanvas output, ScottCanvas top) {
		Flags = new boolean[32];
		Counters = new int[16];
		Objects = new char[NumObjects];
		Yoho = new char[16];
		Params = new char[5];
		for(int i = 0; i < 32; i++)
			Flags[i] = false;
		for(int i = 0; i < 16; i++)
			Counters[i] = 0;
		for(int i = 0; i < 16; i ++)
			Yoho[i] = 0;
		for(int i = 0; i < NumObjects; i ++)
			Objects[i] = ObjectStarts[i];
		CurCounter = 0;
		LightTime = LightRefill;
		Redraw = false;
		Ended = false;
		Location = PlayerRoom;
		Rng = new Random();
		DrawingAgent = output;
		TopDrawingAgent = top;
	}

	/*
	 *	CLDC 1.1 helpers. Some idiot decided that case independant
	 *	string compare could go away even though they kept all the
	 *	other related functions... and people wonder why I think 
	 *	Java is badly designed! Instead we do it ourselves and in
	 *	doing so end up creating lots of temporary objects
	 *
	 *	To minimise the pain we "know" that the second string is
	 *	already upper case.
	 */

	boolean StringEqual(String a, String b) {
		if(a.toUpperCase().equals(b))
			return true;
		return false;
	}


	/*
 	 *	Gamecode helpers
	 */
	int CountCarried() {
		int count = 0;
		for(int i = 0; i < NumObjects; i++) {
			if(Objects[i] == Carried)
				count++;
		}
		return count;
	}
	int CountTreasure() {
		int count = 0;
		for(int i = 0; i < NumObjects; i++) {
			if(Objects[i] == TreasureRoom &&
				ObjectNames[i].charAt(0) == '*')
					count++;
		}
		return count;
	}

	/*
 	 *	Condition code engine
	 */

	/* Remember char is 16bit unsigned, we use this because java is
	   a broken pile of donkey poo when it comes to unsigned maths */
	boolean ExecuteCondition(char c) {
		char op = (char)(c % 20);
		char val = (char)(c / 20);


/* 		System.out.print("C"+(int)op+"P="+(int)val+" "); */
		switch(op) {
			case 0:
				Params[ParamPtr++] = val;
				return true;
			case 1:
				if(Objects[val] == Carried)
					return true;
				return false;
			case 2:
				if(Objects[val] == Location)
					return true;
				return false;
			case 3:
				if(Objects[val] == Carried)
					return true;
				if(Objects[val] == Location)
					return true;
				return false;
			case 4:
				if(Location == val)
					return true;
				return false;
			case 5:
				if(Objects[val] != Location)
					return true;
				return false;
			case 6:
				if(Objects[val] != Carried)
					return true;
				return false;
			case 7:
				if(Location != val)
					return true;
				return false;
			case 8:
				return Flags[val];
			case 9:
				return !Flags[val];
			case 10:
				if(CountCarried() == 0)
					return true;
				return false;
			case 11:
				if(CountCarried()==0)
					return true;
				return false;
			case 12:
				if(Objects[val] == Carried)
					return false;
				if(Objects[val] == Location)
					return false;
				return true;
			case 13:
				if(Objects[val] != Destroyed)
					return true;
				return false;
			case 14:
				if(Objects[val] == Destroyed)
					return true;
				return false;
			case 15:
				if(CurCounter <= val)
					return true;
				return false;
			case 16:
				if(CurCounter >= val)
					return true;
				return false;
			case 17:
				if(Objects[val] == ObjectStarts[val])
					return true;
				return false;
			case 18:
				if(Objects[val] != ObjectStarts[val])
					return true;
				return false;
			case 19:
				if(CurCounter == val)
					return true;
				return false;
		}
		/* Because the compiler is too stupid to work this out */
		return false;
	}

	/* User Interface */
	void Output(String s) { 
		DrawingAgent.AddString(s);
	}
	void OutputNumber(int n) {
		DrawingAgent.AddString(""+n);
	}
	void ClearScreen() {
	}

	void DrawPicture(char p) { }
	void TwoSecondDelay() { }

	void TopBegin() {
		TopDrawingAgent.SwitchToTopScreen();
	}
	void TopOutput(String s) {
		TopDrawingAgent.AddString(s);
	}
	void TopDone() {
		TopDrawingAgent.SwitchToBottomScreen();
		TopDrawingAgent.SetCurrent();
	}

	/* Unimplemented I/O hook */
	void SaveGame() { }


	/*
 	 * 	Action Helpers
	 */
	char Param() {
		return Params[ParamPtr++];
	}
	void CarryLimit() {
		if(UseYou)
			Output("You are carrying too much. ");
		else
			Output("I've too much to carry! ");
	}
	void GameOver() {
		Output("The game is now over.\n");
		Ended = true;
	}
	void Plonk(char thing, char where) {
		if(Objects[thing] == Location || where == Location)
			Redraw = true;
		Objects[thing] = where;
	}
	boolean Dark() {
		boolean dark = Flags[DarkFlag];

		if(Objects[Lamp] == Location ||
		   Objects[Lamp] == Carried)
			dark = false;
		return dark;
	}
	/*
 	 *	Complex operation blocks
	 */
	void Inventory() {
		boolean f = false;
		if(UseYou)
			Output("You are carrying:\n");
		else
			Output("I'm carrying:\n");
		for(int i = 0; i < NumObjects; i++) {
			if(Objects[i] == Carried) {
				if(f == true) {
					if(Trash80 == true)
						Output(". ");
					else
						Output(" - ");
				}
				f = true;
				Output(ObjectNames[i]);
			}
		}
		if(f == false)
			Output("Nothing");
		Output(".\n");
	}
	void Look() {
		boolean printed = false;
		TopBegin();
		if(Dark()) {
			if(UseYou == true)
				TopOutput("You can't see. It is too dark!\n");
			else
				TopOutput("I can't see. It is too dark!\n");
			TopDone();
			return;
		}

		if(Rooms[Location].charAt(0) == '*')
			TopOutput(Rooms[Location].substring(1));
		else {
			if(UseYou == true)
				TopOutput("You are ");
			else
				TopOutput("I'm in a ");
			TopOutput(Rooms[Location]);
		}
		TopOutput("\nObvious exits: ");

		for(int i = 0; i < 6; i++) {
			if(ExitMap[Location * 6 + i] != 0) {
				if(printed == true)
					TopOutput(",");
				printed = true;
				TopOutput(ExitNames[i]);
			}				
		}
		if(printed == false)
			TopOutput("none");
		TopOutput("\n");
		
		printed = false;

		for(int i = 0; i < NumObjects; i++) {
			if(Objects[i] == Location) {
				if(printed == false) {
					if(UseYou == true)
						TopOutput("\nYou can also see: ");
					else
						TopOutput("\nI can also see: ");
					printed = true;
				} else if(Trash80 == false)
					TopOutput(" - ");

				TopOutput(ObjectNames[i]);

				if(Trash80 == true)
					TopOutput(". ");
			}
		}
		TopDone();
	}

	/*
 	 *	Action Execution Engine
	 */
					
	void ExecuteAction(char val)	/* Called post /150 */ {
		char p;
		char p1;
		char t;
		int ts;

/*  		System.out.print("A"+(int)val+" P"+(int)Params[ParamPtr]+" "); */
		switch(val) {
			case 0:
				return;
			case 52:
				if(CountCarried() >= Carry)
					CarryLimit();
				else
					Plonk(Param(), Carried);
				return;
			case 53:
				Plonk(Param(), Location);
				return;
			case 54:
				Location = Param();
				Redraw = true;
				return;
			case 55:
				Plonk(Param(), Destroyed);
				return;
			case 56:
				Flags[DarkFlag] = true;
				return;
			case 57:
				Flags[DarkFlag] = false;
				return;
			case 58:
				Flags[Param()] = true;
				return;
			case 59:
				Plonk(Param(), Destroyed);
				return;
			case 60:
				Flags[Param()] = false;
				return;
			case 61:
				if(UseYou)
					Output("You are dead.\n");
				else
					Output("I am dead.\n");
				Flags[DarkFlag] = false;
				Location = (char)(NumRooms - 1);
				Look();
				return;
			case 62:
				p = Param();
				Objects[p] = Param();
				return;
			case 63:
				/* Do we want a game over exception ? */
				GameOver();
				return;
			case 64:
				Look();
				return;
			case 65:
				ts = CountTreasure();
				if(UseYou)
					Output("You have stored ");
				else
					Output("I've stored ");
				OutputNumber(ts);
				Output(" treasures. On a scale of 0 to 100, that rates ");
				OutputNumber((ts * 100) / Treasures);
				Output(".\n");
				if(ts == Treasures)
				{
					Output("Well done.\n");
					GameOver();
				}
				return;
			case 66:
				Inventory();
				return;
			case 67:
				Flags[0] = true;
				return;
			case 68:
				Flags[0] = false;
				return;
			case 69:
				LightTime = LightRefill;
				Plonk(Lamp, Carried);
				Flags[9] = false;
				return;
			case 70:
				ClearScreen();
				return;
			case 71:
				SaveGame();
				return;
			case 72:
				p = Param();
				p1 = Param();

				t = Objects[p];
				Plonk(p, Objects[p1]);
				Plonk(p1, t);
				return;
			case 73:
				Continuation = true;
				return;
			case 74:
				Plonk(Param(), Carried);
				return;
			case 75:
				p = Param();
				Plonk(p, Objects[Param()]);
				return;
			case 76:
				Look();
				return;
			case 77:
				if(CurCounter > 0)
					CurCounter--;
				return;
			case 78:
				OutputNumber(CurCounter);
				return;
			case 79:
				CurCounter = Param();
				return;
			case 80:
				t = Yoho[CurYoho];
				Yoho[CurYoho] = Location;
				Location = t;
				return;
			case 81:
				p = Param();
				ts = CurCounter;
				CurCounter = Counters[p];
				Counters[p] = ts;
				return;
			case 82:
				CurCounter += Param();
				return;
			case 83:
				CurCounter -= Param();
				if(CurCounter < -1)
					CurCounter = -1;
				return;
			case 84:
				Output(NounString);
				return;
			case 85:
				Output(NounString);
			case 86:
				Output("\n");
				return;
			case 87:
				p = Param();
				t = Location;
				Location = Yoho[p];
				Yoho[p] = t;
				Redraw = true;
				return;
			case 88:
				TwoSecondDelay();
				return;
			case 89:
				DrawPicture(Param());
				return;
			default:
				if(val < 51)
					Output(Messages[val]);
				else if(val > 101)
					Output(Messages[val-50]);
				Output(" ");
				return;
		}
	}
	void ExecuteActionPair(char val) {
		ExecuteAction((char) (val / 150));
		if(Ended == false)
			ExecuteAction((char) (val % 150));
	}
	boolean ExecuteLineCodes(int offset) {
		ParamPtr = 0;
		for(int i = 0; i < 5; i++) {
			if(ExecuteCondition(GameCode[offset]) == false)
				return false;
			offset++;
		}
		ParamPtr = 0;
		ExecuteActionPair(GameCode[offset]);
		if(Ended == false)
			ExecuteActionPair(GameCode[offset+1]);
		return true;
	}
	boolean RandomChance(char percent) {
		int val = Rng.nextInt() % 100;
		if(val < 0)
			val = -val;
		if (val >= (int)percent)
			return false;
		return true;
	}		

	/*
 	 *	Code for executing the tables
	 */

	int ExecuteActions(char verb, char noun) {
		int offset = 0;
		boolean found = false;
		boolean completed = false;
		char no, vb;

		Continuation = false;

		for(int i = 0; i < Actions; i++) {
			vb = GameCode[offset];
			no = (char) (vb % 150);
			vb = (char) (vb / 150);

			if(Continuation == true) {
				/* End of continuation block */
				if(vb != AnyWord || no != AnyWord) {
					Continuation = false;
					if(verb != AnyWord)
						break;
				}
			}
			/* Check for end of non-automatics */
			if(Continuation == false) {
				/* One execution only */
				if(verb != AnyWord && completed == true)
					break;
				/* Does not match */
				if(verb != vb) {
					offset = offset + 8;
					continue;
				}
				/* Running automatics - have chance values */
				if(vb == AnyWord) {
					if(RandomChance(no) == false) {
						offset = offset + 8;
						continue;
					}
				} else {
					if(no != noun && no != AnyWord) {
						offset = offset + 8;
						continue;
					}
				}
			}
			found = true;
/*			System.out.print("V"+(int)vb+"N"+(int)no+":"); */
			if(ExecuteLineCodes(offset + 1) == true)
				completed = true;
/*			System.out.println(""); */
			offset = offset + 8;
		}
		if(completed == true)
			return 0;
		if(found == true)
			return 1;
		return 2;
	}

	/*
 	 *	Handle movement automatics
	 */

	boolean GoHelper(char noun) {
		char moveto;
		boolean dark = Dark();

		if(noun == NoWord) {
			Output("Give me a direction too.");
			return false;
		}
		if(noun < DirNorth || noun > DirDown)
			return false;

		if(dark)
			Output("Dangerous to move in the dark! ");
		
		moveto = ExitMap[Location * 6 + noun - DirNorth];

		if(moveto != 0) {
			Location = moveto;
			Look();
			return true;
		}

		if(dark == false) {
			if(UseYou == false)
				Output("I can't go in that direction. ");
			else
				Output("You can't go in that direction. ");
			return true;
		}

		if(UseYou == false)
			Output("I fell down and broke my neck. ");
		else
			Output("You fell down and broke your neck. ");
		Ended = true;
		return true;
	}

	/*
 	 *	Find the verb and noun
	 */

	char MatchVerb(String s) {
		int len = s.length();
		String t;
		char num = 0;

		if (len == 0)
			return NoWord;
		if (len > WordLength)
			len = WordLength;
		t = s.substring(0, len);

		for(int i = 0; i < NumVerbs; i++) {
			if(Verbs[i].length() > 1 && Verbs[i].charAt(0) == '*') {
				if(StringEqual(t, Verbs[i].substring(1)))
					return num;
			} else {
				num = (char) i;
				if(StringEqual(t, Verbs[i]))
					return num;
			}
		}
		return AnyWord;
	}

	char MatchNoun(String s) {
		int len = s.length();
		String t;
		char num = 0;

		if (len == 0)
			return NoWord;
		if (len > WordLength)
			len = WordLength;
		t = s.substring(0, len);

		for(int i = 0; i < NumNouns; i++) {
			if(Nouns[i].charAt(0) == '*') {
				if(StringEqual(t, Nouns[i].substring(1)))
					return num;
			} else {
				num = (char) i;
				if(StringEqual(t, Nouns[i]))
					return num;
			}
		}
		return AnyWord;
	}

	/* Match for Brian Howarth 'quickie' extensions - FIXME "I" */
	char MatchQuick(String s) {
		String t;

		for(int i = 0; i < 6; i++) {
			if(StringEqual(s, Quickies[i]))
				return (char)i;
		}
		return AnyWord;
	}

	/*
 	 *	Automatic get/drop functions.
	 */

	char MatchUpItem(char no, char where) {
		for (char i = 0; i < NumObjects; i++) {
			if(Objects[i] == where && AutoGets[i] == no)
				return i;
		}
		return NoWord;
	}

	void GetAllHelper() {
		boolean found = false;
		for (int i = 0; i < NumObjects; i++) {
			if(Objects[i] == Location && AutoGets[i] != NoWord) {
				ExecuteActions(VerbGet, AutoGets[i]);
				if(CountCarried() >= Carry) {
					CarryLimit();
					found = true;
					break;
				}
				Plonk((char)i, Carried);
				Output(ObjectNames[i]);
				Output(": OK.\n");
				found  = true;
			}
		}
		if(found == false)
			Output("Nothing taken.\n");
	}

	boolean GetHelper(char no) {
		char what;

		if(StringEqual(NounString, "ALL")) {
			if(Dark())
				Output("It is dark.\n");
			else
				GetAllHelper();
			return true;
		}
		if(no == NoWord) {
			Output("What ? ");
			return false;
		}
		if(CountCarried() >= Carry) {
			CarryLimit();
			return false;
		}
		what = MatchUpItem(no, Location);
		if(what == NoWord) {
			if(UseYou)
				Output("It is beyond your power to do that. ");
			else
				Output("It is beyond my power to do that. ");
			return false;
		}
		Plonk(what, Carried);
		Output("O.K. ");
		return true;
	}

	void DropAllHelper() {
		boolean found = false;
		for (int i = 0; i < NumObjects; i++) {
			if(Objects[i] == Carried && AutoGets[i] != NoWord) {
				ExecuteActions(VerbDrop, AutoGets[i]);
				Plonk((char)i, Location);
				Output(ObjectNames[i]);
				Output(": OK.\n");
				found  = true;
			}
		}
		if(found == false)
			Output("Nothing dropped.\n");
	}

	boolean DropHelper(char no) {
		char what;

		if(StringEqual(NounString, "ALL")) {
			DropAllHelper();
			return true;
		}
		if(no == NoWord) {
			Output("What ? ");
			return false;
		}
		what = MatchUpItem(no, Location);
		if(what == NoWord) {
			if(UseYou)
				Output("It is beyond your power to do that. ");
			else
				Output("It is beyond my power to do that. ");
			return false;
		}
		Plonk(what, Location);
		Output("O.K. ");
		return true;
	}

	/*
 	 *	Given a parsed input perform the command
	 */

	boolean RunCommandLine(char vb, char no) {
		int state;

		if(vb == VerbGo) {
			if(GoHelper(no))
				return true;
		}
		state = ExecuteActions(vb, no);
		if(state != 0) {
			if(vb == VerbGet) {
				if(GetHelper(no) == true)
					return true;
			}
			else if(vb == VerbDrop) {
				if(DropHelper(no) == true)
					return true;
			} else {
				if(state == 2)
					Output("I don't understand your command. ");
				if(state == 1)
					Output("I can't do that yet. ");
			}
			return false;
		}
		return true;
	}

	/*
 	 *	Emulate the hard coded lamp functionality
	 */

	void LampIterate() {
		if(Objects[Lamp] == Destroyed)
			return;
		if(LightTime == -1)
			return;
		LightTime--;
		if(LightTime < 1) {
			Flags[LightOutFlag] = true;
			if(Objects[Lamp] == Carried ||
				Objects[Lamp] == Location) {
				if(ScottLight)
					Output("Light has run out! ");
				else if(UseYou)
					Output("Your light has run out. ");
				else
					Output("My light has run out. ");
				if(Flags[DarkFlag] == true)
					Redraw = true;
			}
			if(OldLamp)
				Plonk(Lamp, Destroyed);
		}		
		else if(LightTime < 25) {
			if(Objects[Lamp] == Carried || Objects[Lamp] == Location) {
				if(ScottLight) {
					Output("Light runs out in ");
					OutputNumber(LightTime);
					Output(" turns. ");
				} else if((LightTime % 5) == 0) {
					if(UseYou)
						Output("Your light is growing dim. ");
					else
						Output("My light is growing dim. ");
				}
			}
		}
	}

	/*
	 *	Run the first iteration of the game processing 
	 */

	public void FirstGameCycle() {
		ExecuteActions(AnyWord, AnyWord);
		Look();
		Redraw = false;
	}

	public boolean ParseInput(String input) {
		/* We want this but it isn't in the MIDP profile
		String[] words = input.split(" "); */
		int pos;
		int words;

		VerbCode = NoWord;
		NounCode = NoWord;

		input = input.trim();
		if(input.equals(""))
			return false;

		NounString = "";

		pos = input.indexOf(' ');
		if(pos == -1) {
			VerbString = input;
			words = 1;
		} else {
			VerbString = input.substring(0, pos);
			input = input.substring(pos + 1).trim();
			pos = input.indexOf(' ');
			if(pos == -1)
				NounString = input;
			else
				NounString = input.substring(pos - 1);
			words  = 2;
		}

		VerbCode = MatchVerb(VerbString);
		if(words > 1) {
			NounCode = MatchNoun(NounString);
		}
		if(words == 1 && VerbCode == AnyWord) {
			char alt = MatchNoun(VerbString);
			if(alt >= DirNorth && alt <= DirDown) {
				VerbCode = VerbGo;
				NounCode = alt;
				NounString = VerbString;
			}
			alt = MatchQuick(VerbString);
			if(alt >= DirNorth && alt <= DirDown) {
				VerbCode = VerbGo;
				NounCode = alt;
				NounString = VerbString;
			}
		}

		if(VerbCode == AnyWord) {
			Output("You use word(s) I don't know! ");
			return false;
		}
		return true;
	}

	/*
 	 *	Run further iterations
	 */

	public boolean GameCycle(String input) {
		if(ParseInput(input) == false)
			return true;
		RunCommandLine(VerbCode, NounCode);
		if(Ended == false) {
			LampIterate();
			ExecuteActions(AnyWord, AnyWord);
		}
		if(Redraw == true) {
			Look();
			Redraw = false;
		}
		return !Ended;
	}
}
