/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class ScottEngine {
    boolean ScottLight;
    boolean Trash80;
    boolean OldLamp;
    boolean UseYou;
    static char PlayerRoom;
    static int Items;
    static int Actions;
    static int NumNouns;
    static int NumVerbs;
    static int NumRooms;
    static int Carry;
    static int Treasures;
    static int WordLength;
    static int LightRefill;
    static int NumMessages;
    static char TreasureRoom;
    static int NumObjects;
    static char[] ObjectStarts;
    static String[] ObjectNames;
    static char[] AutoGets;
    static String[] Messages;
    static String[] Rooms;
    static String[] Nouns;
    static String[] Verbs;
    static char[] GameCode;
    static char[] ExitMap;
    static String[] ExitNames;
    final char Carried = (char)255;
    final char Destroyed;
    final char Lamp = (char)9;
    final int DarkFlag;
    final int LightOutFlag;
    final char NoWord = (char)1000;
    final char AnyWord;
    final char VerbGo;
    final char VerbGet = (char)10;
    final char VerbDrop = (char)18;
    final char DirNorth;
    final char DirDown = (char)6;
    boolean[] Flags = new boolean[32];
    int[] Counters = new int[8];
    char[] Yoho;
    char Location;
    int CurCounter;
    char CurYoho;
    int LightTime;
    char[] Objects = new char[NumObjects];
    char[] Params;
    int ParamPtr;
    boolean Continuation;
    boolean Ended;
    boolean Redraw;
    Random Rng;
    String NounString;
    char NounCode;
    char VerbCode;

    public ScottEngine() {
        int n;
        this.Destroyed = '\u0000';
        this.DarkFlag = 15;
        this.LightOutFlag = 16;
        this.AnyWord = '\u0000';
        this.VerbGo = '\u0001';
        this.DirNorth = '\u0001';
        this.Yoho = new char[4];
        for (n = 0; n < 32; ++n) {
            this.Flags[n] = false;
        }
        for (n = 0; n < 8; ++n) {
            this.Counters[n] = 0;
        }
        for (n = 0; n < 4; ++n) {
            this.Yoho[n] = '\u0000';
        }
        for (n = 0; n < NumObjects; ++n) {
            this.Objects[n] = ObjectStarts[n];
        }
        this.CurCounter = 0;
        this.LightTime = LightRefill;
        this.Redraw = false;
        this.Ended = false;
        this.Location = PlayerRoom;
        this.Rng = new Random();
    }

    boolean StringEqual(String string, String string2) {
        return string.toUpperCase().equals(string2);
    }

    int CountCarried() {
        int n = 0;
        for (int i = 0; i < NumObjects; ++i) {
            if (this.Objects[i] != '\u00ff') continue;
            ++n;
        }
        return n;
    }

    int CountTreasure() {
        int n = 0;
        for (int i = 0; i < NumObjects; ++i) {
            if (this.Objects[i] != TreasureRoom || ObjectNames[i].charAt(0) != '*') continue;
            ++n;
        }
        return n;
    }

    boolean ExecuteCondition(char c) {
        char c2 = (char)(c % 20);
        char c3 = (char)(c / 20);
        switch (c2) {
            case '\u0000': {
                this.Params[this.ParamPtr++] = c3;
                return true;
            }
            case '\u0001': {
                return this.Objects[c3] == '\u00ff';
            }
            case '\u0002': {
                return this.Objects[c3] == this.Location;
            }
            case '\u0003': {
                if (this.Objects[c3] == '\u00ff') {
                    return true;
                }
                return this.Objects[c3] == this.Location;
            }
            case '\u0004': {
                return this.Location == c3;
            }
            case '\u0005': {
                return this.Objects[c3] != this.Location;
            }
            case '\u0006': {
                return this.Objects[c3] != '\u00ff';
            }
            case '\u0007': {
                return this.Location != c3;
            }
            case '\b': {
                return this.Flags[c3];
            }
            case '\t': {
                return !this.Flags[c3];
            }
            case '\n': {
                return this.CountCarried() == 0;
            }
            case '\u000b': {
                return this.CountCarried() == 0;
            }
            case '\f': {
                if (this.Objects[c3] == '\u00ff') {
                    return false;
                }
                return this.Objects[c3] != this.Location;
            }
            case '\r': {
                return this.Objects[c3] != '\u0000';
            }
            case '\u000e': {
                return this.Objects[c3] == '\u0000';
            }
            case '\u000f': {
                return this.CurCounter <= c3;
            }
            case '\u0010': {
                return this.CurCounter >= c3;
            }
            case '\u0011': {
                return this.Objects[c3] == ObjectStarts[c3];
            }
            case '\u0012': {
                return this.Objects[c3] != ObjectStarts[c3];
            }
            case '\u0013': {
                return this.CurCounter == c3;
            }
        }
        return false;
    }

    void Output(String string) {
    }

    void OutputNumber(int n) {
    }

    void ClearScreen() {
    }

    void DrawPicture(char c) {
    }

    void TwoSecondDelay() {
    }

    void TopOutput(String string) {
    }

    void TopDone() {
    }

    void SaveGame() {
    }

    char Param() {
        int n = this.ParamPtr;
        char c = this.Params[n];
        this.Params[n] = (char)(c + '\u0001');
        return c;
    }

    void CarryLimit() {
        if (this.UseYou) {
            this.Output("You are carrying too much. ");
        } else {
            this.Output("I've too much to carry! ");
        }
    }

    void GameOver() {
        this.Output("The game is now over.\n");
        this.Ended = true;
    }

    void Plonk(char c, char c2) {
        if (this.Objects[c] == this.Location || c2 == this.Location) {
            this.Redraw = true;
        }
        this.Objects[c] = c2;
    }

    boolean Dark() {
        boolean bl = this.Flags[15];
        if (this.Objects[9] == this.Location || this.Objects[9] == '\u00ff') {
            bl = false;
        }
        return bl;
    }

    void Inventory() {
        boolean bl = false;
        if (this.UseYou) {
            this.Output("You are carrying:\n");
        } else {
            this.Output("I'm carrying:\n");
        }
        for (int i = 0; i < NumObjects; ++i) {
            if (this.Objects[i] != '\u00ff') continue;
            if (bl) {
                if (this.Trash80) {
                    this.Output(". ");
                } else {
                    this.Output(" - ");
                }
            }
            bl = true;
            this.Output(ObjectNames[i]);
        }
        if (!bl) {
            this.Output("Nothing");
        }
        this.Output(".\n");
    }

    void Look() {
        int n;
        boolean bl = false;
        if (this.Dark()) {
            if (this.UseYou) {
                this.TopOutput("You can't see. It is too dark!\n");
            } else {
                this.TopOutput("I can't see. It is too dark!\n");
            }
            this.TopDone();
            return;
        }
        if (Rooms[this.Location].charAt(0) == '*') {
            this.Output(Rooms[this.Location].substring(1));
        } else {
            if (this.UseYou) {
                this.Output("You are ");
            } else {
                this.Output("I'm in a ");
            }
            this.Output(Rooms[this.Location]);
        }
        this.Output("\nObvions exits: ");
        for (n = 0; n < 6; ++n) {
            if (ExitMap[this.Location * 6 + n] == '\u0000') continue;
            if (!bl) {
                this.TopOutput(",");
            }
            bl = true;
            this.TopOutput(ExitNames[n]);
        }
        if (!bl) {
            this.TopOutput("none");
        }
        this.TopOutput("\n");
        bl = false;
        for (n = 0; n < NumObjects; ++n) {
            if (this.Objects[n] != this.Location) continue;
            if (!bl) {
                if (this.UseYou) {
                    this.TopOutput("\nYou can also see: ");
                } else {
                    this.TopOutput("\nI can also see: ");
                }
                bl = true;
            } else if (!this.Trash80) {
                this.TopOutput(" - ");
            }
            this.TopOutput(ObjectNames[n]);
            if (!this.Trash80) continue;
            this.TopOutput(". ");
        }
        this.TopDone();
    }

    void ExecuteAction(char c) {
        switch (c) {
            case '\u0000': {
                return;
            }
            case '4': {
                if (this.CountCarried() >= Carry) {
                    this.CarryLimit();
                } else {
                    this.Plonk(this.Param(), '\u00ff');
                }
                return;
            }
            case '5': {
                this.Plonk(this.Param(), this.Location);
                return;
            }
            case '6': {
                char c2 = this.Param();
                this.Plonk(c2, this.Param());
                return;
            }
            case '7': {
                this.Plonk(this.Param(), '\u0000');
                return;
            }
            case '8': {
                this.Flags[15] = true;
                return;
            }
            case '9': {
                this.Flags[15] = false;
                return;
            }
            case ':': {
                this.Flags[this.Param()] = true;
                return;
            }
            case ';': {
                this.Plonk(this.Param(), '\u0000');
                return;
            }
            case '<': {
                this.Flags[this.Param()] = false;
                return;
            }
            case '=': {
                if (this.UseYou) {
                    this.Output("You are dead.\n");
                } else {
                    this.Output("I am dead.\n");
                }
                this.Flags[15] = false;
                this.Location = (char)(NumRooms - 1);
                this.Look();
                return;
            }
            case '>': {
                char c3 = this.Param();
                this.Objects[c3] = this.Param();
                return;
            }
            case '?': {
                this.GameOver();
                return;
            }
            case '@': {
                this.Look();
                return;
            }
            case 'A': {
                int n = this.CountTreasure();
                if (this.UseYou) {
                    this.Output("You have stored ");
                } else {
                    this.Output("I've stored ");
                }
                this.OutputNumber(n);
                this.Output(" treasures. On a scale of 0 to 100, that rates ");
                this.OutputNumber(n * 100 / Treasures);
                this.Output(".\n");
                if (n == Treasures) {
                    this.Output("Well done.\n");
                    this.GameOver();
                }
                return;
            }
            case 'B': {
                this.Inventory();
                return;
            }
            case 'C': {
                this.Flags[0] = true;
                return;
            }
            case 'D': {
                this.Flags[0] = false;
                return;
            }
            case 'E': {
                this.LightTime = LightRefill;
                this.Plonk('\t', '\u00ff');
                this.Flags[9] = false;
                return;
            }
            case 'F': {
                this.ClearScreen();
                return;
            }
            case 'G': {
                this.SaveGame();
                return;
            }
            case 'H': {
                char c4 = this.Param();
                char c5 = this.Param();
                char c6 = this.Objects[c4];
                this.Plonk(c4, this.Objects[c5]);
                this.Plonk(c5, c6);
                return;
            }
            case 'I': {
                this.Continuation = true;
                return;
            }
            case 'J': {
                this.Plonk(this.Param(), '\u00ff');
                return;
            }
            case 'K': {
                char c7 = this.Param();
                this.Plonk(c7, this.Objects[this.Param()]);
                return;
            }
            case 'L': {
                this.Look();
                return;
            }
            case 'M': {
                if (this.CurCounter > 0) {
                    --this.CurCounter;
                }
                return;
            }
            case 'N': {
                this.OutputNumber(this.CurCounter);
                return;
            }
            case 'O': {
                this.CurCounter = this.Param();
                return;
            }
            case 'P': {
                char c8 = this.Yoho[this.CurYoho];
                this.Yoho[this.CurYoho] = this.Location;
                this.Location = c8;
                return;
            }
            case 'Q': {
                char c9 = this.Param();
                int n = this.CurCounter;
                this.CurCounter = this.Counters[c9];
                this.Counters[c9] = n;
                return;
            }
            case 'R': {
                this.CurCounter += this.Param();
                return;
            }
            case 'S': {
                this.CurCounter -= this.Param();
                if (this.CurCounter < -1) {
                    this.CurCounter = -1;
                }
                return;
            }
            case 'T': {
                this.Output(this.NounString);
                return;
            }
            case 'U': {
                this.Output(this.NounString);
            }
            case 'V': {
                this.Output("\n");
                return;
            }
            case 'W': {
                char c10 = this.Param();
                char c11 = this.Location;
                this.Location = this.Yoho[c10];
                this.Yoho[c10] = c11;
                this.Redraw = true;
                return;
            }
            case 'X': {
                this.TwoSecondDelay();
                return;
            }
            case 'Y': {
                this.DrawPicture(this.Param());
                return;
            }
        }
        if (c < '3') {
            this.Output(Messages[c]);
        } else if (c > 'e') {
            this.Output(Messages[c - 50]);
        }
    }

    void ExecuteActionPair(char c) {
        this.ExecuteAction((char)(c / 150));
        if (!this.Ended) {
            this.ExecuteAction((char)(c % 150));
        }
    }

    boolean ExecuteLineCodes(int n) {
        this.ParamPtr = 0;
        for (int i = 0; i < 5; ++i) {
            if (!this.ExecuteCondition(GameCode[n])) {
                return false;
            }
            ++n;
        }
        this.ParamPtr = 0;
        this.ExecuteActionPair(GameCode[n]);
        if (!this.Ended) {
            this.ExecuteActionPair(GameCode[n + 1]);
        }
        return true;
    }

    boolean RandomChance(char c) {
        int n = this.Rng.nextInt() % 100;
        return n <= c;
    }

    int ExecuteActions(char c, char c2) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        this.Continuation = false;
        for (int i = 0; i < Actions; ++i) {
            char c3 = GameCode[n];
            char c4 = (char)(c3 / 150);
            c3 = (char)(c3 % 150);
            if (this.Continuation && c3 != '\u0000') {
                this.Continuation = false;
                if (c != '\u0000') break;
            }
            if (!this.Continuation) {
                if (c != '\u0000' && bl2) break;
                if (c != c3) {
                    n += 8;
                    continue;
                }
                if (c3 == '\u0000') {
                    if (!this.RandomChance(c4)) {
                        n += 8;
                        continue;
                    }
                } else if (c4 != c2 && c4 != '\u0000') {
                    n += 8;
                    continue;
                }
            }
            bl = true;
            if (this.ExecuteLineCodes(n)) {
                bl2 = true;
            }
            n += 8;
        }
        if (bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    boolean GoHelper(char c) {
        char c2;
        boolean bl = this.Dark();
        if (c == '\u03e8') {
            this.Output("Give me a direction too.");
            return false;
        }
        if (c < '\u0001' || c > '\u0006') {
            return false;
        }
        if (bl) {
            this.Output("Dangerous to move in the dark! ");
        }
        if ((c2 = ExitMap[this.Location * 6 + c - 1]) != '\u0000') {
            this.Location = c2;
            this.Look();
            return true;
        }
        if (!bl) {
            if (!this.UseYou) {
                this.Output("I can't go in that direction. ");
            } else {
                this.Output("You can't go in that direction. ");
            }
            return true;
        }
        if (!this.UseYou) {
            this.Output("I fell down and broke my neck. ");
        } else {
            this.Output("You fell down and broke your neck. ");
        }
        this.Ended = true;
        return true;
    }

    char MatchVerb(String string) {
        int n = string.length();
        char c = '\u0000';
        if (n > WordLength) {
            n = WordLength;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i <= NumVerbs; ++i) {
            if (Verbs[i].charAt(0) == '*') {
                if (!this.StringEqual(string2, Verbs[i].substring(1))) continue;
                return c;
            }
            c = (char)i;
            if (!this.StringEqual(string2, Verbs[i])) continue;
            return c;
        }
        return '\u0000';
    }

    char MatchNoun(String string) {
        int n = string.length();
        char c = '\u0000';
        if (n > WordLength) {
            n = WordLength;
        }
        String string2 = string.substring(0, n);
        for (int i = 0; i <= NumNouns; ++i) {
            if (Nouns[i].charAt(0) == '*') {
                if (!this.StringEqual(string2, Nouns[i].substring(1))) continue;
                return c;
            }
            c = (char)i;
            if (!this.StringEqual(string2, Nouns[i])) continue;
            return c;
        }
        return '\u0000';
    }

    char MatchUpItem(char c, char c2) {
        for (char c3 = '\u0000'; c3 < NumObjects; c3 = (char)((char)(c3 + 1))) {
            if (this.Objects[c3] != c2 || AutoGets[c3] != c) continue;
            return c3;
        }
        return '\u03e8';
    }

    void GetAllHelper() {
        boolean bl = false;
        for (int i = 0; i < NumObjects; ++i) {
            if (this.Objects[i] != this.Location || AutoGets[i] == '\u03e8') continue;
            this.ExecuteActions('\n', AutoGets[i]);
            if (this.CountCarried() >= Carry) {
                this.CarryLimit();
                bl = true;
                break;
            }
            this.Plonk((char)i, '\u00ff');
            this.Output(ObjectNames[i]);
            this.Output(": OK.\n");
            bl = true;
        }
        if (!bl) {
            this.Output("Nothing taken.\n");
        }
    }

    boolean GetHelper(char c) {
        if (this.StringEqual(this.NounString, "ALL")) {
            if (this.Dark()) {
                this.Output("It is dark.\n");
            } else {
                this.GetAllHelper();
            }
            return true;
        }
        if (c == '\u03e8') {
            this.Output("What ? ");
            return false;
        }
        if (this.CountCarried() >= Carry) {
            this.CarryLimit();
            return false;
        }
        char c2 = this.MatchUpItem(c, this.Location);
        if (c2 == '\u03e8') {
            if (this.UseYou) {
                this.Output("It is beyond your power to do that. ");
            } else {
                this.Output("It is beyond my power to do that. ");
            }
            return false;
        }
        this.Plonk(c2, '\u00ff');
        this.Output("O.K. ");
        return true;
    }

    void DropAllHelper() {
        boolean bl = false;
        for (int i = 0; i < NumObjects; ++i) {
            if (this.Objects[i] != '\u00ff' || AutoGets[i] == '\u03e8') continue;
            this.ExecuteActions('\u0012', AutoGets[i]);
            this.Plonk((char)i, this.Location);
            this.Output(ObjectNames[i]);
            this.Output(": OK.\n");
            bl = true;
        }
        if (!bl) {
            this.Output("Nothing dropped.\n");
        }
    }

    boolean DropHelper(char c) {
        if (this.StringEqual(this.NounString, "ALL")) {
            this.DropAllHelper();
            return true;
        }
        if (c == '\u03e8') {
            this.Output("What ? ");
            return false;
        }
        char c2 = this.MatchUpItem(c, this.Location);
        if (c2 == '\u03e8') {
            if (this.UseYou) {
                this.Output("It is beyond your power to do that. ");
            } else {
                this.Output("It is beyond my power to do that. ");
            }
            return false;
        }
        this.Plonk(c2, this.Location);
        this.Output("O.K. ");
        return true;
    }

    boolean RunCommandLine(char c, char c2) {
        if (c == '\u0001' && this.GoHelper(c2)) {
            return true;
        }
        int n = this.ExecuteActions(c, c2);
        if (n != 0) {
            if (c == '\n' ? this.GetHelper(c2) : c == '\u0012' && this.DropHelper(c2)) {
                return true;
            }
            if (n == 2) {
                this.Output("I don't understand your command. ");
            }
            if (n == 1) {
                this.Output("I can't do that yet. ");
            }
            return false;
        }
        return true;
    }

    void LampIterate() {
        if (this.Objects[9] == '\u0000') {
            return;
        }
        if (this.LightTime == -1) {
            return;
        }
        --this.LightTime;
        if (this.LightTime < 1) {
            this.Flags[16] = true;
            if (this.Objects[9] == '\u00ff' || this.Objects[9] == this.Location) {
                if (this.ScottLight) {
                    this.Output("Light has run out! ");
                } else if (this.UseYou) {
                    this.Output("Your light has run out. ");
                } else {
                    this.Output("My light has run out. ");
                }
                if (this.Flags[15]) {
                    this.Redraw = true;
                }
            }
            if (this.OldLamp) {
                this.Plonk('\t', '\u0000');
            }
        } else if (this.LightTime < 25 && (this.Objects[9] == '\u00ff' || this.Objects[9] == this.Location)) {
            if (this.ScottLight) {
                this.Output("Light runs out in ");
                this.OutputNumber(this.LightTime);
                this.Output(" turns. ");
            } else if (this.LightTime % 5 == 0) {
                if (this.UseYou) {
                    this.Output("Your light is growing dim. ");
                } else {
                    this.Output("My light is growing dim. ");
                }
            }
        }
    }

    public void FirstGameCycle() {
        this.ExecuteActions('\u0000', '\u0000');
        this.Look();
        this.Redraw = false;
    }

    public boolean GameCycle(String string) {
        this.RunCommandLine(this.VerbCode, this.NounCode);
        if (!this.Ended) {
            this.LampIterate();
            this.ExecuteActions('\u0000', '\u0000');
        }
        if (this.Redraw) {
            this.Look();
            this.Redraw = false;
        }
        return !this.Ended;
    }

    static {
        ExitNames = new String[]{"North", "East", "South", "West", "Up", "Down"};
    }
}

