/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class ScottCanvas
extends Canvas {
    int x;
    int yLine;
    int bottom_x;
    int textLines;
    int myWidth;
    int myHeight;
    int spaceWidth;
    int wWidth;
    int lineHeight;
    String[] textLine;
    Font myFont;
    Display display;
    ScottFree myOwner;
    boolean splitScreen;
    int scrollLine;

    public int Characters() {
        return this.textLines * (this.myWidth / this.wWidth);
    }

    public int Lines() {
        return this.textLines;
    }

    void TryFont(int n) {
        this.myFont = Font.getFont((int)64, (int)0, (int)n);
        this.spaceWidth = this.myFont.stringWidth(" ");
        this.wWidth = this.myFont.stringWidth("w");
        this.myWidth = this.getWidth();
        this.myHeight = this.getHeight();
        this.lineHeight = this.myFont.getHeight() + 1;
        this.textLines = this.myHeight / this.lineHeight;
    }

    public ScottCanvas(ScottFree scottFree) {
        this.myOwner = scottFree;
        this.TryFont(8);
        if (this.Characters() > 480) {
            this.TryFont(0);
        }
        if (this.Characters() < 800 || this.Lines() < 12) {
            this.TryFont(8);
        }
        this.textLine = new String[this.textLines];
        this.ClearScreen();
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.myWidth, this.myHeight);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.myFont);
        for (int i = 0; i < this.textLines; ++i) {
            graphics.drawString(this.textLine[i], 0, i * this.lineHeight, 20);
        }
    }

    void ScrollUp() {
        if (this.yLine < this.textLines - 1) {
            ++this.yLine;
            this.x = 0;
            return;
        }
        if (this.x != 0) {
            for (int i = this.scrollLine + 1; i < this.textLines; ++i) {
                this.textLine[i - 1] = this.textLine[i];
            }
            this.textLine[this.textLines - 1] = "";
            this.x = 0;
        }
    }

    void AddWord(String string) {
        int n = 0;
        if (string.length() == 0) {
            return;
        }
        int n2 = this.myFont.stringWidth(string);
        if (this.x != 0) {
            n = this.spaceWidth;
        }
        if (n2 < this.myWidth && n2 + n + this.x >= this.myWidth) {
            this.ScrollUp();
        }
        this.textLine[this.yLine] = this.x != 0 ? this.textLine[this.yLine] + " " + string : string;
        this.x += n2 + this.spaceWidth;
    }

    public void ClearScreen() {
        int n = this.scrollLine - 1;
        if (!this.splitScreen) {
            n = this.textLines;
        }
        for (int i = 0; i < n; ++i) {
            this.textLine[i] = "";
        }
        this.x = 0;
    }

    public void AddString(String string) {
        while (true) {
            if (string.length() > 0 && string.charAt(0) == '\n') {
                this.ScrollUp();
                string = string.substring(1);
                continue;
            }
            int n = string.indexOf(32);
            int n2 = string.indexOf(10);
            if (n2 != -1 && (n == -1 || n > n2)) {
                n = n2;
            }
            if (n == -1) {
                this.AddWord(string);
                return;
            }
            String string2 = string.substring(0, n);
            this.AddWord(string2);
            if (string.charAt(n) == '\n') {
                this.ScrollUp();
            }
            string = string.substring(n + 1, string.length());
        }
    }

    public void SplitScreen() {
        this.splitScreen = true;
        this.SwitchToBottomScreen();
    }

    public void SwitchToTopScreen() {
        if (this.splitScreen) {
            this.bottom_x = this.x;
            this.ClearScreen();
            this.yLine = 0;
        } else {
            this.AddString("\n");
        }
    }

    public void SwitchToBottomScreen() {
        if (this.splitScreen) {
            this.scrollLine = this.yLine + 1;
            this.x = this.bottom_x;
            this.yLine = this.textLines - 1;
        }
    }

    public void SetCurrent() {
        this.display.setCurrent((Displayable)this);
    }

    public void Refresh() {
        this.repaint();
    }

    public void SetDisplay(Display display) {
        this.display = display;
    }

    public void keyPressed(int n) {
        if (this.myOwner == null) {
            return;
        }
        n = this.getGameAction(n);
        switch (n) {
            case 2: {
                this.myOwner.PerformCommand("WEST");
                return;
            }
            case 5: {
                this.myOwner.PerformCommand("EAST");
                return;
            }
            case 1: {
                this.myOwner.PerformCommand("NORTH");
                return;
            }
            case 6: {
                this.myOwner.PerformCommand("SOUTH");
                return;
            }
        }
    }
}

