//-----------------------------------------------------------------------------
// EPFORMS.DL  Ernest Pazera's Forms                       compiled by Athlor |
//-----------------------------------------------------------------------------
#include <CyWin.h>

__dl "epforms.dl" 0 int FileListForm(char*,char*,char*,struct cWinApp*,int,int,int,int);
__dl "epforms.dl" 1 int SimpleMenuForm(char*,char**,int,int,int,int,bool,struct cWinApp*);
__dl "epforms.dl" 2 int MessageBox(char *,char *,long,struct cWinApp *);
__dl "epforms.dl" 3 int InputBox(char*,char*,long,int,char*,struct  cWinApp *);

//-----------------------------------------------------------------------------
// FileListForm  by Ernest Pazera                                             |
//-----------------------------------------------------------------------------
int FileListForm(
 char* title,    // (IN) Title of the form
 char* filter,   // (IN) Filter for file list
 char* filename, // (OUT) Filename selected
 struct cWinApp* ptr_win_app, // (IN) app pointer(main_module.m_process)
 int x,          // Upper left corner, x pos
 int y,          // Upper left corner, y pos
 int w,          // Width of form
 int h           // Height of form
)
{
 int Result; // Return value
 char temp[10];
 struct cCustomForm* pCustomForm; // Custom form (pointer only to save stack)
 struct rect_t* pRect; // Rectangle (pointer only)
 struct cList* pList; // List(ptr)
 struct cItem* pItem; // Item(ptr)
 struct Message* pMsg; // Message pointer
 struct FileFind* pFileFind; // File finder
 struct File* pFile; // File information
  set_hourglass(TRUE); // Turn hourglass ON
  pCustomForm=(struct cCustomForm*)malloc(sizeof(struct cCustomForm)); //Alloc
  pRect=(struct rect_t*)malloc(sizeof(struct rect_t)); // Set up rectangle
  rect_set(pRect,x,y,w,h);
  cCustomForm_ctor(pCustomForm,pRect,title,TRUE,ptr_win_app); // Construct
  pList=(struct cList*)malloc(sizeof(struct cList)); // Allocate the list
  cList_ctor(pList,w-6); // Construct the list WAS 158
  pFileFind=(struct FileFind*)malloc(sizeof(struct FileFind)); //Allocate finder
  pFile=(struct File*)malloc(sizeof(struct File)); // Allocate file
  FileFind_ctor(pFileFind,pFile,filter); // Start finding files
    while(FileFind_has_more_elements(pFileFind)) // Add items
    { // Continue until no more elements
      if(FileFind_next_element(pFileFind)) // Find next element
      {
        pItem=(struct cItem*)malloc(sizeof(struct cItem)); // Allocate item
        sprintf(temp,"%u,%uk",pFile->size/1024,(pFile->size%1024)*10/1024);
        cItem_ctor(pItem,w-6,pFile->name,FALSE,temp,NULL); // Construct item
        cList_AddItem(pList,pItem); // Add item
      }
    }
    File_dtor(pFile,FREE_MEMORY); // Destroy fileinfo
    FileFind_dtor(pFileFind,FREE_MEMORY); // Destroy filefind
    cCustomForm_AddObj(pCustomForm,pList,0,0); // Add the list to the form
    pCustomForm->ModalResult=mrNone; // Set the modal result to none
    set_hourglass(FALSE); // Turn hourglass OFF
    while(pCustomForm->ModalResult==mrNone) // Message loop
    {
      cCustomForm_Show(pCustomForm); // Show form
      pMsg=cWinApp_get_message(ptr_win_app,0,1,MSG_USER); // Get a message
      switch(pMsg->msgid)
      {
        case MSG_QUIT:
        case MSG_SHUTUP:
        {
          Result=-2; // Return a -2
          pCustomForm->ModalResult=mrQuit; // Change the modal result
        }break;
        case MSG_KEYDOWN:
        {
          if(Message_get_key_param(pMsg)->scancode==KEY_ESC) // Check for esc
          {
              Result=-1; // Result of -1
              pCustomForm->ModalResult=mrCancel; // Change modalresult
              break;
          }
          if(Message_get_key_param(pMsg)->scancode==KEY_ENTER) // Check enter
          {
            Result=cList_Sel(pList); // Result of selected item
            pItem=cList_get_by_index(pList,Result); // Get item
            strcpy(filename,cItem_GetTitle(pItem)); // Copy name to filename
            pCustomForm->ModalResult=mrOk; // Change modalresult
            break;
          }
        }
        default:
          cCustomForm_proc(pCustomForm,pMsg); // Default processing
      }
      Message_delete(pMsg); // Delete the message
    }
    cCustomForm_Hide(pCustomForm); // Hide form
    while(cList_GetCount(pList)>0) // Clear out the list
    {
      pItem=cList_get_by_index(pList,0); // Grab first item
      cList_RemObj(pList,pItem); // Remove item
      cItem_dtor(pItem,FREE_MEMORY); // Destroy item
    }
    cCustomForm_RemObj(pCustomForm,pList); // Remove list from form
    cList_dtor(pList,FREE_MEMORY); // Destroy list
    cCustomForm_dtor(pCustomForm,FREE_MEMORY); // Destroy form
    free(pRect); // Destroy rect
 return(Result); // Return the result
}

//-----------------------------------------------------------------------------
// SimpleMenuForm  by Ernest Pazera                                           |
//-----------------------------------------------------------------------------
int SimpleMenuForm(
 char* title,     // (IN) Title of the menu
 char** ItemList, // (IN) List of items (array of char*, with last item being "")
 int x,           // (IN) X coordinate of upperleft
 int y,           // (IN) Y coordinate of upperleft
 int width,       // (IN) Width of form
 int height,      // (IN) Height of form
 bool round,      // (IN) TRUE=rounded, FALSE=rectangular
 struct cWinApp* ptr_win_app // (IN) App pointer(main_module.m_process)
)
{
 struct cCustomForm* pCustomForm; // Custom form (pointer only to save stack)
 struct rect_t* pRect; // Rectangle (pointer only)
 struct cList* pList; // List(ptr)
 struct cItem* pItem; // Item(ptr)
 int index; // Index
 int Result; // Return value
 struct Message* pMsg; // Message pointer
  pCustomForm=(struct cCustomForm*)malloc(sizeof(struct cCustomForm)); // Allocate
  pRect=(struct rect_t*)malloc(sizeof(struct rect_t)); // Set up rectangle
  rect_set(pRect,x,y,width,height);
  cCustomForm_ctor(pCustomForm,pRect,title,round,ptr_win_app); // Construct
  pList=(struct cList*)malloc(sizeof(struct cList)); // Allocate the list
  cList_ctor(pList,width-6); // Construct the list
  index=0; // Add items
  while(strlen(ItemList[index])>0)
  {
    pItem=(struct cItem*)malloc(sizeof(struct cItem)); // Allocate a new item
    cItem_ctor(pItem,width-6,ItemList[index],FALSE,NULL,NULL); // Construct item
    cList_AddItem(pList,pItem); // Add item
    index++;
  }
  cCustomForm_AddObj(pCustomForm,pList,0,0); // Add the list to the form
  pCustomForm->ModalResult=mrNone; // Set the modal result to none
  while(pCustomForm->ModalResult==mrNone) // Message loop
  {
    cCustomForm_Show(pCustomForm); // Show form
    pMsg=cWinApp_get_message(ptr_win_app,0,1,MSG_USER);  // Get a message
    switch(pMsg->msgid)
    {
      case MSG_QUIT:
      case MSG_SHUTUP:
      {
        Result=-2; // Return a -2
        pCustomForm->ModalResult=mrQuit; // Change the modal result
      }break;
      case MSG_KEYDOWN:
      {
        if(Message_get_key_param(pMsg)->scancode==KEY_ESC) // Check for esc
        {
          Result=-1; // Result of -1
          pCustomForm->ModalResult=mrCancel; // Change modalresult
          break;
        }
        if(Message_get_key_param(pMsg)->scancode==KEY_ENTER) // Check for enter
        {
          Result=cList_Sel(pList); // Result of selected item
          pCustomForm->ModalResult=mrOk; // Change modalresult
          break;
        }
      }
      default:
        cCustomForm_proc(pCustomForm,pMsg); // Default processing
    }
    Message_delete(pMsg); // Delete the message
  }
  cCustomForm_Hide(pCustomForm); // Hide form
  while(cList_GetCount(pList)>0) // Clear out the list
  {
    pItem=cList_get_by_index(pList,0);  // Grab first item
    cList_RemObj(pList,pItem); // Remove item
    cItem_dtor(pItem,FREE_MEMORY); // Destroy item
  }
  cCustomForm_RemObj(pCustomForm,pList); // Remove list from form
  cList_dtor(pList,FREE_MEMORY); // Destroy list
  cCustomForm_dtor(pCustomForm,FREE_MEMORY); // Destroy form
  free(pRect); // Destroy rect
 return(Result); // Return the result
}

//-----------------------------------------------------------------------------
// MessageBox  by Ernest Pazera                                               |
//-----------------------------------------------------------------------------
int MessageBox(
 char *title,   // (IN) Title of the message box
 char *message, // (IN) Message for this message box
 long style,    // (IN) Style (combination of mbXXXX constants)
 struct cWinApp *ptr_win_app // (IN) App pointer (main_module.m_process)
)
{
 struct cDialog* pDialog; // Pointer only, cut down on stack space
 int mr; // Return value(modal result)
  pDialog=(struct cDialog*)malloc(sizeof(struct cDialog)); // Allocate dialog
  cDialog_ctor(pDialog,title,message,style,0,ptr_win_app); // Construct dialog
  mr=cDialog_ShowModal(pDialog); // Show the dialog modally
  cDialog_dtor(pDialog,FREE_MEMORY); // Destroy dialog
 return(mr); // Return the modal result
}

//-----------------------------------------------------------------------------
// InputBox  by Ernest Pazera                                                 |
//-----------------------------------------------------------------------------
//input box function(returns a modal result (mrXXXX constant)
int InputBox(
 char* title,     // (IN) Title of the input box
 char* message,   // (IN) Message for this input box
 long style,      // (IN) Style (combination of mbXXXX constants)--NOTE: mbEdit does NOT need to be specified
 int edit_size,   // (IN) Max length of the string for input box
 char* edit_text, // (IN/OUT) Input box text
 struct  cWinApp *ptr_win_app // (IN) App pointer (main_module.m_process)
)
{
 struct cDialog* pDialog; // Pointer only, cut down on stack space
 int mr; // Return value(modal result)
  pDialog=(struct cDialog*)malloc(sizeof(struct cDialog)); // Allocate dialog
  cDialog_ctor(pDialog,title,message,style|mbEdit,edit_size,ptr_win_app); // Construct dialog
  cDialog_SetEditText(pDialog,edit_text); // Set the edit text
  mr=cDialog_ShowModal(pDialog); // Show the dialog modally
  cDialog_GetEditText(pDialog,edit_text); // Retrieve the edit text
  cDialog_dtor(pDialog,FREE_MEMORY); // Destroy dialog
 return(mr); // Return the modal result
}

long main( int argc, char* argv[], bool start )
{
 return 0L;
}
