
#include <time.h>
#include "rnd.h"

long rnd_seed;

void reset_rnd_seed(void)
{
	set_rnd_seed((time(NULL)%(RNG_M-1))+1);
}

void set_rnd_seed(long seedval)
{
	rnd_seed=seedval;
}

long get_rnd_seed(void)
{
	return(rnd_seed);
}


long rnd(void)
{
	long low, high, test;

	high = rnd_seed / RNG_Q;
	low = rnd_seed % RNG_Q;
	test = RNG_A * low - RNG_R * high;
	if(test>0)
		rnd_seed = test;
	else
		rnd_seed = test + RNG_M;

	return rnd_seed;
}

long xrnd(long maxrnd)
{
	if(maxrnd==0L)
		return rnd();
	else
		return((rnd())%maxrnd);
}
