! ==============================================================================
!
!   * * * SLOVENIAN LANGUAGE DEFINITION FILE * * *
!
!
!   Release 2, 22. June 2007
!
!
!   Copyright (c) 2007 by Benjamin Lipovsek
!
!   e-mail:   benolipovsek@yahoo.com
!
! ==============================================================================
!
!   Original file created by Graham Nelson, (c) 1993-2004
!
!   Supplied for use with Inform 6.
!
! ==============================================================================
!
!   NAVODILA:
!
!
!   1. Vkljucitev knjiznice:
!
!      Knjiznico lahko vkljucis na vec nacinov. Lahko jo preprosto preimenujes
!      v English.h in z njo prepises originalno datoteko, ki se nahaja v mapi
!      LIB paketa Inform.
!
!      Vendar pa je mnogo elegantnejsa resitev, da knjiznico Slovenian.h le
!      namestis v mapo LIB, nato pa v komandno ICL vrstico ob kompilaciji
!      programske kode vrines naslednji ukaz:
!
!         +language_name=Slovenian
!
!      Lahko pa zgornji ukaz v kodo vkljucis kar avtomaticno s posebnim
!      stikalom, ki se mora nahajati cisto na zacetku (na vrhu) programske
!      kode. Na sam vrh programa torej vtipkaj:
!
!         !% +language_name=Slovenian
!
!
!   2. Skloni:
!
!      Slovenscina je glede sklonov izjemno tezaven jezik. Razlicnih
!      sklanjatev je ogromno, njihovo implementiranje v univerzalnem smislu
!      pa bi bilo skoraj nemogoce.
!
!      Ta knjiznica zato za svoje delovanje zahteva naslednje strogo (zato pa
!      k sreci nadvse preprosto) pravilo:
!
!      ***********************************************************************
!      * Glavno ime objekta (external name) mora biti nujno zapisano v prvem *
!      * sklonu - IMENOVALNIKU.						     *
!      *								     *
!      * Vsak objekt pa mora vsebovati tudi posebno polje petih elementov,   *
!      * imenovano "SKLON", v katerem je ime objekta zapisano po vrsti se v  *
!      * ostalih sklonih od RODILNIKA do ORODNIKA (glej spodnja primera).    *
!      ***********************************************************************
!
!      Prav tako je dobro (vendar ne nujno), da programer tudi vsa klicna
!      imena (name) zapise v vseh moznih sklonih, s cimer poveca moznost
!      uspesne interakcije z objektom.
!
!      Ocitno je torej, da je pisanja nekoliko vec, vendar je s tem resen
!      tudi ves problem s skloni, jezik pa zveni zelo naravno.
!
!
!   3. Spol:
!
!      Spol mora biti za razliko od angleskih programov definiran za vsak
!      objekt, ne glede na zivost ali stevilo. Zenski spol podaja atribut
!      "female", moskega "male" in srednjega "neuter". Ce atribut za spol
!      ni dolocen, se privzame moski spol.
!
!
!   4. Dvojina:
!
!      Dvojina je zaenkrat sicer implementirana v nekaj primerih, a mnogokrat
!      se vedno odpove. V splosnem se obnasaj, kot da je ni, in raje uporabljaj
!      mnozino.
!
!
!   5. Slovnicno stevilo:
!
!      Objekt, ki predstavlja kup predmetov (npr. 'zlati kovanci'), ali pa je
!      zgolj mnozinski samostalnik (npr. 'vilice'), mora vsebovati atribut
!      "pluralname".
!
!      Pazi pa na objekte, ki sicer predstavljajo vec predmetov, a se sklanjajo v
!      ednini (npr. 'drevje'). Ti predmeti omenjenega atributa ne smejo imeti!
!
!
!   6. Dva primera pravilne definicije objektov za uporabo knjiznice Slovenian.h:
!
!      a)
!
!      Object   miza "velika bela miza"       <- 1.sklon, IMENOVALNIK, NOMINATIV
!        with   name 'velika' 'bela' 'miza'   <-   Cim vec moznih klicnih besed
!                    'velike' 'bele' 'mize'   <-   v razlicnih oblikah (sklonih),
!                    'veliki' 'beli' 'mizi'   <-   s katerimi bi igralec lahko
!                    'veliko' 'belo' 'mizo',  <-   sprozil zahtevane reakcije
!               sklon "velike bele mize"      <- 2.sklon, RODILNIK, GENITIV
!                     "veliki beli mizi"      <- 3.sklon, DAJALNIK, DATIV
!                     "veliko belo mizo"      <- 4.sklon, TOZILNIK, AKUZATIV
!                     "veliki beli mizi"      <- 5.sklon, MESTNIK, LOKATIV
!                     "veliko belo mizo",     <- 6.sklon, ORODNIK, INSTUMENTAL
!               ...,
!         has   female ...;
!
!      (Opomba: V zgornjem primeru izgleda, kot da so za lastnost 'name'
!               zapisani le prvi stirje skloni. Vendar pa sta peti in sesti
!               sklon v tem primeru po obliki enaka tretjemu in cetrtemu,
!               zato besed se enkrat nima smisla ponavljati. V slovenscini
!               je takih ponovitev k sreci precej, tako da si prihranimo
!               nekaj pisanja.)
!
!      b)
!
!      Objekt   letala "reaktivna letala"     <- 1.sklon, IMENOVALNIK, NOMINATIV
!        with   name 'reaktivna'   'letala'   <-   Cim vec moznih klicnih
!                    'reaktivnih'  'letal'    <-   besed v razlicnih oblikah
!                    'reaktivnim'  'letalom'  <-   (sklonih), s katerimi bi
!                                  'letalih'  <-   igralec lahko sprozil
!                    'reaktivnimi' 'letali',  <-   zahtevane reakcije
!               sklon "reaktivnih letal"      <- 2.sklon, RODILNIK, GENITIV
!                     "reaktivnim letalom"    <- 3.sklon, DAJALNIK, DATIV
!                     "reaktivna letala"      <- 4.sklon, TOZILNIK, AKUZATIV
!                     "reaktivnih letalih"    <- 5.sklon, MESTNIK, LOKATIV
!                     "reaktivnimi letali",   <- 6.sklon, ORODNIK, INSTRUMENTAL
!               ...,
!         has   neuter pluralname ...;
!
!
!      Se enkrat pozor! Izpolnjeno polje "SKLON" je *NUJNO* za delovanje!!!
!
! ==============================================================================
!
!   Dodatne informacije, napotke za uporabo in razlage novih funkcij najdes
!   v pdf knjizici "Slovenska interaktivna fikcija", ki jo dobis na naslovu:
!
!      http://sloif.freehost386.com
!
! ==============================================================================
!
! ******************************************************************************
! * Ta verzija knjiznice je se vedno v zgodnji fazi testiranja. Lepo prosim,   *
! * poslji vse najdene napake in hrosce, prav tako pa tudi morebitne ideje,    *
! * predloge in vprasanja, na zgoraj napisani e-naslov. Najlepsa hvala!        *
! ******************************************************************************
!
! ==============================================================================

System_file;

! ------------------------------------------------------------------------------
!    1.   Uvodne nastavitve
! ------------------------------------------------------------------------------

!Constant EnglishNaturalLanguage;    ! Needed to keep old pronouns mechanism
!
! Zgornja funkcija nezakomentirana povzroca Library error 14(0,0)
!

! ------------------------------------------------------------------------------
!  1.1 Definicija kompasa
!
!  Kot vsi objekti v slovenscini morajo imeti tudi smeri neba svojo lastnost
!  SKLON!
! ------------------------------------------------------------------------------

Class   CompassDirection
  with  number 0,
        description [;
            if (location provides compass_look && location.compass_look(self)) rtrue;
            if (self.compass_look()) rtrue;
            L__M(##Look, 7, self);
        ],
        compass_look false,
  has   scenery;

Object Compass "compass" has concealed;

#Ifndef WITHOUT_DIRECTIONS;

CompassDirection -> n_obj "sever"
            with door_dir n_to,
                 name 's//' 'sever' 'severno' 'severu',
                 sklon "severa" "severu" "sever" "severu" "severom",
             has male;

CompassDirection -> s_obj "jug"
            with door_dir s_to, name 'j//' 'jug' 'juzno' 'jugu',
                 sklon "juga" "jugu" "jug" "jugu" "jugom",
             has male;

CompassDirection -> e_obj "vzhod"
            with door_dir e_to, name 'v//' 'vzhod' 'vzhodno' 'vzhodu',
                 sklon "vzhoda" "vzhodu" "vzhod" "vzhodu" "vzhodom",
             has male;

CompassDirection -> w_obj "zahod"
            with door_dir w_to, name 'z//' 'zahod' 'zahodno' 'zahodu',
                 sklon "zahoda" "zahodu" "zahod" "zahodu" "zahodom",
             has male;

CompassDirection -> ne_obj "severovzhod"
            with door_dir ne_to, name 'sv' 'severovzhod' 'severovzhodno' 'severovzhodu',
                 sklon "severovzhoda" "severovzhodu" "severovzhod" "severovzhodu"
                       "severovzhodom",
             has male;

CompassDirection -> nw_obj "severozahod"
             with door_dir nw_to, name 'sz' 'severozahod' 'severozahodno' 'severozahodu',
                  sklon "severozahoda" "severozahodu" "severozahod" "severozahodu"
                        "severozahodom",
              has male;

CompassDirection -> se_obj "jugovzhod"
            with door_dir se_to, name 'jv' 'jugovzhod' 'jugovzhodno' 'jugovzhodu',
                 sklon "jugovzhoda" "jugovzhodu" "jugovzhod" "jugovzhodu" "jugovzhodom",
             has male;

CompassDirection -> sw_obj "jugozahod"
            with door_dir sw_to, name 'jz' 'jugozahod' 'jugozahodno' 'jugozahodu',
                 sklon "jugozahoda" "jugozahodu" "jugozahod" "jugozahodu" "jugozahodom",
             has male;

CompassDirection -> u_obj "strop"
             with door_dir u_to, name 'g//' 'gor' 'strop' 'stropu' 'zgoraj',
                  sklon "stropa" "stropu" "strop" "stropu" "stropom",
              has male;

CompassDirection -> d_obj "tla"
            with door_dir d_to, name 'd//' 'dol' 'tla' 'tlem' 'spodaj',
                 sklon "tal" "tlom" "tla" "tleh" "tlemi",
             has neuter pluralname;

#endif; ! WITHOUT_DIRECTIONS

CompassDirection -> in_obj "notranjost"
            with door_dir in_to, name 'noter' 'notri',
                 sklon "notranjosti" "notranjosti" "notranjost" "notranjosti" "notranjostjo",
             has female;

CompassDirection -> out_obj "zunanjost"
            with door_dir out_to, name 'ven' 'zunaj',
                 sklon "zunanjosti" "zunanjosti" "zunanjost" "zunanjosti" "zunanjostjo",
             has female;

! ------------------------------------------------------------------------------
!    2.   Vokabular
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
!  2.1 Hitri vokabular ukazov in besed, ki jih med igro vpisuje uporabnik
! ------------------------------------------------------------------------------

Constant AGAIN1__WD     = 'ponovi';
Constant AGAIN2__WD     = 'n//';
Constant AGAIN3__WD     = 'ponovi';
Constant OOPS1__WD      = 'ups';
Constant OOPS2__WD      = 'u//';
Constant OOPS3__WD      = 'popravi';
Constant UNDO1__WD      = 'razveljavi';
Constant UNDO2__WD      = 'preklici';						
Constant UNDO3__WD      = 'undo';

Constant ALL1__WD       = 'vse';
Constant ALL2__WD       = 'vsa';
Constant ALL3__WD       = 'vsakega';
Constant ALL4__WD       = 'vsako';
Constant ALL5__WD       = 'vse';
Constant AND1__WD       = 'in';
Constant AND2__WD       = 'ter';
Constant AND3__WD       = 'in';
Constant BUT1__WD       = 'razen';
Constant BUT2__WD       = 'poleg';
Constant BUT3__WD       = 'brez';
Constant ME1__WD        = 'me';
Constant ME2__WD        = 'sebe';
Constant ME3__WD        = 'se';
Constant OF1__WD        = 'od';				
Constant OF2__WD        = 'iz';					
Constant OF3__WD        = 'izmed';				
Constant OF4__WD        = 'od';					
Constant OTHER1__WD     = 'drugega';
Constant OTHER2__WD     = 'drugo';
Constant OTHER3__WD     = 'drug';
Constant THEN1__WD      = 'nato';
Constant THEN2__WD      = 'zatem';
Constant THEN3__WD      = 'potem';

Constant NO1__WD        = 'n//';
Constant NO2__WD        = 'ne';
Constant NO3__WD        = 'nak';
Constant YES1__WD       = 'd//';
Constant YES2__WD       = 'da';
Constant YES3__WD       = 'ja';

Constant AMUSING__WD    = 'zabavno';
Constant FULLSCORE1__WD = 'tockovnik';				
Constant FULLSCORE2__WD = 'tockovnik';			
Constant QUIT1__WD      = 'koncaj';
Constant QUIT2__WD      = 'izhod';
Constant RESTART__WD    = 'znova';
Constant RESTORE__WD    = 'nalozi';

! ------------------------------------------------------------------------------
!  2.2 Zaimki
! ------------------------------------------------------------------------------

Array LanguagePronouns table

  ! word        possible GNAs                   connected
  !             to follow:                      to:
  !             a     i
  !             s  p  s  p
  !             mfnmfnmfnmfn

    'on'      $$100000100000                    NULL
    'ono'     $$001000001000                    NULL
    'njega'   $$101000101000                    NULL
    'ga'      $$101000101000 			NULL
    'njemu'   $$101000101000 			NULL
    'mu'      $$101000101000			NULL
    'njem'    $$101000101000			NULL
    'njim'    $$101000101000			NULL

    'ona'     $$010101010101			NULL
    'nje'     $$010000010000			NULL
    'je'      $$010000010000			NULL
    'njo'     $$010000010000			NULL
    'jo'      $$010000010000			NULL
    'njej'    $$010000010000			NULL

    'njiju'   $$000111000111			NULL
    'ju'      $$000111000111			NULL
    'njima'   $$000111000111			NULL
    'jima'    $$000100000100			NULL

    'oni'     $$000111000111			NULL
    'njih'    $$000111000111			NULL
    'jih'     $$000111000111			NULL
    'njim'    $$000111000111			NULL
    'jim'     $$000111000111			NULL
    'njimi'   $$000111000111			NULL

    'one'     $$000010000010			NULL;

! ------------------------------------------------------------------------------
!  2.3 Deskriptorji
! ------------------------------------------------------------------------------

Array LanguageDescriptors table

  ! word        possible GNAs   descriptor      connected
  !             to follow:      type:           to:
  !             a     i
  !             s  p  s  p
  !             mfnmfnmfnmfn

  'moj'       $$100000100000 	POSSESS_PK	0
  'moja'      $$010101010101   	POSSESS_PK	0
  'moje'      $$011110011110    POSSESS_PK	0
  'mojega'    $$101000101000   	POSSESS_PK	0
  'mojemu'    $$101000101000  	POSSESS_PK	0
  'moji'      $$010111010111  	POSSESS_PK	0
  'mojo'      $$010000010000   	POSSESS_PK	0
  'mojem'     $$101000101000    POSSESS_PK	0
  'mojim'     $$101111101111  	POSSESS_PK	0
  'mojih'     $$000111000111  	POSSESS_PK	0
  'mojima'    $$000111000111   	POSSESS_PK	0
  'mojimi'    $$000111000111    POSSESS_PK	0

  'ta'        $$110101110101 	POSSESS_PK	0
  'to'        $$011000011000    POSSESS_PK	0
  'tega'      $$101000101000 	POSSESS_PK	0
  'te'        $$010110010110 	POSSESS_PK	0
  'temu'      $$101000101000  	POSSESS_PK	0
  'tej'	      $$010000010000   	POSSESS_PK	0
  'tem'       $$101111101111   	POSSESS_PK	0
  'ti'        $$000111000111  	POSSESS_PK	0
  'teh'       $$000111000111  	POSSESS_PK	0
  'tema'      $$000111000111 	POSSESS_PK	0
  'temi'      $$000111000111 	POSSESS_PK	0

  'tisti'     $$110111110111  	POSSESS_PK	1
  'tista'     $$010101010101    POSSESS_PK	1
  'tisto'     $$011000011000 	POSSESS_PK	1
  'tistega'   $$101000101000   	POSSESS_PK	1
  'tiste'     $$010110010110   	POSSESS_PK	1
  'tistemu'   $$101000101000  	POSSESS_PK	1
  'tistem'    $$101000101000 	POSSESS_PK	1
  'tistim'    $$101111101111	POSSESS_PK	1
  'tistih'    $$000111000111   	POSSESS_PK	1
  'tistima'   $$000111000111  	POSSESS_PK	1
  'tistimi'   $$000111000111 	POSSESS_PK	1

  'njegov'    $$100000100000	POSSESS_PK	'ga'
  'njegova'   $$010101010101 	POSSESS_PK	'ga'
  'njegovo'   $$011000011000 	POSSESS_PK	'ga'
  'njegovega' $$101000101000   	POSSESS_PK	'ga'
  'njegove'   $$010110010110  	POSSESS_PK	'ga'
  'njegovemu' $$101000101000    POSSESS_PK	'ga'
  'njegovi'   $$010111010111  	POSSESS_PK	'ga'
  'njegovem'  $$101000101000  	POSSESS_PK	'ga'
  'njegovim'  $$101111101111  	POSSESS_PK	'ga'
  'njegovih'  $$000111000111 	POSSESS_PK	'ga'
  'njegovima' $$000111000111  	POSSESS_PK	'ga'
  'njegovimi' $$000111000111  	POSSESS_PK	'ga'

  'njen'      $$100000100000	POSSESS_PK	'jo'
  'njena'     $$010101010101   	POSSESS_PK	'jo'
  'njeno'     $$011000011000  	POSSESS_PK	'jo'
  'njenega'   $$101000101000  	POSSESS_PK	'jo'
  'njene'     $$010110010110  	POSSESS_PK	'jo'
  'njenemu'   $$101000101000   	POSSESS_PK	'jo'
  'njeni'     $$010111010111  	POSSESS_PK	'jo'
  'njenem'    $$101000101000  	POSSESS_PK	'jo'
  'njenim'    $$101111101111  	POSSESS_PK	'jo'
  'njenih'    $$000111000111 	POSSESS_PK	'jo'
  'njenima'   $$000111000111 	POSSESS_PK	'jo'
  'njenimi'   $$000111000111    POSSESS_PK	'jo'

  'njun'      $$100000100000 	POSSESS_PK	'jih'
  'njuna'     $$010101010101 	POSSESS_PK	'jih'
  'njuno'     $$011000011000 	POSSESS_PK	'jih'
  'njunega'   $$101000101000 	POSSESS_PK	'jih'
  'njune'     $$010110010110	POSSESS_PK	'jih'
  'njunemu'   $$101000101000 	POSSESS_PK	'jih'
  'njuni'     $$010111010111 	POSSESS_PK	'jih'
  'njunem'    $$101000101000 	POSSESS_PK	'jih'
  'njunim'    $$101111101111  	POSSESS_PK	'jih'
  'njunih'    $$000111000111  	POSSESS_PK	'jih'
  'njunima'   $$000111000111 	POSSESS_PK	'jih'
  'njunimi'   $$000111000111   	POSSESS_PK	'jih'

  'njihov'    $$100000100000 	POSSESS_PK	'jih'
  'njihova'   $$010101010101  	POSSESS_PK	'jih'
  'njihovo'   $$011000011000 	POSSESS_PK	'jih'
  'njihovega' $$101000101000  	POSSESS_PK	'jih'
  'njihove'   $$010110010110 	POSSESS_PK	'jih'
  'njihovemu' $$101000101000 	POSSESS_PK	'jih'
  'njihovi'   $$010111010111 	POSSESS_PK	'jih'
  'njihovem'  $$101000101000  	POSSESS_PK	'jih'
  'njihovim'  $$101111101111   	POSSESS_PK	'jih'
  'njihovih'  $$000111000111 	POSSESS_PK	'jih'
  'njihovima' $$000111000111  	POSSESS_PK	'jih'
  'njihovimi' $$000111000111  	POSSESS_PK	'jih';

!
! Deskriptorji za 'osvetljen'/'neosvetljen' so po mojem brez pomena...
!

! ------------------------------------------------------------------------------
!  2.4 Vokabular osnovnih stevil
! ------------------------------------------------------------------------------

Array LanguageNumbers table
    'ena' 1 'dve' 2 'dva' 2 'tri' 3 'stiri' 4 'pet' 5  				
    'sest' 6 'sedem' 7 'osem' 8 'devet' 9 'deset' 10
    'enajst' 11 'dvanajst' 12 'trinajst' 13 'stirinajst' 14 'petnajst' 15
    'sestnajst' 16 'sedemnajst' 17 'osemnajst' 18 'devetnajst' 19 'dvajset' 20;

! ------------------------------------------------------------------------------
!    3.   Pretvorba ukazov v programu razumljivi jezik Informese
! ------------------------------------------------------------------------------

[ LanguageToInformese;

! Dobro bi bilo imeti:
!
!    - funkcija, ki razbije besede, kot je npr. VANJ (vanj --> v njega)
!    - funkcija, ki spremeni vrstni red zaimka in glagola v primerih, ko
!      ta ne ustreza dogovorjenemu redu (npr. "vzemi jabolko nato ga pojej"
!

];

! ------------------------------------------------------------------------------
!    4.   Sporocila, odzivi in odgovori
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
!  4.1 Privzeta spola za zive in nezive objekte
! ------------------------------------------------------------------------------

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = male;

! ------------------------------------------------------------------------------
!  4.2. Zacetne crke besed & clen (ostanek iz angleske razlicice)
! ------------------------------------------------------------------------------

Constant LanguageContractionForms = 1;     ! English has two:
                                           ! 0 = starting with a consonant
                                           ! 1 = starting with a vowel

[ LanguageContraction text; text->0 = 'a'; return 0; ]; ! Povsem brez pomena.
 						        ! Ukaz je dodan le zato,
 						        ! da se ob kompilaciji
 						        ! ne izpise opozorilo

Array LanguageArticles --> "" "" "";

                   !             a           i
                   !             s     p     s     p
                   !             m f n m f n m f n m f n

Array LanguageGNAsToArticles --> 0 0 0 0 0 0 0 0 0 0 0 0;

! ------------------------------------------------------------------------------
!  4.3 Izpis strani neba
! ------------------------------------------------------------------------------

[ LanguageDirection d;
    switch (d) {
      n_to:    print "proti severu";
      s_to:    print "proti jugu";
      e_to:    print "proti vzhodu";
      w_to:    print "proti zahodu";
      ne_to:   print "proti severovzhodu";
      nw_to:   print "proti severozahodu";
      se_to:   print "proti jugovzhodu";
      sw_to:   print "proti jugozahodu";
      u_to:    print "gor";
      d_to:    print "dol";
      in_to:   print "noter";
      out_to:  print "ven";
      default: return RunTimeError(9,d);
    }
];

! ------------------------------------------------------------------------------
!  4.4 Izpis stevil
! ------------------------------------------------------------------------------

[ LanguageNumber n f;
    if (n == 0)    { print "nic"; rfalse; }
    if (n < 0)     { print "minus "; n = -n; }
    if (n >= 1000) { print (LanguageNumber) n/1000, " tisoc"; n = n%1000; f = 1; }
    if (n >= 100)  {
       switch (n/100) {
          1: print "sto";
          2: print "dvesto";
          default: print (LanguageNumber) n/100, "sto";
       }
       n = n%100; f = 1;
    }
    if (n == 0) rfalse;
    if (f == 1) print " ";
    if (n<20)
       switch (n) {
          1:    print "ena";
          2:    print "dva";
          3:    print "tri";
          4:    print "stiri";
          5:    print "pet";
          6:    print "sest";
          7:    print "sedem";
          8:    print "osem";
          9:    print "devet";
          10:   print "deset";
          11:   print "enajst";
          12:   print "dvanajst";
          13:   print "trinajst";
          14:   print "stirinajst";
          15:   print "petnajst";
          16:   print "sestnajst";
          17:   print "sedemnajst";
          18:   print "osemnajst";
          19:   print "devetnajst";
       }
    else {
       switch (n%10) {
          1:    print "enain";
          2:    print "dvain";
          3:    print "triin";
          4:    print "stiriin";
          5:    print "petin";
          6:    print "sestin";
          7:    print "sedemin";
          8:    print "osemin";
          9:    print "devetin";
       }
       switch (n/10) {
          2:  print "dvajset";
          3:  print "trideset";
          4:  print "stirideset";
          5:  print "petdeset";
          6:  print "sestdeset";
          7:  print "sedemdeset";
          8:  print "osemdeset";
          9:  print "devetdeset";
       }
    }
];

! ------------------------------------------------------------------------------
!  4.5 Izpis casa
! ------------------------------------------------------------------------------

[ LanguageTimeOfDay hours mins i;
    i = hours%24;
    if (i == 0) i = 0;
    if (i < 10) print " ";
    print i, ":", mins/10, mins%10;
];

! ------------------------------------------------------------------------------
!  4.6 Izpis glagolov
!
!  Ta funkcija se klice v primerih, ko mora biti izpisana klicna beseda glagola
!  (npr. "I only understood you as far as wanting to TAKE the box." [Misc. 28]).
!  Nekatere klicne besede so namrec okrajsane tudi na zgolj eno crko, zato so
!  za vse te okrajsave tukaj definirane polne besede, ki naj se izpisejo.
!
!  Druga moznost uporabe funkcije pa bi bila tudi za primere, ko velelnik in
!  nedolocnik glagola nista enaka - zgornji odgovor namrec zahteva nedolocnik,
!  besede v gramaticnih tabelah (SlovenianG.h) pa so v velelniku. Vendar pa se
!  v slovenscini nedolocnik in velelnik skoraj vedno razlikujeta, torej bi
!  morali tukaj definirati se enkrat vse glagole v nedolocniku, kar pa nima
!  smisla. Namesto tega je raje nekoliko spremenjen problematicni odgovor
!  (glej [Miscellany 28]).
! ------------------------------------------------------------------------------

[ LanguageVerb i;				
    switch (i) {				
      'i//','inv':			
               print "inventar";			
      'o//':   print "opisi";			
      'p//':   print "poglej";			
      'c//':   print "cakaj";			
      default: rfalse;				
    }						
    rtrue;					
];						

! ----------------------------------------------------------------------------
!  4.7 Detekcija razhroscevalnih ukazov
!
!  LanguageVerbIsDebugging is called by SearchScope.  It should return true
!  if word w is a debugging verb which needs all objects to be in scope.
! ----------------------------------------------------------------------------

#Ifdef DEBUG;
[ LanguageVerbIsDebugging w;
    if (w == 'purloin' or 'tree' or 'abstract'
                       or 'gonear' or 'scope' or 'showobj')
        rtrue;
    rfalse;
];
#Endif;

! ----------------------------------------------------------------------------
!  4.8 Detekcija neprehodnih glagolov
!
!  LanguageVerbLikesAdverb is called by PrintCommand when printing an UPTO_PE
!  error or an inference message.  Words which are intransitive verbs, i.e.,
!  which require a direction name as an adverb ('walk west'), not a noun
!  ('I only understood you as far as wanting to touch /the/ ground'), should
!  cause the routine to return true.
!
!  (Ker slovenscina nima clenov, je tale funkcija najbrz brez pomena.)
! ----------------------------------------------------------------------------

[ LanguageVerbLikesAdverb w;
    if (w == 'pojdi' or 'poglej' or 'porini')
        rtrue;
    rfalse;
];

! ----------------------------------------------------------------------------
!  4.9 Detekcija besed, ki so lahko tako ukaz kot pridevnik
!
!  LanguageVerbMayBeName is called by NounDomain when dealing with the
!  players reply to a "Which do you mean, the short stick or the long
!  stick?" prompt from the parser. If the reply is another verb (for example,
!  LOOK) then then previous ambiguous command is discarded /unless/
!  it is one of these words which could be both a verb /and/ an
!  adjective in a 'name' property.
! ----------------------------------------------------------------------------

[ LanguageVerbMayBeName w;
    if (w == 'dolgo' or 'kratko' or 'normalno'
                    or 'opisno' or 'okrnjeno' or 'gostobesedno')
        rtrue;
    rfalse;
];

! ------------------------------------------------------------------------------
!  4.10 Besede menujev
! ------------------------------------------------------------------------------

Constant NKEY__TX       = "D = dol";
Constant PKEY__TX       = "     G = gor";
Constant QKEY1__TX      = "N = nadaljuj igro";
Constant QKEY2__TX      = "        N = nazaj";
Constant RKEY__TX       = "ENTER = preberi temo";

Constant NKEY1__KY      = 'D';
Constant NKEY2__KY      = 'd';
Constant PKEY1__KY      = 'G';
Constant PKEY2__KY      = 'g';
Constant QKEY1__KY      = 'N';
Constant QKEY2__KY      = 'n';

! ------------------------------------------------------------------------------
!  4.11 Vokabular standardnih besed, ki jih za izpisovanje potrebuje program
!
!  Nekatere izmed teh besed so bile glagoli biti in nekateri zaimki, za katere
!  je ze poskrbljeno v prevodih standardnih odzivov in odgovorov (razdelek 4.16).
!  Preostale besede pa so prevedene, vendar lahko ponekod povzrocajo tezave,
!  kot so na primer napacen sklon, stevilo itd.
! ------------------------------------------------------------------------------

Constant SCORE__TX      = " Tock: ";
Constant MOVES__TX      = "Potez: ";
Constant TIME__TX       = " Cas: ";
Constant CANTGO__TX     = "Ne mores iti v tisto smer.";	! Napacna smer - ze v odgovorih
Constant FORMER__TX     = "kar je nekoc bilo ti";	! Ime originalnega telesa (selfobj)
Constant YOURSELF__TX   = "namenjeno tebi";	! Predpostavljen predmet (npr. Zbudi)
Constant YOU__TX        = "Ti";			! Protagonist, na zacetku stavka
Constant DARKNESS__TX   = "Tema";		! Ime lokacije, ko je temno

Constant THOSET__TX     = "tiste stvari";	! Izpis po nekaterih nepopolnih ukazih
Constant THAT__TX       = "tisto";		! Izpis po nekaterih nepopolnih ukazih
Constant OR__TX         = " ali ";		! Izbira (npr. "Which one..., a OR b?")
Constant NOTHING__TX    = "nic";		! Ime za neobstojec predmet
Constant IS__TX         = "";			! Opisi lokacij (npr. "On the desk IS...")
Constant ARE__TX        = "";			! Opisi lokacij (npr. "On the desk ARE...")
Constant IS2__TX        = "";			! Biti (npr. "Car, in which IS...")
Constant ARE2__TX       = "";			! Biti (npr. "Car, in which ARE...")
Constant AND__TX        = " in ";		! Nastevanje stvari
Constant WHOM__TX       = "";			! Zaimek (npr. "Man, on WHOM...")
Constant WHICH__TX      = "";			! Zaimek (npr. "Car, in WHICH...")
Constant COMMA__TX      = ", ";			! Nastevanje stvari

! ------------------------------------------------------------------------------
!  4.12 Predlogi, stevilo in zaimki
!
!  Naslednje funkcije izpisejo pravilne oblike predlogov, glagolov biti, zaimkov
!  itd. Pri tem upostevajo GNA objekta (spol, stevilo, zivost) in njegovo prvo
!  crko.
! ------------------------------------------------------------------------------

[ PredlogSZ obj;
     @output_stream 3 zacasno_ime;
     print (nominativ) obj;
     @output_stream -3 zacasno_ime;
     if (zacasno_ime->2 == 't' or 's' or 'h' or 'k' or 'f' or 'c' or 'p'
                        or 'T' or 'S' or 'H' or 'K' or 'F' or 'C' or 'P') {print "s"; return;}
     else {print "z"; return;}
];

[ PredlogKH obj;
     @output_stream 3 zacasno_ime;
     print (nominativ) obj;
     @output_stream -3 zacasno_ime;
     if (zacasno_ime->2 == 'k' or 'g' or 'K' or 'G') {print "h"; return;}
     else {print "k"; return;}
];

[ JeSoSi obj;
     if (obj == player)		{print "si"; return;}
     if (obj has pluralname)	{print "so"; return;}
     print "je"; return;
];

[ NiNisoNisi obj;
     if (obj == player) 	{print "nisi"; return;}
     if (obj has pluralname)    {print "niso"; return;}
     print "ni"; return;
];

[ ZaimekAkuzativ obj;
     switch (GetGNAOfObject(obj)) {
     0,6,2,8: print "ga";
     1,7: print "jo";
     default: print "jih";
     }
     return;
];

! ------------------------------------------------------------------------------
!  4.13 Skloni
!
!  Naslednje funkcije izpisejo pravilni sklon predmeta. Pazijo tudi na izpis
!  zaimka, ce je interakcijski ojekt igralec sam. V primeru, da lasnost SKLON
!  v objektu ni bila definirana, izpisejo ime v imenovalniku.
! ------------------------------------------------------------------------------

[ Nominativ obj;
     if (obj == player)		{print "sam"; return;}
     else			{print (name) obj; return;}
];

[ Genitiv obj;
     if (obj == player)		{print "sebe"; return;}
     else if (~~(obj provides sklon)) {print (name) obj; return;}
     else       		{print (string) obj.&sklon-->0; return;}
];

[ Dativ obj;
     if (obj == player)		{print "sebi"; return;}
     else if (~~(obj provides sklon)) {print (name) obj; return;}
     else       		{print (string) obj.&sklon-->1; return;}
];

[ Akuzativ obj;
     if (obj == player) 	{print "sebe"; return;}
     else if (~~(obj provides sklon)) {print (name) obj; return;}
     else			{print (string) obj.&sklon-->2; return;}
];

[ Lokativ obj;
     if (obj == player)		{print "sebi"; return;}
     else if (~~(obj provides sklon)) {print (name) obj; return;}
     else       		{print (string) obj.&sklon-->3; return;}
];

[ Instrumental obj;
     if (obj == player)		{print "seboj"; return;}
     else if (~~(obj provides sklon)) {print (name) obj; return;}
     else       		{print (string) obj.&sklon-->4; return;}
];

! ------------------------------------------------------------------------------
!  4.14 Skloni z veliko zacetnico
!
!  Funkcije, ki se klicejo v primeru, ce mora predmet nastopiti kot prva beseda
!  v vrstici. Takrat te funkcije po potrebi spremenijo prvo crko v veliko
!  zacetnico.
!
!  Ukaz "@output_stream 3 zacasno_ime;" vkljuci pisanje v polje 'zacasno_ime'
!  Izkljuci se s podobnim ukazom, le da je argument tokrat -3.
!
!  Polje 'zacasno_ime' je tabelaricno znakovno polje. V prvi lokaciji (0) je
!  shranjeno stevilo vseh znakov polja, sami znaki pa so razporejeni v celicah
!  od 2 naprej (2,3,4,...).
!
!  Funkcije torej najprej po potrebi izpisejo prvi znak besede (2), nato pa v
!  zanki se vse ostale.
! ------------------------------------------------------------------------------

Array zacasno_ime --> 100;

[ NominativVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (nominativ) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

[ GenitivVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (genitiv) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

[ DativVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (dativ) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

[ AkuzativVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (akuzativ) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

[ LokativVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (lokativ) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

[ InstrumentalVZ obj stevec;
     @output_stream 3 zacasno_ime;
     print (instrumental) obj;
     @output_stream -3 zacasno_ime;
     if ((zacasno_ime->2 >96) && (zacasno_ime->2 < 123))
          print (char) zacasno_ime->2-32;
     else print (char) zacasno_ime->2;
     for (stevec=3:stevec<=(zacasno_ime-->0)+1:stevec++)
          print (char) zacasno_ime->stevec;
];

! ------------------------------------------------------------------------------
!  4.15 Stevec objektov
!
!  Naslednja funkcija vrne ustrezen glagol biti (je/sta/so) ob nastevanju
!  predmetov v/na objektu "LOC". Deluje v dveh fazah:
!  a) Najprej preveri, ali je objekt "LOC" morda prava lokacija, v kateri se
!     nahaja igralec (cetudi sam ni neposredno njen child). Ce je tako, potem
!     se je funkcija klicala iz ukaza LOOK. To pomeni, da izpisuje le tiste
!     predmete, ki niso predhodno opisani z ukazi, kot so "initial", "describe",
!     "when_open" itd. Funkcija torej presteje le navadne, preostale predmete;
!     prav tako ne steje igralca.
!  b) Ce pa objekt "LOC" ni prava lokacija, torej je z igralcem na enakem ali
!     nizjem nivoju glede na drevo objektov, potem enostavno presteje vse
!     predmete v objektu "LOC".
! ------------------------------------------------------------------------------

[ StevecObjektov loc obj sib stevilo;
     stevilo = 0;
     sib = parent(player);
     do
     {
        if (sib == loc)
        {
           objectloop (obj in loc)
           {
              if (obj has scenery || obj has concealed || obj == player ||
                  obj provides describe || (obj provides initial && obj hasnt moved) ||
                 (obj hasnt on && obj provides when_off) ||
                 (obj has on && obj provides when_on) ||
                 (obj hasnt open && obj provides when_closed) ||
                 (obj has open && obj provides when_open));
              else
              {
                 if (obj has pluralname) {print "so"; return;}
                 stevilo++;
              }
           }
           switch (stevilo)
           {
              0: print "ni";
              1: print "je";
              2: print "sta";
              default: print "so";
           }
           return;
        }
        sib = parent(sib);
     }
     until (sib == nothing);
     objectloop (obj in loc)
     {
        if (obj has pluralname) {print "so"; return;}
     }
     switch (children(loc))
     {
        0: print "ni";
        1: print "je";
        2: print "sta";
        default: print "so";
     }
     return;
];

! ------------------------------------------------------------------------------
!  4.16 Standardni odgovori in pravila (LIBRARY MESSAGES)
! ------------------------------------------------------------------------------

[ LanguageLM n x1;
  Answer,Ask:
            "Brez odgovora.";
! Ask:      see Answer
  Attack:   "Nasilje tule ne bo kaj prida zaleglo.";
  Blow:     "Ne mores napihniti ", (genitiv) x1, ".";
  Burn:     "S tem nevarnim dejanjem se ne bi dalo kaj prida doseci.";
  Buy:      "Nic ni naprodaj.";
  Climb:    "Dvomim, da bi se dalo s tem kaj prida doseci.";
  Close: switch (n) {
        1:  print_ret (nominativvz) x1, " ", (ninisonisi) x1, " nekaj, kar bi se dalo
            zapreti.";
        2:  print (nominativvz) x1, " ", (jesosi) x1, " ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "zaprt.";
            1,7,5,11: "zaprta.";
            2,8: "zaprto.";
            3,9: "zaprti.";
            4,10: "zaprte.";
            }
        3:  "Zapres ", (akuzativ) x1, ".";
    }
  CommandsOff: switch (n) {
        1: "[Snemanje ukazov izkljuceno.]";
        #Ifdef TARGET_GLULX;
        2: "[Snemanje ukazov je ze izkljuceno.]";
        #Endif; ! TARGET_
    }
  CommandsOn: switch (n) {
        1: "[Snemanje ukazov vkljuceno.]";
        #Ifdef TARGET_GLULX;
        2: "[Ukazi se trenutno predvajajo.]";
        3: "[Snemanje ukazov je ze vkljuceno.]";
        4: "[Snemanje ukazov ni uspelo.]";
        #Endif; ! TARGET_
    }
  CommandsRead: switch (n) {
        1: "[Predvajanje ukazov.]";
        #Ifdef TARGET_GLULX;
        2: "[Ukazi se ze predvajajo.]";
        3: "[Predvajanje ukazov ni uspelo. Snemanje ukazov je vkljuceno.]";
        4: "[Predvajanje ukazov ni uspelo.]";
        5: "[Predvajanje ukazov koncano.]";
        #Endif; ! TARGET_
    }
  Consult:  "Nic zanimivega ne najdes v ", (lokativ) x1, ".";
  Cut:      "Rezanje ", (genitiv) x1, " bi bilo povsem brez smisla.";
  Dig:      "Ves trud s kopanjem bi bil tule zaman.";
  Disrobe: switch (n) {
        1:  print "Saj ", (genitiv) x1, " sploh nimas ";
            switch (GetGNAOfObject(x1)) {
            0,2,6,8: "oblecenega.";
            1,7: "oblecene.";
            default: "oblecenih.";
            }
        2:  "Sleces si ", (akuzativ) x1, ".";
    }
  Drink:    "Nic primernega ni tukaj za piti.";
  Drop: switch (n) {
        1:  print_ret (nominativvz) x1, " ", (jesosi) x1, " ze tu.";
        2:  "Saj sploh nimas ", (genitiv) x1, ".";
        3:  "(najprej si sleces ", (akuzativ) x1, ")";
        4:  "Opravljeno.";
    }
  Eat: switch (n) {
        1:  print (nominativvz) x1, " ", (jesosi) x1, " povsem ";
            switch (GetGNAOfObject(x1)) {
            0,6: "neuziten.";
            1,5,7,11: "neuzitna.";
            2,8: "neuzitno.";
            3,9: "neuzitni.";
            4,10: "neuzitne.";
            }
        2:  "Pojes ", (akuzativ) x1, ". Ni slabo.";
    }
  EmptyT: switch (n) {
        1:  print (nominativvz) x1, " ne ";
            if (x1 has pluralname) print "morejo "; else print "more ";
            "vsebovati drugih stvari.";
        2:  print (nominativvz) x1, " ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " zaprt.";
            1,7,5,11: " zaprta.";
            2,8: " zaprto.";
            3,9: " zaprti.";
            4,10: " zaprte.";
            }
        3:  print (nominativvz) x1, " ", (jesosi) x1, " ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "prazen.";
            1,7,5,11: "prazna.";
            2,8: "prazno.";
            3,9: "prazni.";
            4,10: "prazne.";
            }
        4:  "Tole dejanje bi tezko karkoli izpraznilo.";
    }
  Enter: switch (n) {
        1:  print "Pa saj si vendar ze ";
            if (x1 has supporter) print "na "; else print "v ";
            print_ret (lokativ) x1, ".";
        2:  print (nominativvz) x1, " ", (ninisonisi) x1, " primeren kraj za ";
            switch (verb_word) {
              'sedi':   "sedenje.";
              'lezi':   "lezanje.";
              default:  "to.";
            }
        3:  print "Ne mores se spraviti v ";
            switch (GetGNAOfObject(x1)) {
            0,6: print "zaprt ";
            1,2,7,8: print "zaprto ";
            3,4,9,10: print "zaprte ";
            default: print "zaprta ";
            }
            print_ret (akuzativ) x1, ".";
        4:  "Lahko gres le v nekaj, kar stoji samo od sebe.";
        5:  print "Spravis se ";
            if (x1 has supporter) print "na "; else print "v ";
            print_ret (akuzativ) x1, ".";
        6:  print "(spravis se ";
            if (x1 has supporter) print (predlogsz) x1, " "; else print "iz ";
            print (genitiv) x1; ")";
        7:  if (x1 has supporter) "(spravis se na ", (akuzativ) x1, ")^";
            if (x1 has container) "(spravis se v ", (akuzativ) x1, ")^";
            "(vstopis v ", (akuzativ) x1, ")^";
    }
  Examine: switch (n) {
        1:  "Tema (samostalnik, zenski spol, ednina, 1. sklon): Odsotnost svetlobe.";
        2:  "Nic posebnega ne opazis glede ", (genitiv) x1, ".";
        3:  print (nominativvz) x1, " ", (jesosi) x1, " trenutno ";
            if (x1 has on) switch (GetGNAOfObject(x1)) {
                           0,6: "vkljucen.";
                           1,5,7,11: "vkljucena.";
                           2,8: "vkljuceno.";
                           3,9: "vkljuceni.";
                           4,10: "vkljucene.";
                           }
            else switch (GetGNAOfObject(x1)) {
                  0,6: "izkljucen.";
                  1,5,7,11: "izkljucena.";
                  2,8: "izkljuceno.";
                  3,9: "izkljuceni.";
                  4,10: "izkljucene.";
                  }
    }
  Exit: switch (n) {
        1:  "Pa saj trenutno nisi v nicemer.";
        2:  print "Ne mores se spraviti ven iz ";
            switch (GetGNAOfObject(x1)) {
            0,2,6,8: print "zaprtega ";
            1,7: print "zaprte ";
            default: "zaprtih ";
            }
            print_ret (genitiv) x1, ".";
        3:  print "Spravis se ";
            if (x1 has supporter) print (predlogsz) x1, " "; else print "iz ";
            print_ret (genitiv) x1, ".";
        4:  print "Pa saj nisi ";
            if (x1 has supporter) print "na "; else print "v ";
            print_ret (lokativ) x1, ".";
    }
  Fill:     "Toda tu ni nobene vode, ki bi se jo dalo tako prenasati.";
  FullScore: switch (n) {
        1:  if (deadflag) print "Razpored tock je bil "; else print "Razpored tock je ";
            "naslednji:^";
        2:  "za najdbo pomembnih predmetov";
        3:  "za obisk pomembnih lokacij";
        4:  print "skupno (od ", MAX_SCORE;
            switch (MAX_SCORE) {
            1: " mozne)";
            default: " moznih)";
            }
    }
  GetOff:   "Pa saj trenutno nisi na ", (lokativ) x1, ".";
  Give: switch (n) {
        1:  print_ret (nominativvz) x1, " zal ", (ninisonisi) x1, " v tvojih rokah.";
        2:  "Nekaj trenutkov zongliras ", (predlogsz) x1, " ", (instrumental) x1, ", a ne
            dosezes nicesar.";
        3:  print "Nic ne kaze, da bi ";
            switch (GetGNAOfObject(x1)) {
            0,6: print "bil ";
            1,75,11: print "bila ";
            2,8: print "bilo ";
            3,9: print "bili ";
            4,10: print "bile ";
            }
            print (nominativ) x1, " kaj prida ";
            switch (GetGNAOfObject(x1)) {
            0,6: "zainteresiran.";
            1,5,7,11: "zainteresirana.";
            2,8: "zainteresirano.";
            3,9: "zainteresirani.";
            4,10: "zainteresirane.";
            }
    }
  Go: switch (n) {
        1:  print "Najprej se bo treba spraviti ";
            if (x1 has supporter) print "dol ", (predlogsz) x1, " "; else print "ven iz ";
            print_ret (genitiv) x1, ".";
        2:  "Ne mores iti v tisto smer.";
        3:  "Ne mores splezati na ", (akuzativ) x1, ".";
        4:  "Ne mores se spustiti po ", (lokativ) x1, ".";
        5:  print "Ne mores, saj ";
            if (x1 has pluralname) "so ti ", (nominativ) x1, " napoti.";
            else "ti je ", (nominativ) x1, " napoti.";
        6:  print "Ne mores, saj ", (nominativ) x1;
            if (x1 has pluralname) " ne vodijo nikamor."; else " ne vodi nikamor.";
    }
  Insert: switch (n) {
        1:  print_ret (akuzativvz) x1, " moras najprej imeti v rokah, preden ",
            (zaimekakuzativ) x1, " lahko vstavis v karkoli drugega.";
        2:  print (nominativvz) x1;
            if (x1 has pluralname) " ne morejo vsebovati stvari.";
            else " ne more vsebovati stvari.";
        3:  print (nominativvz) x1, " ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " zaprt.";
            1,7,5,11: " zaprta.";
            2,8: " zaprto.";
            3,9: " zaprti.";
            4,10: " zaprte.";
            }
        4:  print_ret "Najprej si ", (zaimekakuzativ) x1, " bo treba sleci.";
        5:  "Ne mores vendar vstaviti nekaj samo vase.";
        6:  "(najprej si ", (zaimekakuzativ) x1, " sleces)^";
        7:  "V ", (lokativ) x1, " ni vec prostora.";
        8:  "Opravljeno.";
        9:  print_ret (akuzativvz) x1, " polozis v ", (akuzativ) second, ".";
    }
  Inv: switch (n) {
        1:  "Nicesar nimas.";
        2:  print "V tvojem inventarju ", (stevecobjektov) player;
        3:  print ":^";
        4:  print ".^";
    }
  Jump:     "Povsem brez ucinka skaces na mestu.";
  JumpOver,Tie:
            "S tem se ne bi dalo kaj prida doseci.";
  Kiss:     "Misli raje na igro.";
  Listen:   "Nic nepricakovanega ne slisis.";
  ListMiscellany: switch (n) {
        1:  if (x1 has pluralname) print " (ki proizvajajo svetlobo)";
            else print " (ki proizvaja svetlobo)";
        2:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " zaprt)";
            1,7,5,11: print " zaprta)";
            2,8: print " zaprto)";
            3,9: print " zaprti)";
            4,10: print " zaprte)";
            }
        3:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " zaprt in proizvaja svetlobo)";
            1,7: print " zaprta in proizvaja svetlobo)";
            2,8: print " zaprto in proizvaja svetlobo)";
            3,9: print " zaprti in proizvajajo svetlobo)";
            4,10: print " zaprte in proizvajajo svetlobo)";
            5,11: print " zaprta in proizvajajo svetlobo)";
            }
        4:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " prazen)";
            1,7,5,11: print " prazna)";
            2,8: print " prazno)";
            3,9: print " prazni)";
            4,10: print " prazne)";
            }
        5:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " prazen in proizvaja svetlobo)";
            1,7: print " prazna in proizvaja svetlobo)";
            2,8: print " prazno in proizvaja svetlobo)";
            3,9: print " prazni in proizvajajo svetlobo)";
            4,10: print " prazne in proizvajajo svetlobo)";
            5,11: print " prazna in proizvajajo svetlobo)";
            }
        6:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " zaprt in prazen)";
            1,7,5,11: print " zaprta in prazna)";
            2,8: print " zaprto in prazno)";
            3,9: print " zaprti in prazni)";
            4,10: print " zaprte in prazne)";
            }
        7:  print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " zaprt, prazen in proizvaja svetlobo)";
            1,7: print " zaprta, prazna in proizvaja svetlobo)";
            2,8: print " zaprto, prazno in proizvaja svetlobo)";
            3,9: print " zaprti, prazni in proizvajajo svetlobo)";
            4,10: print " zaprte, prazne in proizvajajo svetlobo)";
            5,11: print " zaprta, prazna in proizvajajo svetlobo)";
            }
        8:  print " (ki ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "proizvaja svetlobo in ga imas oblecenega";
            1,7: print "proizvaja svetlobo in jo imas obleceno";
            3,9,4,10: print "proizvajajo svetlobo in jih imas oblecene";
            5,11: print "proizvajajo svetlobo in jih imas oblecena";
            }
        9:  if (x1 has pluralname) print " (ki proizvajajo svetlobo";
            else print " (ki proizvaja svetlobo";
        10: print " (ki ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "ga imas oblecenega";
            1,7: print "jo imas obleceno";
            3,9,4,10: print "jih imas oblecene";
            5,11: print "jih imas oblecena";
            }
        11: print " (ki ";
        12: switch (GetGNAOfObject(x1)) {
            0,6: print "je odprt";
            1,7: print "je odprta";
            2,8: print "je odprto";
            3,9: print "so odprti";
            4,10: print "so odprte";
            5,11: print "so odprta";
            }
        13: switch (GetGNAOfObject(x1)) {
            0,6: print "je odprt, a prazen";
            1,7: print "je odprta, a prazna";
            2,8: print "je odprto, a prazno";
            3,9: print "so odprti, a prazni";
            4,10: print "so odprte, a prazne";
            5,11: print "so odprta, a prazna";
            }
        14: switch (GetGNAOfObject(x1)) {
            0,6: print "je zaprt";
            1,7: print "je zaprta";
            2,8: print "je zaprto";
            3,9: print "so zaprti";
            4,10: print "so zaprte";
            5,11: print "so zaprta";
            }
        15: switch (GetGNAOfObject(x1)) {
            0,6: print "je zaprt in zaklenjen";
            1,7: print "je zaprta in zaklenjena";
            2,8: print "je zaprto in zaklenjeno";
            3,9: print "so zaprti in zaklenjeni";
            4,10: print "so zaprte in zaklenjene";
            5,11: print "so zaprta in zaklenjena";
            }
        16: switch (GetGNAOfObject(x1)) {
            0,6: print " in prazen";
            1,7,5,11: print " in prazna";
            2,8: print " in prazno";
            3,9: print " in prazni";
            4,10: print " in prazne";
            }
        17: print " (ki ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: print " prazen)";
            1,7,5,11: print " prazna)";
            2,8: print " prazno)";
            3,9: print " prazni)";
            4,10: print " prazne)";
            }
        18: switch (GetGNAOfObject(x1)) {
            0,6,2,8: print ", v katerem ";
            1,7: print ", v kateri ";
            default: print ", v katerih ";
            }
            print (stevecobjektov) x1, " ";
        19: print " (na ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "njem ";
            1,7: print "njej ";
            default: print "njih ";
            }
            print (stevecobjektov) x1, " ";
        20: print ", na ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "njem ";
            1,7: print "njej ";
            default: print "njih ";
            }	
            print (stevecobjektov) x1, " ";
        21: print " (v ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "njem ";
            1,7: print "njej ";
            default: print "njih ";
            }		
            print (stevecobjektov) x1, " ";	
        22: print ", v ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "njem ";
            1,7: print "njej ";
            default: print "njih ";
            }
            print (stevecobjektov) x1, " ";	
    }
  LMode1:   " - nacin opisovanja: Igra je zdaj v normalnem, ~opisnem~ nacinu, ki podaja polne
             opise novih lokacij, poznane lokacije pa opisuje le na kratko.";
  LMode2:   " - nacin opisovanja: Igra je zdaj v ~gostobesednem~ nacinu, ki vedno podaja
             polne opise lokacij (cetudi so bile ze prej obiskane).";
  LMode3:   " - nacin opisovanja: Igra je zdaj v svojem ~okrnjenem~ nacinu, ki nikoli ne
             podaja polnih opisov lokacij (cetudi se niso bile prej obiskane).";
  Lock: switch (n) {
        1:  "Nic ne kaze, da bi se dalo ", (akuzativ) x1, " na kakrsenkoli
             nacin zakleniti.";
        2:  print (nominativvz) x1, " ", (jesosi) x1, " trenutno ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "zaklenjen.";
            1,7,5,11: "zaklenjena.";
            2,8: "zaklenjeno.";
            3,9: "zaklenjeni.";
            4,10: "zaklenjene.";
            }
        3:  "Najprej bo treba zapreti ", (akuzativ) x1, ".";
        4:  print (nominativvz) x1, " zal ne ";
            if (x1 has pluralname) "ustrezajo kljucavnici.";
            else "ustreza kljucavnici.";
        5:  "Zaklenes ", (akuzativ) x1, ".";
    }
  Look: switch (n) {
        1:  print " (na ", (lokativ) x1, ")";
        2:  print " (v ", (lokativ) x1, ")";
        3:  print " (kot ", (object) x1, ")";
        4:  print "^Na ", (lokativ) x1, " ", (stevecobjektov) x1, " ";
            WriteListFrom(child(x1),
              ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT);
            ".";
        5,6:
            if (x1 ~= location) {
                if (x1 has supporter) print "^Na "; else print "^V ";
                print (lokativ) x1, " ", (stevecobjektov) x1, " ";
            }
            else print "^Tukaj ", (stevecobjektov) x1, " ";
            if (n == 5) print "tudi ";
            WriteListFrom(child(x1),
              ENGLISH_BIT+RECURSE_BIT+PARTINV_BIT+TERSE_BIT+CONCEAL_BIT+WORKFLAG_BIT);
            ".";
        7:  "Nic posebnega ne vidis v tej smeri.";
    }
  LookUnder: switch (n) {
        1:  "Pretemno je.";
        2:  "Nic posebnega ne najdes.";
    }
  Mild:     "Prav res.";
  Miscellany: switch (n) {
        1:  "(samo za prvih sestnajst objektov)^";
        2:  "Prav nicesar ne mores storiti!";
        3:  print " Vec srece prihodnjic. ";
        4:  print " CESTITKE! ";
        5:  print "^(Moznosti: zacni ZNOVA, NALOZI shranjeno igro";
            #Ifdef DEATH_MENTION_UNDO;
            print ", RAZVELJAVI zadnjo potezo";
            #Endif;
            if (TASKS_PROVIDED == 0) print ", izpisi TOCKOVNIK";
            if (deadflag == 2 && AMUSING_PROVIDED == 0)
                print ", preberi namige za vse ZABAVNO v igri";
            ", KONCAJ igro.)";
        6:  "[Tvoj interpreter zal ne podpira funkcije ~razveljavi~.]";
            #Ifdef TARGET_ZCODE;
        7:  "Funkcija ~razveljavi~ ni uspela.  [Nekateri interpreterji je ne podpirajo.]";
            #Ifnot; ! TARGET_GLULX
        7:  "[Ne mores razveljavljati dalje.]";
            #Endif; ! TARGET_
        8:  "Prosim, vpisi eno izmed zgornjih moznosti.";
        9:  "^Zdaj je tu temno kot v rogu!";
        10: "Lepo prosim?";
        11: "[Ne mores razveljaviti, cesar nisi storil!]";
        12: "[Zal ne morem razveljaviti dvakrat zapored.]";
        13: "[Prejsnja poteza razveljavljena.]";
        14: "Zal mi je, tega ne morem popraviti.";
        15: "Nic hudega.";
        16: "~Ups~ lahko popravi le eno besedo.";
        17: "Temno je kot v rogu, niti svojega nosu ne vidis.";
        18: print "sebe";
        19: "Izgledas dobro kot se nikoli.";
        20: "Ce zelis ponoviti ukaz kot npr. ~zaba, skoci~, vtipkaj le ~ponovi~, ne pa
             ~zaba, ponovi~.";
        21: "Tezko bo ponoviti kaj takega.";
        22: "Ne mores zaceti stavka z vejico.";
        23: "Izgleda, kot da zelis z nekom govoriti, ni pa mi jasno, s kom.";
        24: "Ne mores govoriti ", (predlogsz) x1, " ", (instrumental) x1, ".";
        25: "Ce zelis s kom govoriti, poizkusi ~nekdo, zdravo~ ali kaj podobnega.";
        26: "(najprej vzames ", (akuzativ) not_holding, ")";
        27: "Tega stavka nisem razumel.";
        28: print "Zal sem razumel le nekaj v zvezi z glagolom ";
        29: "Te stevilke nisem razumel.";
        30: "Nic takega ne vidis.";
        31: "Kaka besedica vec ne bi skodila!";
        32: "Tega vendar nimas v rokah!";
        33: "S tem glagolom ne mores uporabiti vec objektov.";
        34: "Vec objektov hkrati lahko uporabis le enkrat v vrstici.";
        35: "Nisem cisto preprican, na kaj se nanasa zaimek ~", (address) pronoun_word, "~.";
        36: "Iz dejanja si izkljucil nekaj, kar sploh ni bilo vkljuceno.";
        37: "To lahko pocnes le z zivimi bitji.";
            #Ifdef DIALECT_US;
        38: "Tega glagola ne razumem.";
            #Ifnot;
        38: "Tega glagola ne razumem.";
            #Endif;
        39: "S tem si v tej igri ni treba beliti glave.";
        40: "Objekta, ki se nanasa na zaimek ~", (address) pronoun_word, "~ (",
            (the) pronoun_obj, "), trenutno ne vidis.";
        41: "Konca tega ukaza nisem razumel.";
        42: switch(x1) {
            0: print "Nic jih ni";
            1: print "Le 1 je";
            2,3,4: print "Le ", (number) x1, " so";
            default: print "Le ", (number) x1, " jih je";
            }
            " na voljo.";
        43: "Prav nicesar ne mores storiti!";
        44: "Saj sploh nicesar ni!";
        45: print "Kdo tocno te zanima, ";
        46: print "Kaj tocno te zanima, ";
        47: "Zal lahko tukaj uporabis le en predmet. Katerega tocno?";
        48,49: print "[Vse lepo in prav, a temu ukazu vendarle se nekaj manjka.]^";
        50: print "Tvoj skupni sestevek tock ";
            if (x1 > 0) print "se je pravkar povecal za ";
            else { x1 = -x1; print "je pravkar padel za "; }
            switch(x1) {
            1: print "1 tocko";
            2: print "2 tocki";
            3,4: print (number) x1, " tocke";
            default: print (number) x1, " tock";
            }
        51: "(Nekaj dramaticnega se je zgodilo, zato se je tvoj seznam ukazov obcutno
             skrajsal.)";
        52: "^Vpisi stevilo od 1 do ", x1, ", vpisi 0 za osvezitev zaslona, ali pa pritisni
             ENTER.";
        53: "^[Prosim, pritisni SPACE.]";
        54: "[Komentar posnet.]";
        55: "[Komentar NI posnet.]";
        56: print ".^";
        57: print "?^";
    }
  No,Yes:   "Vprasanje je bilo retoricno.";
  NotifyOff:
            "Opombe tockovanja izkljucene.";
  NotifyOn: "Opombe tockovanja vkljucene.";
  Objects: switch (n) {
        1:  "Objekti, ki so bili pobrani:^";
        2:  "(doslej se noben)";
        3:  print "   (objekt imas oblecen)";
        4:  print "   (objekt imas v rokah)";
        5:  print "   (objekt je bil podarjen)";
        6:  print "   (lokacija: ", (nominativ) x1, ")";
        7:  print "   (v ", (lokativ) x1, ")";
        8:  print "   (v ", (lokativ) x1, ")";
        9:  print "   (na ", (lokativ) x1, ")";
        10: print "   (objekt je izgubljen)";
    }
  Open: switch (n) {
        1:  print_ret (nominativvz) x1, " ", (ninisonisi) x1, " nekaj, kar bi se dalo
            odpreti.";
        2:  print "Kaze, da ", (jesosi) x1, " ", (nominativ) x1;
            switch(GetGNAOfObject(x1)) {
            0,6: " zaklenjen.";
            1,7,5,11: " zaklenjena.";
            2,8: " zaklenjeno.";
            3,9: " zaklenjeni.";
            4,10: " zaklenjene.";
            }
        3:  print (nominativvz) x1, " ", (jesosi) x1, " ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "odprt.";
            1,7,5,11: "odprta.";
            2,8: "odprto.";
            3,9: "odprti.";
            4,10: "odprte.";
            }
        4:  print "Odpres ", (akuzativ) x1, ", v ";
            switch (GetGNAOfObject(x1)) {
            0,6,2,8: print "katerem ";
            1,7: print "kateri ";
            default: print "katerih ";
            }
            print (stevecobjektov) x1, " ";
            if (WriteListFrom(child(x1), ENGLISH_BIT+TERSE_BIT+CONCEAL_BIT) == 0) "nicesar";
            ".";
        5:  "Odpres ", (akuzativ) x1, ".";
    }
  Order:    print (nominativvz) x1;
            if (x1 has pluralname) print " imajo"; else print " ima";
            " pametnejse stvari za poceti.";
  Places: switch (n) {
        1:  print "Znane so naslednje lokacije:^^";
        2:  print "^";
    }
  Pray:     "Tvoja molitev ne obrodi konkretnih sadov.";
  Prompt:   print "^>";
  Pronouns: switch (n) {
        1:  print "Trenutni poznani zaimki: ";
        2:  print "se nanasa na ";
        3:  print "ni dolocen";
        4:  "Igra ne pozna nobenega zaimka.";
        5:  ".";
    }
  Pull,Push,Turn: switch (n) {
        1:  print (nominativvz) x1, " ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " trdno pritrjen na mesto.";
            1,7,5,11: " trdno pritrjena na mesto.";
            2,8: " trdno pritrjeno na mesto.";
            3,9: " trdno pritrjeni na mesto.";
            4,10: " trdno pritrjene na mesto.";
            }
        2:  "Ne mores.";
        3:  "Nic posebnega se ne zgodi.";
        4:  "To bi bilo skrajno neprimerno.";
    }
! Push: see Pull
  PushDir: switch (n) {
        1:  "Se ne mores spomniti nic pametnejsega?";
        2:  "To vendar ni nobena smer.";
        3:  "Ne, tja pa nikakor ne.";
    }
  PutOn: switch (n) {
        1:  print_ret (akuzativvz) x1, " moras najprej imeti v rokah, preden ",
            (zaimekakuzativ) x1, " lahko polozis na karkoli drugega.";
        2:  "Ne mores vendar postaviti nekaj samo nase.";
        3:  "Polaganje reci na ", (akuzativ) x1, " te ne bo pripeljalo posebej dalec.";
        4:  "Manjka ti potrebnih spretnosti.";
        5:  "(najprej si ", (zaimekakuzativ) x1, " sleces)^";
        6:  "Na ", (lokativ) x1, " ni vec prostora.";
        7:  "Opravljeno.";
        8:  print_ret (akuzativvz) x1, " polozis na ", (akuzativ) second, ".";
    }
  Quit: switch (n) {
        1:  print "Prosim, odgovori z da ali ne.";
        2:  print "Zelis zares koncati z igranjem? ";
    }
  Remove: switch (n) {
        1:  print (nominativvz) x1, " ", (jesosi) x1, " zal ";
            switch (GetGNAOfObject(x1)) {
            0,6: "zaprt.";
            1,7,5,11: "zaprta.";
            2,8: "zaprto.";
            3,9: "zaprti.";
            4,10: "zaprte.";
            }
        2:  print_ret "Toda ", (genitiv) x1, " vendar ni tam.";
        3:  "Odstranjeno.";
    }
  Restart: switch (n) {
        1:  print "Zelis zares zaceti znova? ";
        2:  "Neuspesno.";
    }
  Restore: switch (n) {
        1:  "Nalaganje ni uspelo.";
        2:  "V redu.";
    }
  Rub:      "S tem nic ne dosezes.";
  Save: switch (n) {
        1:  "Shranjevanje ni uspelo.";
        2:  "V redu.";
    }
  Score: switch (n) {
        1:  if (deadflag) print "Retultat igre je bil ";
            else print "Trenutni rezultat igre je ";
            print score;
            switch (score) {
            -1,1: print " tocka";
            -2,2: print " tocki";
            -4,-3,3,4: print " tocke";
            default: print " tock";
            }
            print " od ", MAX_SCORE;
            if (MAX_SCORE == 1) print " mozne, za kar ";
            else print " moznih, za kar ";
            switch (turns) {
            1: print "je bila potrebna 1 poteza";
            2: print "sta bili potrebni 2 potezi";
            3: print "so bile potrebne 3 poteze";
            4: print "so bile potrebne 4 poteze";
            default: print "je bilo potrebnih ", turns, " potez";
            }
            return;
        2:  "Ta zgodba je brez tock.";
    }
  ScriptOff: switch (n) {
        1:  "Pisanje scenarija je ze izkljuceno.";
        2:  "^Konec scenarija.";
        3:  "Konec pisanja scenarija ni uspel.";
    }
  ScriptOn: switch (n) {
        1:  "Pisanje scenarija je ze vkljuceno.";
        2:  "Zacetek scenarija:";
        3:  "Zacetek pisanja scenarija ni uspel.";
    }
  Search: switch (n) {
        1:  "Pretemno je.";
        2:  "Nicesar ni na ", (lokativ) x1, ".";
        3:  print "Na ", (lokativ) x1, " ", (stevecobjektov) x1;
            WriteListFrom(child(x1), ENGLISH_BIT+TERSE_BIT+CONCEAL_BIT+ISARE_BIT);
            ".";
        4:  "Nic posebnega ne najdes.";
        5:  print "Ne mores videti v notranjost, saj ", (jesosi) x1, " ", (nominativ) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " zaprt.";
            1,7,5,11: " zaprta.";
            2,8: " zaprto.";
            3,9: " zaprti.";
            4,10: " zaprte.";
            }
        6:  print (nominativvz) x1, " ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " prazen.";
            1,7,5,11: " prazna.";
            2,8: " prazno.";
            3,9: " prazni.";
            4,10: " prazne.";
            }
        7:  print "V ", (lokativ) x1, " ", (stevecobjektov) x1,;
            WriteListFrom(child(x1), ENGLISH_BIT+TERSE_BIT+CONCEAL_BIT+ISARE_BIT);
            ".";
    }
  Set:      "Ne, ", (genitiv) x1, " ne mores nastaviti.";
  SetTo:    "Ne, ", (genitiv) x1, " ne mores nastaviti.";
  Show: switch (n) {
        1:  print_ret (nominativvz) x1, " zal ", (ninisonisi) x1, " v tvojih rokah.";
        2:  print (nominativvz) x1, " ", (ninisonisi) x1, " kaj prida ";
            switch (GetGNAOfObject(x1)) {
            0,6: "navdusen.";
            1,5,7,11: "navdusena.";
            2,8: "navduseno.";
            3,9: "navduseni.";
            4,10: "navdusene.";
            }
    }
  Sing:     "Tvoje petje je obupno.";
  Sleep:    "Ne pocutis se posebno zaspano.";
  Smell:    "Nic posebnega ne vohas.";
            #Ifdef DIALECT_US;
  Sorry:    "Ah, nic se ne opravicuj.";
            #Ifnot;
  Sorry:    "Ah, nic se ne opravicuj.";
            #Endif;
  Squeeze: switch (n) {
        1:  "Roke k sebi!";
        2:  "Prav nic ne dosezes s tem.";
    }
  Strong:   "Pravi ljubitelji interaktivne fikcije ne uporabljajo takih besed!";
  Swim:     "Premalo je vode za plavanje.";
  Swing:    "Nic pametnega ne vidis, kar bi se dalo zanihati.";
  SwitchOff: switch (n) {
        1:  print_ret (nominativvz) x1, " ", (ninisonisi) x1, " nekaj, kar bi se dalo
            izkljuciti.";
        2:  print (nominativvz) x1, " ", (jesosi) x1, " ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "izkljucen.";
            1,7,5,11: "izkljucena.";
            2,8: "izkljuceno.";
            3,9: "izkljuceni.";
            4,10: "izkljucene.";
            }
        3:  "Izkljucis ", (akuzativ) x1, ".";
    }
  SwitchOn: switch (n) {
        1:  print_ret (nominativvz) x1, " ", (ninisonisi) x1, " nekaj, kar bi se dalo
            vkljuciti.";
        2:  print (nominativvz) x1, " ", (jesosi) x1, " ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "vkljucen.";
            1,7,5,11: "vkljucena.";
            2,8: "vkljuceno.";
            3,9: "vkljuceni.";
            4,10: "vkljucene.";
            }
        3:  "Vkljucis ", (akuzativ) x1, ".";
    }
  Take: switch (n) {
        1:  "Vzeto.";
        2:  "Hladnokrvno, ni kaj.";
        3:  "Dvomim, da bi bilo ", (dativ) x1, " to vsec.";
        4:  print "Najprej se bo treba spraviti ";
            if (x1 has supporter) print "dol ", (predlogsz) x1, " "; else print "ven iz ";
            print_ret (genitiv) x1, ".";
        5:  "Saj ze imas ", (akuzativ) x1, ".";
        6:  "Kaze, da", (nominativ) noun, " pripada ", (dativ) x1, ".";
        7:  "Kaze, da", (jesosi) noun, " ", (nominativ) noun, " del ", (genitiv) x1, ".";
        8:  print_ret (nominativvz) x1, " ", (ninisonisi) x1, " na voljo.";
        9:  print (nominativvz) x1, " ", (ninisonisi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: "odprt.";
            1,7,5,11: "odprta.";
            2,8: "odprto.";
            3,9: "odprti.";
            4,10: "odprte.";
            }
        10: "Se ti ne zdi, da bi bilo ", (akuzativ) x1, " vendarle nekam nerodno prenasati
             naokrog?";
        11: print (nominativvz) x1, " ", (jesosi) x1;
            switch (GetGNAOfObject(x1)) {
            0,6: " trdno pritrjen na mesto.";
            1,7,5,11: " trdno pritrjena na mesto.";
            2,8: " trdno pritrjeno na mesto.";
            3,9: " trdno pritrjeni na mesto.";
            4,10: " trdno pritrjene na mesto.";
            }
        12: "Ze zdaj prenasas prevec stvari!";
        13: "(", (the) x1, " odlozis v ", (the) SACK_OBJECT, " in s tem ustvaris nekoliko vec
             prostora)";
    }
  Taste:    "Nic posebnega ne okusas.";
  Tell: switch (n) {
        1:  "Nekaj casa se pogovarjas s seboj.";
        2:  "Brez odziva.";
    }
  Think:    "Kako dobra ideja!";
  ThrowAt: switch (n) {
        1:  "Zaman.";
        2:  "Nima smisla. V odlocilnem trenutku ti tako ali tako vedno zmanjka poguma.";
    }
! Tie:  see JumpOver.
  Touch: switch (n) {
        1:  "Roke k sebi!";
        2:  "Nic posebnega ne obcutis.";
        3:  "Ce mislis, da bo to kaj pomagalo...";
    }
! Turn: see Pull.
  Unlock:  switch (n) {
        1:  "Nic ne kaze, da bi se dalo ", (akuzativ) x1, " na kakrsenkoli
             nacin odkleniti.";
        2:  print (nominativvz) x1, " ", (jesosi) x1, " trenutno ze ";
            switch (GetGNAOfObject(x1)) {
            0,6: "odklenjen.";
            1,7,5,11: "odklenjena.";
            2,8: "odklenjeno.";
            3,9: "odklenjeni.";
            4,10: "odklenjene.";
            }
        3:  print (nominativvz) x1, " zal ne ";
            if (x1 has pluralname) "ustrezajo kljucavnici.";
            else "ustreza kljucavnici.";
        4:  "Odklenes ", (akuzativ) x1, ".";
    }
  VagueGo:  "Podati bo treba konkretno smer.";
  Verify: switch (n) {
        1:  "Datoteka z igro je brezhibna.";
        2:  "Datoteka z igro je morda poskodovana!";
    }
  Wait:     "Minute tecejo...";
  Wake:     "Grozljiva resnica je ta, da to sploh niso sanje!";
  WakeOther:"Ne vidim potrebe po tem.";
  Wave: switch (n) {
        1:  print_ret (nominativvz) x1, " zal ", (ninisonisi) x1, " v tvojih rokah.";
        2:  "Prav bedasto izgledas, ko mahas ", (predlogsz) x1, " ", (instrumental) x1, ".";
    }
  WaveHands:"Pomahas, pri tem pa se pocutis skrajno bedasto.";
  Wear: switch (n) {
        1:  "Ne mores si vendar obleci ", (genitiv) x1, "!";
        2:  "Saj ", (genitiv) x1, " sploh nimas v rokah!";
        3:  print_ret (akuzativvz) x1, " imas vendar ze na sebi!";
        4:  "Obleces si ", (akuzativ) x1, ".";
    }
! Yes:  see No.
];

! ==============================================================================

Constant LIBRARY_ENGLISH;       ! for dependency checking.

! ==============================================================================

