/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.blorb;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import org.zmpp.base.MemoryAccess;
import org.zmpp.blorb.MemoryAccessInputStream;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.media.InformMetadata;
import org.zmpp.media.StoryMetadata;

public class BlorbMetadataHandler
extends DefaultHandler {
    private StoryMetadata story;
    private StringBuilder buffer;
    private boolean processAux;

    public BlorbMetadataHandler(FormChunk formChunk) {
        this.extractMetadata(formChunk);
    }

    public InformMetadata getMetadata() {
        return this.story == null ? null : new InformMetadata(this.story);
    }

    private void extractMetadata(FormChunk formChunk) {
        Chunk chunk = formChunk.getSubChunk("IFmd".getBytes());
        if (chunk != null) {
            MemoryAccess memoryAccess = chunk.getMemoryAccess();
            MemoryAccessInputStream memoryAccessInputStream = new MemoryAccessInputStream(memoryAccess, 8, chunk.getSize() + 8);
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse((InputStream)memoryAccessInputStream, (DefaultHandler)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("story".equals(string3)) {
            this.story = new StoryMetadata();
        }
        if ("title".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("headline".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("author".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("genre".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("description".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if (this.isPublishYear(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("auxiliary".equals(string3)) {
            this.processAux = true;
        }
        if ("coverpicture".equals(string3)) {
            this.buffer = new StringBuilder();
        }
        if ("group".equals(string3)) {
            this.buffer = new StringBuilder();
        }
    }

    public void endElement(String string, String string2, String string3) {
        if ("title".equals(string3)) {
            this.story.setTitle(this.buffer.toString());
        }
        if ("headline".equals(string3)) {
            this.story.setHeadline(this.buffer.toString());
        }
        if ("author".equals(string3)) {
            this.story.setAuthor(this.buffer.toString());
        }
        if ("genre".equals(string3)) {
            this.story.setGenre(this.buffer.toString());
        }
        if ("description".equals(string3) && !this.processAux) {
            this.story.setDescription(this.buffer.toString());
        }
        if (this.isPublishYear(string3)) {
            this.story.setYear(this.buffer.toString());
        }
        if ("group".equals(string3)) {
            this.story.setGroup(this.buffer.toString());
        }
        if ("coverpicture".equals(string3)) {
            String string4 = this.buffer.toString().trim();
            try {
                this.story.setCoverPicture(Integer.parseInt(string4));
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException in cover picture: " + string4);
            }
        }
        if ("auxiliary".equals(string3)) {
            this.processAux = false;
        }
        if ("br".equals(string3) && this.buffer != null) {
            this.buffer.append("\n");
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.buffer != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append(cArray[i]);
            }
            this.buffer.append(stringBuilder.toString().trim());
        }
    }

    private boolean isPublishYear(String string) {
        return "year".equals(string) || "firstpublished".equals(string);
    }
}

