/*
 * This file is part of IFM (Interactive Fiction Mapper), copyright (C)
 * Glenn Hutchings 1997-2008.
 *
 * IFM comes with ABSOLUTELY NO WARRANTY.  This is free software, and you
 * are welcome to redistribute it under certain conditions; see the file
 * COPYING for details.
 */

/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /home/daffy/u0/vern/flex/RCS/flex.skl,v 2.91 96/09/10 16:58:48 vern Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>
#include <unistd.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 88
#define YY_END_OF_BUFFER 89
static yyconst short int yy_accept[256] =
    {   0,
        0,    0,   89,   87,    2,    3,    4,    1,   87,   86,
       84,   84,   84,   84,   10,   15,   84,   84,   84,   84,
       84,   84,   84,   84,   43,   84,   84,   59,   84,   76,
       80,    2,    1,   85,    0,   86,    0,   84,   84,   84,
       84,   84,   84,   84,   12,   84,   84,   84,   84,   84,
       84,   84,   84,   84,   84,   27,   84,   84,   31,   32,
       84,   84,   84,   84,   84,   84,   84,   44,   84,   54,
       84,   84,   84,   84,   84,   84,   62,   84,   84,   68,
       84,   84,   84,   74,   84,   84,   79,   84,   84,   83,
       84,    6,    7,   84,    9,   11,   84,   84,   84,   84,

       84,   84,   84,   84,   84,   84,   24,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   42,
       84,   84,   84,   84,   84,   84,   84,   84,   56,   84,
       84,   84,   84,   84,   84,   84,   69,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   83,   84,   84,   13,
       14,   16,   84,   84,   19,   84,   84,   84,   23,   25,
       28,   84,   84,   33,   34,   35,   36,   84,   84,   39,
       40,   41,   45,   84,   84,   49,   84,   84,   53,   84,
       84,   58,   60,   84,   84,   84,   84,   70,   71,   84,
       84,   75,   84,   84,   81,   82,    5,   84,   84,   84,

       20,   84,   84,   26,   84,   84,   37,   84,   84,   84,
       84,   50,   84,   84,   61,   63,   66,   67,   72,   73,
       77,   78,    8,   84,   18,   21,   22,   29,   30,   38,
       46,   47,   48,   84,   84,   55,   84,   84,   84,   84,
       84,   84,   57,   84,   84,   17,   84,   84,   84,   84,
       51,   52,   64,   65,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    6,    1,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    1,    1,    1,
        1,    1,    1,    1,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
        1,    1,    1,    1,    8,    1,    9,   10,   11,   12,

       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       23,   24,   25,   26,   27,   28,   29,   30,   31,   32,
       33,    8,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[34] =
    {   0,
        1,    1,    2,    1,    1,    3,    4,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5
    } ;

static yyconst short int yy_base[260] =
    {   0,
        0,    0,  503,  504,  500,  504,  504,    0,  494,   28,
      494,   30,   32,   33,   34,   37,   64,   49,   31,   43,
       41,   50,   85,   68,   55,   70,   82,  103,  129,   61,
       76,  497,    0,  491,  490,   35,    0,  490,   47,   90,
       73,   97,   95,   74,   91,   98,  109,  107,  112,  119,
      111,  121,  114,  122,  118,  126,  137,  134,  489,  138,
      136,  151,  141,  152,  153,  154,  156,  157,  176,  488,
      159,  161,  160,  163,  165,  167,  487,  170,  178,  486,
      186,  197,  187,  485,  177,  206,  484,  189,  191,    0,
      201,  483,  482,  171,  481,  480,  199,  185,  211,  214,

      216,  217,  219,  218,  220,  221,  479,  224,  225,  226,
      227,  222,  230,  238,  241,  243,  245,  247,  248,  478,
      251,  249,  250,  252,  262,  253,  264,  258,  477,  266,
      272,  273,  268,  274,  277,  276,  476,  278,  279,  285,
      281,  286,  298,  299,  282,  301,    0,  300,  302,  475,
      474,  473,  284,  303,  472,  307,  308,  309,  471,  312,
      470,  316,  313,  469,  468,  467,  466,  317,  315,  465,
      464,  463,  462,  318,  325,  461,  327,  330,  460,  331,
      332,  459,  458,  338,  336,  339,  344,  457,  456,  342,
      347,  455,  348,  350,  454,  453,  452,  352,  353,  355,

      451,  357,  358,  450,  360,  362,  449,  365,  366,  368,
      372,  371,  370,  373,  448,  379,  447,  446,  445,  444,
      435,  432,  429,  374,  427,  425,  423,  422,  421,  420,
      419,  418,  417,  387,  385,  415,  391,  399,  394,  400,
      389,  395,  414,  403,  405,  413,  406,  408,  409,  411,
      412,  319,  172,  124,  504,  439,  442,   79,  444
    } ;

static yyconst short int yy_def[260] =
    {   0,
      255,    1,  255,  255,  255,  255,  255,  256,  255,  255,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  255,  256,  255,  255,  255,  258,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  259,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  259,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,    0,  255,  255,  255,  255
    } ;

static yyconst short int yy_nxt[538] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   26,   11,   11,   27,   28,   29,   30,   11,
       31,   11,   11,   35,   36,   37,   37,   37,   37,   37,
       35,   36,   37,   39,   42,   47,   37,   57,   37,   40,
       44,   41,   37,   43,   37,   37,   45,   58,   48,   46,
       37,   54,   62,   61,   59,   55,   37,   68,   49,   37,
       60,   56,   50,   37,   91,   37,   67,   69,   37,   37,
       51,   37,   86,   90,   87,   70,   52,   37,   88,   53,
       37,   71,   89,   63,   73,   37,   37,   64,   72,   96,

       37,   65,   37,   37,   74,   93,   95,   66,   37,   92,
       94,   75,   37,   76,   37,   77,   37,   37,  100,   37,
       98,   97,  101,   37,   37,   78,   37,   37,  102,   37,
       79,   37,  104,   80,   37,   99,  106,   81,  103,   37,
      105,   37,   37,   37,   82,   83,   37,  108,  110,  107,
      112,   84,  113,  109,   85,  111,   37,   37,   37,   37,
      116,   37,   37,  114,   37,   37,   37,  115,   37,  121,
       37,  128,   37,  117,  118,   37,   37,   37,  132,  120,
      119,   37,   37,   37,  130,  131,  135,  122,  129,  133,
       37,   37,   37,  149,   37,  123,   37,  124,  134,  125,

      137,  126,   37,  127,   37,  142,   37,  140,  151,  139,
      136,   37,  138,  148,  141,  145,   37,  143,  146,   37,
      150,   37,   37,   37,   37,   37,   37,   37,  154,   37,
       37,   37,   37,  144,  157,   37,  160,  162,  152,  158,
      153,  159,  164,   37,  155,  156,   37,  161,   37,  163,
       37,  165,   37,   37,   37,   37,   37,   37,   37,  169,
      171,  166,  173,   37,  176,  170,  175,   37,  167,   37,
      177,   37,  168,   37,  174,  172,  179,   37,   37,   37,
      178,   37,   37,   37,   37,  183,   37,   37,  180,   37,
       37,   37,  182,  184,  181,  187,  188,  190,  192,  189,

      191,  185,  186,   37,   37,   37,   37,   37,   37,  195,
      193,  199,   37,   37,   37,  194,  196,   37,   37,  201,
       37,   37,   37,   37,   37,  197,  200,  198,  205,  207,
       37,  203,   37,  204,  202,   37,   37,   37,  206,  213,
      209,   37,  208,   37,   37,  212,  210,   37,  214,   37,
      215,  216,   37,   37,  211,   37,  218,   37,   37,  220,
       37,  221,   37,   37,  223,   37,  217,   37,  219,  222,
       37,   37,  226,   37,  229,   37,   37,   37,   37,   37,
      230,  228,  225,  234,   37,  224,  232,  233,  227,  231,
       37,  238,   37,  240,   37,  241,   37,  242,  237,   37,

       37,  235,  236,  243,   37,   37,  245,  244,   37,  239,
       37,   37,  246,   37,   37,  247,   37,   37,   37,   37,
       37,  248,   37,   37,   37,   37,   37,   37,   37,  249,
       37,  250,   37,  251,   37,  252,  253,   37,  254,   33,
       37,   33,   33,   33,   38,   38,   38,  147,  147,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   34,   34,   32,   37,

       34,   32,  255,    3,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255
    } ;

static yyconst short int yy_chk[538] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,   10,   10,   12,   19,   13,   14,   15,
       36,   36,   16,   12,   13,   16,   21,   19,   20,   12,
       15,   12,   39,   14,   18,   22,   15,   20,   16,   15,
       25,   18,   22,   21,   20,   18,   30,   25,   16,   17,
       20,   18,   17,   24,   39,   26,   24,   25,   41,   44,
       17,   31,   30,  258,   30,   25,   17,   27,   31,   17,
       23,   26,   31,   23,   27,   40,   45,   23,   26,   44,

       43,   23,   42,   46,   27,   41,   43,   23,   28,   40,
       42,   28,   48,   28,   47,   28,   51,   49,   48,   53,
       46,   45,   49,   55,   50,   28,   52,   54,   49,  254,
       28,   56,   51,   28,   29,   47,   53,   29,   50,   58,
       52,   61,   57,   60,   29,   29,   63,   55,   57,   54,
       60,   29,   61,   56,   29,   58,   62,   64,   65,   66,
       64,   67,   68,   62,   71,   73,   72,   63,   74,   68,
       75,   71,   76,   64,   65,   78,   94,  253,   75,   67,
       66,   69,   85,   79,   73,   74,   79,   69,   72,   76,
       98,   81,   83,   94,   88,   69,   89,   69,   78,   69,

       81,   69,   82,   69,   97,   85,   91,   83,   98,   82,
       79,   86,   81,   91,   83,   88,   99,   86,   89,  100,
       97,  101,  102,  104,  103,  105,  106,  112,  101,  108,
      109,  110,  111,   86,  104,  113,  108,  110,   99,  105,
      100,  106,  112,  114,  102,  103,  115,  109,  116,  111,
      117,  113,  118,  119,  122,  123,  121,  124,  126,  117,
      119,  114,  121,  128,  124,  118,  123,  125,  115,  127,
      125,  130,  116,  133,  122,  119,  127,  131,  132,  134,
      126,  136,  135,  138,  139,  132,  141,  145,  128,  153,
      140,  142,  131,  133,  130,  136,  138,  140,  142,  139,

      141,  134,  135,  143,  144,  148,  146,  149,  154,  145,
      143,  153,  156,  157,  158,  144,  146,  160,  163,  156,
      169,  162,  168,  174,  252,  148,  154,  149,  162,  168,
      175,  158,  177,  160,  157,  178,  180,  181,  163,  180,
      174,  185,  169,  184,  186,  178,  175,  190,  181,  187,
      184,  185,  191,  193,  177,  194,  187,  198,  199,  191,
      200,  193,  202,  203,  198,  205,  186,  206,  190,  194,
      208,  209,  202,  210,  206,  213,  212,  211,  214,  224,
      208,  205,  200,  212,  216,  199,  210,  211,  203,  209,
      235,  216,  234,  224,  241,  234,  237,  235,  214,  239,

      242,  212,  213,  237,  238,  240,  239,  238,  244,  216,
      245,  247,  240,  248,  249,  241,  250,  251,  246,  243,
      236,  242,  233,  232,  231,  230,  229,  228,  227,  244,
      226,  245,  225,  247,  223,  248,  249,  222,  250,  256,
      221,  256,  256,  256,  257,  257,  257,  259,  259,  220,
      219,  218,  217,  215,  207,  204,  201,  197,  196,  195,
      192,  189,  188,  183,  182,  179,  176,  173,  172,  171,
      170,  167,  166,  165,  164,  161,  159,  155,  152,  151,
      150,  137,  129,  120,  107,   96,   95,   93,   92,   87,
       84,   80,   77,   70,   59,   38,   35,   34,   32,   11,

        9,    5,    3,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "ifm-scan.l"
#define INITIAL 0
#line 2 "ifm-scan.l"
/* Lexical scanner */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <vars.h>

#include "ifm-main.h"
#include "ifm-util.h"
#include "ifm-parse.h"

/* Internal string buffer */
static vbuffer *sbuf = NULL;
#line 585 "ifm-scan.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp = NULL, *yy_bp = NULL;
	register int yy_act;

#line 32 "ifm-scan.l"


#line 739 "ifm-scan.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 256 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 504 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 34 "ifm-scan.l"
/* Ignore comments */
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 36 "ifm-scan.l"
/* Strip whitespace */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 38 "ifm-scan.l"
{
    line_number++;
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 42 "ifm-scan.l"
{
    /* Quoted string */

    int c, quote = 0, eatspace = 0;

    /* Initialise buffer */
    if (sbuf == NULL)
        sbuf = vb_create();
    else
        vb_empty(sbuf);

    /* Slurp string in, one char at a time */
    while (1) {
        c = input();

        if        (c == EOF) {
            yyerror("unterminated string");
            break;
        } else if (c == '"' && !quote) {
            break;
        } else if (c == '\\' && !quote) {
            quote = 1;
            continue;
        } else if (c == '\n') {
            vb_putc(sbuf, ' ');
            eatspace = 1;
            line_number++;
        } else if (!eatspace || !isspace(c)) {
            vb_putc(sbuf, c);
        }

        if (!isspace(c))
            eatspace = 0;

        quote = 0;
    }

    yylval.sval = vb_getcopy(sbuf);
    return STRING;
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 83 "ifm-scan.l"
{ return AFTER; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 84 "ifm-scan.l"
{ return ALL; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 85 "ifm-scan.l"
{ return ANY; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 86 "ifm-scan.l"
{ return BEFORE; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 87 "ifm-scan.l"
{ return CMD; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 88 "ifm-scan.l"
{ return DOWN; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 89 "ifm-scan.l"
{ return DIR; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 90 "ifm-scan.l"
{ return DO; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 91 "ifm-scan.l"
{ return DOWN; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 92 "ifm-scan.l"
{ return DROP; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 93 "ifm-scan.l"
{ return EAST; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 94 "ifm-scan.l"
{ return EAST; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 95 "ifm-scan.l"
{ return ENDSTYLE; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 96 "ifm-scan.l"
{ return EXCEPT; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 97 "ifm-scan.l"
{ return EXIT; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 98 "ifm-scan.l"
{ return FALSE; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 99 "ifm-scan.l"
{ return FINISH; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 100 "ifm-scan.l"
{ return FOLLOW; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 101 "ifm-scan.l"
{ return FROM; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 102 "ifm-scan.l"
{ return GET; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 103 "ifm-scan.l"
{ return GIVE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 104 "ifm-scan.l"
{ return GIVEN; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 105 "ifm-scan.l"
{ return GO; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 106 "ifm-scan.l"
{ return GOTO; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 107 "ifm-scan.l"
{ return HIDDEN; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 108 "ifm-scan.l"
{ return IGNORE; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 109 "ifm-scan.l"
{ return IN; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 110 "ifm-scan.l"
{ return IT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 111 "ifm-scan.l"
{ return ITEM; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 112 "ifm-scan.l"
{ return JOIN; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 113 "ifm-scan.l"
{ return KEEP; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 114 "ifm-scan.l"
{ return LAST; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 115 "ifm-scan.l"
{ return LEAVE; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 116 "ifm-scan.l"
{ return LENGTH; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 117 "ifm-scan.l"
{ return LINK; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 118 "ifm-scan.l"
{ return LOSE; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 119 "ifm-scan.l"
{ return LOST; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 120 "ifm-scan.l"
{ return MAP; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 121 "ifm-scan.l"
{ return NORTH; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 122 "ifm-scan.l"
{ return NORTHEAST; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 123 "ifm-scan.l"
{ return NEED; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 124 "ifm-scan.l"
{ return NODROP; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 125 "ifm-scan.l"
{ return NOLINK; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 126 "ifm-scan.l"
{ return NOPATH; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 127 "ifm-scan.l"
{ return NONE; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 128 "ifm-scan.l"
{ return NORTH; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 129 "ifm-scan.l"
{ return NORTHEAST; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 130 "ifm-scan.l"
{ return NORTHWEST; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 131 "ifm-scan.l"
{ return NOTE; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 132 "ifm-scan.l"
{ return NORTHWEST; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 133 "ifm-scan.l"
{ return ONEWAY; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 134 "ifm-scan.l"
{ return OUT; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 135 "ifm-scan.l"
{ return REQUIRE; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 136 "ifm-scan.l"
{ return ROOM; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 137 "ifm-scan.l"
{ return SOUTH; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 138 "ifm-scan.l"
{ return SAFE; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 139 "ifm-scan.l"
{ return SCORE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 140 "ifm-scan.l"
{ return SOUTHEAST; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 141 "ifm-scan.l"
{ return SOUTH; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 142 "ifm-scan.l"
{ return SOUTHEAST; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 143 "ifm-scan.l"
{ return SOUTHWEST; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 144 "ifm-scan.l"
{ return START; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 145 "ifm-scan.l"
{ return STYLE; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 146 "ifm-scan.l"
{ return SOUTHWEST; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 147 "ifm-scan.l"
{ return TAG; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 148 "ifm-scan.l"
{ return TASK; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 149 "ifm-scan.l"
{ return THEM; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 150 "ifm-scan.l"
{ return TIMES; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 151 "ifm-scan.l"
{ return TITLE; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 152 "ifm-scan.l"
{ return TO; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 153 "ifm-scan.l"
{ return TRUE; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 154 "ifm-scan.l"
{ return UP; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 155 "ifm-scan.l"
{ return UNDEF; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 156 "ifm-scan.l"
{ return UNTIL; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 157 "ifm-scan.l"
{ return UP; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 158 "ifm-scan.l"
{ return WEST; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 159 "ifm-scan.l"
{ return WEST; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 160 "ifm-scan.l"
{ return WITH; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 162 "ifm-scan.l"
{
    yylval.sval = v_strdup(yytext);
    return ID;
}
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 167 "ifm-scan.l"
{
    yylval.sval = v_strdup(yytext);
    return ID;
}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 172 "ifm-scan.l"
{
    yylval.dval = atof(yytext);
    return REAL;
}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 177 "ifm-scan.l"
{
    yylval.ival = atoi(yytext);
    return INTEGER;
}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 182 "ifm-scan.l"
{ return yytext[0]; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 184 "ifm-scan.l"
ECHO;
	YY_BREAK
#line 1315 "ifm-scan.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 256 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 256 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 255);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}
#endif /* YY_NO_INPUT */

#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}



#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 184 "ifm-scan.l"

