/* main.c contains the "os independant" interface to the emulator; I've
 * added this header file so that one can more easily see the interface
 * that is available. I make most of these functions talk to my wrappers
 * in unix.c, which int turn talk to the lower level graphics libs in
 * x11lib.c.
 */

#ifndef h_main_h
#define h_main_h

#define WIDTH        78

int main ( int argc, char *argv[] );

/* load and save a buffer to a named file */
type8 ms_load_file ( type8 *name, type8 *ptr, type16 size );
type8 ms_save_file ( type8 *name, type8 *ptr, type16 size );

/* write to the player command scripting file */
void script_write ( type8 c );

/* write to a game transcript file */
void transcript_write ( type8 c );

/* write to the status area of the display */
void ms_statuschar ( type8 c );

/* main text buffer handlers */
void ms_flush ( void );           /* display the buffer */
void ms_putchar ( type8 c );      /* put character into buffer */

/* get a character from input buffer */
type8 ms_getchar ( void );

/* display picture on display */
type8 *ms_extract ( type8 pic,type16 *w, type16 *h, type16 *pal );
void ms_showpic ( type8 c,type8 mode );

#endif
