// INITIAL STUFF

//Verbs

jumpVerb: deepverb
	sdesc = "jump"
	verb = 'jump' 'jump over' 'jump off'
	action(actor)= {
		if((Me.location).jd)
			{
			if(Me.location = ledge)
				{
				"When you jump, the ledge gives out from under you and you 
					fall to your death.";
				die();
				}
			if((Me.location).eu)
				{
				if((Me.location).rh)
					{"You plant your feet firmly and jump high up above Europa.  
						When you land on the ice sheet you slip and loose your footing and plunge over 
						the edge of the rift.   After a brief couple of second you die when you are 
					impaled on the razor sharp 
						ice at the bottom of the rift.";
						die();
					}
				else {
					"You try to jump but all you do is loose your  footing and fall down on your rear.  
					Feeling silly, you get up.\b";
					}
				}
			if((Me.location).onmerc)
					{
					"Solidly planting your feet, you leap.  You drift up, up, up and off 
					the surface of Mercury into space.  A short time passes until the gravitational 
					pull of the Sun grabs you and pulls you to a fiery death.";
					die();
					}
				}
		else "Weeeee!!!!!!  What fun!!!!";
	}
;

tieVerb: deepverb
	sdesc = "tie"
	verb = 'tie'
	prepDefault = toPrep
	ioAction(toPrep) = 'TieTo'
;

climbupVerb: deepverb
	verb = 'climb up'
	sdesc = "climb up"
	doAction = 'Climbup'
;

climbdownVerb: deepverb
	verb = 'climb down'
	sdesc = "climb down"
	doAction = 'Climbdown'
;


untieVerb: deepverb
	verb = 'untie'
	sdesc = "untie"
	doAction = 'Untie'
;

goVerb: deepverb
	sdesc = "go"
	ldesc = "go"
	verb	= 'go'
	doAction = 'Go'
;

getonVerb: deepverb
	sdesc = "get on"
	verb = 'get on'
	doAction = 'Geton'
;

getoffVerb: deepverb
	sdesc = "get off"
	verb = 'get off'
	doAction = 'Getoff'
;

listenVerb: deepverb
	sdesc = "listen to"
	verb = 'listen to' 'listen'
	prepDefault = toPrep
	doAction = 'Listento'
;

forPrep: Prep
    sdesc = "for"
    preposition = 'for'
;

payVerb: deepverb
	verb = 'pay'
    sdesc = "pay"
	doAction = 'Pay'
    ioAction( forPrep ) = 'PayFor'
	prepDefault = forPrep
;

payforVerb: deepverb
    verb = 'pay for'
    sdesc = "pay for"
    doAction = 'Buy'
;

buyVerb: deepverb
	sdesc = "buy"
	verb = 'buy' 'purchase'
	doAction = 'Buy'
;

breakVerb:deepverb
	sdesc = "break"
	verb = 'break' 'smash' 'destroy' 'hit'
	doAction = 'Break'
;

letgoVerb: deepverb
	sdesc = "let go"
	verb = 'let go'
	doAction = 'Letgo'
	doDefault(actor, dobj) = 
		{
		if(dobj.isworn) "How do you propose to do that?";
		else pass verdoDrop ;
		}
;

steponVerb: deepverb
	sdesc = "step on"
	verb = 'step on' 'step'
	doAction = 'Stepon'
;

// Scoring routine

gscorevar: object
	notification = true
	amnt = 0
;

notifyVerb:deepverb
	sdesc = "notify"
	verb = 'notify'
	action(actor) = {
		gscorevar.notification := not gscorevar.notification;
		if(gscorevar.notification = nil)
			{"Score notification is now off.";}
		else
			{"Score notification is now on.";}
	}
;

replace incscore: function(amount)
	{
	gscorevar.amnt := amount;
	global.score := global.score + amount;
	if(gscorevar.notification)
		{
		"\b***Your score just changed by <<gscorevar.amnt>> points***\b";
		}
	setscore( global.score, global.turnsofar );
	}
;
		

// Code Breaking

codeVerb: deepverb
	sdesc = "codebreaker"
	verb = 'codebreaker'
	action(actor) = 
	{
	"I'm about to show you the key to the code in the hits file. 
	If you want to capture this information to a file
	(so that you can print it out, for example), answer NO below,
        then use the SCRIPT command (just type SCRIPT, then answer the
	question asking you for a filename), then enter the CODEBREAKER
        command again.";
	for (;;)
	{
	    local resp;

	    "\bDo you want to see the code key now? (Y is affirmative) >";
	    resp := yorn();
	    if (resp = 1) break;
	    if (resp = 0) return;
	}
	"The key is given in the format \"decoded symbol = coded symbol\"\b
	a = 10, b = 15, c = 8, d = 2, e = 19, f = 14, g = 29, h = 18, i = 27, 
	j = 5, k = 21, l = 16, m = 4, n = 12, o = 7, p = 26, q = 35, r = 3, 
	s = 25, t = 33, u = 11, v = 31, w = 6, x = 17, y = 1, z = 23, 
	0 = 20, 1 = 13, 2 = 24, 3 = 9, 4 = 28, 5 = 34, 6 = 22, 7 = 36, 
	8 = 32, 9 = 30.";
	}
;


//Classes

class vowelItem: object
     adesc = "an <<self.sdesc>>"
  ;

class pressuresuit: clothingItem
	checkDrop ={
		if(self.isworn)
			{
			"( Taking off <<self.thedesc>> first ).\n";
			if((Me.location).oncharon)
				{"You have always wondered if it was true if a person explodes when suddenly exposed 
				to a vacuum.  When you remove <<self.thedesc>>, you find out that it is indeed true.";
				die();
				}
			if((Me.location).oneur)
				{"You have always wondered if it was true that a person explodes when suddenly exposed 
				to a vacuum.  When you remove <<self.thedesc>>, you don't find out because 
				you freeze solid first.";
				die();
				}
			if((Me.location).onmerc)
				{"You remove <<self.thedesc>> and explode from sudden immersion in a vacuum.";
				die();
				}
			if((Me.location).onvenus)
				{"You once heard that the Venusian atmosphere is dense enough to crush a steel box, hot 
					enough to melt lead and acidic enough to corrode almost anything.  When you remove 
					<<self.thedesc>> you find out first hand that all the above is true.";
					die();
				}
			}
		}
	doWear(actor)={
		if(self.location = Me)
			{
			local melist, lmelist, i ,obj, h;
			h := true;
			melist := Me.contents;
			lmelist := length(melist);
			i := 1;
			while (i<= lmelist)
				{
				obj := melist[i];
				if(obj.isworn)
					{
					"The <<self.sdesc>> doesn't fit over the <<obj.sdesc>>.";
					h := nil;
					}
				i := i+1;
				}
			if(h)
				{
				self.isworn := true;
				"Ok, you are now wearing <<self.thedesc>>.";
				}
			else
				self.isworn := nil;
			}
		else "I don't see what you are talking about.";
		}
	doUnwear(actor)={
			"Okay, you are no longer wearing <<self.thedesc>>.";
			self.isworn := nil;
			if((Me.location).oncharon)
				{"\bYou have always wondered if it was true if a person explodes when suddenly exposed 
				to a vacuum.  When you remove <<self.thedesc>>, you find out that it is indeed true.";
				die();
				}
			if((Me.location).oneur)
				{"\bYou have always wondered if it was true that a person explodes when suddenly exposed 
				to a vacuum.  When you remove <<self.thedesc>>, you don't find out because 
				you freeze solid first.";
				die();
				}
			if((Me.location).onmerc)
				{"\bYou remove <<self.thedesc>> and explode from sudden immersion in a vacuum.";
				die();
				}
			if((Me.location).onvenus)
				{"\bYou once heard that the Venusian atmosphere is dense enough to crush a steel box, hot 
					enough to melt lead and acidic enough to corrode almost anything.  When you remove 
					<<self.thedesc>> you find out first hand that all the above is true.";
					die();
				}
		}
;

class treasure: item
	istreasure = true
;

class touchitem: fixeditem
	verDoTouch(actor)={}
	verDoPush(actor)={}
	doPush(actor) ={"The <<self.sdesc>> cannot be pressed.  It can, however, be touched.";}
;

class vulnerable: item
	vulner = true
;


class venusroom: room
	onvenus = true
;


// Functions and Objects

countvars: object
	vt = 0
	cvt =0
	rvc = 0
	pc = 0
	vinec = 0
	curtain = 0
	roboc = 0
	robotzip = nil
	cvindex = 0
;

vropecount:function;
vinecount:function;
robotcount:function;
venuscount:function;
flashcount:function;
curtaincount:function;
pillcount:function;
cvcount:function;
chipmelt:function;
venusdie:function;
vlakedie:function;
hotdie:function;
colddie:function;
eighthbutton:function;

flashcount: function (parm)
	{
	if(flash.islit)
	{
	flash.count := flash.count +1;
	if(flash.count =50)
		"\bThe flashlight seems to be a bit dimmer.";
	if(flash.count=75)
		"\bThe flashlight is definitely dimmer than it was before.";
	if(flash.count=100)
		{
		"\bThe flashlight goes out. (I guess the guarantee wasn't all that great after all).";
		flash.isactive := nil;
		flash.islit := nil;
		}
	}
	}
;

robotcount: function (parm)
	{
	if((Me.location).istower) exit;
	if(isclass(Me.location, jungleroom)) exit;
	{
		randomize();
		countvars.roboc:= rand(15);
		if(countvars.roboc < 5 or countvars.roboc > 10)
			{countvars.robotzip :=nil;
			exit;}
		else
			{
			if(countvars.robotzip) exit;
			else
				{
				if (countvars.roboc = 5)
					{"\bA high pitched electronic squeal erupts from underfoot.  Jumping back you see a small 
						gardening robot.  You must have stepped on it, for the robot chirps at you with 
						annoyance.  The robot speeds off into the rubble (running over your feet once for good measure).\b";	
						countvars.robotzip:=true;
						exit;
					}
				if(countvars.roboc = 6)
					{"\bA small metallic object zooms out from the rubble next to you.  It quickly circles your legs in 
						a figure eight pattern five and a half times before it speeds off back the way it came.\b";
					countvars.robotzip:=true;
					exit;
					}
				if(countvars.roboc=7)
					{"\bIn the distance you hear the faint sound of heavy wheels rolling over rubble.\b";
						countvars.robotzip := true;
						exit;
					}
				if(countvars.roboc=8)
					{"\bAppearing out of nowhere, a small gardening robot charges straight towards you like an angry rhino.  
					You leap aside as it barrels past you.  Getting up, you see the robot has disappeared from sight.  You dust 
					yourself off to the sound of high pitched electronic laughter.\b";
					countvars.robotzip := true;
					exit;
					}
				if(countvars.roboc = 9)
					{"\bThat's odd... You feel like you are being watched...\b";
						countvars.robotzip:=true;
						exit;
					}
				if(countvars.roboc = 10)
					{"\bYou see what looks like a broken down gardening robot up ahead.  As you approach 
						it, it suddenly comes to life and gives you an electric shock from one of its tools and speeds 
						off into the rubble.  As you 
						rub yourself in pain, you loose sight of the robot.\b";
						countvars.robotzip:=true;
						exit;
					}
				}
			}
		}
	}
;


vropecount : function (parm)
	{
		
		if (countvars.rvc = 4 and rope.location = Me.location)
			{
			"\nThe rope looks like it is not holding up well in this atmosphere.\b";
			}
		if (countvars.rvc = 8 and rope.location = Me.location)
			{
			"\nThe rope doesn't look like is will last much longer.\b";
			}
		if (countvars.rvc = 13)
			{
			if(rope.location = Me.location)
			{
			"\nThe rope corrodes away in the harsh atmosphere.\b";
				rope.moveInto(dvoid);
				if (Me.location = ropeledge)
					{
					"Unfortunately you were on it at the time.";
					die();
					}
				if (Me.location = ledge)
						{
						"Unfortunately you are now stranded and soon asphyxiate when your never fail life 
						support system fails.";
						die();
						}
				}
			else
				{
				if((rope.location).onvenus)
				rope.moveInto(void);
				}
		}
	countvars.rvc := countvars.rvc + 1;
	}
;


vinecount: function(parm)
	{
	if(not isclass((Me.location), jungleroom))exit;
	else
		{
		randomize();
		countvars.vinec:= rand(10);
		if(countvars.vinec < 5 )
			exit;
		else
			{
				if (countvars.vinec = 5)
					{"\bOUCH!!  A sharp pain thrusts through your body from your neck.  You reach back 
						and pull an thick, sappy leaf off.  The sap on the leaf stings your fingers. You drop it and it falls 
						through the mat of plants at your feet.\b";
						exit;
					}
				if(countvars.vinec = 6)
					{"\bYou hear something moving in the canopy above.\b";
					exit;
					}
				if(countvars.vinec=7)
					{"\bAs you are walking along you trip over a vine lying across your path.  As you stand up 
				the vine that tripped you moves away into one of the buildings.\b";
						exit;
					}
				if(countvars.vinec=8)
					{"\bWithout any warning, a high pitched electronic scream rips the air asunder.  The 
						scream is suddenly cut short and all that is left is an evil silence.\b";
					exit;
					}
				if(countvars.vinec = 9)
					{"\bThat's odd... You feel like you are being watched...\b";
						exit;
					}
				if(countvars.vineoc = 10)
					{"\bYou see movement out of the corner of your eye.  Turning around you notice that 
						the vines have gotten a bit thicker behind you.\b";
						exit;
					}
				}
			}
		}
;

curtaincount: function (parm)
	{
	if (countvars.curtain = 3)
		{
		if((Me.location).gheart)
			{"A curtain of vines lowers itself down from above blocking the path to the ";
			if(Me.location = gairlock) "north.\b";
			if(Me.location = greenroad1) "south.\b";
			vcurtain.moveInto(Me.location);
			}
		else vcurtain.moveInto(greenroad1);
		countvars.curtain := 0;
		vcurtain.active := true;
		remdaemon(curtaincount, nil);
		exit;
		}
	else countvars.curtain := countvars.curtain +1;
	}
;



cvcount: function (parm)
	{
	countvars.cvt := countvars.cvt +1;
	if (countvars.cvt = 9)
		{
		local chestlist, lchestlist, chobj ;
		chestlist := chest.contents;
		lchestlist := length(chestlist);
		if (lchestlist <> 0)
			{
			countvars.cvindex := 1;
			while (countvars.cvindex <= lchestlist)
				{
				chobj := chestlist[countvars.cvindex];
				if (chobj.vulner)
					{
					"\^<<chobj.thedesc>> succumbs to the harsh environment and 
					corrodes away.\b";
					chobj.moveInto(dvoid);
					if(chobj.istreasure) incscore(-20);
					}
				countvars.cvindex  := ++countvars.cvindex;
				}
			}
			remdaemon (cvcount, nil);
			countvars.cvt := 0;
			setdaemon (cvcount, nil);
		}
	}
;

pillcount: function (parm)
	{
	local itemRem, thisItem;
	countvars.pc := countvars.pc +1;
	if(countvars.pc = 12)
		"\bA feeling of weakness washes over you and you start to feel sleepy.";
	if(countvars.pc = 20)
		{"\bSuddenly your muscles feel like yesterday's warm jello.  All the strength flows out 
			your body and you drop everything.  You collapse into unconsciousness as a tidal 
			wave a exhaustion hits you.";
			Me.maxweight := 10;
			Me.maxbulk := 10;
			itemRem := Me.contents;
			while (car(itemRem))
				{
				thisItem := car(itemRem);
				if(not thisItem.isworn) thisItem.moveInto(Me.location);
				itemRem := cdr(itemRem);
				}
			"\b\b\b\b\bYou wake up some time later feeling rejuvenated.";
		}
	}
;

// Modifications

modify putVerb
	verb = 'stick'
;

modify thing
	doTake(actor) = {
		if(self.location = pedestal and secbut.active)
			{
			"The blue halo shocks your fingers as you try to take 
			the <<self.sdesc>>.";
			}
		else  pass doTake;
	}
	
;

modify theFloor
	ldesc = {
			if(Me.location = chwerehouse)
				{
				"The floor is covered with a thick layer of dust. ";
				if(trapdoor.location = chwerehouse)
					{
					"In the center of the 
					floor there is a trapdoor in the floor which is currently 
						<<trapdoor.isopen ? "open.": "closed.">>";
					}
				}
			else
				"There is nothing special on the floor.";
			}
	verDoSearch(actor) = {}
	doSearch(actor) = {
		if(Me.location = chwerehouse)
			{
			if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			exit;
			}
			if(Me.location = sbuild or Me.location = observation)
				{
				"Searching through the dust all you find is a dustless area near the 
				far wall.";
				exit;
				}
			"You find nothing of interest.";
			}
	verDoClear(actor) = {}
	doClear(actor) = {
		if(Me.location = chwerehouse)
			{
			if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			}
		if(Me.location = sbuild or Me.location = observation)
				{
				"It would take many lifetimes to clean up the amount of dust here.";
				exit;
				}
		"You find nothing of interest.";
			}
	verDoClean(actor) = {}
	doClean(actor) = {
		if(Me.location = chwerehouse)
			{
			if (trapdoor.location = chwerehouse)
					"It would take a lifetime to clean the rest of the dust off the floor.";
				else
				{
				"You clear away some of the dust and uncover a trap door.";
				trapdoor.moveInto(chwerehouse);
				}
			}
			if(Me.location = sbuild or Me.location = observation)
				{
				"It would take many lifetimes to clean up the amount of dust here.";
				exit;
				}
			"Don't you have better things to do than play housekeeper?";
			}
;


//Technical rooms

void: room					// This is where items start and finish if they aren't in a specific location
;

dvoid: room				// This is where destroyed items go
;
	
tvoid :room				// This is where treasures go
;	

dispvoid: room			// This is where dispenser items come and go from
;

// Planets and ship item

E1: room					// Earth 1995AD (start)
;

V: room				// Venus 1953AD
;

EU: room				// Europa 20 BC
;

MA: room				// Mars 2537 AD
;

PL: room				// Pluto 1 million AD
;

MER: room				// Mercury 1825 AD
;

CH: room					// Charon 1 million AD
;

E2: room					// Earth 1995 AD (endgame)
;

ship: item						// ship locator
	location = E1
;


/*				Scoring

Pluto

+10	finding passage underground (searching the rubble in the Burned Building)
+15 	getting past the guard robot the first time
+15	getting past the vine curtain the first time
+10	finding the cubic machine (search the machines in the Ruined Lab)
+20 reaching the Musueum the first time
+5	deactivating halo in Museum
+5	reaching the Model Room
+10 getting into the tower

Europa

+10 moving on the ice the first time

Charon

+5 getting up to Back on the Surface of Charon

Mars

+5	getting marsmid
+5	getting capsule from Fred
+10 	putting rope in dispensing machine after widget in gotten on venus
+5	putting the Wankle Rodery Engine in the dispensing machine

Objects

+25	getting the trinketer (Mars)
+25	getting the widget (venus)
+5	setting suit's atmosphere to oxygen (1st time)
+5	getting the average looking rock (Mercury)
+10	getting the black crystal ball (Charon)
+25	destroying the boulder (Mercury)
+10 gaining access to the Device Room (Pluto)
+10 getting the black chronoprogram cube (Pluto)
+25	properly programming the black cube (Pluto)
+25 getting the lump of iron (Charon)
+20 getting the pebble (Europa)

Spaceship

+5 gaining access to the inerior of the ship (1st time)
+5 activating the bedroom pad
+10 repairing the 8th symbol
+10 getting the pebble into the deep hole
+25 getting the ice chip into the deep hole
+30 reaching the Country Road (endgame)

Total: 400

RANKS

<=25					Lost, hoelessly lost
25 -> =50			Lost without a clue
50 -> =75			Lost suburbian with a compass
75 -> =100			Lost up the proverbial river without a paddle
100-> =150			Lost in the dark while wearing sunglasses
150-> =200			being lost. Just lost.
200-> =250			Lost wioth some resemblence of a clue.
250-> =300			Lost with a good compass and a good map
300-> =350			Lost, but have a good idea where you are
350->400				Lost, but having a really good idea of where you are
400						Found
> 400					Imposible score, after all there are only 400 points

*/
