#charset "us-ascii"

/*
 *   Copyright (c) 2002 by Joao Mendes.
 *   ericgift.t: Eric's Gift main file.
 */

#include <adv3.h>
#include <en_us.h>

main(args)
{
    gPlayerChar = me;

    intro();
    runGame(true);

    "<.p>Thank you for enjoying Eric's Gift!\b";
}

/******************************************************************************/

PreinitObject
    execute()
    {
        local tab = new LookupTable();
        tab['Name'] = versionInfo.name;
        tab['Byline'] = versionInfo.byline;
        tab['HtmlByline'] = versionInfo.htmlByline;
        tab['AuthorEmail'] = versionInfo.authorEmail;
        tab['Version'] = versionInfo.version;
        tab['Desc'] = 'Eric\'s Gift - A short interactive story about painting
                       the future.';
        tab['HtmlDesc'] = '<b>Eric\'s Gift</b> - A short interactive story
                           about painting the future.';
        tab['PresentationProfile'] = 'Multimedia';

        writeGameInfo(tab, 'GameInfo.txt');
    }
;

versionInfo: GameID
    name = 'Eric\'s Gift'
    byline = 'by Joao Mendes'
    htmlByline = 'by <a href="mailto:joao.mendes@netcabo.pt">
                  Jo&atilde;o Mendes</a>'
    authorEmail = 'Joao Mendes <joao.mendes@netcabo.pt>'
    version = '2002 IF Comp Release'

    showCredit()
    {
        "Eric's Gift is &#169; 2002, Joao Mendes.\b";
        "Eric's Gift beta testers: Ana Carrilho, Craig Thomson, Bruno Almeida,
         Aaron Light, Jeffrey James, Iain Merrick, Dylan Tovey, Peter Seebach,
         Cynthia Jackson, Steve Evans, Jen Picagli.\b";
        "Thanks to Michael J. Roberts for his excellent TADS 3 system.\b";
        "Finally, thanks to the folks at RAIF for being generally helpful.\b";
    }
    showAbout()
    {
        "About <q>Eric's Gift</q>:";
        "\bThis interactive work is based on the short story of the same name,
         also written by me, maybe in my senior year in high-school, maybe in
         my freshman year in college, I forget. (It has been at least twelve
         years.)";
        "\nBelieve it or not, I actually dreamed the most important bits of
         the story. When I woke up, I remember it felt like I had just had a
         nightmare, but the plot seemed much cooler than any other dream I
         had ever had, so I decided to write down everything I remembered.";
        "\nA few days later, I decided to structure it like a short story, to
         see how it felt.";
        "\nMany years later, I found raif and TADS and wanted to try to make
         a game. The rest is history.";
        "\bFor the player:";
        "\n- If you are unfamiliar with command-driven text adventure games,
         type <b>instructions</b>;";
        "\n- If you want to know about special verb usage, type
         <b>special</b>;";
        "\n- To see who was involved in the making of this work, type
         <b>credits</b>;";
        "\n- To get the version information, type <b>version</b>.";
        "\bThere are no puzzles worthy of that name in this work. However,
         since the story will only move forward if you take the appropriate
         action at each point, it is conceivable that you might get stuck.
         Therefore:";
        "\n- To see a hint appropriate to the stage you are in, type
         <b>hint</b>;";
        "\n- For a minimal walkthrough of the story, type <b>walkthrough</b>;";
    }
;

ModuleID
    showCredit()
    {
        "\bThe author would appreciate feedback, at
         <a href=\"mailto:joao.mendes@netcabo.pt\">joao.mendes@netcabo.pt</a>";
        "\bThank you for playing <q>Eric's Gift</q>\b";
    }
    showVersion()
    {
    }

    listingOrder = 1000
;

/******************************************************************************/

modify Floor
    dobjFor(SitOn)
    {
        verify()
        {
            illogical('Normal people don\'t sit on the floor in this kind of
                       situation.');
        }
    }
    dobjFor(LieOn)
    {
        verify()
        {
            illogical('Normal people don\'t lie down in this kind of situation.');
        }
    }
;

/******************************************************************************/

DefineTAction(KnockOn)
;

VerbRule(KnockOn)
    ('knock' | 'knock' 'on') dobjList
    : KnockOnAction
    verbPhrase = 'knock/knocking on (what)'
;

modify Thing
    dobjFor(KnockOn)
    {
        preCond = [touchObj]
        verify() { }
        action() { mainReport('{You/he} knock{s} on {the dobj/him}.'); }
    }
;

modify Actor
    dobjFor(KnockOn)
    {
        preCond = [touchObj]
        verify() { illogical('{You/he} can\'t knock on {the dobj/him}.'); }
    }
;

/******************************************************************************/

class SingAction: IAction
    execAction
    {
        if ( gActor == gPlayerChar )
            gPlayerChar.doSing();
        else
            mainReport('{You/he} hum{s} a little ditty.');
    }
;

VerbRule(Sing)
    'sing' | 'sing' 'jingle' | 'sing' 'song' | 'sing' 'tune' |
    'hum' | 'hum' 'jingle' | 'hum' 'song' | 'hum' 'tune'
    : SingAction
    verbPhrase = 'singing'
;

/******************************************************************************/

class SpecialAction: SystemAction
    execSystemAction
    {
        "Verb usage in this work is mostly standard. However, a few details
         should be noted:";
        "\nTo ask someone about something or tell someone about something,
         use the standard <b>ASK <i>person</i> ABOUT <i>thing</i></b> or
         <b>TELL <i>person</i> ABOUT <i>thing</i></b>.";
        "\nIf the story doesn't understand what you are asking about, it will
         tell you.";
        "\nSometimes, however, the story won't let you address someone unless
         you greet them first. You can use  <b>TALK TO <i>person</i></b>,
         <b>GREET <i>person</i></b>, or even <b><i>person</i>, HELLO</b>.";
        "\nMost other times, however, greeting someone won't tell you anything
         new.";
        "\nAlso, there are many times in which you can <b>SING</b>. Not
         always, though.\b";
    }
;

VerbRule(Special)
    'special'
    : SpecialAction
    verbPhrase = 'view/viewing special verbs'
;

/******************************************************************************/

finishOptionEpilogue: FinishOption
    desc = "show the <<aHrefAlt('epilogue', 'EPILOGUE', '<b>E</b>PILOGUE',
            'Show epilogue')>>"
    responseKeyword = 'epilogue'
    responseChar = 'e'
    doOption()
    {
        doEpilogue();
        return true;
    }
;

/******************************************************************************/
/* jmmm: Beta Stuff - stripped
StringPreParser
    runOrder = 1
    doParsing(str, which)
    {
        if (str.toUpper().startsWith('COMMENT '))
        {
            "Duly noted. Thank you.\b";
            return nil;
        }
        else
            return str;
    }
;
*/
/******************************************************************************/

class LocVoc: Decoration
    desc = "<<location.desc>>"
;

/******************************************************************************/

class HintAction: SystemAction
    execSystemAction
    {
        switch( me.location )
        {
        case plaza:
            "There is something you need to ask the woman about.";
            break;
        case theBench:
            "The coffee will trigger flashbacks in your mind.";
            break;
        case apartment:
            "There is nothing to do here.";
            break;
        case street:
            if ( theHat.location )
                "What does one usually do with hats?";
            else
                "What exactly did you come out in the street for?";
            break;
        case streetJB:
            "Examine everything carefully. Then, just go up.";
            break;
        case hallway:
            if ( cappellaHallway.location )
                "There is something you need to ask her about.";
            else
                "What do you usually do at someone's door when you want to
                 visit?";
            break;
        case study:
            "There is something you need to examine.";
            break;
        case chairs:
            "Let them talk. Do what they ask. When it's over, finish your
             dinner.";
            break;
        default:
            if ( panelBuildings.isEnding )
                "You need to take a fresh look at something you have already
                 seen.";
            else if ( Eric.location )
                "Just ask him about his paintings.";
            else
                "Examine everything. Also, you need to know her name.";
            break;
        }
        exitAction;
    }
;

VerbRule(Hint)
    'hint'
    : HintAction
    verbPhrase = 'view/viewing hints'
;

/******************************************************************************/

class WThruAction: SystemAction
    execSystemAction
    {
        "Note that following this will result in getting only minimal
         information.";
        "\nGREET WOMAN";
        "\nASK WOMAN ABOUT ME";
        "\nSMELL COFFEE";
        "\nTASTE COFFEE";
        "\nOUT";
        "\nSING";
        "\nGET HAT";
        "\nWEAR HAT";
        "\nX KEMSTONE";
        "\nX JB";
        "\nUP";
        "\nKNOCK ON DOOR";
        "\nASK WOMAN ABOUT JB";
        "\nASK WOMAN ABOUT HER";
        "\nX BUILDINGS";
        "\nZ";
        "\nASK MAN ABOUT PAINTINGS";
        "\nX CANVAS";
        "\nZ";
        "\nZ";
        "\nZ";
        "\nZ";
        "\nZ";
        "\nSING";
        "\nZ";
        "\nZ";
        "\nZ";
        "\nZ";
        "\nEAT FOOD";
        "\nX BUILDINGS";
    }
;

VerbRule(WTrhu)
    'walkthrough' | 'walkthru'
    : WThruAction
    verbPhrase = 'view/viewing the walkthrough'
;

/******************************************************************************/

VerbRule(About2)
    'help' | 'info'
    : AboutAction
    verbPhrase = 'show/showing story information'
;

/******************************************************************************/

DefineTAction(Hug)
;

VerbRule(Hug)
    'hug' singleDobj
    : HugAction
    verbPhrase = 'hug/hugging (what)'
;

modify Thing
    dobjFor(Hug)
    {
        preCond = [touchObj]
        verify() { illogical('That\'s not something {you/he} need to hug.'); }
    }
;

modify Actor
    dobjFor(Hug)
    {
        verify() {}
        action() { reportFailure('{The dobj/he} refuses your advances.'); }
    }
;

/******************************************************************************/

modify Thing
    dobjFor(Kiss)
    {
        preCond = [touchObj]
        verify() { illogical('That\'s not something {you/he} need to kiss.'); }
    }
;

modify Actor
    dobjFor(Kiss)
    {
        verify() {}
        action() { reportFailure('{The dobj/he} refuses your advances.'); }
    }
;

/******************************************************************************/

class SmileAction: IAction
    execAction
    {
        mainReport('{You/he} smile{s}.');
    }
;

VerbRule(Smile)
    'smile' | 'grin'
    : SmileAction
    verbPhrase = 'smiling'
;

/******************************************************************************/

modify Thing
    dobjFor(Taste)
    {
        preCond = [touchObj]
        verify() { illogical('That would be most unsanitary.'); }
    }
;

/******************************************************************************/

modify Thing
    dobjFor(GetOutOf)
    {
        verify() { illogical('{You/he} {are} not inside {that dobj/him}. '); }
    }
;
