! -*- mode: indented-text; coding: latin-1 -*- ---------------------------------
!
! German Inform Library: Language Definition File
! Copyright (C) 1997, 1998, 1999 Ralf Herrmann
!
! $Release: 6.10.1 $
! $Revision: 1.34 $
! $Date: 2000/01/05 21:58:06 $
!
!	ralf@niflheim.de
!	http://www.niflheim.de/infom/
!
!	Ralf Herrmann
!	Ludwig-Landmann-Str. 52
!	60488 Frankfurt am Main
!	Federal Republic of Germany
!
! This library is free software; you can redistribute it and/or modify it under
! the terms of the GNU Library General Public License as published by the Free
! Software Foundation; either version 2 of the License, or (at your option) any
! later version.
!
! This library is distributed in the hope that it will be useful, but without
! any warranty; without even the implied warranty of merchantability or fitness
! for a particular purpose. See the GNU Library General Public License for more
! details.
!
! You should have received a copy of the GNU Library General Public License
! along with this library; if not, write to the Free Software Foundation, Inc.,
! 675 Mass Ave, Cambridge, MA 02139, USA.
!
! ------------------------------------------------------------------------------

System_file;

! ------------------------------------------------------------------------------
! Part I.   Preliminaries
! ------------------------------------------------------------------------------

Constant LanguageVersion = "Deutsche Bibliothek 6.9.1 Copyright (C) 1996-1999 Ralf Herrmann <ralf@@niflheim.de>";

Constant LanguageCases = 4;

Constant CASE_NOM =	0;	! Nominativ
Constant CASE_GEN =	1;	! Genitiv
Constant CASE_DAT =	2;	! Dativ
Constant CASE_AKK =	3;	! Akkusativ

Property declination;

Constant none =		-1;	! No declination at all
Constant A0 =		-2;     ! Substantiviertes Adj.	der Gttliche
Constant S1_es =	-10;	! Singular [m,n]	dem Tag, des Tag-es
Constant S1_s =		-11;	! Singular [m,n]	dem Koenig, des Koenig-s
Constant S1_ses =	-12;	! Singular [m,n]	dem Bildnis, des Bildnis-ses
Constant S2_en =	-13;	! Singular [m]		dem Mensch-en, des Mensch-en, der Mensch
Constant S2_n =		-14;	! Singular [m]		dem Kunde-n, des Kunde-n, der Kunde
Constant S3 =		-15;	! Singular [f]		der Frau, der Frau
Constant P1 =		-16;	! Plural		den Tag-en, der Tag-e
Constant P2 =		-17;	! Plural		den Segel-n, der Segel
Constant P3 =		-18;	! Plural		den Mensch-en, der Mensch-en
Constant P4 =		-19;	! Plural		den Bild-ern, der Bild-er
Constant P5 =		-20;	! Plural		den Oma-s, der Oma-s

Property enter_type;

Constant enter_tritt = 0;	! Du <trittst> auf die Plattform (default)
Constant enter_sitze = 1;	! Du <setzt> dich auf den Stuhl
Constant enter_steige = 2;	! Du <steigst> auf den Tisch
Constant enter_liege = 3;	! Du <legst> dich auf den Tisch
Constant enter_klettere = 4;	! Du <kletterst> auf den Tisch (um zu tanzen?)
Constant enter_gehe = 5;	! Du <gehst> in den Fahrstuhl
Constant enter_springe = 6;	! Du <springst> in den Brunnen

ZCharacter '@ss';
ZCharacter '@:o';
ZCharacter '@:u';
ZCharacter '@:a';
ZCharacter '@:A';
ZCharacter '@:O';
ZCharacter '@:U';

#ifdef ANREDE_DU;	Constant ANREDE = 1; Lowstring du_str "D"; #endif;
#ifdef ANREDE_DU_KLEIN; Constant ANREDE = 1; Lowstring du_str "d"; #endif;
#ifdef ANREDE_IHR;	Constant ANREDE = 3; #endif;
#ifndef ANREDE;		Constant ANREDE = 3; #endif;

Lowstring sz_str "@ss";
Lowstring ss_str "ss";

Lowstring xae_str "@:a";  Lowstring yae_str "ae";
Lowstring xoe_str "@:o";  Lowstring yoe_str "oe";
Lowstring xue_str "@:u";  Lowstring yue_str "ue";

Lowstring xcae_str "@:A"; Lowstring ycae_str "Ae";
Lowstring xcoe_str "@:O"; Lowstring ycoe_str "Oe";
Lowstring xcue_str "@:U"; Lowstring ycue_str "Ue";

[ LanguageInitialise;

  give thedark female ~male ~neuter;
  short_name_case = case_akk;

  string 30 sz_str;
  string 31 sz_str;
  withUmlaut();

  #iftrue ANREDE == 1; string 29 du_str; #endif;
];

Object Compass "Kompass"
  has			concealed male;

Class CompassDirection
  with
    number		0,
  has			scenery male;

#ifndef WITHOUT_DIRECTIONS;

! Due to a bug in parserm.ParseNoun we must not use LanguageRefers to
! determine if a word may match a compass object - so we need to enter
! the forms for all suffixes as a name

CompassDirection -> n_obj "Norden"
  with
    name 		'n//' 'nord' 'noerdlich' 'norden',
    door_dir 		n_to;
CompassDirection -> s_obj "S@24den"
  with
    name 		's//' 'sued' 'suedlich' 'sueden',
    door_dir 		s_to;
CompassDirection -> e_obj "Osten"
  with
    name 		'o//' 'ost' 'oestlich' 'osten',
    door_dir 		e_to;
CompassDirection -> w_obj "Westen"
  with
    name 		'w//' 'west' 'westlich' 'westen',
    door_dir 		w_to;
CompassDirection -> ne_obj "Nordosten"
  with
    name		'no' 'nordost' 'nordoestliche' 'nordosten',
    door_dir		ne_to;
CompassDirection -> nw_obj "Nordwesten"
  with
    name 		'nw' 'nordwest' 'nordwestlich' 'nordwesten',
    door_dir 		nw_to;
CompassDirection -> se_obj "S@24dosten"
  with
    name 		'so' 'suedost' 'suedoestlich' 'suedosten',
    door_dir		se_to;
CompassDirection -> sw_obj "S@24dwesten"
  with
    name 		'sw' 'suedwest' 'suedwestlich' 'suedwesten',
    door_dir 		sw_to;
CompassDirection -> u_obj "Decke",
  with
    name 		'h//' 'hinauf' 'hoch' 'oben' 'decke' 'himmel' 'rauf' 'auf',
    door_dir 		u_to,
  has			female ~male;
CompassDirection -> d_obj "Boden"
  with
    name 		'r//' 'hinab' 'hinunter' 'runter' 'unten' 'boden' 'abwaerts' 'ab',
    door_dir		d_to;

#endif;

CompassDirection -> out_obj "Drau@30en"
  with
    door_dir		out_to,
  has			neuter ~male;

CompassDirection -> in_obj "Drinnen"
  with
    door_dir		in_to
  has			neuter ~male;

! ------------------------------------------------------------------------------
! Part II.   Vocabulary
! ------------------------------------------------------------------------------

Constant AGAIN1__WD   = 'nocheinmal';
Constant AGAIN2__WD   = 'nochmal';
Constant AGAIN3__WD   = 'wiederhole';

Constant OOPS1__WD    = 'berichtige';
Constant OOPS2__WD    = 'huch';
Constant OOPS3__WD    = 'k//';
Constant UNDO1__WD    = 'zurueck';
Constant UNDO2__WD    = 'rueckgaengig';
Constant UNDO3__WD    = 'undo';

Constant ALL1__WD     = 'all';
Constant ALL2__WD     = 'alle';
Constant ALL3__WD     = 'allem';
Constant ALL4__WD     = 'allen';
Constant ALL5__WD     = 'alles';

Constant AND1__WD     = 'und';
Constant AND2__WD     = 'sowie';
Constant AND3__WD     = 'plus';

Constant BUT1__WD     = 'ausser';
Constant BUT2__WD     = 'ausser';
Constant BUT3__WD     = 'ausgenommen';
Constant ME1__WD      = 'mich';
Constant ME2__WD      = 'mir';
Constant ME3__WD      = 'selbst';
Constant OF1__WD      = 'der';			! Many problems with that
Constant OF2__WD      = 'der';
Constant OF3__WD      = 'der';
Constant OF4__WD      = 'der';
Constant OTHER1__WD   = 'andere';
Constant OTHER2__WD   = 'anderen';
Constant OTHER3__WD   = 'anderes';
Constant THEN1__WD    = 'dann';
Constant THEN2__WD    = 'sodann';
Constant THEN3__WD    = 'danach';

Constant NO1__WD      = 'n//';
Constant NO2__WD      = 'nein';
Constant NO3__WD      = 'nicht';
Constant YES1__WD     = 'j//';
Constant YES2__WD     = 'ja';
Constant YES3__WD     = 'sicher';

Constant FULLSCORE1__WD =	'punktestand';	! Zur Wahl dieser Worte siehe
Constant FULLSCORE2__WD =	'ansehen';	! L__M(Miscellany, 5)
Constant QUIT1__WD =		'q//';
Constant QUIT2__WD =		'abbrechen';
Constant RESTART__WD =		'beginnen';
Constant RESTORE__WD =		'laden';
Constant AMUSING__WD =		'erfahren';


Array LanguagePronouns table

      ! word      possible GNAs			connected
      !		  a     i			to:
      !		  s  p  s  p
      !		  mfnmfnmfnmfn

	'es'	$$001000001000			NULL
	'ihn'	$$100000100000			NULL
	'sie'	$$010111010111			NULL
	'qwe'	$$111000111000			NULL;	! special for 'darauf'

Array LanguageDescriptors table

      ! word	  possib. GNAs	descriptor	connected
      !		  a     i	type:		to:
      !		  s  p  s  p
      !		  mfnmfnmfnmfn

      'den'	$$100111100111	DEFART_PK	NULL
      'dem'	$$101000101000	DEFART_PK	NULL
      'die'	$$010111010111	DEFART_PK	NULL
      'der'	$$010000010000	DEFART_PK	NULL
      'das'	$$001000001000	DEFART_PK	NULL
      'des'     $$101000101000	DEFART_PK	NULL
      'einen'	$$100000100000	INDEFART_PK	NULL
      'eine'	$$010000010000	INDEFART_PK	NULL
      'ein'	$$001000001000	INDEFART_PK	NULL
      'einige'	$$000111000111	INDEFART_PK	NULL
      'manche'	$$000111000111	INDEFART_PK	NULL

      'meinen'	$$100000100000	POSSESS_PK	0
      'meine'	$$010111010111	POSSESS_PK	0
      'mein'	$$001000001000	POSSESS_PK	0
      'diesen'  $$100000100000	POSSESS_PK	0
      'diese'	$$010111010111	POSSESS_PK	0
      'dieses'	$$001000001000	POSSESS_PK	0
      'dies'	$$001000001000	POSSESS_PK	0
      'jenen'	$$100000100000	POSSESS_PK	1
      'jene'	$$010111010111	POSSESS_PK	1
      'jenes'	$$001000001000	POSSESS_PK	1
      'seinen'	$$100000100000	POSSESS_PK	'ihn'
      'seine'	$$010111010111	POSSESS_PK	'ihn'
      'sein'	$$001000001000	POSSESS_PK	'ihn'
      'ihren'	$$100000100000	POSSESS_PK	'sie'
      'ihre'	$$010111010111	POSSESS_PK	'sie'
      'ihr'	$$001000001000	POSSESS_PK	'sie'
      'seinen'	$$100000100000	POSSESS_PK	'ihn'
      'seine'	$$010111010111	POSSESS_PK	'ihn'
      'sein'	$$001000001000	POSSESS_PK	'ihn'

        'helle'	$$111000111000	light		NULL
       'hellen'	$$111111111111	light		NULL
  'erleuchtete'	$$111000111000	light		NULL
 'erleuchteten'	$$111111111111	light		NULL
  'entzuendete' $$111000111000	light		NULL
 'entzuendeten'	$$111111111111	light		NULL
   'leuchtende'	$$111000111000	light		NULL
  'leuchtenden'	$$111111111111	light		NULL
    'brennende' $$111000111000	light		NULL
   'brennenden'	$$111111111111	light		NULL
     'erhellte' $$111000111000	light		NULL
    'erhellten'	$$111111111111	light		NULL
    'gluehende' $$111000111000	light		NULL
   'gluehenden'	$$111111111111	light		NULL
       'dunkle'	$$111000111000	(-light)	NULL
      'dunklen'	$$111111111111	(-light)	NULL;

Array LanguageNumbers table
	'eins' 1 'einen' 1 'eine' 1 'ein' 1 'einer' 1
	'zwei' 2 'drei' 3 'vier' 4 'fuenf' 5 'sechs' 6 'sieben' 7 'acht' 8
	'neun' 9 'zehn' 10 'elf' 11 'zwoelf' 12 'dreizehn' 13 'vierzehn' 14
	'fuenfzehn' 15 'sechzehn' 16 'siebzehn' 17 'siebenzehn' 17
	'achtzehn' 18 'neunzehn' 19 'zwanzig' 20;

! ------------------------------------------------------------------------------
! Part III.   Processing Input
! ------------------------------------------------------------------------------

! ------------------------------------------------------------------------------
! LanguageIsVerb is called whenever the parser checks if a word may match a
! verb. It handle umlauts and the trailing -e on its own, as it could be
! called with input which wasn't processed by LanguageToInformese.
! Note further, you can't use DictionaryLookup so these procedure mangles the
! buffer2.
! ------------------------------------------------------------------------------

Array LanguageVerbBuffer -> 33;
Array LanguageVerbParse -> 9;

[ LanguageIsVerb buffer parse i		f l w j k;

  ! @tokenise works with arrays containing their maximum length in array->0,
  ! so we need to initialise them

  LanguageVerbBuffer->0 = 32; LanguageVerbParse->0 = 8;

  f = parse->(i*4+1);
  l = parse->(i*4);

  for (j = 0, k = 0: j < l: j++, k++)
    {
      LanguageVerbBuffer->(2+k) = buffer->(f+j);
      switch (buffer->(f+j))
        {
          '@ss': LanguageVerbBuffer->(2+k) = 's';
                 LanguageVerbBuffer->(3+k) = 's'; k++;
          '@:a': LanguageVerbBuffer->(2+k) = 'a';
                 LanguageVerbBuffer->(3+k) = 'e'; k++;
          '@:o': LanguageVerbBuffer->(2+k) = 'o';
                 LanguageVerbBuffer->(3+k) = 'e'; k++;
          '@:u': LanguageVerbBuffer->(2+k) = 'u';
                 LanguageVerbBuffer->(3+k) = 'e'; k++;
        };
    };

  LanguageVerbBuffer->1 = k;

  ! First check, iff the word contained any umlauts. Note: parse->1 is valid (but maybe
  ! null) as our buffer contains a word!

  @tokenise LanguageVerbBuffer LanguageVerbParse;
  w = LanguageVerbParse-->1;
  if (w ~= 0 && (w->#dict_par1 & 1) ~= 0) return w;

  ! Second, remove a trailing -e as long as we do not end with -ee (like oeffnee)
  ! or are too short

  if (k > 3 && LanguageVerbBuffer->(1+k) == 'e' && LanguageVerbBuffer->(0+k) ~= 'e')
    {
      LanguageVerbBuffer->(1+k) = ' ';

      @tokenise LanguageVerbBuffer LanguageVerbParse;
      w = LanguageVerbParse-->1;
      if (w ~= 0 && (w->#dict_par1 & 1) ~= 0) return w;
    };

  return 0;
];

! ------------------------------------------------------------------------------
! LanguageRefers is an enhancement to Refers. It checks if a given word matches
! the object. It strips off the suffixes -er -es -en -em -e -s and -n (substant.
! plural dative) and checks the resulting stem against the name property.
! ------------------------------------------------------------------------------

[ LanguageRefers o wnum			adr l a b s w		k;

  ! Bug in Library 6/8: we will called with nonexistend words

  if (wnum > parse->1) rfalse;

  adr = WordAddress(wnum); l = WordLength(wnum);

  w = DictionaryLookup(adr, l); k = w;

  if (w ~= 0 && WordInProperty(w, o, name) == true) rtrue;

  if (l > 2)
    {
      a = adr->(l-2); b = adr->(l-1);

      if (b == 'r' or 's' or'n' or 'm' && a == 'e')
        s = 2;
      else if (b == 'e' && a ~= 'e' || b == 's' or 'n')
        s = 1;
      else
        s = 0;

      w = DictionaryLookup(adr, l-s);
      if (WordInProperty(w, o, name) == true) rtrue;
    };


  return -1;
];

[ LanguageToInformese			i j k w f l s;

  #ifdef DEBUG; PrintBuffer__LTI("Buffer "); #endif;

  ! Replace "<comma> <then>" by "<then>";

  for (i = 1: i < parse->1: i++)
    {
      w = parse-->(i*2+1);

      if (w == THEN1__WD or THEN2__WD or THEN3__WD)
        if (parse->(i*4) == 1)
          {
            w = parse->(i*4+1);
            if (buffer->(w) == ',') buffer->w = ' ';
          };
    };

  ! Replace @ss and umlauts

  for (i = 2: i < 2+buffer->1: i++)
    {
      switch (buffer->i)
        {
          '@ss': buffer->i = 's'; LTI_Insert(i, 's');
          '@:a': buffer->i = 'e'; LTI_Insert(i, 'a');
	  '@:o': buffer->i = 'e'; LTI_Insert(i, 'o');
	  '@:u': buffer->i = 'e'; LTI_Insert(i, 'u');
        };
    };

  ! Replace: (aber|doch|jedoch|nur) nicht -> ausser

  @tokenise buffer parse;

  for (i = 1: i < parse->1: i++)
    if (parse-->(i*2+1) == 'nicht')
      {
        w = parse-->(i*2-1);

        if (w == 'aber' or 'doch' or 'jedoch' or 'nur')
          {
            f = parse->(i*4+5);
            l = parse->(i*4+4);

            for (j = 0: j < l: j++) buffer->(f+j) = ' ';

            f = parse->(i*4+1);
            l = parse->(i*4);

            for (j = 0: j < 6-l: j++) LTI_Insert(f, ' ');

            buffer->(f+0) = 'a';
            buffer->(f+1) = 'u';
            buffer->(f+2) = 's';
            buffer->(f+3) = 's';
            buffer->(f+4) = 'e';
            buffer->(f+5) = 'r';

            for (j = 6: j < l: j++) buffer->(f+j) = ' ';
          };
      };

  ! Trenne die Verschmelzung von Praeposition und Artikel

  @tokenise buffer parse;

  k = 0;
  for (i = 0: i < parse->1: i++)
    {
      w = parse-->(i*2+1);

      f = parse->(i*4+5) + k;
      l = parse->(i*4+4);

      switch (w)
        {
          'ans', 'aufs', 'durchs', 'fuers', 'ins', 'ums':
            buffer->(f+l-1) = ' ';
            LTI_Insert(f+l, 's');
            LTI_Insert(f+l, 'a');
            LTI_Insert(f+l, 'd');

            k = k+3;
          'am', 'im', 'vom':
            buffer->(f+l-1) = 'n';
            LTI_Insert(f+l, 'm');
            LTI_Insert(f+l, 'e');
            LTI_Insert(f+l, 'd');
            LTI_Insert(f+l, ' ');

            k = k+4;
          'beim':
            buffer->(f+l-1) = ' ';
            LTI_Insert(f+l, 'm');
            LTI_Insert(f+l, 'e');
            LTI_Insert(f+l, 'd');

            k = k+3;
          'zur':
            buffer->(f+l-1) = ' ';
            LTI_Insert(f+l, 'r');
            LTI_Insert(f+l, 'e');
            LTI_Insert(f+l, 'd');

            k = k+3;
        };
    };

  ! darauf, darunter

  @tokenise buffer parse;

  k = 0;
  for (i = 0: i < parse->1: i++)
    {
      f = parse->(i*4+5) + k;
      l = parse->(i*4+4);

      switch (parse-->(i*2+1))
        {
          0:
            if (buffer->f == 'd' && buffer->(f+1) == 'a')
              {
                if (buffer ->(f+2) == 'r') s = 3; else s = 2;

                if (DictionaryLookup(buffer+f+s, l-s) ~= 0)
                  {
                    for (j = 0: j < s: j++) buffer->(f+j) = ' ';

                    LTI_Insert(f+l, 'e');
                    LTI_Insert(f+l, 'w');
                    LTI_Insert(f+l, 'q');
                    LTI_Insert(f+l, ' ');

                    k = k + 4;
                  };
              };

	  'jede', 'jeden', 'jedes':
            k = 4-l; if (k < 0) k = 0;
            for (j = 0: j < k: j++) LTI_Insert(f, ' ');

            buffer->(f+0) = 'a';
            buffer->(f+1) = 'l';
            buffer->(f+2) = 'l';
            buffer->(f+3) = 'e';

            for (j = 0: j < l+k-4: j++) buffer->(f+4+j) = ' ';

          'nur':
            for (j = 0: j < l: j++) buffer->(f+j) = ' ';

          'ihm':
            buffer->(f+2) = 'n';
        };
     };

  #ifdef DEBUG; PrintBuffer__LTI("Buffer "); #endif;
];

! ------------------------------------------------------------------------------
! Part IV.   Printing
! ------------------------------------------------------------------------------

Constant LanguageAnimateGender   = male;
Constant LanguageInanimateGender = male;

Constant LanguageContractionForms = 1;	! no contraction forms in german

[ LanguageContraction t;

  t = 0;				! no compiler warnings, please
  return 0;
];

Array LanguageArticles -->
	"Der " "der " "ein "		! male, nominative
	"Des " "des " "eines "		! male, genitive
	"Dem " "dem " "einem "		! male, dative
	"Den " "den " "einen "		! male, accussative

	"Die " "die " "eine "
	"Der " "der " "einer "
	"Der " "der " "einer "
	"Die " "die " "eine "

	"Das " "das " "ein "
	"Des " "des " "eines "
	"Dem " "dem " "einem "
	"Das " "das " "ein "

	"Die " "die " "(error)"		! plural, nominative
	"Der " "der " "(error)"		! plural, genitive
	"Den " "den " "(error)"		! plural, dative
	"Die " "die " "(error)";	! plural, accussative

Array LanguageGNAsToArticles --> 0 1 2 3 3 3 0 1 2 3 3 3;
!				 a           i
!				 s     p     s     p
!				 m f n m f n m f n m f n

[ LanguageDirection d;

  switch (d)
    {
      n_to:	print "nord";
      s_to: 	print "s@24d";
      e_to: 	print "ost";
      w_to: 	print "west";
      ne_to: 	print "nordost";
      nw_to: 	print "nordwest";
      se_to: 	print "s@24dost";
      sw_to: 	print "s@24dwest";
      u_to: 	print "hinauf";
      d_to: 	print "hinab";
      in_to: 	print "hinein";
      out_to: 	print "hinaus";
      default: 	return RunTimeError(9,d);
    };
];

[ LanguageNumber n j		f;

  #ifdef JAHRESZAHLEN; j = 1100; #ifnot; if (j == 0) j = 2000; #endif;

  if (n == 0)	{ print "null"; rfalse; };
  if (n < 0)	{ print "minus "; n = -n; };

  if (n >= 1000)
    {
      if (n >= 2000)
        {
          print (number) n/1000, "tausend";
          n = n % 1000; f = 1;
        }
      else if (n < j)
        {
          #ifdef EINHUNDERT; print "eintausend"; #ifnot; print "tausend"; #endif;
          n = n % 1000; f = 1;
        };
    };

  if (n >= 100)
    {
      if (n >= 200)
        print (number) n/100, "hundert";
      else
        {
          #ifdef EINHUNDERT; print "einhundert"; #ifnot; print "hundert"; #endif;
        };

      n = n % 100; f = 1;
    };

  switch(n)
    {
       0: rfalse;
       1: print "eins";
       2: print "zwei";
       3: print "drei";
       4: print "vier";
       5: print "f@24nf";
       6: print "sechs";
       7: print "sieben";
       8: print "acht";
       9: print "neun";
      10: print "zehn";
      11: print "elf";
      12: print "zw@26lf";
      13: print "dreizehn";
      14: print "vierzehn";
      15: print "f@24nfzehn";
      16: print "sechzehn";
      17: print "siebzehn";
      18: print "achtzehn";
      19: print "neunzehn";

      default:
        switch (n % 10)
          {
            0:
            1:       print "einund";
            default: print (number) n % 10, "und";
          };

        switch (n / 10)
          {
            2: print "zwanzig";
            3: print "drei@30ig";
            4: print "vierzig";
            5: print "f@24nfzig";
            6: print "sechzig";
            7: print "siebzig";
            8: print "achtzig";
            9: print "neunzig";
          };
    };
];

[ Ziffern n			f;

  if (n < 0) { print "-"; n = -n; };
  if (n >= 1000) { print n/1000, "."; n = n % 1000; f = true; };
  if (n < 10 && f == true) print "0";
  if (n < 100 && f == true) print "0";
  print n;
];

[ Jahreszahl n;

  LanguageNumber(n, 1100);
];

[ LanguageTimeOfDay hours mins;

  print (string) TIME__TX;
  print hours/10, hours%10, ":", mins/10, mins%10;
];

! ------------------------------------------------------------------------------
! Please note, that the infinitive of a verb is printed iff the verb stands on
! its own (i.e., is not followed by any input) and more than one object in scope
! matches the grammar.
! ------------------------------------------------------------------------------

[ VerbInfinitive v;

  LanguageVerbBuffer->0 = 32;

  @output_stream 3 LanguageVerbBuffer;
  print (address) v;
  @output_stream -3;

  if (buffer->((buffer->1)-1) == 'e')
    print (address) v, "n";
  else
    print (address) v, "en";
];

[ LanguageVerb v;

  switch (v)
    {
      #n$z:			print "warte";
      #n$i, 'inv', #n$b :	print "zeige deinen Besitz";
      #n$x:			print "untersuche";
      #n$l:			print "sieh";
      'oeffne':			print "@26ffne";
      'pflueck':		print "pfl@24cke";
      'schmueck':		print "schm@24cke dich";
      'schuett':		print "sch@24tte";
      'schliesse':		print "schlie@30e";

      default:			rfalse;
    };

  rtrue;
];

Constant NKEY__TX     = "N = N@28chstes Thema";
Constant PKEY__TX     = "V = Voriges Thema";
Constant QKEY1__TX    = "Z = Zur@24ck zum Spiel";
Constant QKEY2__TX    = "Z = Zur@24ck zum vorigen Men@24";
Constant RKEY__TX     = "EINGABE = Thema lesen";

Constant NKEY1__KY    = 'N';
Constant NKEY2__KY    = 'n';
Constant PKEY1__KY    = 'V';
Constant PKEY2__KY    = 'v';
Constant QKEY1__KY    = 'Z';
Constant QKEY2__KY    = 'z';

Constant SCORE__TX    = "Punkte: ";
Constant MOVES__TX    = "Z@24ge: ";
Constant TIME__TX     = "Zeit: ";
Constant DARKNESS__TX = "Finsternis";

Constant THOSET__TX   = "jene";
Constant THAT__TX     = "jenes";
Constant OR__TX       = " oder ";
Constant NOTHING__TX  = "nichts";
Constant IS__TX       = " ist";		! " ist";
Constant ARE__TX      = " sind";		! " sind";
Constant IS2__TX      = "ist ";		! "ist ";
Constant ARE2__TX     = "sind ";		! "sind ";
Constant AND__TX      = " und ";
Constant WHOM__TX     = "";
Constant WHICH__TX    = "";

#iftrue ANREDE==1;
  Constant CANTGO__TX   = "In diese Richtung kannst Du nicht gehen.";
  Constant FORMER__TX   = "Dein voriges selbst";
  Constant YOURSELF__TX = "Dich selbst";
#endif;

#iftrue ANREDE==3;
  Constant CANTGO__TX   = "In diese Richtung k@26nnt Ihr nicht gehen.";
  Constant FORMER__TX   = "Euer voriges selbst";
  Constant YOURSELF__TX = "Euch selbst";
#endif;

! ------------------------------------------------------------------------------
! The declination of adjectives and substantives depends on the rules stated
! in [DUDEN: Die Grammatik]. It covers at least 90% of common declinations
! ------------------------------------------------------------------------------

Array LanguageScratch --> 200;

Array AdjectiveSuffix -->
	"er" "en" "em" "en" "e" "er" "er" "e" "es" "en" "em" "es"	! Singular I
	"e" "en" "en" "en"  "e" "en" "en" "e" "e" "en" "en" "e"		! Singular II
	"er" "en" "en" "en" "e" "en" "en" "e" "es" "en" "en" "es"	! Singular III
	"e" "er" "en" "e" "e" "er" "en" "e" "e" "er" "en" "e";		! Plural I

[ Decline__Adjective o adr len p	i j;

  if (o has pluralname or male || p == true)
    len = len - 2;
  else
    len = len - 1;

  i = short_name_case;
  if (o has female) i = i + 4;
  if (o has neuter) i = i + 8;

  if (indef_mode ~= NULL)
    {
      if (indef_mode == true)
        i = i + 24;
      else
        i = i + 12;
    };

  if (o has pluralname || p == true) i = i + 36;
  if (i >= 48) i = 2;

  for (j = 0: j < len: j++) print (char) adr->j;

  print (string) AdjectiveSuffix-->i;
];

[ Decline__Substantive o adr len p	a b c j;

  a = adr->(len-3);
  b = adr->(len-2);
  c = adr->(len-1);

  if (o has pluralname && p == 0 || p > 0)
    {
      if (c == 'n' or 's')
        p = P2;
      else
        p = P1;
    };

  if (o has female && p == 0)
    p = S3;

  if (o has male or neuter && p == 0)
    {
      p = S1_s;

      if (short_name_case == case_gen)
        {
          if (c == 'e')                           p = S1_s;
          if (b == 'e' && c == 'r' or 'l' or 'n') p = S1_s;
          if (a == 'e' && b == 'i' && c == 'n')   p = S1_s;
          if (a == 'i' && b == 'n' && c == 'g')   p = S1_s;
          if (a == 's' && b == 'c' && c == 'h')   p = S1_es;
          if (b == 's' && c == 't')               p = S1_es;
          if (c == 's' or '@ss' or 'x' or 'z')    p = S1_es;
          if (a == 'n' && b == 'i' && c == 's')   p = S1_ses;
        };
    };

  if (p == S2_en or S2_n)
    {
      if (short_name_case == case_nom)
        {
          if (p == S2_en)
            len = len - 2;
          else
            len = len - 1;
        };

      for (j = 0: j < len: j++) print (char) adr->j;
    }
  else
    {
      for (j = 0: j < len: j++) print (char) adr->j;

      if (short_name_case == case_gen && p == S1_s or S1_es or S1_ses)
        {
          switch (p)
            {
              S1_es  : print "es";
              S1_s   : print "s";
              S1_ses : print "ses";
            };
        }
      else if (short_name_case == case_dat && p == P1 or P2 or P3 or P4 or P5)
        {
          switch (p)
            {
              P1 : print "n";
              P2 : print "n";
              P4 : print "n";
            };
        };
    };
];

[ Decline__Article o adr len p;

  o = 0;

  switch (adr->(len-2))
    {
      'a' : p = 2;
      'i' : p = 1;
      'e' : p = 0;
    };

  if (p == 0)
    {
      switch (short_name_case)
        {
          case_nom : print "der";
          case_gen : print "des";
          case_dat : print "dem";
          case_akk : print "den";
        };
    }
  else if (p == 1)
    {
      switch (short_name_case)
        {
          case_nom : print "die";
          case_gen : print "der";
          case_dat : print "der";
          case_akk : print "die";
        };
    }
  else
    switch (short_name_case)
      {
        case_nom : print "das";
        case_gen : print "des";
        case_dat : print "dem";
        case_akk : print "das";
      };
];

[ Decline__Preposition o adr len	j;

  o = 0;

  for (j = 0: j < len: j++)
    print (char) adr->j;
];

[ Decline__Name o a l			i j k r m s u v t;

  m = o.&declination;
  t = true;

  for (i = 0: i < l: k++, i++)
    {
      for (j = 0: a->(i+j) ~= ' ' && (i+j < l): j++);

      s = t;
      if (m ~= 0 && k < o.#declination / 2 && s) s = m-->k;

      if (s == true)
        {
          r = a->i;

          if (r >= 'A' && r <= 'Z' || r == '@:A' or '@:O' or '@:U')
            {
              if (s == true) s = 0;
              Decline__Substantive(o, a+i, j);
            }
          else
            {
              u = a->(i+1); v = a->(i+2);

              if (j == 3 && r == 'd' && ((u == 'a' && v == 's') || (u == 'i' && v == 'e') || (u == 'e' && v == 'n' or 's' or 'r' or'm')))
                Decline__Article(o, a+i, j);
              else
                Decline__Adjective(o, a+i, j);
            };
        }
      else if (s < none)
        {
	  if (s == A0)
	    Decline__Adjective(o, a+i, j);
	  else
            Decline__Substantive(o, a+i, j, s);
	}
      else
        {
	  if (s == none) t = false;
          Decline__Preposition(o, a+i, j);
	};

      i = i+j;
      if (i < l) print " ";
    };
];

[ Decline__String o s p f;

  if (metaclass(s) == string)
    {
      LanguageScratch-->0 = 200;

      @output_stream 3 LanguageScratch;
      print (string) s;
      @output_stream -3;

      switch (f)
        {
          0: Decline__Adjective  (o, LanguageScratch+2, LanguageScratch-->0, p);
          1: Decline__Substantive(o, LanguageScratch+2, LanguageScratch-->0, p);
          2: Decline__Name       (o, LanguageScratch+2, LanguageScratch-->0, p);
          3: Decline__Article    (o, LanguageScratch+2, LanguageScratch-->0, p);
        };
    }
  else
    RunTimeError(15, o, s);
];

[ LanguagePrintShortName o;

  if (o.&short_name ~= 0 && metaclass(o.short_name) == Routine)
    if (RunRoutines(o, short_name) ~= 0) rtrue;

  if (short_name_case == case_akk && indef_mode == false)
    {
      if (o.&short_name == 0 || PrintOrRun(o, short_name, 1) == 0)
        @print_obj o;
    }
  else
    {
      LanguageScratch-->0 = 200;

      @output_stream 3 LanguageScratch;
      if (o.&short_name == 0 || PrintOrRun(o, short_name, 1) == 0)
        @print_obj o;
      @output_stream -3;

      Decline__Name(o, LanguageScratch+2, LanguageScratch-->0);
    };

  rtrue;

];

[ LPSN o case indef cap				xc;

  xc = short_name_case; short_name_case = case;

  if (indef == NULL)
    print "*** error ***";
  else if (indef == true)
    Indefart(o);
  else
    {
      if (cap == true) CDefart(o); else Defart(o);
    };

  short_name_case = xc;
];

[ der obj;	LPSN(obj, case_nom); ];
[ des obj;	LPSN(obj, case_gen); ];
[ dem obj;	LPSN(obj, case_dat); ];
[ den obj;	LPSN(obj, case_akk); ];

[ cDer obj;	LPSN(obj, case_nom, false, true); ];
[ cDen obj;	LPSN(obj, case_akk, false, true); ];

[ ein obj;	LPSN(obj, case_nom, true); ];
[ eines obj;	LPSN(obj, case_gen, true); ];
[ einem obj;	LPSN(obj, case_dat, true); ];
[ einen obj;	LPSN(obj, case_akk, true); ];

[ LanguagePrintArticle obj case cap		i j;

  if (obj has male)	  i = 0;
  if (obj has female)	  i = 1;
  if (obj has neuter)	  i = 2;
  if (obj has pluralname) i = 3;

  j = case * 3;
  if (cap == false) j = j + 1;

  print (string) LanguageArticles-->(12 * i + j);
];

[ xder obj;	LanguagePrintArticle(obj, case_nom, true); ];
[ xdes obj;	LanguagePrintArticle(obj, case_gen, true); ];
[ xdem obj;	LanguagePrintArticle(obj, case_dat, true); ];
[ xden obj;	LanguagePrintArticle(obj, case_akk, true); ];

! Print the name (depending on case) AFTER an article has been printed.

[ LanguagePrintNameAfterArticle o case		xc xi;

  xc = short_name_case; xi = indef_mode;

  short_name_case = case; indef_mode = false;
  LanguagePrintShortName(o);

  short_name_case = xc; indef_mode = xi;
];

[ nameDer obj;	LanguagePrintNameAfterArticle(obj, case_nom); ];
[ nameDem obj;	LanguagePrintNameAfterArticle(obj, case_dat); ];
[ nameDes obj;	LanguagePrintNameAfterArticle(obj, case_gen); ];
[ nameDen obj;	LanguagePrintNameAfterArticle(obj, case_akk); ];

[ PrintAdjective o s p;		Decline__String(o, s, p, 0); ];
[ PrintSubstantive o s p;	Decline__String(o, s, p, 1); ];
[ PrintName o s;		Decline__String(o, s, false, 2); ];

Array LanguagePronounsForPrinting -->
	"er"		"sie"		"es"		"sie"
	"Er"		"Sie"		"Es"		"Sie"
	"ihn"		"sie"		"es"		"sie"
	"ihm"		"ihr"		"ihm"		"ihnen"
	"keinen"	"keine"		"kein"		"keine"
	"ist"		"ist"		"ist"		"sind"
	"diesem"	"dieser"	"diesem"	"diesen";

[ PrintPronoun obj i;

  if (obj has pluralname) { print (string) LanguagePronounsForPrinting-->(i*4+3); rfalse; };
  if (obj has neuter)     { print (string) LanguagePronounsForPrinting-->(i*4+2); rfalse; };
  if (obj has female)     { print (string) LanguagePronounsForPrinting-->(i*4+1); rfalse; };
  print (string) LanguagePronounsForPrinting-->(i*4+0);
];

[ er obj;	PrintPronoun(obj, 0); ];
[ cEr obj;	PrintPronoun(obj, 1); ];
[ ihn obj;	PrintPronoun(obj, 2); ];
[ ihm obj;	PrintPronoun(obj, 3); ];
[ keinen obj;	PrintPronoun(obj, 4); ];
[ ist obj;	PrintPronoun(obj, 5); ];
[ diesem obj;	PrintPronoun(obj, 6); ];

[ im o;

  if (o has pluralname or female)
    print "in ", (dem) o;
  else
    print "im ", (nameDem) o;
];

[ vom o;

  if (o has pluralname or female)
    print "von ", (dem) o;
  else
    print "vom ", (nameDem) o;
];

[ am o;

  if (o has pluralname or female)
    print "an ", (dem) o;
  else
    print "am ", (nameDem) o;
];

[ in o;

  if (o has neuter)
    print "ins ", (nameDen) o;
  else
    print "in ", (den) o;
];

! ------------------------------------------------------------------------------
! In German items of a list may be written in accusative, dative or nominative.
! Call WriteListFromCase with case set to one of the constants case_#? and o,
! style and depth as usual
! ------------------------------------------------------------------------------

[ WriteListFromCase o style depth case		oc;

  oc = short_name_case; short_name_case = case;

  WriteListFrom(o, style, depth);

  short_name_case = oc;
];

! ------------------------------------------------------------------------------
! Library Messages 48 and 49 need to know, if the verb is followed by any input.
! As checking for pcount == 1 is not enough, we need a special routine to do
! that.
! ------------------------------------------------------------------------------

[ CheckPrintCommandPattern	k f;

  for (k = 1: k < pcount && f == false: k++)
    {
      if (pattern-->k == PATTERN_NULL) continue;
      rtrue;
    };

  rfalse;
];

[ LanguageLM n x1;

  Prompt:
    print "^>";

  Miscellany:
    switch(n)
      {
	1:	"(unter Ber@24cksichtigung der ersten sechzehn Objekte)^";

	2:	"Nichts zu tun!?!";

	3:	#iftrue ANREDE==1; print " Du bist gestorben "; #endif;
		#iftrue ANREDE==3; print " Ihr seid gestorben "; #endif;

	4:	#iftrue ANREDE==1; print " Du hast gewonnen "; #endif;
		#iftrue ANREDE==3; print " Ihr habt gewonnen "; #endif;

	5:	#iftrue ANREDE==1; print "^M@26chtest du"; #endif;
		#iftrue ANREDE==3; print "^M@26chtet Ihr"; #endif;

		print " ein neues Spiel BEGINNEN, einen gespeicherten Spielstand LADEN";
		if (TASKS_PROVIDED == 0)
		  print ", den Punktestand ANSEHEN";
		if (deadflag == 2 && AMUSING_PROVIDED == 0)
		  print ", Vorschl@28ge zu einigen am@24santen Aktionen ERFAHREN";
		" oder ABBRECHEN?";

	6:	"[Dieser Interpreter erlaubt das Zur@24cknehmen eines Zuges nicht]";

	7:	"Dieser Zug konnte nicht zur@24ckgenommen werden. [Nicht alle
		Interpreter erm@26glichen dies]";

	8:	#iftrue ANREDE==1; "Bitte gib eine der obigen Antworten."; #endif;
		#iftrue ANREDE==3; "Bitte gebt eine der obigen Antworten."; #endif;

	9:	#iftrue ANREDE==1; "^Es ist jetzt stockfinster."; #endif;
		#iftrue ANREDE==3; "^Dies ist ein wahrhaft finsterer Ort!"; #endif;

	10:	#iftrue ANREDE==1; "Ich f@24rchte, ich verstehe @29ich nicht so recht."; #endif;
		#iftrue ANREDE==3; "Ich f@24rchte, ich verstehe Euch nicht so recht."; #endif;

	11:	#iftrue ANREDE==1; "[Du hast noch gar keinen Zug get@28tigt!?!]"; #endif;
		#iftrue ANREDE==3; "[Ihr habt noch gar keinen Zug get@28tigt!?!]"; #endif;

	12:	#iftrue ANREDE==1; "[Du kannst nicht zwei Z@24ge in Folge zur@24cknehmen]"; #endif;
		#iftrue ANREDE==3; "[Ihr k@26nnt nicht zwei Z@24ge in Folge zur@24cknehmen]"; #endif;

	13:	"[Der vorige Zug wurde zur@24ckgenommen]";

	14:	#iftrue ANREDE==1; "Entschuldige, doch dies kann nicht verbessert werden."; #endif;
		#iftrue ANREDE==3; "Entschuldigt, doch dies kann nicht verbessert werden."; #endif;

	15:	"Bitte!"; ! * "Think nothing of it" = "Don't mention it"

	16:	#iftrue ANREDE==1; "Du kannst nur ein einziges Wort verbessern."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt nur ein einziges Wort verbessern."; #endif;

	17:	#iftrue ANREDE==1; "Es ist dunkel, und @29u kannst nichts sehen."; #endif;
		#iftrue ANREDE==3; "Es ist dunkel, und Ihr k@26nnt nichts sehen."; #endif;

	18:	#iftrue ANREDE==1; print "Du selbst"; #endif;
		#iftrue ANREDE==3; print "Ihr selbst"; #endif;

	19:	"Gut aussehend, wie immer.";

	20:	print "Um einen Befehl wie @>>Frosch, quake@<< zu wiederholen, ";
		#iftrue ANREDE==1; print "verwende "; #endif;
		#iftrue ANREDE==3; print "verwendet "; #endif;
		"@>>noch(ein)mal@<< nicht, @>>Frosch, nocheinmal@<<.";

	21:	#iftrue ANREDE==1; "Das kannst Du nur schwerlich wiederholen."; #endif;
		#iftrue ANREDE==3; "Das k@26nnt Ihr nur schwerlich wiederholen."; #endif;

	22:	#iftrue ANREDE==1; "Du kannst einen Satz nicht mit einem Komma beginnen."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt einen Satz nicht mit einem Komma beginnen."; #endif;

	23:	print "Es hat den Anschein, da@31 ";
		#iftrue ANREDE==1; print "@29u mit jemandem redest, "; #endif;
		#iftrue ANREDE==3; print "Ihr mit jemandem redet, "; #endif;
		"doch vermag ich nicht zu erkennen, mit wem.";

	24:	#iftrue ANREDE==1; "Du kannst doch nicht mit ", (dem) x1, " sprechen."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt doch nicht mit ", (dem) x1, " sprechen."; #endif;

	25:	print "Um mit jemandem zu sprechen, etwa einem Frosch, ";
		#iftrue ANREDE==1; print "versuche "; #endif;
		#iftrue ANREDE==3; print "versucht "; #endif;
		"@>>Frosch, Hallo@<< oder etwas @28hnliches.";

	26:	#iftrue ANREDE==1; "(zuerst nimmst @29u ", (den) x1, " auf)"; #endif;
		#iftrue ANREDE==3; "(zuerst nehmt Ihr ", (den) x1, " auf)"; #endif;

	27:	"Diesen Satz verstehe ich nicht.";

	28:	#iftrue ANREDE==1; print "Ich verstehe @29ich nur soweit: "; #endif;
		#iftrue ANREDE==3; print "Ich verstehe Euch nur soweit: "; #endif;

	29:	"Diese Zahl verstehe ich nicht.";

	30:	#iftrue ANREDE==1; "Dies kannst @29u hier nicht sehen."; #endif;
		#iftrue ANREDE==3; "Dies k@26nnt Ihr hier nicht sehen."; #endif;

	31:	#iftrue ANREDE==1; "Anscheinend sagtest @29u zuwenig."; #endif;
		#iftrue ANREDE==3; "Anscheinend sagtet Ihr zuwenig."; #endif;

	32:	#iftrue ANREDE==1; "Du h@28ltst dies nicht in deiner Hand."; #endif;
		#iftrue ANREDE==3; "Ihr haltet dies nicht in Eurer Hand."; #endif;

	33:	#iftrue ANREDE==1; "Du kannst mit diesem Verb nur genau ein Objekt verwenden."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt mit diesem Verb nur genau ein Objekt verwenden."; #endif;

	34:	#iftrue ANREDE==1; "Du kannst mehrere Objekte nur einmal pro Zeile verwenden."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt mehrere Objekte nur einmal pro Zeile verwenden."; #endif;

	35:	"Ich bin nicht sicher, worauf @>>", (address) pronoun_word, "@<< sich bezieht.";

	36:	#iftrue ANREDE==1; "Du hast etwas ausgeschlossen, was ohnehin nicht eingeschlossen war."; #endif;
		#iftrue ANREDE==3; "Ihr habt etwas ausgeschlossen, was ohnehin nicht eingeschlossen war."; #endif;

	37:	"Diese Aktion mu@31 auf ein Lebewesen abzielen.";

	38:	"Dieses Verb kenne ich nicht.";

	39:	#iftrue ANREDE==1; "Das ist nichts, worauf @29u in diesem Abenteuer Bezug nehmen mu@31t."; #endif;
		#iftrue ANREDE==3; "Das ist nichts, worauf Ihr in diesem Abenteuer Bezug nehmen m@24@31t."; #endif;

	40:	#iftrue ANREDE==1; "Du kannst @>>", (address) pronoun_word, "@<< (", (den) pronoun_obj, ") im Augenblick nicht sehen."; #endif;
		#iftrue ANREDE==3; "Ihr k@26nnt @>>", (address) pronoun_word, "@<< (", (den) pronoun_obj, ") im Augenblick nicht sehen."; #endif;

	41:	"Am Ende des Satzes steht etwas unverst@28ndliches.";

	42:	switch(x1)
		  {
		    0 :		"Davon gibt es hier nichts.";	! ** PROBLEM: Welches Objekt?
		    1 :		"Davon ist nur eines verf@24gbar.";
		    default:	"Davon gibt es hier nur ", (number) x1, ".";
		  };

	43:	"Nichts zu tun!";

	44:	#iftrue ANREDE==1; print "Du hast nichts zur Verf@24gung"; #endif;
		#iftrue ANREDE==3; print "Ihr habt nichts zur Verf@24gung"; #endif;

	45:	#iftrue ANREDE==1; print "Wen meinst @29u: "; #endif;
		#iftrue ANREDE==3; print "Wen meint Ihr: "; #endif;

	46:	#iftrue ANREDE==1; print "Was meinst @29u: "; #endif;
		#iftrue ANREDE==3; print "Was meint Ihr: "; #endif;

	47:	#iftrue ANREDE==1; print "Entschuldige, aber hier kannst @29u"; #endif;
		#iftrue ANREDE==3; print "Entschuldigt, aber hier k@26nnt Ihr"; #endif;
		" nur einen Gegenstand verwenden. Welchen genau?";

        48:	#iftrue ANREDE==1; print "Bitte vervollst@28ndige: "; #endif;
		#iftrue ANREDE==3; print "Bitte vervollst@28ndigt: "; #endif;
		if (actor ~= player) print " ", (The) actor, ", ";
                PrintCommand(); print "?^";

        49:     #iftrue ANREDE==1; print "Bitte vervollst@28ndige: "; #endif;
		#iftrue ANREDE==3; print "Bitte vervollst@28ndigt: "; #endif;
		 PrintCommand(); print "?^";

        	!if (actor ~= player)
                !  print "Was soll der ", (the) actor, " ";
                !else
                !  print "Was m@26chtet Ihr ";
                !print_verb_infinitive = true; PrintCommand(); print "?^";

	50:	if (x1 > 0)
		  {
		    #iftrue ANREDE==1; print "Du hast @29ir gerade"; #endif;
		    #iftrue ANREDE==3; print "Ihr habt Euch gerade"; #endif;
		  }
		else
		  {
		    #iftrue ANREDE==1; print "Du hast gerade"; #endif;
		    #iftrue ANREDE==3; print "Ihr habt gerade"; #endif;
		  };

		if (x1 == 1 || x1 == -1) print " einen Punkt"; else print " ", (number) x1, " Punkte";
		if (x1 > 0) print " verdient"; else print " verloren";

	51:	#iftrue ANREDE==1; "(Da etwas dramatisches geschah, wurde die Zahl Deiner m@26glichen Befehle verringert.)"; #endif;
		#iftrue ANREDE==3; "(Da etwas dramatisches geschah, wurde die Zahl Eurer m@26glichen Befehle verringert.)"; #endif;

	52:	#iftrue ANREDE==1;
		  "^Gib eine Zahl von 1 bis ", x1, " ein, 0 um das Men@24 nocheinmal
		  zu zeigen oder dr@24cke ~EINGABE~.";
		#endif;
		#iftrue ANREDE==3;
		  "^Gebt eine Zahl von 1 bis ", x1, " ein, 0 um das Men@24 nocheinmal
		  zu zeigen, oder dr@24ckt ~EINGABE~.";
		#endif;

	53:	"^[LEERTASTE]";
      };

  ListMiscellany:
    switch(n)
      {
	1:  print " (leuchtend)";
  	2:  print " (geschlossen)";
  	3:  print " (geschlossen und leuchtend)";
  	4:  print " (leer)";
  	5:  print " (leer und leuchtend)";
  	6:  print " (leer und geschlossen)";
  	7:  print " (leer, geschlossen und leuchtend)";
  	8:  print " (leuchtend und angezogen";
  	9:  print " (leuchtend";
  	10: print " (angezogen";
  	11: print " (";
  	12: print "offen";
  	13: print "offen und leer";
  	14: print "geschlossen";
  	15: print "abgeschlossen";
  	16: print " und leer";
  	17: print " (leer)";
  	18: print ", darinnen ";
  	19: print " (auf ", (diesem) x1, " ";
  	20: print ", auf ", (diesem) x1, " ";
  	21: print " (in ", (diesem) x1, " ";
  	22: print ", in ", (diesem) x1, " ";
      };

  Pronouns:
    switch(n)
      {
	1:	print "Im Augenblick bezeichnet ";
	2:	;
	3:	print "nichts";
	4:	"Die Pronomen sind noch nicht bestimmt.";
      };

  Order:
    print (cDer) x1; if (x1 has pluralname) print " gehorchen"; else print " gehorcht";
    #iftrue ANREDE==1; " @29ir nicht."; #endif;
    #iftrue ANREDE==3; " Euch nicht."; #endif;

  Quit:
    switch(n)
      {
        1: #iftrue ANREDE==1; print "Bitte antworte mit ja oder nein."; #endif;
	   #iftrue ANREDE==3; print "Bitte antwortet mit ja oder nein."; #endif;
	2: #iftrue ANREDE==1; print "Willst @29u wirklich abbrechen? "; #endif;
           #iftrue ANREDE==3; print "Wollt Ihr wirklich abbrechen? "; #endif;
      };

  Restart:
    switch(n)
      {
        1: #iftrue ANREDE==1; print "M@26chtest @29u wirklich ein neues Spiel beginnen? "; #endif;
           #iftrue ANREDE==3; print "M@26chtet Ihr wirklich ein neues Spiel beginnen? "; #endif;
        2: "Misslungen.";
      };

  Restore:
    switch(n)
      {
        1: "Beim Laden trat ein Fehler auf!";
        2: "Fertig.";
      };

  Save:
    switch(n)
      {
        1: "Beim Speichern trat ein Fehler auf!";
        2: "Fertig.";
      };

  Verify:
    switch(n)
      {
        1: "Das Spiel wurde als unversehrt befunden.";
        2: "Das Spiel scheint besch@28digt zu sein und mag demnach Fehler enthalten.
           (Es w@28re allerdings auch m@26glich, da@31 sie einen allzu primitiven
           Interpreter verwenden, und dieser die @23berpr@24fung nicht ordentlich
           durchf@24hrte.)";
      };

  ScriptOn:
    switch(n)
      {
        1: "Es wird bereits mitgeschrieben.";
        2: "Es wird eine Mitschrift begonnen.";
        3: "Beim Starten der Mitschrift trat ein Fehler auf!";
      };

  ScriptOff:
    switch(n)
      {
        1: "Aber es wird doch gar nicht mitgeschrieben.";
        2: "Ende der Mitschrift.";
        3: "Beim Versuch die Mitschrift zu beenden trat ein Fehler auf!";
      };

  NotifyOn:
    #iftrue ANREDE==1; "@27nderungen Deines Punktestandes werden @29ir mitgeteilt."; #endif;
    #iftrue ANREDE==3; "@27nderungen Eures Punktestandes werden Euch mitgeteilt."; #endif;

  NotifyOff:
    #iftrue ANREDE==1; "@27nderungen Deines Punktestandes werden @29ir nun nicht mehr mitgeteilt."; #endif;
    #iftrue ANREDE==3; "@27nderungen Eures Punktestandes werden Euch nun nicht mehr mitgeteilt."; #endif;

  Places:
    #iftrue ANREDE==1; print "Bisher hast @29u folgende Orte besucht: "; #endif;
    #iftrue ANREDE==3; print "Bisdar habt Ihr folgende Orte besucht: "; #endif;

  Objects:
    switch(n)
      {
        1:  #iftrue ANREDE==1; "Objekte die @29u handhabtest:^"; #endif;
            #iftrue ANREDE==3; "Objekte die Ihr handhabtet:^"; #endif;
        2:  "Keine.";
        3:  print "   (angezogen)";
        4:  #iftrue ANREDE==1; print "   (in Deinem Besitz)"; #endif;
            #iftrue ANREDE==3; print "   (in Eurem Besitz)"; #endif;
        5:  print "   (fortgegeben)";
        6:  print "   (", (nameDer) x1, ")";
        7:  print "   (", (im) x1, ")";
        8:  print "   (", (im) x1, ")";
        9:  print "   (auf ", (dem) x1, ")";
        10: print "   (verloren)";
      };

  Score:
    if (deadflag) print "In diesem Spiel "; else print "Bisher ";
    #iftrue ANREDE==1; print "hast Du"; #endif;
    #iftrue ANREDE==3; print "habt Ihr"; #endif;

    if (turns == 1)
      print " in einem Zug ";
    else if (turns <= 12)
      print " in ", (number) turns, " Z@24gen ";
    else
      print " in ", (ziffern) turns, " Z@24gen ";

    if (MAX_SCORE == 1)
      print "den einen Punkt noch nicht erreicht";
    else
      {
        if (score == 0) print "keinen"; else print (ziffern) score;
        print " von ", (ziffern) MAX_SCORE, " Punkten erreicht";
      };

  FullScore:
    switch(n)
      {
        1: print "Dieser Punktestand setzt sich wie folgt zusammen:^";
        2: "f@24r das Auffinden bestimmter Gegenst@28nde";
        3: "f@24r das Aufsuchen bestimmter Orte";
        4: "insgesamt (von ", (ziffern) MAX_SCORE, " Punkten.)";
      };

  Inv:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Deine Taschen sind leer."; #endif;
           #iftrue ANREDE==3; "Eure Taschen sind leer."; #endif;
        2: #iftrue ANREDE==1; print "Du besitzt"; #endif;
           #iftrue ANREDE==3; print "Ihr besitzt"; #endif;
      };

  Take:
    switch(n)
      {
        1:  "Aufgenommen.";
        2:  #iftrue ANREDE==1; "Du hast @29ich schon immer selbst besessen."; #endif;
            #iftrue ANREDE==3; "Ihr besa@30t Euch schon immer selbst."; #endif;
        3:  "Das w@24rde ", (dem) x1, " sicher nicht gefallen.";
        4:  #iftrue ANREDE==1; "Du mu@31t zuerst ", (den) x1, " verlassen."; #endif;
            #iftrue ANREDE==3; "Ihr m@24@31t zuerst ", (den) x1, " verlassen."; #endif;
        5:  #iftrue ANREDE==1; "Du h@28ltst ", (den) x1, " bereits in Deinen H@28nden."; #endif;
            #iftrue ANREDE==3; "Ihr haltet ", (den) x1, " bereits in Euren H@28nden."; #endif;
        6:  print "Es hat den Anschein, da@31 ", (der) noun, " ", (dem) x1;
            if (noun has pluralname) " geh@26ren."; else " geh@26rt.";

        7:  #iftrue NO_GENITIVE;
              "Anscheinend ", (ist) noun, " ", (er) noun, " ein Teil ", (vom) x1, ".";
            #ifnot;
              "Anscheinend ", (ist) noun, " ", (er) noun, " ein Teil ", (des) x1, ".";
            #endif;

        8:  print_ret (cDer) x1, " ", (ist) x1, " nicht verf@24gbar.";
        9:  print_ret (cDer) x1, " ", (ist) x1, " nicht offen.";
        10: #iftrue ANREDE==1; print_ret (xden) x1, "kannst @29u nicht aufnehmen."; #endif;
            #iftrue ANREDE==3; print_ret (xden) x1, "k@26nnt Ihr nicht aufnehmen."; #endif;
        11: print_ret (cDer) x1, " ", (ist) x1, " hier fest verankert.";
        12: #iftrue ANREDE==1; "Du tr@28gst bereits zuviel bei Dir."; #endif;
            #iftrue ANREDE==3; "Ihr tragt bereits zuviel bei Euch."; #endif;

        13: #iftrue ANREDE==1; "(zuvor legst @29u ", (den) x1, " in ", (den) SACK_OBJECT, ")"; #endif;
            #iftrue ANREDE==3; "(zuvor legt Ihr ", (den) x1, " in ", (den) SACK_OBJECT, ")"; #endif;
      };

  Drop:
    switch(n)
      {
        1: print (cDer) x1; if (x1 has pluralname) print " sind"; else print " ist";
           "bereits hier.";
        2: #iftrue ANREDE==1; print "Du hast"; #endif;
           #iftrue ANREDE==3; print "Ihr habt"; #endif;
           " ", (ihn) x1, " aber nicht.";
        3: #iftrue ANREDE==1; "(zuerst ziehst @29u ", (den) x1, " aus)"; #endif;
           #iftrue ANREDE==3; "(zuerst zieht Ihr ", (den) x1, " aus)"; #endif;
        4: "Abgelegt.";
      };

  Remove:
    switch(n)
      {
        1: "Leider ", (ist) x1, " ", (er) x1, " geschlossen.";
	2: print "Aber ", (er) x1, " ", (ist) x1, " nicht ";
	   if (second has supporter) print "auf"; else print "in";
	   " ", (dem) second, ".";
	3: "Entfernt.";
      };

  PutOn:
    switch(n)
      {
        1: #iftrue ANREDE==1;
             "Du mu@31t ", (den) x1, " aufnehmen, bevor @29u ",
             (ihn) x1, " auf etwas anderes legen kannst.";
           #endif;
           #iftrue ANREDE==3;
             "Ihr m@24@31t ", (den) x1, " aufnehmen, bevor Ihr ",
             (ihn) x1, " auf etwas anderes legen k@26nnt.";
           #endif;
        2: #iftrue ANREDE==1; "Du kannst nichts auf sich selbst legen."; #endif;
           #iftrue ANREDE==3; "Ihr k@26nnt nichts auf sich selbst legen."; #endif;
        3: print "Etwas auf ", (den) x1, " zu legen, hilft ";
           #iftrue ANREDE==1; "@29ir auch nicht weiter."; #endif;
           #iftrue ANREDE==3; "Euch auch nicht weiter."; #endif;
        4: #iftrue ANREDE==1; "Du bist zu ungeschickt."; #endif;
           #iftrue ANREDE==3; "Ihr seid zu ungeschickt."; #endif;
        5: #iftrue ANREDE==1; "(zuerst ziehst @29u ", (den) x1, " aus)^"; #endif;
           #iftrue ANREDE==3; "(zuerst zieht Ihr ", (den) x1, " aus)^"; #endif;
        6: "Der Platz auf ", (dem) x1, " reicht nicht aus.";
        7: "Vollbracht.";
        8: #iftrue ANREDE==1; "Du legst ", (den) x1, " auf ", (den) second, "."; #endif;
           #iftrue ANREDE==3; "Ihr legt ", (den) x1, " auf ", (den) second, "."; #endif;
      };

  Insert:
    switch(n)
      {
        1: #iftrue ANREDE==1;
             "Du mu@31t ", (den) x1, " aufnehmen, bevor @29u ",
             (ihn) x1, " in etwas anderes legen kannst.";
           #endif;
           #iftrue ANREDE==3;
             "Ihr m@24@31t ", (den) x1, " aufnehmen, bevor Ihr ",
             (ihn) x1, " in etwas anderes legen k@26nnt.";
           #endif;
        2: #iftrue ANREDE==1; "In ", (den) x1, " kannst @29u nichts legen."; #endif;
           #iftrue ANREDE==3; "In ", (den) x1, " k@26nnt Ihr nichts legen."; #endif;
        3: "Leider ", (ist) x1, " ", (der) x1, " geschlossen.";
        4: #iftrue ANREDE==1; "Du mu@31t ", (ihn) x1, " zuvor ausziehen."; #endif;
           #iftrue ANREDE==3; "Ihr m@24@31t ", (ihn) x1, " zuvor ausziehen."; #endif;
        5: #iftrue ANREDE==1; "Du kannst nichts in sich selbst legen."; #endif;
           #iftrue ANREDE==3; "Ihr k@26nnt nichts in sich selbst legen."; #endif;
        6: #iftrue ANREDE==1; "(zuerst nimmst @29u ", (ihn) x1, " ab)"; #endif;
           #iftrue ANREDE==3; "(zuerst nehmt Ihr ", (ihn) x1, " ab)"; #endif;
        7: "In ", (dem) x1, " ist nicht gen@24gend Platz.";
        8: "Vollbracht";
        9: #iftrue ANREDE==1; "Du legst ", (den) x1, " in ", (den) second, "."; #endif;
           #iftrue ANREDE==3; "Ihr legt ", (den) x1, " in ", (den) second, "."; #endif;
      };

  EmptyT:
    switch(n)
      {
        1: print_ret (cder) x1, " enth@28lt aber nichts.";
        2: print_ret (cder) x1, " ", (ist) x1, " verschlossen.";
        3: print_ret (cder) x1, " ", (ist) x1, " bereits leer.";
      };

  Give:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Du besitzt ", (den) x1, " nicht."; #endif;
           #iftrue ANREDE==3; "Ihr besitzt ", (den) x1, " nicht."; #endif;
        2: #iftrue ANREDE==1; "Du jonglierst eine Weile mit ", (dem) x1, ", ohne allerdings etwas zu erreichen."; #endif;
           #iftrue ANREDE==3; "Ihr jongliert eine Weile mit ", (dem) x1, ", ohne allerdings etwas zu erreichen."; #endif;
        3: print (cder) x1; if (x1 has pluralname) print " zeigen"; else print " zeigt";
           " kein Interesse daran";
      };

  Show:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Du h@28lst ", (den) x1, " nicht in der Hand."; #endif;
           #iftrue ANREDE==3; "Ihr haltet ", (den) x1, " nicht in der Hand."; #endif;
        2: print (cder) x1; if (x1 has pluralname) print " geben"; else print " gibt";
           " sich unbeindruckt.";
      };

  Enter:
    switch(n)
      {
        1: switch (x1.enter_type)
             {
               enter_sitze:
                 #iftrue ANREDE==1; print "Aber @29u sitzt"; #endif;
                 #iftrue ANREDE==3; print "Aber Ihr sitzt"; #endif;
               enter_liege:
                 #iftrue ANREDE==1; print "Aber @29u liegst"; #endif;
                 #iftrue ANREDE==3; print "Aber Ihr liegt"; #endif;
               default:
                 #iftrue ANREDE==1; print "Aber @29u bist"; #endif;
                 #iftrue ANREDE==3; print "Aber Ihr seid"; #endif;
             };
           if (x1 == noun) print " bereits"; else print " derzeit";

           if (x1 has supporter)
             " auf ", (dem) x1, ".";
           else
             " in ", (dem) x1, ".";
        2,
        3: if (x1.enter_type ~= enter_tritt || n == 3)
             {
               if (x1 has container)
                 print "In ", (den) x1, " ";
               else
                 print "Auf ", (den) x1, " ";

               switch (x1.enter_type)
                 {
                   enter_sitze:
                     #iftrue ANREDE==1; print "kannst @29u @29ich nicht setzen"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr Euch nicht setzen"; #endif;
                   enter_liege:
                     #iftrue ANREDE==1; print "kannst @29u @29ich nicht legen"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr Euch nicht legen"; #endif;
                   enter_steige:
                     #iftrue ANREDE==1; print "kannst @29u nicht steigen"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr nicht steigen"; #endif;
                   enter_klettere:
                     #iftrue ANREDE==1; print "kannst @29u nicht klettern"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr nicht klettern"; #endif;
                   enter_gehe:
                     #iftrue ANREDE==1; print "kannst @29u nicht gehen"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr nicht gehen"; #endif;
		   enter_springe:
		     #iftrue ANREDE==1; print "kannst @29u nicht springen"; #endif;
		     #iftrue ANREDE==3; print "k@26nnt Ihr nicht springen"; #endif;
                   default:
                     #iftrue ANREDE==1; print "kannst @29u nicht betreten"; #endif;
                     #iftrue ANREDE==3; print "k@26nnt Ihr nicht betreten"; #endif;
                 };

               if (n == 3) ", solange ", (er) x1, " geschlossen ", (ist) x1, ".";
               ".";
             }
           else
             print_ret (cDer) x1, " ", (ist) x1, " nicht dazu gedacht, betreten zu werden.";

        4: #iftrue ANREDE==1; "Du kannst nur etwas freistehendes betreten."; #endif;
           #iftrue ANREDE==3; "Ihr k@26nnt nur etwas freistehendes betreten."; #endif;

        5: switch (x1.enter_type)
             {
               enter_sitze:
                 #iftrue ANREDE==1; print "Du setzt dich"; #endif;
                 #iftrue ANREDE==3; print "Ihr setzt Euch"; #endif;
               enter_liege:
                 #iftrue ANREDE==1; print "Du legst dich"; #endif;
                 #iftrue ANREDE==3; print "Ihr legt Euch"; #endif;
               enter_steige:
                 #iftrue ANREDE==1; print "Du steigst"; #endif;
                 #iftrue ANREDE==3; print "Ihr steigt"; #endif;
               enter_klettere:
                 #iftrue ANREDE==1; print "Du kletterst"; #endif;
                 #iftrue ANREDE==3; print "Ihr klettert"; #endif;
               enter_gehe:
                 #iftrue ANREDE==1; print "Du gehst"; #endif;
                 #iftrue ANREDE==3; print "Ihr geht"; #endif;
	       enter_springe:
	         #iftrue ANREDE==1; print "Du springst"; #endif;
		 #iftrue ANREDE==3; print "Ihr spring"; #endif;
               default:
                 #iftrue ANREDE==1; print "Du trittst"; #endif;
                 #iftrue ANREDE==3; print "Ihr tretet"; #endif;
             };
           if (x1 has supporter)
             " auf ", (den) x1, ".";
           else
             " in ", (den) x1, ".";

        6: print "("; L__M(##Exit, 3, x1); ")";
        7: print "("; L__M(##Enter, 3, x1); ")";
      };

  GetOff:
    switch (x1.enter_type)
      {
        enter_sitze:
          #iftrue ANREDE==1; print "Aber @29u sitzt"; #endif;
          #iftrue ANREDE==3; print "Aber Ihr sitzt"; #endif;
        enter_liege:
          #iftrue ANREDE==1; print "Aber @29u liegst"; #endif;
          #iftrue ANREDE==3; print "Aber Ihr liegt"; #endif;
        default:
          #iftrue ANREDE==1; print "Aber @29u bist"; #endif;
          #iftrue ANREDE==3; print "Aber Ihr seid"; #endif;
      };

    if (x1 has container)
      " nicht ", (im) x1, ".";
    else
      " nicht auf ", (dem) x1, ".";

  Exit:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Aber @29u bist nirgendwo drinnen."; #endif;
           #iftrue ANREDE==3; "Aber Ihr seid nirgendwo drinnen."; #endif;
        2: #iftrue ANREDE==1; print "@29u kannst"; #endif;
           #iftrue ANREDE==3; print "Ihr k@26nnt"; #endif;
           " ", (den) x1, " nicht verlassen, solange ", (er) x1, " geschlossen ", (ist) x1, ".";

        3: switch (x1.enter_type)
             {
               enter_sitze, enter_liege:
                 #iftrue ANREDE==1; "Du stehst auf."; #endif;
                 #iftrue ANREDE==3; "Ihr steht auf."; #endif;
               enter_steige:
                 #iftrue ANREDE==1; print "Du steigst"; #endif;
                 #iftrue ANREDE==3; print "Ihr steigt"; #endif;
               enter_klettere:
                 #iftrue ANREDE==1; print "Du kletterst"; #endif;
                 #iftrue ANREDE==3; print "Ihr klettert"; #endif;
               enter_gehe:
                 #iftrue ANREDE==1; print "Du gehst"; #endif;
                 #iftrue ANREDE==3; print "Ihr geht"; #endif;
	       enter_springe:
	         #iftrue ANREDE==1; print "Du springst"; #endif;
		 #iftrue ANREDE==3; print "Ihr spring"; #endif;
               enter_tritt:
                 #iftrue ANREDE==1; print "Du trittst"; #endif;
                 #iftrue ANREDE==3; print "Ihr tretet"; #endif;
             };

           if (x1 has container)
             " aus ", (dem) x1, ".";
           else
             " ", (vom) x1, ".";
      };

  VagueGo:
    #iftrue ANREDE==1; "In welche Richtung m@26chtest @29u gehen?"; #endif;
    #iftrue ANREDE==3; "In welche Richtung m@26chtet Ihr gehen?"; #endif;

  Go:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Du mu@31t zuerst ", (den) x1, " verlassen."; #endif;
           #iftrue ANREDE==3; "Ihr m@24@31t zuerst ", (den) x1, " verlassen."; #endif;
        2: #iftrue ANREDE==1; "Diesen Weg kannst @29u nicht gehen."; #endif;
           #iftrue ANREDE==3; "Diesen Weg k@26nnt Ihr nicht gehen."; #endif;
        3: #iftrue ANREDE==1; "Du bist zu unf@28hig, ", (den) x1, " zu erklimmen."; #endif;
           #iftrue ANREDE==3; "Ihr seid zu unf@28hig, ", (den) x1, " zu erklimmen."; #endif;
        4: #iftrue ANREDE==1; "Du bist zu unf@28hig, ", (den) x1, " hinabzusteigen."; #endif;
           #iftrue ANREDE==3; "Ihr seid zu unf@28hig, ", (den) x1, " hinabzusteigen."; #endif;
        5: #iftrue ANREDE==1; "Leider ", (ist) x1, " ", (der) x1, " @29ir im Weg."; #endif;
           #iftrue ANREDE==3; "Leider ", (ist) x1, " ", (der) x1, " Euch im Weg."; #endif;
        6: print "Leider ist das nicht m@26glich, da ", (der) x1, " nach nirgendwo ";
           if (x1 has pluralname) "f@24hren."; else "f@24hrt.";
      };

  LMode1:
    " schildert die Welt nun kurz und knapp, und gibt nur bei zuvor nicht
    besuchten Orten ausf@24hrliche Beschreibungen.";

  LMode2:
    " schildert die Welt nun ausf@24hrlich (auch bereits zuvor besuchte Orte).";

  LMode3:
    " schildert die Welt nur sehr knapp, und gibt nur noch kurze Ortsbeschreibungen
    (auch bei noch nicht besuchten Orten).";

  Look:
    switch(n)
      {
        1: print " (Auf ", (dem) x1, ")";
        2: print " (In ", (dem) x1, ")";
        3: print " (Als ", (der) x1, ")";
        4: #iftrue ANREDE==1; print "^Auf ", (dem) x1, " siehst @29u "; #endif;
           #iftrue ANREDE==3; print "^Auf ", (dem) x1, " seht Ihr "; #endif;

           WriteListFrom(child(x1), ENGLISH_BIT + RECURSE_BIT + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
           ".";

        default:
          if (x1 ~= location)
            {
              if (x1 has supporter) print "^Auf "; else print "^In ";
              print (dem) x1, " ";

              #iftrue ANREDE==1; print "siehst @29u "; #endif;
              #iftrue ANREDE==3; print "seht Ihr "; #endif;
            }
          else
            {
              #iftrue ANREDE==1; print "^Du siehst "; #endif;
              #iftrue ANREDE==3; print "^Ihr seht "; #endif;
            };

          if (n == 5) print "auch ";
          WriteListFrom(child(x1), ENGLISH_BIT + WORKFLAG_BIT + RECURSE_BIT + PARTINV_BIT + TERSE_BIT + CONCEAL_BIT);
          ".";
      };

  Examine:
    switch(n)
      {
        1: "Es ist zu dunkel, um etwas zu erkennen.";
        2: #iftrue ANREDE==1; "Du siehst nichts besonderes ", (am) x1, "."; #endif;
           #iftrue ANREDE==3; "Ihr seht nichts besonderes ", (am) x1, "."; #endif;
        3: print (cDer) x1, " ", (ist) x1, " derzeit ";
           if (x1 has on) "eingeschaltet."; else "ausgeschaltet.";
      };

  LookUnder:
    switch(n)
      {
        1: "Aber es ist zu dunkel.";
        2: #iftrue ANREDE==1; "Du findest nichts besonderes."; #endif;
           #iftrue ANREDE==3; "Ihr findet nichts besonderes."; #endif;
      };

  Search:
    switch(n)
      {
        1: "Aber es ist zu dunkel.";
        2: "Auf ", (dem) x1, " befindet sich nichts.";
        3: print "Auf ", (dem) x1;
           #iftrue ANREDE==1; print " siehst Du"; #endif;
           #iftrue ANREDE==3; print " seht Ihr"; #endif;
           WriteListFrom(child(x1), TERSE_BIT + ENGLISH_BIT + ISARE_BIT + CONCEAL_BIT);
           ".";
        4: #iftrue ANREDE==1; "Du findest nichts von Interesse."; #endif;
           #iftrue ANREDE==3; "Ihr findet nichts von Interesse."; #endif;
        5: #iftrue ANREDE==1; print "@29u kannst"; #endif;
           #iftrue ANREDE==3; print "Ihr k@26nnt"; #endif;
           " nicht in ", (den) x1, " sehen, solange ", (er) x1, " verschlossen ", (ist) x1, ".";
        6: print_ret (cder) x1, " ", (ist) x1, " leer.";
        7: print (cDer) x1, " enth@28lt ";
           WriteListFromCase(child(x1), TERSE_BIT + ENGLISH_BIT + CONCEAL_BIT, 0, case_akk);
           ".";
      };

  Unlock:
    switch(n)
      {
        1: print_ret (cder) x1, " ", (ist) x1, " nicht dazu gedacht, aufgeschlossen zu werden.";
        2: "Aber ", (er) x1, " ", (ist) x1, " bereits aufgeschlossen.";
        3: if (x1 has pluralname) print "Es passen"; else print "Es pa@31t";
           " ", (der) x1, " nicht ins Schlo@31.";
        4: #iftrue ANREDE==1; print "Du schlie@30t"; #endif;
           #iftrue ANREDE==3; print "Ihr schlie@30t"; #endif;
           " ", (den) x1, " auf.";
      };

  Lock:
    switch(n)
      {
        1: print_ret (cder) x1, " ", (ist) x1, " nicht dazu gedacht, abgeschlossen zu werden.";
        2: "Aber ", (er) x1, " ", (ist) x1, " bereits abgeschlossen.";
        3: #iftrue ANREDE==1; print "Zuerst mu@31t Du"; #endif;
           #iftrue ANREDE==3; print "Zuerst m@24@31t Ihr"; #endif;
           " ", (den) x1, " schlie@30en.";
        4: #iftrue ANREDE==1; print "Du schlie@30t"; #endif;
           #iftrue ANREDE==3; print "Ihr schlie@30t"; #endif;
           " ", (den) x1, " ab.";
      };

  SwitchOn:
    switch(n)
      {
        1: print_ret (cDer) x1, " kann nicht eingeschaltet werden.";
        2: print_ret (cer) x1, " ", (ist) x1, " bereits eingeschaltet.";
        3: #iftrue ANREDE==1; print "Du schaltest ", (den) x1, " ein."; #endif;
           #iftrue ANREDE==3; print "Ihr schaltet ", (den) x1, " ein."; #endif;
      };

  SwitchOff:
    switch(n)
      {
        1: print_ret (cDer) x1, " kann nicht ausgeschaltet werden.";
        2: print_ret (cer) x1, " ", (ist) x1, " bereits ausgeschaltet.";
        3: #iftrue ANREDE==1; print "Du schaltest ", (den) x1, " aus."; #endif;
           #iftrue ANREDE==3; print "Ihr schaltet ", (den) x1, " aus."; #endif;
      };

  Open:
    switch(n)
      {
        1: print_ret (xder) x1, "kann nicht ge@26ffnet werden.";
        2: print_ret (cer) x1, " ", (ist) x1, " abgeschlossen.";
        3: print_ret (cer) x1, " ", (ist) x1, " bereits offen.";
        4: #iftrue ANREDE==1; print "Du @26ffnest ", (den) x1, " und findest "; #endif;
           #iftrue ANREDE==3; print "Ihr @26ffnet ", (den) x1, " und findet "; #endif;

           if (WriteListFrom(child(x1), ENGLISH_BIT + TERSE_BIT + CONCEAL_BIT) == 0)
             "nichts.";
           ".";
        5: #iftrue ANREDE==1; "Du @26ffnest ", (den) x1, "."; #endif;
           #iftrue ANREDE==3; "Ihr @26ffnet ", (den) x1, "."; #endif;
      };

  Close:
    switch(n)
      {
        1: print_ret (xder) x1, "kann nicht geschlossen werden.";
        2: print_ret (cer) x1, " ", (ist) x1, " bereits geschlossen.";
        3: #iftrue ANREDE==1; print "Du schlie@30t"; #endif;
           #iftrue ANREDE==3; print "Ihr schlie@30t"; #endif;
           " ", (den) x1, ".";
      };

  Disrobe:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Du tr@28gst ", (ihn) x1, " nicht."; #endif;
           #iftrue ANREDE==3; "Ihr tragt ", (ihn) x1, " nicht."; #endif;
        2: #iftrue ANREDE==1; "Du ziehst ", (den) x1, " aus."; #endif;
           #iftrue ANREDE==3; "Ihr zieht ", (den) x1, " aus."; #endif;
      };

  Wear:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Damit kannst @29u @29ich nicht kleiden!"; #endif;
           #iftrue ANREDE==3; "Damit k@26nnt Ihr Euch nicht kleiden!"; #endif;
        2: #iftrue ANREDE==1; "Du tr@28gst ", (ihn) x1, " nicht bei Dir."; #endif;
           #iftrue ANREDE==3; "Ihr tragt ", (ihn) x1, " nicht bei Euch."; #endif;
        3: #iftrue ANREDE==1; "Du tr@28gst ", (ihn) x1, " bereits."; #endif;
           #iftrue ANREDE==3; "Ihr tragt ", (ihn) x1, " bereits."; #endif;
        4: #iftrue ANREDE==1; "Du ziehst ", (den) x1, " an."; #endif;
           #iftrue ANREDE==3; "Ihr zieht ", (den) x1, " an."; #endif;
      };

  Eat:
    switch(n)
      {
        1: print_ret (cer) x1, " ", (ist) x1, " nicht essbar.";
        2: #iftrue ANREDE==1; "Du isst ", (den) x1, ". ", (cer) x1, " schmeckt vorz@24glich."; #endif;
           #iftrue ANREDE==3; "Ihr esst ", (den) x1, ". ", (cer) x1, " schmeckt vorz@24glich."; #endif;
      };

  Yes, No:
    "Das war eine rhetorische Frage!";

  Burn:
    "Es ist viel zu gef@28hrlich, mit Feuer zu spielen.";

  Pray:
    "Taten sprechen lauter als Worte.";

  Wake:
    #iftrue ANREDE==1; "Auch wenn @29u glaubst zu tr@28umen, so bist @29u doch wach."; #endif;
    #iftrue ANREDE==3; "Auch wenn Ihr glaubt zu tr@28umen, so seid Ihr doch wach."; #endif;

  WakeOther:
    "Das erscheint ein wenig unn@26tig.";

  Kiss:
    "Aber nicht doch.";

  Think:
    "Welch gute Idee.";

  Smell:
    #iftrue ANREDE==1; "Du riechst nichts ungew@26hnliches."; #endif;
    #iftrue ANREDE==3; "Ihr riecht nichts ungew@26hnliches."; #endif;

  Listen:
    #iftrue ANREDE==1; "Du h@26rst nichts unerwartetes."; #endif;
    #iftrue ANREDE==3; "Ihr h@26rt nichts unerwartetes."; #endif;

  Taste:
    #iftrue ANREDE==1; "Du schmeckst nichts unerwartetes."; #endif;
    #iftrue ANREDE==3; "Ihr schmeckt nichts unerwartetes."; #endif;

  Touch:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Behalte Deine H@28nde bei Dir!"; #endif;
           #iftrue ANREDE==3; "Behaltet Eure H@28nde bei Euch!"; #endif;
        2: #iftrue ANREDE==1; "Du f@24hlst nichts unerwartetes."; #endif;
           #iftrue ANREDE==3; "Ihr f@24hlt nichts unerwartetes."; #endif;
        3: #iftrue ANREDE==1; "Wenn @29u glaubst, das w@24rde helfen."; #endif;
           #iftrue ANREDE==3; "Wenn Ihr glaubt, das w@24rde helfen."; #endif;
      };

  Dig:
    #iftrue ANREDE==1; "Damit erreichst @29u hier nichts."; #endif;
    #iftrue ANREDE==3; "Damit erreicht Ihr hier nichts."; #endif;

  Cut:
    #iftrue ANREDE==1; print_ret (cDen) x1, " zu zerschneiden, h@28lfe @29ir nicht weiter."; #endif;
    #iftrue ANREDE==3; print_ret (cDen) x1, " zu zerschneiden, h@28lfe Euch nicht weiter."; #endif;

  Jump:
    #iftrue ANREDE==1; "Du h@24pfst auf der Stelle, mal auf einem Bein, mal auf zweien."; #endif;
    #iftrue ANREDE==3; "Ihr h@24pft auf der Stelle, mal auf einem Bein, mal auf zweien."; #endif;

  JumpOver, Tie:
    #iftrue ANREDE==1; "Das hilft @29ir auch nicht weiter."; #endif;
    #iftrue ANREDE==3; "Das hilft Euch auch nicht weiter."; #endif;

  Drink:
    "Hier gibt es nichts gutes zu trinken.";

  Fill:
    "Aber hier gibt es nichts zum f@24llen.";

  Sorry:
    #iftrue ANREDE==1; "Du mu@31t @29ich nicht entschuldigen."; #endif;
    #iftrue ANREDE==3; "Ihr m@24@31t Euch nicht entschuldigen."; #endif;

  Strong:
    "Wahre Helden gebrauchen solche Worte nicht.";

  Mild:
    "Ganz recht.";

  Attack:
    "Gewalt ist die falsche Antwort.";

  Swim:
    "Hier gibt es nicht genug Wasser zum schwimmen.";

  Swing:
    "Hier gibt es nichts, um daran zu schwingen.";

  Blow:
    #iftrue ANREDE==1; "Wie willst @29u ", (den) x1, " blasen."; #endif;
    #iftrue ANREDE==3; "Wie wollt Ihr", (den) x1, " blasen."; #endif;

  Rub:
    #iftrue ANREDE==1; "Das brachte @29ich auch nicht weiter."; #endif;
    #iftrue ANREDE==3; "Das brachte Euch auch nicht weiter."; #endif;

  SetTo, Set:
    print_ret (cDen) x1, " kann man nicht einstellen.";

  WaveHands:
    #iftrue ANREDE==1; "Du winkst, und f@24hlst @29ich n@28rrisch dabei."; #endif;
    #iftrue ANREDE==3; "Ihr winkt, und f@24hlt Euch etwas n@28rrisch dabei."; #endif;

  Wave:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Du hast ", (ihn) x1, " nicht."; #endif;
           #iftrue ANREDE==3; "Ihr habt ", (ihn) x1, " nicht."; #endif;
        2: #iftrue ANREDE==1; "Du siehst ein wenig l@28cherlich aus, wie @29u ", (den) x1, " schwenkst."; #endif;
           #iftrue ANREDE==3; "Ihr seht ein wenig l@28cherlich aus, wie Ihr ", (den) x1, " schwenkt."; #endif;
      };

  Pull, Push, Turn:
    switch(n)
      {
        1: print_ret (cer) x1, " ", (ist) x1, " fest verankert.";
        2: #iftrue ANREDE==1; "Das kannst @29u nicht"; #endif;
           #iftrue ANREDE==3; "Das k@26nnt Ihr nicht"; #endif;
        3: "Nichts geschieht.";
        4: "Das w@28re aber recht unfreundlich.";
      };

  PushDir:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Ist das Deine beste Idee?"; #endif;
           #iftrue ANREDE==3; "Ist das Eure beste Idee?"; #endif;
        2: "Das ist keine Richtungsangabe.";
        3: "Nein! In diese Richtung geht das nicht.";
      };

  Squeeze:
    switch(n)
      {
        1: #iftrue ANREDE==1; "Behalte deine H@28nde bei Dir."; #endif;
           #iftrue ANREDE==3; "Behaltet Eure H@28nde bei Euch."; #endif;
        2: #iftrue ANREDE==1; "Damit erreichst @29u nichts."; #endif;
           #iftrue ANREDE==3; "Damit erreicht Ihr nichts."; #endif;
      };

  ThrowAt:
    switch(n)
      {
        1: "V@26llig nutzlos.";
        2: #iftrue ANREDE==1; "Im entscheidenden Moment, fehlt @29ir dann doch der Mut dazu."; #endif;
           #iftrue ANREDE==3; "Im entscheidenden Moment, fehlt Euch dann doch der Mut dazu."; #endif;
      };

  Tell:
    switch(n)
      {
	1: #iftrue ANREDE==1; "Du sprichst einige Zeit mit @29ir selbst."; #endif;
	   #iftrue ANREDE==3; "Ihr sprecht einige Zeit mit Euch selbst."; #endif;
	2: "Keine Reaktion.";
      };

  Answer, Ask:
    #iftrue ANREDE==1; "Du erh@28ltst keine Antwort."; #endif;
    #iftrue ANREDE==3; "Ihr erhaltet keine Antwort."; #endif;

  Buy:
    "Hier wird nichts verkauft.";

  Sing:
    #iftrue ANREDE==1; "Du singst schrecklich falsch."; #endif;
    #iftrue ANREDE==3; "Euer Gesang ist gar schrecklich falsch."; #endif;

  Climb:
    #iftrue ANREDE==1; "Das hilft @29ir auch nicht weiter."; #endif;
    #iftrue ANREDE==3; "Das hilft Euch auch nicht weiter."; #endif;

  Wait:
    "Die Zeit verrinnt.";

  Sleep:
    #iftrue ANREDE==1; "Du f@24hlst @29ich nicht allzu m@24de."; #endif;
    #iftrue ANREDE==3; "Ihr f@24hlt Euch nicht allzu m@24de."; #endif;

  Consult:
    "Dar@24ber steht nichts ", (im) x1, ".";

];

! ------------------------------------------------------------------------------
! Part V.	Special routines
! ------------------------------------------------------------------------------

[ withoutUmlaut;
  string 28 yae_str; string 27 ycae_str;
  string 26 yoe_str; string 25 ycoe_str;
  string 24 yue_str; string 23 ycue_str;
];

[ withUmlaut;
  string 28 xae_str; string 27 xcae_str;
  string 26 xoe_str; string 25 xcoe_str;
  string 24 xue_str; string 23 xcue_str;
];


[ szSwissSub;
  withUmlaut(); string 30 ss_str; string 31 ss_str;
  "Rechtschreibung: Schweizer ~@ss~ Handhabung";
];

[ szGermNewSub;
  withUmlaut(); string 30 sz_str; string 31 ss_str;
  "Rechtschreibung: Reform";
];

[ szGermOldSub;
  withUmlaut(); string 30 sz_str; string 31 sz_str;
  "Rechtschreibung: alt";
];

[ noUmlautSub;
  withoutUmlaut(); string 30 ss_str; string 31 ss_str;
  "Rechtschreibung: keine Umlaute";
];



! ------------------------------------------------------------------------------
! Part VI.	German debugging stuff
! ------------------------------------------------------------------------------

#ifdef DEBUG;

Global trace_LTI = false;

[ PrintBuffer__LTI text		i;

	if (trace_LTI == true) {
		#ifv5; font off; #endif;

		print (string) text, " = ~";
		for (i = 2: i < 2 + buffer->1: i++) print (char) buffer->i;
		print "~^";

		#ifv5; font on; #endif;
	};
];

[ TraceLTIOnSub;	trace_LTI = true;  "Tracing Language to Inform on.";	];
[ TraceLTIOffSub;	trace_LTI = false; "Tracing Language to Inform off.";	];

[ DeclineSub;

  #ifv5; style bold; #endif;
  print "Genus: ";
  if (noun has female) print "Femininum ";
  if (noun has neuter) print "Neutrum ";
  if (noun has male)   print "Maskulinum";
  #ifv5; style roman; #endif;
  print "^^";

  #ifv5; style bold; #endif; print "Bestimmt Singular^"; #ifv5; style roman; #endif;

  print (der) noun, "^";
  print (des) noun, "^";
  print (dem) noun, "^";
  print (den) noun, "^^";

  #ifv5; style bold; #endif; print "Unbestimmt Singular^"; #ifv5; style roman; #endif;

  print (ein)   noun, "^";
  print (eines) noun, "^";
  print (einem) noun, "^";
  print (einen) noun, "^^";

!  #ifv5; style bold; #endif; print "Singular ohne Artikel^"; #ifv5; style roman; #endif;
!
!  print (nameDer) noun, "^";
!  print "(statt) ", (nameDes) noun, "^";
!  if (noun has female) print "(mit) "; else print "(aus) "; print (nameDem) noun, "^";
!  print "(f@24r) ", (nameDen) noun, "^";
];

#endif;

