package iageserver;


/**
 * Process Class - takes user input and player object, then
 * delegates the work to the other objects on new threads.
 */
public class processor extends Thread {
	
	/** Text received from player */
	String received;
	/** Reference to current player object */
	player thisplayer;
	
	/** Starts the processing off on a new thread */
	public processor (String rec, player curplayer) {
		// Set local references
		received = rec;
		thisplayer = curplayer;
		// Fire up routine on new thread
		this.start();
	}
	
	/**
     *  Main body of class - parses input and delegates work to
     *  appropriate parts of system. NB: Extends thread so all
     *  receivers run in separate threads and run asynchronously - 
     *  receipt of further input from user while processing will
     *  still cause a new thread running alongside the current one.
     *  This routine really just slices up the input if it contains
     *  separators and sends them off to be processed.
     */
	public void run() {
		
		int i = 0;
		int spos = 0;
		int v = 1;
		verb nv = null;
		int nextseppos = 0;
		boolean foundatleastone = true;
		
		// Before attempting standard code, check to see if this reponse is 
		// something we were expecting in response to an ASK command and it's not
		// GETSCORE which the client sends at some point during input
		if (thisplayer.WaitingForAskResponse && !received.equals("getscore")) {
			// Check to see if the response has .getscore tacked on the end
			// since the clients do this as a rule and throw it away
			// if it has.
			if (received.indexOf(".getscore") != -1) {
				received = received.substring(0, received.indexOf(".getscore"));	
			}
			
			// Store the value we received
			thisplayer.UserResponseToAsk = received;
			// Pull the player's interpreter that was doing
			// this stuff so we still have local variables
			// Run the code from the ask line again
			thisplayer.AskInterpreter.runcode(thisplayer.AskCode, thisplayer.AskCodeSource, thisplayer.AskProgramCounter);
			// Break out of this process object - we are done!
			return;
		}
			
		// Get a collection of verbs which satisfy as separators
		// of commands.
		iagecollection sepverbs = verb.getVerbsForID(constant.VERB_PREPROCESS_SENTENCEBREAKER);
		
		// If we don't have any, process the lot right now
		if (sepverbs.getCount() == 0) processinput(received);
		
		// Otherwise, lets scan for them - count through valid separators
		nextseppos = 0;
		while (foundatleastone == true) {			
		
			foundatleastone = false;
			
			v = 1;
			while (v <= sepverbs.getCount()) {
			
				nv = (verb) sepverbs.get(v);
				nextseppos = received.indexOf(nv.Text, spos);
				
				if (nextseppos != -1) {
					// We found a separator!
					// Process everything upto it
					processinput(received.substring(spos, nextseppos));
					// Set start position after separator
					spos = nextseppos + nv.Text.length();
					// Flag to say we found one in this pass
					foundatleastone = true;
					// Now that we have moved on to the next position, 
					// start looking for all verbs again
					v = 0;
				}
				v++;
			}
		}
		// There will still be a chunk to process after the separators (if any)
		processinput(received.substring(spos, received.length()));
	}
	
	/*** Equivalent of printf - uses %S for args instead */
	public static String smake(String mess, String arg1) {
		int i = 0;
		StringBuffer b;
		String os = "";
		i = mess.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(mess);
			os = vdu.stringbuffreplace(b, i, i + 2, arg1).toString();
			return os;
		}
		else
		{
			return mess;	
		}
	}
	
	/*** Equivalent of printf - uses %S for args instead */
	public static String smake(String mess, String arg1, String arg2) {
		int i;
		StringBuffer b;
		String os = "";
		i = mess.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(mess);
			os = vdu.stringbuffreplace(b, i, i + 2, arg1).toString();
		}
		else
		{
			return mess;	
		}
		
		String ps = "";
		i = os.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(os);
			ps = vdu.stringbuffreplace(b, i, i + 2, arg2).toString();
			return ps;
		}
		else
		{
			return os;	
		}
		
	}
	
	/*** Equivalent of printf - uses %S for args instead */
	public static String smake(String mess, String arg1, String arg2, String arg3) {
		int i;
		String os = "";
		StringBuffer b;
		i = mess.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(mess);
			os = vdu.stringbuffreplace(b, i, i + 2, arg1).toString();
		}
		else
		{
			return mess;	
		}
		
		String ps = "";
		i = os.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(os);
			ps = vdu.stringbuffreplace(b, i, i + 2, arg2).toString();
		}
		else
		{
			return os;	
		}
		
		String qs = "";
		i = ps.indexOf("%s");
		if (i != -1) {
			b = new StringBuffer(ps);
			qs = vdu.stringbuffreplace(b, i, i + 2, arg3).toString();
			return qs;
		}
		else
		{
			return ps;	
		}
	}
	
	/**
     *  Processes an individual command from the user.
     *  Performs checks for special server commands, performs
     *  dictionary and noun reference matching, triggers events
     *  and runs internal engine code.
     */
	public void processinput(String sproc) {
		
		// Before we do anything, we need to throw away
		// any leading spaces.
		sproc = sproc.trim();
		
		// Check for special server commands and break out
		// if we find an appropriate one.
		if (servercommands(sproc)) return;
		
		// That command must be ok, so store it as last player command
		thisplayer.LastCommand = sproc;		
		
		// Call the parser
		parsestring p = new parsestring(sproc, thisplayer, " ");
    
    	// Scan for dictionary matches, returning errors for
    	// non-existent words etc.
    	if (!p.scanformatches()) return;
    	
    	// If the parser asked the player a question on their last go, then
    	// see if we only have a noun (parser questions asked are *always*
    	// asking for a noun) and if we do, add the players last verb
    	// in and resume.
    	if (p.Verb == 0 && (p.Adverb != 0 || p.Noun != 0) && thisplayer.LastParserAskedQuestion) {
			p.Verb = thisplayer.LastParser.Verb;
			p.SVerb = thisplayer.LastParser.SVerb;
			p.Verb2 = thisplayer.LastParser.Verb2;
			p.SVerb2 = thisplayer.LastParser.SVerb2;
			p.Verb3 = thisplayer.LastParser.Verb3;
			p.SVerb3 = thisplayer.LastParser.SVerb3;
			if (thisplayer.LastQReplacesNoun == 1) {
				// This parser already has the new noun - do nothing
			}
			if (thisplayer.LastQReplacesNoun == 2) {
				// Replace second noun and revert the old one back to the first
				p.Noun2 = p.Noun;
				p.SNoun2 = p.SNoun;
				p.Noun = thisplayer.LastParser.Noun;				
				p.SNoun = thisplayer.LastParser.SNoun;
			}
			if (thisplayer.LastQReplacesNoun == 3) {
				// Replace third noun and revert the other two
				p.Noun3 = p.Noun;
				p.SNoun3 = p.SNoun;
				p.Noun = thisplayer.LastParser.Noun;
				p.SNoun = thisplayer.LastParser.SNoun;
				p.Noun2 = thisplayer.LastParser.Noun2;
				p.SNoun2 = thisplayer.LastParser.SNoun2;
			}
			if (thisplayer.LastQReplacesNoun == 4) {
				// There is no noun 4, but this is in that special
				// case where you want to ask for an adverb
				// Since the player should have already given the
				// new adverb as the first one anyway, we don't need to
				// do anything here, since adding in the old verb
				// is enough
			}
		}    
		
		// Destroy the old parser - the question has been completed or ignored
		thisplayer.LastParserAskedQuestion = false;
		thisplayer.LastParser = null;	
		thisplayer.LastQReplacesNoun = 0;
   
    	// Make sure nouns refer to objects available
    	if (!p.checknouns()) return;
    
    	// Create a new interpreter object from the current player and parser
    	interpreter i = new interpreter(thisplayer, p);
    
    	  // Perform object each_turn code
		  // if they have some
		  int co = 1;
		  item im = null;
		  while (co <= data.oitems.getCount()) {
		  	  im = (item) data.oitems.get(co);
		  	  // Run the code
		      i.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "each_turn", new String[4], 0, "Internal.EachTurn", 0, 0);
		  	  co++;
		  }
		  
		  // Perform location each_turn code
		  // if they have some
		  co = 1;
		  location lo = null;
		  while (co <= data.olocations.getCount()) {
		  	  lo = (location) data.olocations.get(co);
		  	  // Run the code
		      i.runcode(lo.OnInput, "Location(" + lo.Name + ").OnInput", "each_turn", new String[4], 0, "Internal.EachTurn", 0, 0);
		  	  co++;
		  }
		  
		  // Perform character each_turn code
		  // if they have some
		  co = 1;
		  character cc = null;
		  while (co <= data.ocharacters.getCount()) {
		  	  cc = (character) data.ocharacters.get(co);
		  	
		  	  // If we aren't running real-time NPCs, then
		      // fire off their AI routines now for each player turn
		  	  if (!data.ogame.RealTimeNPCs) {
		  	  	cc.PerformAI();
			  	i.runcode(cc.OnTimer, "Character(" + Long.toString(cc.ID) + ").OnTimer");
			  }
		  	  
		  	  // Run the code
		      i.runcode(cc.OnAction, "Character(" + cc.Name + ").OnAction", "each_turn", new String[4], 0, "Internal.EachTurn", 0, 0);
		  	  co++;
		  }
    
    	// Mark this user as having nothing transmitted to them at this point
    	thisplayer.OutputToPlayer = false;
    	
    	// Perform immediate after input code
    	i.runcode(data.ogame.OnAfterInputImmediate, "Game.OnAfterInputImmediate");
    
    	// Attempt to perform location specific code if nothing came
    	// of immediate after input.
    	if (!thisplayer.OutputToPlayer) {
    		i = new interpreter(thisplayer, p);
	    	int z = 1;
	    	location l = null;
	    	while (z <= data.olocations.getCount()) {
	    		l = (location) data.olocations.get(z);
	    		if (l.ID == thisplayer.CurrentLocation) {
	    			i.runcode(l.OnInput, "Location_" + Long.toString(thisplayer.CurrentLocation) + ".OnInput");
	    			break;
	    		}
	    		z++;
	    	}
	    }
        
        // If nothing happened as a result, run the code for items or npcs
        // referenced by nouns
        if (!thisplayer.OutputToPlayer) {
        	p.runactioncode();
        }
        
        
        // If nothing happened as a result, check if it was an NPC address
        // and run their OnTalk code:
        // If this is an NPC address (ie, command starts with the
		// NPC's noun, follwed by a comma - established in ScanForMatches)
		// we run the ontalk code for that NPC.
		if (p.isnpcaddress) {
			interpreter ti = new interpreter(thisplayer, p);
			// Find the NPC
			int z = 1;
			character c = null;
			while (z <= data.ocharacters.getCount()) {
				c = (character) data.ocharacters.get(z);
				if (c.ID == p.npcarrayaddressid) {
					ti.runcode(c.OnTalk, "Character(" + Long.toString(c.ID)	+ ").OnTalk");
					break;
				}
				z++;
			}
		}
        
    	// If nothing happened as a result, go to the global after input code
	    if (!thisplayer.OutputToPlayer) {
	    
	        i.runcode(data.orunafterinput.code, "OnAfterInput");
	        
	        // If nothing still happened, then go to our internal code
	        // to see if it's something the engine can handle.
	        if (!thisplayer.OutputToPlayer) {
	            if (!p.internalcode()) {
	            	// If we got false from the internal code, 
	            	// we should not increment the turn counter
	            	// and just run the before input code and drop out
    				i.runcode(data.orunbeforeinput.code,"OnBeforeInput");
    				return;        		
	            }
	     	}
	 	}
    
    	// Increase turns taken
    	thisplayer.Turns++;
    
    	// Run the before input code.
    	i.runcode(data.orunbeforeinput.code,"OnBeforeInput");
	}
	
	/**
     *  Looks for special server instructions from the client
     *  in the user's input text. If it finds one, this
     *  executes the command and returns true, causing the rest
     *  of the processing to be abandoned. This is because
     *  items in the category "server instructions" should not
     *  be parsed and matched in the same way.
     */
	public boolean servercommands(String sproc) {
	
		int i;
	
		// SETALIAS command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_SETALIAS, sproc, false);
		if (i == 0) {
			// Find the new alias by throwing away everything before the first space
			int alpos = sproc.indexOf(" ");
			if (alpos != -1 && alpos < sproc.length()) {
				// Find the new alias
				String newalias = sproc.substring(alpos + 1, sproc.length());
				
				// Work out whether this is a new player or a change of name
				boolean isnew = thisplayer.Name.equals(data.defaultnewplayername);
				
				// Inform the other users
				if (isnew) {
					vdu.TransmitAll(smake(message.getMessage(constant.MSG_PLAYERENTEREDTHEGAME), newalias));
				}
				else
				{
					vdu.TransmitAll(smake(message.getMessage(constant.MSG_PLAYERXISNOWKNOWNAS), thisplayer.Name, newalias));
				}
				
				// Change it on the player object
				thisplayer.Name = newalias;
				thisplayer.DisplayName = newalias;
				
				// Update the server console to reflect the new name
				vdu.updateconnectionlist();
				
				// Special server command was found
				return true;
			}
			else
			{
				// The new alias is not valid - tell the user
				vdu.Transmit(message.getMessage(constant.MSG_INVALIDALIAS), thisplayer);
				return true;
			}
		}
		
		// LISTPLAYERS command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_LISTPLAYERS, sproc, true);
		if (i == 0) {
			// Output list of players on the server to user
			String tonly = "";
			String PBanner = "";
			i = 1;
			player p = null;
			interpreter banint = null;
			while (i <= data.oplayers.getCount()) {
				p = (player) data.oplayers.get(i);
				// Get the player's banner
				banint = new interpreter(p, new parsestring("x", p, "|"));
				banint.runcode(data.ogame.OnDisplayBanner, "Game.OnDisplayBanner");
				PBanner = banint.returnvalue;
				tonly = tonly + p.Name + " (" + p.IPAddress + ":" + Integer.toString(p.Index) + ") (" + PBanner + ")<br>";
				i++;
			}
			
			vdu.Transmit(tonly, thisplayer);
			
			// Special server command was found.
        	return true;
		}
		
		// SETTEXT command ----------------------------------------
		if (sproc.equalsIgnoreCase("SetText")) {
			thisplayer.TextOnly = true;
			vdu.Transmit("Text only mode enabled.", thisplayer);
			return true;	
		}
		
		// IPTERM command -----------------------------------------
		if (sproc.equalsIgnoreCase("IPTERM")) {
			// Start everything up for them:
			processinput("settext");
			processinput("setalias newterminalplayer");
			processinput("run_on_start");
			return true;
		}
			
		
		// GETSCORE command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_GETSCORE, sproc, true);
		if (i == 0) {
			// Run OnDisplayBanner code	
			interpreter ti = new interpreter(thisplayer, null);
			ti.runcode(data.ogame.OnDisplayBanner, "OnDisplayBanner");
			vdu.Transmit("SCORE: " + ti.returnvalue + "|", thisplayer);
			// Special server command was found
			return true;
		}
		
		// SAY command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_SAY, sproc, false);
		if (i == 0) {
			// Output speech
			String speech = sproc.substring(sproc.indexOf(" "), sproc.length());
			vdu.TransmitAllInLocation(thisplayer.Name + ": " + speech, thisplayer, thisplayer.CurrentLocation);
			// echo back to user so they can see their own speech.
			vdu.Transmit(thisplayer.Name + ": " + speech, thisplayer);
			
			// Spawn a new parser containing this string and run
			// NPC OnTalk events so they can act on it
			parsestring ps = new parsestring(speech, thisplayer, " ");
			interpreter inp = new interpreter(thisplayer, ps);
			int z = 1;
			character cc= null;
			while (z <= data.ocharacters.getCount()) {
				cc = (character) data.ocharacters.get(z);
				
				// Only run if they are in the same location as the player
				// speaking.
				if (cc.CurrentLocation == thisplayer.CurrentLocation) {
					inp.runcode(cc.OnTalk, "Character(" + cc.Name + ").OnTalk");					
				}
				
				z++;
			}
			
			// Found command ok
			return true;
		}
		
		// DO command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_DO, sproc, false);
		if (i == 0) {
			// Output action
			String action = sproc.substring(sproc.indexOf(" "), sproc.length());
			vdu.TransmitAllInLocation(thisplayer.Name + " " + action, thisplayer, thisplayer.CurrentLocation);
			// echo back to user so they can see their own action.
			vdu.Transmit(thisplayer.Name + " " + action, thisplayer);
			// Found command ok
			return true;
		}			
		
		// SHOUT command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_SHOUT, sproc, false);
		if (i == 0) {
			// Output speech		
			String squeal = sproc.substring(sproc.indexOf(" "), sproc.length());
			vdu.TransmitAllInLocation(thisplayer.Name + " shouts: " + squeal, thisplayer, thisplayer.CurrentLocation);
			// echo back to user
			vdu.Transmit(thisplayer.Name + " shouts: " + squeal, thisplayer);
			
			// Spawn a new parser containing this string and run
			// NPC OnTalk events so they can act on it
			parsestring ps = new parsestring(squeal, thisplayer, " ");
			interpreter inp = new interpreter(thisplayer, ps);
			int z = 1;
			character cc= null;
			while (z <= data.ocharacters.getCount()) {
				cc = (character) data.ocharacters.get(z);
				
				// Only run if they are in the same location as the player
				// speaking.
				if (cc.CurrentLocation == thisplayer.CurrentLocation) {
					inp.runcode(cc.OnTalk, "Character(" + cc.Name + ").OnTalk");					
				}
				
				z++;
			}
			
			// Found command ok
			return true;
		}
		
		// QUIT command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_QUIT, sproc, true);
		if (i == 0) {
			// Make the player quit
			thisplayer.quit(false);
			// Found command
			return true;
		}
		
		// RUN_ON_START command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_RUN_ON_START, sproc, true);
		if (i == 0) {
			interpreter ti = new interpreter(thisplayer, null);
			ti.runcode(data.ogame.OnStart, "Game.OnStart");
			return true;
		}
		
		// VERBOSE command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_VERBOSE, sproc, true);
		if (i == 0) {
			thisplayer.VerboseMode = true;
			vdu.Transmit(message.getMessage(constant.MSG_VERBOSE_ON), thisplayer);
			return true;
		}
		
		// BRIEF command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_BRIEF, sproc, true);
		if (i == 0) {
			thisplayer.VerboseMode = false;
			vdu.Transmit(message.getMessage(constant.MSG_VERBOSE_OFF), thisplayer);
			return true;
		}
		
		// AGAIN command ------------------------------------
		i = verb.checkVerbIDInString(constant.VERB_SC_AGAIN, sproc, true);
		if (i == 0) {
			// Call processinput routine again with last command -
			processinput(thisplayer.LastCommand);
			return true;
		}
		
		
		return false;
	}
	
	/**
     *  Forces a string to be "width" characters long.
     */
	private String pad(String s, int width) {
		String spc = "                                                                ";
		if (s.length() > width) {
			return s.substring(0, width);
		}
		return s + spc.substring(0, width - s.length());
	}

}