package iagecompiler;


/**
 * Game class. Used to store designer's preferences, game
 * level information and custom events.
 */
public class game {

	/** Maximum number of items any player can carry */
	public long MaxItemsCanCarry = 0;
	/** Maximum weight of combined items any player can carry */
	public long MaxWeightCanCarry = 0;
	/** Maximum size of combined items any player can carry */
	public long MaxSizeCanCarry = 0;
	/** Location all players start in (or -1 for random) */
	public long StartingLocation = 1;
	/** Flag to determine whether descriptions should be repeated
	* to players who have already visited a location. Basically the
	* default for verbosity for all players 
	*/
	public boolean RepeatDescription = true;
	/** If set, an extra line of text will be appended to location 
	* descriptions, listing the available exits.
	*/
	public boolean ShowAvailableExits = true;
	/**
	*  If set, MUD players can save and load their states
	*  in a special server area. Note that objects cannot be persisted with
	*  players because of how they are tied together - besides it really isn't
	*  fair is it! Basically all the custom properties for that player are
	*  persisted, along with their alias, their score, turns taken and currentlocation.
	*  Combat properties are included in the custom properties.
	*  Players can password protect their save games.
	*/
	public boolean AllowPersist = false;
	/** If this option is set, more detailed player saves are allowed*/
	public boolean SinglePlayerGame = false;
	/** Number of simultaneous maximum users on server for this game */
	public int MaxUsers = 128;
	/** Turn based NPCs instead of real time? */
	public boolean RealTimeNPCs = true;
	/** Password for IDE */
	public String IDEPassword = "";
	/** Set if you want to use IAGE inbuilt combat system. The properties can still be used
	  * if you write your own.*/
	public boolean UsingIAGECombat = false;
	/** Set if you want to use IAGE money. Money is an abstract entity which has no
	  * object references. IAGE will take care of giving money to killers etc. if you switch
	  * this on. */
	public boolean UsingIAGEMoney = false;
	/** Determines whether location/inventories are tall or wide */
	public boolean WideDisplay = true;
	/** Default number of hit points each player starts the game with */
	public long DefaultHitPoints = 50;
	/** Default maximum damage a player can do with a single hit */
	public long DefaultDamage = 5;
	/** Initial amount of money the player is carrying */
	public long DefaultMoney = 0;
	/** Default percentage chance of a player hitting their target in an attack */
	public long DefaultChanceOfHitting = 60;
	/** Amount to increment hit chance by after killing a player */
	public long ChanceOfHittingIncrementForKill = 2;
	/** Amount to increment barefist damage indicator by after a kill */
	public long DamageIndicatorIncrementForKill = 1;
	/*** Media base path - is automatically put on the front of URLs */
	public String MediaBase = "";
	/*** Trigger verb ID list to override secondary nouns */
	public String OverrideSecondaryNouns = "";
	/** Players stay dead once killed and have to reconnect */
	public boolean PlayersStayDead = false;
	/** NPCs stay dead once killed - if this is set to false, they are
	  * resurrected in a random location */
	public boolean NPCsStayDead = false;
	/*** Name of the loaded game */
	public String Name = "";
	/** Code collection, fires immediately after input */
	public iagecode OnAfterInputImmediate = new iagecode();
	/** Code collection, fires when any player quits */
	public iagecode OnQuit = new iagecode();
	/** Code collection, fires when a new player enters the game */
	public iagecode OnStart = new iagecode();
	/** Code collection, runs when the score banner is displayed at the top-right */
	public iagecode OnDisplayBanner = new iagecode();
	/** Code collection, runs when a player requests their score with SCORE (or equivalent) */
	public iagecode OnScore = new iagecode();
	/** Code collection, runs when the game is started */
	public iagecode OnInitialise = new iagecode();
  
}

