package iageserver;

/**
 * Location class. Contains information about a single IAGE location.
 */
public class location {

  /** Player base constant.
    * Bases are used for object locations. If item.CurrentLocation is
    * player.ID + location.PLAYERBASE then it's being held by that player.
    */
  static public long PLAYERBASE = 100000;
  /** Container base constant.
    * Bases are used for object locations. If item.CurrentLocation is
    * item.ID + location.CONTAINERBASE then it's being stored in a container.represented
    * by item.ID.
    */
  static public long CONTAINERBASE = 200000;
  /** NPC base constant.
    * Bases are used for object locations. If item.CurrentLocation is
    * character.ID + location.NPCBASE then it's being held by that NPC.
    */
  static public long NPCBASE = 300000;
  /**
   *  Surface base representing item surfaces.
   */
  static public long SURFACEBASE = 400000;
  /** Location base constant.
    * Bases are used for object locations. If item.CurrentLocation is
    * location.ID + location.LOCATIONBASE then it's in that location.
    */
  static public long LOCATIONBASE = 0;
  /** LIMBO constant - items in limbo are not anywhere. */
  static public long LIMBO = 0;
  /** RANDOM constant - any location marked as random will be generated
    * at random into a real location at the appropriate time (only really
    * valid for Item.CurrentLocation and Game.StartingLocation).
    */
  static public long RANDOM = -1;  

  /** Location's ID */
  public long ID = 0;
  /** Location's display name */
  public String Name = "";
  /** Absolute URL of image data for this location. Relative URLs are
    * no longer permitted.
    */
  public String ImagePath = "";
  /** Location description */
  public String Description = "";
  /** Determines if the location is dark (ie. someone must have a lightsource to see) */
  public boolean IsDark = false;
  /** Custom properties for location. Custom properties tie together objects and flags */
  public String CustomProperties = "";

  /** Location to move to if player or NPC goes north */
  public long N = 0;
  /** Location to move to if player or NPC goes south */
  public long S = 0;
  /** Location to move to if player or NPC goes east */
  public long E = 0;
  /** Location to move to if player or NPC goes west */
  public long W = 0;
  /** Location to move to if player or NPC goes up */
  public long U = 0;
  /** Location to move to if player or NPC goes down */
  public long D = 0;
  /** Location to move to if player or NPC goes northeast */
  public long NE = 0;
  /** Location to move to if player or NPC goes northwest */
  public long NW = 0;
  /** Location to move to if player or NPC goes southeast */
  public long SE = 0;
  /** Location to move to if player or NPC goes southwest */
  public long SW = 0;
    /** Name value pairs */
  public iagecollection NameValues = new iagecollection();
  /** Code collection, fires when a player transmits input to the server while
    * in this location
    */
  public iagecode OnInput = new iagecode();
  /** Code collection, fires immediately after the location has been transmitted
    * to a player
    */
  public iagecode OnDisplay = new iagecode();

	public String getNameValue(String valname) {
	
		 // Find value of this name
		 int ic = 1;
		 namevaluepair nv = null;
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	// Found it - return the value
		 	 	return nv.Value;
		 	 }
		     ic++;	 	
		 }	
		 return "0";
	}
	
	public void setNameValue(String valname, String newval) {
	
		// Hunt through to see if we already have a value with
		// this name:
		 int ic = 1;
		 namevaluepair nv = null;
		 
		 while (ic <= this.NameValues.getCount()) {
		 	 nv = (namevaluepair) this.NameValues.get(ic);
		 	 if (nv.Name.equalsIgnoreCase(valname)) {
		 	 	
		 	 	// We have one, replace the value
		 	 	nv.Value = newval;
		 	 	return;
		 	 }
		     ic++;	 	
		 }
		 
	 	// Add it
	 	nv = new namevaluepair();
	 	nv.Name = valname;
	 	nv.Value = newval;
	 	this.NameValues.add(nv);
		
	}

}