package iagecompiler;


import java.awt.*;

/**
 * Wrapper class to start up mainframe.
 * Also contains MAIN routine for application startup.
 */
public class mainscreen {
  /** True if we are going to pack the frame, otherwise validates */
  boolean packFrame = false;

  /** Construct the application */
  public mainscreen() {
    mainframe frame = new mainframe();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame) {
      frame.pack();
    }
    else {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
    
  }
  /** Main method - starts IAGE IDE */
  public static void main(String[] args) {
  	
  	// If we don't have any arguments, then start up as normal
  	if ( args.length == 0 ) {
    	new mainscreen();
    }
    else
    {
    	// Make sure we have enough arguments
    	if (args.length == 1) {
    		System.out.println("Usage: iagecompiler.jar <source> <destination>");
    		System.exit(0);
    	}
    	
    	// Tell vdu to use console
    	vdu.consoleonly = true;
    	// Compile it
    	importiage ia = new importiage();
    	ia.donamedimport(args[0]);
    	// Save it
    	data.openfilename = args[1];
		new data().SaveData(true);
		// Finish
		System.exit(0);
    }
  }
}