package iagecompiler;

import java.io.*;

/*** This is the class that actually does all the compiling up */
public class importiage extends importer {
	
	private iagecode tf = new iagecode();
	private int ci = 1;
	private boolean errorflag = false;
	private String errormsg = "";
	private boolean islibrary = false;
	
	public importiage() {
		super();
	}	
	
	public void importandcompilefromsubclass(String filename) {
		
		openfilename = filename;
		islibrary = true;
		
		fileeof = false;
	  	String buff = "";
	  	
	  	try {
	  		
		  	File fh = new File(filename);
		  	FileInputStream in = new FileInputStream(fh);
		  	try {
				parsesubfile(in);
			}
			catch (Exception e) {
				e.printStackTrace();
				vdu.println("Library compilation failed - " + e.getMessage());
			}
		}
		catch (IOException e) {
			e.printStackTrace();
			vdu.println("IO Error compiling library - " + filename);
		}
			
	}
	
	public void parse(FileInputStream in) throws Exception {

		// It's much easier to work in memory, so we are going to build an IAGE
		// code collection containing all the file contents.
		
		while (!fileeof) {
			tf.add(readline(in));
		}
	
		// Jump to the start of our compile pass
		startcompile();
	}
	
	public void parsesubfile(FileInputStream in) throws Exception {

		// It's much easier to work in memory, so we are going to build an IAGE
		// code collection containing all the file contents.
		
		while (!fileeof) {
			tf.add(readline(in));
		}
	
		// import the info
		importsubfile();
	}
	
	/*** Limited compile for imported files follows - these will be properly
	     resolved at the end by the main compile */
	private void importsubfile() throws Exception {
		
		try {
			
			if (!islibrary)
				vdu.println("Building " + openfilename + "...");
			else
				System.out.println("Building " + openfilename + "...");
				
			System.out.println("Number of lines in file: " + Integer.toString(tf.getCount()));
			
			// FIRST PASS - INCLUDES
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "#import ") || checkstart(s, "#import\t")) {
					importandcompile(s);
				}
				ci++;
			}
			
			// SECOND PASS - LOCATIONS ONLY AND NO RESOLVING:
			ci = 1;
			while (ci <= tf.getCount()) {
			
				// Work out what is on each line from the header	
				String s = tf.get(ci);
				s = s.trim();
				
				if (checkstart(s, "location ") || checkstart(s, "location\t")) {
					storelocation();
				}
				ci++;
			}
			
			// THIRD PASS - ITEMS
			ci = 1;
			while (ci <= tf.getCount()) {
				
				// Work out what is on each line from the header
				String s= tf.get(ci);
				s = s.trim();
				
				if (checkstart(s, "item ") || checkstart(s, "item\t")) {
					storeitem();
				}
				ci++;
			}
			
			
			// FOURTH PASS - INHERITED ITEMS
			ci = 1;
			while (ci <= tf.getCount()) {
				
				String s = tf.get(ci);
				s = s.trim();
				if (s.indexOf(" extends ") != -1 && checkstart(s, "item ")) {
					resolveextendeditem(s);
				}
				ci++;
			}
					
			
			// FIFTH PASS - NPCS	
			ci = 1;
			while (ci <= tf.getCount()) {
				
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "character ") || checkstart(s, "character\t")) {
					storenpc();
				}
				ci++;
			}
		
			// SIXTH PASS - CODE MODULES
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "module ") || checkstart(s, "module\t")) {
					storemodule();
				}
				ci++;
			}
		
		
			// SEVENTH PASS - GAME OBJECT
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "gamecode ") || (checkstart(s, "gamecode\t"))) {
					storegame();
				}
				ci++;
			}
			
			// NINTH PASS - MESSAGE
			ci = 1;
			boolean mmatch = false;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "librarymessage ") || checkstart(s, "librarymessage\t")) {
					message m = new message();
					m.ID = Long.parseLong(getwithproperty(s));
					m.Text = getwithtextproperty(s);
					
					// Now see if we have a message with this ID
					int bi = 1;
					message mt = null;
					mmatch = false;
					while (bi <= data.omessages.getCount()) {
						mt = (message) data.omessages.get(bi);
						if (mt.ID == m.ID) {
							// We do, override the text
							mt.Text = m.Text;
							// Break out of this inner while loop
							mmatch = true;
							break;
						}
						bi++;
					}
					if (!mmatch) {
						data.omessages.add(m);
					}
				}
				ci++;
			}
			
		}
		catch (Exception e) {
			vdu.println(e.getMessage());
			e.printStackTrace();
			throw new Exception("Errors occurred.");
		}
	}
	
	
	/*** Main compile routines follow */
	private void startcompile() throws Exception {
		
		try {
			
			if (!islibrary)
				vdu.println("Building " + openfilename + "...");
			else
				System.out.println("Building " + openfilename + "...");
				
			System.out.println("Number of lines in file: " + Integer.toString(tf.getCount()));
			
			// FIRST PASS - INCLUDES
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "#import ") || checkstart(s, "#import\t")) {
					importandcompile(s);
				}
				ci++;
			}
			
			// SECOND PASS - LOCATIONS ONLY AND NO RESOLVING:
			ci = 1;
			while (ci <= tf.getCount()) {
			
				// Work out what is on each line from the header	
				String s = tf.get(ci);
				s = s.trim();
				
				if (checkstart(s, "location ") || checkstart(s, "location\t")) {
					storelocation();
				}
				ci++;
			}
		
			// SECOND PASS - RESOLVE LOCATION POINTERS INTERNALLY
			resolvelocation();
			
			// THIRD PASS - ITEMS
			ci = 1;
			while (ci <= tf.getCount()) {
				
				// Work out what is on each line from the header
				String s= tf.get(ci);
				s = s.trim();
				
				if (checkstart(s, "item ") || checkstart(s, "item\t")) {
					storeitem();
				}
				ci++;
			}
			
			
			// FOURTH PASS - INHERITED ITEMS
			ci = 1;
			while (ci <= tf.getCount()) {
				
				String s = tf.get(ci);
				s = s.trim();
				if (s.indexOf(" extends ") != -1 && checkstart(s, "item ")) {
					resolveextendeditem(s);
				}
				ci++;
			}
					
			
			// FIFTH PASS - NPCS	
			ci = 1;
			while (ci <= tf.getCount()) {
				
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "character ") || checkstart(s, "character\t")) {
					storenpc();
				}
				ci++;
			}
		
			// SIXTH PASS - CODE MODULES
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "module ") || checkstart(s, "module\t")) {
					storemodule();
				}
				ci++;
			}
		
		
			// SEVENTH PASS - GAME OBJECT
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "gamecode ") || (checkstart(s, "gamecode\t"))) {
					storegame();
				}
				ci++;
			}
			
			// NINTH PASS - MESSAGE
			ci = 1;
			boolean mmatch = false;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "librarymessage ") || checkstart(s, "librarymessage\t")) {
					message m = new message();
					m.ID = Long.parseLong(getwithproperty(s));
					m.Text = getwithtextproperty(s);
					
					// Now see if we have a message with this ID
					int bi = 1;
					message mt = null;
					mmatch = false;
					while (bi <= data.omessages.getCount()) {
						mt = (message) data.omessages.get(bi);
						if (mt.ID == m.ID) {
							// We do, override the text
							mt.Text = m.Text;
							// Break out of this inner while loop
							mmatch = true;
							break;
						}
						bi++;
					}
					if (!mmatch) {
						data.omessages.add(m);
					}
				}
				ci++;
			}
			
			// TENTH PASS - RESOLVE ALL CODE REFERENCES TO THIS AND OTHER NAMED OBJECTS
			int i = 1;
			location l = null;
			while (i <= data.olocations.getCount()) {
				l = (location) data.olocations.get(i);
				try {
					translatecode(l.OnInput, "location(" + l.ID + ")", l.CodeName);
				} catch(Exception e) {vdu.println("Error in " + l.CodeName + ".OnInput"); throw new Exception(e.getMessage());}
				try {
				translatecode(l.OnDisplay, "location(" + l.ID + ")", l.CodeName);
				} catch(Exception e) {vdu.println("Error resolving objects in " + l.CodeName + ".OnDisplay"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			item im = null;
			while (i <= data.oitems.getCount()) {
				im = (item) data.oitems.get(i);
				try {
				translatecode(im.OnAction, "item(" + im.ID + ")", im.CodeName);
				} catch(Exception e) {vdu.println("Error resolving objects in " + im.CodeName + ".OnAction"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			character cc = null;
			while (i <= data.ocharacters.getCount()) {
				cc = (character) data.ocharacters.get(i);
				try {
				translatecode(cc.OnAction, "character(" + cc.ID + ")", cc.CodeName);
				} catch(Exception e) {vdu.println("Error resolving objects in " + cc.CodeName + ".OnAction"); throw new Exception(e.getMessage());}
				try {
				translatecode(cc.OnTalk, "character(" + cc.ID + ")", cc.CodeName);
				} catch(Exception e) {vdu.println("Error resolving objects in " + cc.CodeName + ".OnTalk"); throw new Exception(e.getMessage());}
				try {
				translatecode(cc.OnTimer, "character(" + cc.ID + ")", cc.CodeName);
				} catch(Exception e) {vdu.println("Error resolving objects in " + cc.CodeName + ".OnTimer"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			codemodule cm = null;
			while (i <= data.omodules.getCount()) {
				cm = (codemodule) data.omodules.get(i);
				try {
					translatecode(cm.Code, "Module(" + cm.Name + ")", cm.Name);
				} catch(Exception e) {vdu.println("Error resolving objects in module " + cm.Name + ".Code"); throw new Exception(e.getMessage());}
				i++;
			}

			// Game code
			try {
				translatecode(data.ogame.OnInitialise, "game", "Game.OnInitialise");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnInitialise"); throw new Exception(e.getMessage());}
						try {
				translatecode(data.ogame.OnStart, "game", "Game.OnStart");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnStart"); throw new Exception(e.getMessage());}
						try {
				translatecode(data.ogame.OnQuit, "game", "Game.OnQuit");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnQuit"); throw new Exception(e.getMessage());}
							try {
				translatecode(data.ogame.OnAfterInputImmediate, "game", "Game.OnAfterInputImmediate");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnAfterInputImmediate"); throw new Exception(e.getMessage());}
							try {
				translatecode(data.ogame.OnScore, "game", "Game.OnScore");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnScore"); throw new Exception(e.getMessage());}
							try {
				translatecode(data.ogame.OnDisplayBanner, "game", "Game.OnDisplayBanner");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.OnDisplayBanner"); throw new Exception(e.getMessage());}
							try {
				translatecode(data.orunafterinput.code, "game", "Game.AfterInput");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.AfterInput"); throw new Exception(e.getMessage());}
							try {
				translatecode(data.orunafterinput.code, "game", "Game.BeforeInput");
				} catch(Exception e) {vdu.println("Error resolving objects in Game.BeforeInput"); throw new Exception(e.getMessage());}
			

			// ELEVENTH PASS - SYNTAX CHECK ALL CODE
			syntaxchecker sc = new syntaxchecker();
			i = 1;
			while (i <= data.olocations.getCount()) {
				l = (location) data.olocations.get(i);
				try {
					sc.docheck(l.OnInput);
				} catch(Exception e) {vdu.println("Syntax error in " + l.CodeName + ".OnInput"); throw new Exception(e.getMessage());}
				try {
				sc.docheck(l.OnDisplay);
				} catch(Exception e) {vdu.println("Syntax error in " + l.CodeName + ".OnDisplay"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			while (i <= data.oitems.getCount()) {
				im = (item) data.oitems.get(i);
				try {
				sc.docheck(im.OnAction);
				} catch(Exception e) {vdu.println("Syntax error in " + im.CodeName + ".OnAction"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			while (i <= data.ocharacters.getCount()) {
				cc = (character) data.ocharacters.get(i);
				try {
				sc.docheck(cc.OnAction);
				} catch(Exception e) {vdu.println("Syntax error in " + cc.CodeName + ".OnAction"); throw new Exception(e.getMessage());}
				try {
				sc.docheck(cc.OnTalk);
				} catch(Exception e) {vdu.println("Syntax error in " + cc.CodeName + ".OnTalk"); throw new Exception(e.getMessage());}
				try {
				sc.docheck(cc.OnTimer);
				} catch(Exception e) {vdu.println("Syntax error in " + cc.CodeName + ".OnTimer"); throw new Exception(e.getMessage());}
				i++;
			}
			i = 1;
			while (i <= data.omodules.getCount()) {
				cm = (codemodule) data.omodules.get(i);
				try {
					sc.docheck(cm.Code);
				} catch(Exception e) {vdu.println("Syntax error in module " + cm.Name + ".Code"); throw new Exception(e.getMessage());}
				i++;
			}

			// Game code
			try {
				sc.docheck(data.ogame.OnInitialise);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnInitialise"); throw new Exception(e.getMessage());}
						try {
				sc.docheck(data.ogame.OnStart);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnStart"); throw new Exception(e.getMessage());}
						try {
				sc.docheck(data.ogame.OnQuit);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnQuit"); throw new Exception(e.getMessage());}
							try {
				sc.docheck(data.ogame.OnAfterInputImmediate);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnAfterInputImmediate"); throw new Exception(e.getMessage());}
							try {
				sc.docheck(data.ogame.OnScore);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnScore"); throw new Exception(e.getMessage());}
							try {
				sc.docheck(data.ogame.OnDisplayBanner);
				} catch(Exception e) {vdu.println("Syntax error in Game.OnDisplayBanner"); throw new Exception(e.getMessage());}
							try {
				sc.docheck(data.orunafterinput.code);
				} catch(Exception e) {vdu.println("Syntax error in Game.AfterInput"); throw new Exception(e.getMessage());}
							try {
				sc.docheck(data.orunafterinput.code);
				} catch(Exception e) {vdu.println("Syntax error in Game.BeforeInput"); throw new Exception(e.getMessage());}
			
			if (!islibrary) vdu.println("Process completed.");
		
		}
		catch (Exception e) {
			vdu.println(e.getMessage());
			e.printStackTrace();
			throw new Exception("Errors occurred.");
		}
	}
	
	/** Stores item details */
	private void storeitem() throws Exception {
		
		String cl = "";  // Current line
		String cw = "";  // Current word
		
		cl = tf.get(ci);
		
		// Break up the item signature by spaces
		iagecode vw = splitstring(cl, " ");
		
		int wi = 2; 	// Word index
		cw = vw.get(wi);
		
		// Create a new item
		item im = new item();
		
		// Assign it an ID
		im.ID = data.oitems.getCount() + 1;
		
		// Read it's codename
		im.CodeName = cw;
		
		// Set real name
		im.Name = getwithtextproperty(cl);
		
		// Drop to the next line and start looking for WITH
		// or HAS items.
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}") && (ci <= tf.getCount())) {
			
			if (checkstart(cl, "nouns")) {
				// Break those nouns and create noun
				// entries for them:
				createnouns(1000 + im.ID, cl);
				im.NounID = 1000 + im.ID;
			}
			if (checkstart(cl, "description")) {
				im.DefaultExamine = getwithtextproperty(cl);
			}
			if (checkstart(cl, "initial")) {
				im.Description = getwithtextproperty(cl);
			}
			if (checkstart(cl, "startsin")) {
				im.CurrentLocation = getlocationbyname(getwithproperty(cl));
			}
			if (checkstart(cl, "readabletext")) {
				im.ReadableText = getwithtextproperty(cl);
			}
			if (checkstart(cl, "staticmessage")) {
				im.FixedMessage = getwithtextproperty(cl);
			}
			if (checkstart(cl, "subitemof")) {
				im.SubItemOf = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "size")) {
				im.Size = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "weight")) {
				im.Weight = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "HasUDB")) {
				im.UserBooleans = cl;
			}
			if (checkstart(cl, "damageindicator")) {
				im.DamageIndicator = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "has")) {
				
				// Check boolean properties on this line to set
				// flags:
				
				// Add a space to the end - this makes it easy to distinguish
				// between things like light/lightsource open/openable by
				// tacking a space on the end in the quick search. Clever eh?
				
				cl = cl + " ";
				
				if (cl.indexOf("lightsource") != -1) {
					im.IsLightSource = true;
				}
				if (cl.indexOf("light ") != -1) {
					im.IsLit = true;
				}
				if (cl.indexOf("worn") != -1) {
					im.IsWorn = true;
				}
				if (cl.indexOf("wearable") != -1) {
					im.IsWearable = true;
				}
				if (cl.indexOf("weapon") != -1) {
					im.IsWeapon = true;
				}
				if (cl.indexOf("transparent") != -1) {
					im.Transparent = true;
				}
				if (cl.indexOf("supporter") != -1) {
					im.HasSurface = true;
				}
				if (cl.indexOf("lay") != -1) {
					im.CanBeLaidOn = true;
				}
				if (cl.indexOf("sit") != -1) {
					im.CanBeSatOn = true;
				}
				if (cl.indexOf("stand") != -1) {
					im.CanBeStoodOn = true;
				}
				if (cl.indexOf("enterable") != -1) {
					im.CanBeGotIn = true;
				}
				if (cl.indexOf("container") != -1) {
					im.IsContainer = true;
				}
				if (cl.indexOf("edible") != -1) {
					im.IsEdible = true;
				}
				if (cl.indexOf("readable") != -1) {
					im.IsReadable = true;
				}
				if (cl.indexOf("static") != -1) {
					im.IsFixed = true;
				}
				if (cl.indexOf("openable") != -1) {
					im.CanOpenClose = true;
				}
				if (cl.indexOf("open ") != -1) {
					im.OpenCloseState = true;
				}
				if (cl.indexOf("invisible ") != -1) {
					im.Invisible = true;
				}
				if (cl.indexOf("scenery ") != -1) {
					im.Invisible = true;
				}
				if (cl.indexOf("subitem") != -1) {
					im.IsSubItem = true;
				}
				
			}
			if (checkstart(cl, "OnAction:")) {
				im.OnAction = loadcode(im.OnAction);
			}
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}
		
		// If the item has no nouns set, default -1 so
		// it is not referred to with no noun
		if (im.NounID == 0) im.NounID = -1;
		
		// Add the item
		data.oitems.add(im);
		
	}
	
	/** Stores item details */
	private void storenpc() throws Exception {
		
		String cl = "";  // Current line
		String cw = "";  // Current word
		
		cl = tf.get(ci);
		
		// Break up the item signature by spaces
		iagecode vw = splitstring(cl, " ");
		
		int wi = 2; 	// Word index
		cw = vw.get(wi);
		
		// Create a new character
		character cc = new character();
		
		// Assign it an ID
		cc.ID = data.ocharacters.getCount() + 1;
		
		// Read it's codename
		cc.CodeName = cw;
		
		// Set real name
		cc.Name = getwithtextproperty(cl);
		
		// Drop to the next line and start looking for WITH
		// or HAS items.
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}") && (ci <= tf.getCount())) {
			
			if (checkstart(cl, "nouns")) {
				// Break those nouns and create noun
				// entries for them:
				createnouns(100000 + cc.ID, cl);
				cc.NounID = 100000 + cc.ID;
			}
			if (checkstart(cl, "description")) {
				cc.DefaultExamine = getwithtextproperty(cl);
			}
			if (checkstart(cl, "initial")) {
				cc.Description = getwithtextproperty(cl);
			}
			if (checkstart(cl, "startsin")) {
				cc.CurrentLocation = getlocationbyname(getwithproperty(cl));
			}
			if (checkstart(cl, "timerinterval")) {
				cc.TimerInterval = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "hitpoints")) {
				cc.HitPoints = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "damageindicator")) {
				cc.DamageIndicator = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "money")) {
				cc.Money = Long.parseLong(getwithproperty(cl));
			}
			
			if (checkstart(cl, "has")) {
				
				// Check boolean properties on this line to set
				// flags:
				
				// Add a space to the end - this makes it easy to distinguish
				// between things like light/lightsource open/openable by
				// tacking a space on the end in the quick search. Clever eh?
				
				cl = cl + " ";
				
				if (cl.indexOf("autoattack") != -1) {
					cc.AutoAttack = true;
				}
				if (cl.indexOf("attackwhenattacked") != -1) {
					cc.AttackWhenAttacked = true;
				}
			}
			if (checkstart(cl, "OnAction:")) {
				cc.OnAction = loadcode(cc.OnAction);
			}
			if (checkstart(cl, "OnTalk:")) {
				cc.OnTalk = loadcode(cc.OnTalk);
			}
			if (checkstart(cl, "OnTimer:")) {
				cc.OnTimer = loadcode(cc.OnTimer);
			}
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}
		
		// Add the character
		data.ocharacters.add(cc);
		
	}
	
	/** Stores module details */
	private void storemodule() throws Exception {
	
		String cl = "";  // Current line
		String cw = "";  // Current word
		
		cl = tf.get(ci);
		
		// Break up the item signature by spaces
		iagecode vw = splitstring(cl, " ");
		
		int wi = 2; 	// Word index
		cw = vw.get(wi);
		
		// Create a new module
		codemodule mo = new codemodule();
		
		// Assign it an ID
		mo.ID = data.omodules.getCount() + 1;
		
		// Read it's name
		mo.Name = cw;
		
		// Drop to the next line and start reading code
		ci++;
		cl = tf.get(ci);
		
		while (!cl.trim().startsWith("}") && (ci <= tf.getCount())) {
			mo.Code.add(cl);
			ci++;	
			cl = tf.get(ci);
		}
		
		// Add the module
		data.omodules.add(mo);
		
	}
	
	/** Stores location details */
	private void storelocation() throws Exception {
		
		String cl = "";  // Current line
		String cw = "";  // Current word
		item locobj = null;
		
		cl = tf.get(ci);
		
		// Break up the location signature by spaces
		iagecode vw = splitstring(cl, " ");
		
		int wi = 2; 	// Word index
		cw = vw.get(wi);
		
		// Create a new location
		location l = new location();
		
		// Assign it an ID
		l.ID = data.olocations.getCount() + 1;
		
		// Read it's codename
		l.CodeName = cw;
		
		// Set real name
		l.Name = getwithtextproperty(cl);
		
		// Drop to the next line and start looking for WITH
		// or HAS items.
		
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}") && (ci <= tf.getCount())) {

			if (checkstart(cl, "nouns")) {
				
				// Create a dummy object with this location's name
				locobj = new item();
				locobj.ID = data.oitems.getCount() + 1;
				locobj.Name = l.Name;
				locobj.Invisible = true;
				locobj.NounID = 1000 + locobj.ID;
				locobj.CurrentLocation = l.ID;
				
				// Default description should be "That's scenery" message
				locobj.DefaultExamine = "[ That is just scenery and does not need to be referred to during this game. ]";
				
				// Add the item
				data.oitems.add(locobj);
				
				// Break those nouns and create noun
				// entries for them:
				createnouns(1000 + locobj.ID, cl);
				
			}
			
			if (checkstart(cl, "description")) {
				l.Description = getwithtextproperty(cl);
			}
			
			if (checkstart(cl, "imagepath")) {
				l.ImagePath = getwithtextproperty(cl);
			}
			
			if (checkstart(cl, "examine")) {
				
				if (locobj == null) {
					errormsg = "Examine statement found without noun list at line: " + Integer.toString(ci);
					errorflag = true;
					return;
				}
				
				locobj.DefaultExamine = getwithtextproperty(cl);			
			}
			
			if (checkstart(cl, "n_to")) {
				l.N_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "s_to")) {
				l.S_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "e_to")) {
				l.E_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "w_to")) {
				l.W_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "u_to")) {
				l.U_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "d_to")) {
				l.D_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "ne_to")) {
				l.NE_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "nw_to")) {
				l.NW_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "se_to")) {
				l.SE_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "sw_to")) {
				l.SW_to = getwithproperty(cl);
			}
			
			if (checkstart(cl, "has")) {
				
				// Check boolean properties on this line to set
				// flags:
				
				// Add a space to the end - this makes it easy to distinguish
				// between things like light/lightsource open/openable by
				// tacking a space on the end in the quick search. Clever eh?
				
				cl = cl + " ";
				
				if (cl.indexOf("light") != -1) {
					l.IsDark = false;
				}
				if (cl.indexOf("darkness") != -1) {
					l.IsDark = true;
				}
			}
			
			if (checkstart(cl, "OnDisplay:")) {
				l.OnDisplay = loadcode(l.OnDisplay);
			}
			
			if (checkstart(cl, "OnInput:")) {
				l.OnInput = loadcode(l.OnInput);
			}
			
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}
		
		// Add the location
		data.olocations.add(l);
		
	}
	
	/*** Reads the game object in and it's appropriate code */
	private void storegame() throws Exception {
		
		ci++;
		String cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}") && (ci <= tf.getCount())) {

			if (checkstart(cl, "name")) {
				data.ogame.Name = getwithtextproperty(cl);
			}
			if (checkstart(cl, "maxitemscancarry")) {
				data.ogame.MaxItemsCanCarry = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "maxweightcancarry")) {
				data.ogame.MaxWeightCanCarry = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "maxsizecancarry")) {
				data.ogame.MaxSizeCanCarry = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "startinglocation")) {
				data.ogame.StartingLocation = getlocationbyname(getwithproperty(cl));
			}
			if (checkstart(cl, "verbose")) {
				data.ogame.RepeatDescription = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "showavailableexits")) {
				data.ogame.ShowAvailableExits = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "allowpersist")) {
				data.ogame.AllowPersist = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "singleplayergame")) {
				data.ogame.SinglePlayerGame = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "maxusers")) {
				data.ogame.MaxUsers = Integer.parseInt(getwithproperty(cl));
			}
			if (checkstart(cl, "realtimenpcs")) {
				data.ogame.RealTimeNPCs = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "idepassword")) {
				data.ogame.IDEPassword = getwithtextproperty(cl);
			}
			if (checkstart(cl, "usingiagecombat")) {
				data.ogame.UsingIAGECombat = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "usingiagemoney")) {
				data.ogame.UsingIAGEMoney = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "wideinventorydisplay")) {
				data.ogame.WideDisplay = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "defaulthitpoints")) {
				data.ogame.DefaultHitPoints = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "defaultdamage")) {
				data.ogame.DefaultDamage = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "defaultmoney")) {
				data.ogame.DefaultMoney = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "defaultchanceofhitting")) {
				data.ogame.DefaultChanceOfHitting = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "chanceofhittingincrementforkill")) {
				data.ogame.ChanceOfHittingIncrementForKill = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "damageindicatorincrementforkill")) {
				data.ogame.DamageIndicatorIncrementForKill = Long.parseLong(getwithproperty(cl));
			}
			if (checkstart(cl, "mediabase")) {
				data.ogame.MediaBase = getwithtextproperty(cl);
			}
			if (checkstart(cl, "overridesecondarynouns")) {
				data.ogame.OverrideSecondaryNouns = getwithtextproperty(cl);
			}
			if (checkstart(cl, "playersstaydead")) {
				data.ogame.PlayersStayDead = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			if (checkstart(cl, "npcsstaydead")) {
				data.ogame.NPCsStayDead = getwithproperty(cl).equalsIgnoreCase("yes");
			}
			
			// Code modules:
			if (checkstart(cl, "initialise:")) {
				data.ogame.OnInitialise = loadcode(data.ogame.OnInitialise);
			}
			if (checkstart(cl, "afterinputimmediate:")) {
				data.ogame.OnAfterInputImmediate = loadcode(data.ogame.OnAfterInputImmediate);
			}
			if (checkstart(cl, "quit:")) {
				data.ogame.OnQuit = loadcode(data.ogame.OnQuit);
			}
			if (checkstart(cl, "start:")) {
				data.ogame.OnStart = loadcode(data.ogame.OnStart);
			}
			if (checkstart(cl, "displaybanner:")) {
				data.ogame.OnDisplayBanner = loadcode(data.ogame.OnDisplayBanner);
			}
			if (checkstart(cl, "score:")) {
				data.ogame.OnScore = loadcode(data.ogame.OnScore);
			}
			if (checkstart(cl, "afterinput:")) {
				data.orunafterinput.code = loadcode(data.orunafterinput.code);
			}
			if (checkstart(cl, "beforeinput:")) {
				data.orunbeforeinput.code = loadcode(data.orunbeforeinput.code);
			}
		
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}
		
	}
	
	/*** Resolves internal locations and sets map accordingly */
	private void resolvelocation() throws Exception {
		
		int i = 1;
		location l = null;
		
		while (i <= data.olocations.getCount()) {
			l = (location) data.olocations.get(i);
			try {
				if (l.N_to != "") {l.N = getlocationbyname(l.N_to);}
				if (l.S_to != "") {l.S = getlocationbyname(l.S_to);}
				if (l.E_to != "") {l.E = getlocationbyname(l.E_to);}
				if (l.W_to != "") {l.W = getlocationbyname(l.W_to);}
				if (l.U_to != "") {l.U = getlocationbyname(l.U_to);}
				if (l.D_to != "") {l.D = getlocationbyname(l.D_to);}
				if (l.NE_to != "") {l.NE = getlocationbyname(l.NE_to);}
				if (l.NW_to != "") {l.NW = getlocationbyname(l.NW_to);}
				if (l.SE_to != "") {l.SE = getlocationbyname(l.SE_to);}
				if (l.SW_to != "") {l.SW = getlocationbyname(l.SW_to);}
			}
			catch (Exception e) {
				vdu.println("Error occurred resolving locations for map in location '" + l.CodeName + "' (" + e.getMessage() + ")");	
			}
			i++;	
		}	
	}
	
	/** Returns a location's ID from it's name */
	private long getlocationbyname(String locname) throws Exception {
		
		int i = 1;
		location l = null;
		while (i <= data.olocations.getCount()) {
			l = (location) data.olocations.get(i);
			if (l.CodeName.equalsIgnoreCase(locname)) {
				return l.ID;
			}			
			i++;
		}		
		
		// If we came out of here, we don't have a location
		// check for special "limbo" and "random" keywords.
		if (locname.equalsIgnoreCase("limbo")) return 0;
		if (locname.equalsIgnoreCase("random")) return -1;
		
		// OK, check to see now if the name refers to an item instead
		i = 1;
		item im = null;
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.CodeName.equalsIgnoreCase(locname)) {
				// We have it! Check to see what kind of container
				// this item is. If it has a surface, assume it is
				// on that. Otherwise put it inside
				if (im.HasSurface) {
					return im.ID + location.SURFACEBASE;
				}
				else
				{
					return im.ID + location.CONTAINERBASE;
				}
			}
			i++;
		}
		
		// Check if the name refers to an NPC instead.
		i = 1;
		character cc = null;
		while (i <= data.ocharacters.getCount()) {
			cc = (character) data.ocharacters.get(i);
			if (cc.CodeName.equalsIgnoreCase(locname)) {
				return cc.ID + location.NPCBASE;
			}
			i++;
		}
		
		// We are out of options - throw an exception because we
		// cannot resolve.
		throw new Exception("Unable to resolve location named '" + locname + "'");

	}
	
	/*** Splits a string and returns an iagecode collection */
	private iagecode splitstring(String tosplit, String delimiter) {
	
		// Break by spaces and fill vwords
		int i = 0;
		int spos = 0;
		iagecode vwords = new iagecode();
		
		i = tosplit.indexOf(delimiter);
		while (i != -1) {
			
			// Add the word
			vwords.add(tosplit.substring(spos, i));
			spos = i + 1;
			i = tosplit.indexOf(delimiter, spos);
			
		}
		
		// Add the final word
		vwords.add(tosplit.substring(spos, tosplit.length()));
		
		// Return them
		return vwords;
		
	}
	
	/*** Returns true if a string starts with the specified one ignoring case*/
	private boolean checkstart(String findin, String find) {
		return findin.toLowerCase().startsWith(find.toLowerCase());
	}
	
	/*** Returns second argument of a line for numeric with properties */
	private String getwithproperty(String findin) throws Exception {
		
		String s = findin.trim();

		// loop through	the chars of this string, looking for
		// the first space or tab
		int i = 0;
		while (i <= s.length() - 1) {
			if (s.substring(i, i + 1).equals(" ") || s.substring(i, i + 1).equals("\t"))
				break;
			i++;
		}
		
		// We got it - did we run out of string?
		if (i == s.length() -1) {
			throw new Exception("Bad WITH statement at line: " + Integer.toString(ci));
		}
		
		// Strip down to our new position and throw away whitespace
		String trimmed = s.substring(i, s.length());
		trimmed = trimmed.trim();
		
		// Now loop again and find the first space, tab or the end of the string
		i = 0;
		while (i <= trimmed.length() - 1) {
			if (trimmed.substring(i, i + 1).equals(" ") || trimmed.substring(i, i + 1).equals("\t")) {
				break;
			}
			i++;
		}
		// We should now have a valid end marker in I now
		if (i == trimmed.length() - 1) {
			i = trimmed.length();
		}
		return trimmed.substring(0, i);
	}
	
	/*** Returns text with properties in the form Description "desc" */
	private String getwithtextproperty(String findin) throws Exception {
		
		int del1 = findin.indexOf("\"");
		int del2 = findin.indexOf("\"", del1 + 1);
		
		String buff = "";
		
		// if we don't have a second string delimter, then
		// take the string from this line into a buffer
		// and keep on doing it until we have the lot
		
		if (del1 != -1 && del2 == -1) {
			
			buff = findin.substring(del1 + 1, findin.length());
			
			// Throw away space from ends
			buff = buff.trim();
						
			ci++;
			findin = tf.get(ci);
			del1 = findin.indexOf("\"");
			while (del1 == -1) {
			
				// Add to our buffer, adding a space
				// first and removing all whitespace
				buff = buff + " " + findin.trim();
				
				ci++;
				findin = tf.get(ci);
				del1 = findin.indexOf("\"");
				
			}
			
			// Add the end line
			buff = buff + " " + findin.trim();
			
			// Throw away the speech mark from the end
			if (buff.endsWith("\"")) {
				buff = buff.substring(0, buff.length() - 1);
			}
			
			// Replace tildes with speech marks and return
			return vdu.replace(buff, "~", "\"");
		}		
		
		if ((del1 > del2) || del1 == -1 || del2 == -1) {
			throw new Exception("Bad WITH text property at line: " + Integer.toString(ci));
		}
		
		// Build return
		String outputst = findin.substring(del1 + 1, del2);
		
		// Replace tildes with speech marks
		return vdu.replace(outputst, "~", "\"");
	}

	/*** Creates nouns from a list in the form Nouns "noun1" "noun2" */
	private void createnouns(long nounid, String commandtext) throws Exception {
	
		iagecode vw = splitstring(commandtext, " ");
		
		if (vw.getCount() < 2) {
			throw new Exception("Noun list started but no list given at line: " + Integer.toString(ci));
		}
		
		int i = 2;
		while (i <= vw.getCount()) {
			// Generate new nouns
			noun no = new noun();
			no.ID = nounid;
			no.Text = vw.get(i).replace('\"', ' ').trim(); // Stuff on end throws away "
			
			if (no.Text.trim().equals("")) {
				throw new Exception("Too many spaces in noun list - blank nouns not allowed at line: " + Integer.toString(ci));
			}
			
			data.onouns.add(no);
			i++;
		}	
		
	}
	
	/** Used to load and override/extend code
	    in objects. */
	private iagecode loadcode(iagecode codenow) {	
		
		// Determine whether we are overriding code.
		String temptest = tf.get(ci).toLowerCase();
		boolean override = temptest.indexOf("override") > -1;
		
		// If we are overriding code, then start with
		// fresh code object. If we aren't, start from
		// the one we were passed in.
		if (override) {
			codenow = new iagecode();
		}
		
		// Transfer code
		ci++;
		String cl = tf.get(ci);

		while (!cl.trim().equals("]")) {
			
			codenow.add(cl);
				
			ci++;
			cl = tf.get(ci);
		}	
		
		// Return it
		return codenow;
		
	}
	
		/*** Accepts an iagecode block to translate and returns
		   a translated one.
		
		   This routine replaces the this. keyword with
		   the correct object, resolves object names to their
		   correct IAGE names, replaces
		   all spaces between # chars with _ chars, 
		   and finally, replaces all spaces and _ chars between
		   " chars with ^ chars instead to correctly resolve
		   strings and expressions. */
	private void translatecode(iagecode ic, String thisobject, String objectcodename) throws Exception {
		
		iagecode outputcode = new iagecode();
		
		// Start code proper
		int i = 1;
		String cl = "";
		
		try {
			while (i <= ic.getCount()) {
				cl = ic.get(i);
				
				// Resolve this.
				cl = codereplace(cl, "this.", thisobject + ".");
				
				// Resolve named objects
				// ===================================
				// Locations
				location l = null;
				int z = 1;
				while (z <= data.olocations.getCount()) {
					l = (location) data.olocations.get(z);
					if (!l.CodeName.equals(""))
					cl = codereplace(cl, l.CodeName + ".", "location(" + l.ID + ").");
					z++;	
				}
				// Items
				item im = null;
				z = 1;
				while (z <= data.oitems.getCount()) {
					im = (item) data.oitems.get(z);
					if (!im.CodeName.equals(""))
						cl = codereplace(cl, im.CodeName + ".", "item(" + im.ID + ").");
					z++;	
				}
				// Characters
				character cc = null;
				z = 1;
				while (z <= data.ocharacters.getCount()) {
					cc = (character) data.ocharacters.get(z);
					if (!cc.CodeName.equals(""))
						cl = codereplace(cl, cc.CodeName + ".", "character(" + cc.ID + ").");
					z++;	
				}
				
				// Resolve strings surrounded by "
				cl = findandfillspacesbetween(cl, "\"", ' ', '^');
				
				// Replace all tilde characters with speechmarks
				cl = vdu.replace(cl, "~", "\"");
				
				// Resolve expressions surrounded by |
				cl = findandfillspacesbetween(cl, "|", ' ', '_');
				
				// Update the code line in the collection
				ic.set(i, cl);
				
				i++;
			}
		}
		catch(Exception e) {
			vdu.println(e.getMessage());
			vdu.println("Error occurred in " + thisobject + "codename '" + objectcodename + "' at line " + Integer.toString(i));
		}
	}
	
	
	/*** replaces named objects with proper references */
	private String codereplace(String findin, String find, String replace) {
		
		String output = new String(findin);
					
		// Do a quick scan throughout. This one however relies on the
		// target being preceded by a space.
		output = crep(output, " " + find, " " + replace);
		
		// Try another scan, this one relying on the target being
		// preceded by a tab
		output = crep(output, "\t" + find, "\t" + replace);

		// Try another scan, this one relying on the target being
		// preceded by a | (start of an expression)
		output = crep(output, "|" + find, "|" + replace);
		
		// Try another scan, this one relying on the target being
		// preceded by a ( object index.
		output = crep(output, "(" + find, "(" + replace);
		
		return output;
	}
	
	/*** Special code replace routine which ensures object matches are
	     genuine object calls */
	private String crep(String findin, String find, String replacewith) {
		
		int i = 0;

		String sb = new String(findin);
		
		while (i <= sb.length() - find.length()) {
			
			if (sb.substring(i, i + find.length()).equalsIgnoreCase(find)) {
				
				// We have a match - make sure that the character following
				// the match is NOT a " or a space - if it is, we do not
				// have a valid match, and the word has been used in a string.
				if (sb.substring(i + find.length(), i + find.length() + 1).equals("\"") ||
					sb.substring(i + find.length(), i + find.length() + 1).equals(" ")) {}
				else
					sb = vdu.stringbuffreplace(new StringBuffer(sb), i, i + find.length(), replacewith).toString();
			}
			i++;
		}
		return sb.toString();
	}
	
	/*** Finds delimited markers and replaces all occurrences of a char with another */
	private String findandfillspacesbetween(String find, String marker, char findchar, char replacechar) throws Exception {
	
		int ipos = find.indexOf(marker);
		int epos = 0;
		
		while (ipos != -1) {
			
			// Get end marker. If it is last char of string, use 
			// end instead.
			epos = find.indexOf(marker, ipos + 1);
			
			if ( ipos > epos ) {
				throw new Exception("Incorrect number of " + findchar +" arguments.");
			}
			
			String foundrange = find.substring(ipos + 1, epos);
			
			// now do the char swap
			foundrange = foundrange.replace(findchar, replacechar);
			
			// replace this section of our string with the new one
			if (epos == find.length() - 1)
				find = find.substring(0, ipos) + foundrange;
			else
				find = find.substring(0, ipos) + foundrange + find.substring(epos + 1, find.length());
			
			// Attempt to find the next start marker
			ipos = find.indexOf(marker);
			
		}	
		
		return find;
	}
	
	private void resolveextendeditem(String extendline) throws Exception {
	
		String extendeditem = "";
		boolean founditem = false;
	
		iagecode vw = splitstring(extendline, " ");
		
		// Find extends keyword
		int i = 1;
		while (i <= vw.getCount()) {
			if (vw.get(i).equalsIgnoreCase("extends")) {
				// Next word is item to extend
				extendeditem = vw.get(i + 1);
				if (extendeditem.equals("{")) {
					throw new Exception("Extend found but no item named at line: " + Integer.toString(ci));
				}
				founditem = true;
				break;
			}
			i++;
		}
		if (!founditem) return;
		
		// Get the subclass name
		i = 1;
		item subclass = null;
		while (i <= data.oitems.getCount()) {
			subclass = (item) data.oitems.get(i);
			if (subclass.CodeName.equalsIgnoreCase(vw.get(2))) {
				// We have it
				break;
			}
			i++;
		}
				
		// We have our item's code name that we are extending --
		// let's go find it:
		
		i = 1;
		item im = null;
		String buffline = "";
		while (i <= data.oitems.getCount()) {
			im = (item) data.oitems.get(i);
			if (im.CodeName.equalsIgnoreCase(extendeditem)) {
				// We have it - paste our OnAction code
				// to the end of it's existing code. This way
				// the subclass has priority for overriding
				// procs etc.
				int z = 1;
				while (z <= im.OnAction.getCount()) {
					buffline = im.OnAction.get(z);
					// If there were any this references previously
					// in the extended class, they will point to itself
					// we need to update these to point to the subclass
					// instead.
					buffline = vdu.replace(buffline, "item(" + Long.toString(im.ID) + ").", "item(" + Long.toString(subclass.ID) + ").");
					subclass.OnAction.add(buffline);
					z++;
				}	
				break;
			}
			i++;
		}
		
	}
	
	private void importandcompile(String importstring) throws Exception {
		
		// Get the file name
		String filename = getwithtextproperty(importstring);
		
		// Work out from where we are importing
		String realfile = new File(openfilename).getAbsolutePath();
		realfile = realfile.substring(0, realfile.lastIndexOf(File.separator) + 1);
		realfile = realfile + filename;
		
		// Does this file exist?
		File fh = new File(realfile);
		if (!fh.exists()) {
			// It doesn't, so assume we are looking in the compiler
			// directory
			realfile = new File("").getAbsolutePath();
			//realfile = realfile.substring(0, realfile.lastIndexOf(File.separator) + 1);
			realfile = realfile + File.separator + filename;
		}
		
		System.out.println("Including " + realfile + "...");
		
		// Create a new compiler and execute it
		new importiage().importandcompilefromsubclass(realfile);
		
	}
	
}