/*
 * Decompiled with CFR 0.152.
 */
package iageserver;

import iageserver.adverb;
import iageserver.character;
import iageserver.codemodule;
import iageserver.constant;
import iageserver.data;
import iageserver.flag;
import iageserver.game;
import iageserver.iagecode;
import iageserver.iagecollection;
import iageserver.iagecondition;
import iageserver.item;
import iageserver.location;
import iageserver.message;
import iageserver.noun;
import iageserver.parsestring;
import iageserver.player;
import iageserver.vdu;
import iageserver.verb;

public class interpreter {
    public String returnvalue = "";
    public boolean cancelled = false;
    private player thisplayer = null;
    private parsestring thisparser = null;
    private int instruction = 1;
    private int programcounter = 1;
    private String source = "";
    private iagecode thecode = null;
    private iagecollection codeline = null;
    private boolean isget = false;
    private iagecollection localvariables = new iagecollection();
    private iagecollection localvariablevalues = new iagecollection();

    public interpreter(player p, parsestring pa) {
        this.thisplayer = p;
        this.thisparser = pa;
    }

    /*
     * Unable to fully structure code
     */
    public void runcode(iagecode tcode, String codesource) {
        this.source = codesource;
        this.cancelled = false;
        this.programcounter = 1;
        this.thecode = tcode;
        p = null;
        curcodeline = "";
        if (this.thecode.getCount() != 0) ** GOTO lbl26
        return;
lbl-1000:
        // 1 sources

        {
            this.instruction = 1;
            curcodeline = this.thecode.get(this.programcounter);
            curcodeline = data.removeleadingspaces(curcodeline);
            curcodeline = curcodeline.trim();
            p = new parsestring(curcodeline, this.thisplayer, " ");
            this.codeline = p.vwords;
            if (this.codeline.getCount() != 0) {
                while (this.instruction <= this.codeline.getCount()) {
                    try {
                        this.interpret();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        data.oerror.RaiseError(this.source, "Interpreter error - " + e.toString(), this.programcounter, this.instruction);
                        e.printStackTrace(this.thisplayer.socket_outputstream);
                    }
                }
            }
            ++this.programcounter;
lbl26:
            // 2 sources

            ** while (this.programcounter <= this.thecode.getCount())
        }
lbl27:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void runcode(iagecode tcode, String codesource, String procname, String[] args, int noargs, String originalsource, int oldinstruction, int oldprogcount) {
        this.source = codesource;
        this.cancelled = false;
        this.programcounter = 1;
        this.thecode = tcode;
        p = null;
        curcodeline = "";
        firstword = "";
        secondword = "";
        i = 1;
        if (this.thecode.getCount() != 0) ** GOTO lbl29
        return;
lbl-1000:
        // 1 sources

        {
            curcodeline = this.thecode.get(this.programcounter);
            p = new parsestring(curcodeline.trim(), this.thisplayer, " ");
            if (p.vwords.getCount() > 1) {
                firstword = (String)p.vwords.get(1);
                secondword = (String)p.vwords.get(2);
                if (firstword.equalsIgnoreCase("proc") && secondword.equalsIgnoreCase(procname)) {
                    p = new parsestring(curcodeline.trim(), this.thisplayer, " ");
                    i = 3;
                    while (i <= p.vwords.getCount()) {
                        this.localvariables.add((String)p.vwords.get(i));
                        this.localvariablevalues.add(args[i - 2]);
                        ++i;
                    }
                    break;
                }
            }
            ++this.programcounter;
lbl29:
            // 2 sources

            ** while (this.programcounter <= this.thecode.getCount())
        }
lbl30:
        // 2 sources

        if (this.programcounter > this.thecode.getCount()) {
            if (oldprogcount > 0) {
                data.oerror.RaiseError(originalsource, "Procedure " + procname + " does not exist in " + codesource + ".", oldprogcount, oldinstruction);
            }
            return;
        }
        ++this.programcounter;
        while (this.programcounter <= this.thecode.getCount()) {
            this.instruction = 1;
            curcodeline = this.thecode.get(this.programcounter);
            curcodeline = data.removeleadingspaces(curcodeline);
            curcodeline = curcodeline.trim();
            p = new parsestring(curcodeline, this.thisplayer, " ");
            this.codeline = p.vwords;
            if (this.codeline.getCount() != 0) {
                while (this.instruction <= this.codeline.getCount()) {
                    try {
                        this.interpret();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        data.oerror.RaiseError(this.source, "Interpreter error - " + e.toString(), this.programcounter, this.instruction);
                        e.printStackTrace(this.thisplayer.socket_outputstream);
                    }
                }
            }
            ++this.programcounter;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void runcode(iagecode tcode, String codesource, int progcountstartat) {
        this.source = codesource;
        this.cancelled = false;
        this.programcounter = progcountstartat;
        this.thecode = tcode;
        p = null;
        curcodeline = "";
        if (this.thecode.getCount() != 0) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            this.instruction = 1;
            curcodeline = this.thecode.get(this.programcounter);
            curcodeline = data.removeleadingspaces(curcodeline);
            p = new parsestring(curcodeline, this.thisplayer, " ");
            this.codeline = p.vwords;
            if (this.codeline.getCount() != 0) {
                while (this.instruction <= this.codeline.getCount()) {
                    try {
                        this.interpret();
                    }
                    catch (Exception e) {
                        data.oerror.RaiseError(this.source, "Interpreter error - " + e.toString(), this.programcounter, this.instruction);
                        e.printStackTrace(this.thisplayer.socket_outputstream);
                    }
                }
            }
            ++this.programcounter;
lbl24:
            // 2 sources

            ** while (this.programcounter <= this.thecode.getCount())
        }
lbl25:
        // 1 sources

    }

    private void interpret() {
        Object im;
        String tid;
        String loc;
        int i;
        if (this.checkcommand(":")) {
            ++this.instruction;
            return;
        }
        if (this.checkcommand("'")) {
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        if (this.checkcommand("proc ")) {
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        this.isget = false;
        if (this.checkcommand(";")) {
            this.Cmd_IfVerb();
            return;
        }
        if (this.checkcommand("#")) {
            this.Cmd_IfAdverb();
            return;
        }
        if (this.checkcommand("message(")) {
            this.Obj_Message((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("flag(")) {
            this.Obj_Flag((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("game.")) {
            this.Obj_Game((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("currentplayer.")) {
            this.Obj_CurrentPlayer((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("playerarray(")) {
            this.Obj_PlayerArray((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("player(")) {
            this.Obj_Player((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("location(")) {
            this.Obj_Location((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("item(")) {
            this.Obj_Item((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("internal.")) {
            this.Obj_Internal((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("character(")) {
            this.Obj_Character((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("input.")) {
            this.Obj_Input((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("returnvalue")) {
            this.Prop_ReturnValue();
            return;
        }
        if (this.checkcommand("array")) {
            this.Obj_Array((String)this.codeline.get(this.instruction));
            return;
        }
        if (this.checkcommand("if")) {
            this.Cmd_If();
            return;
        }
        if (this.checkcommand("goto")) {
            this.Cmd_Goto();
            return;
        }
        if (this.checkcommand("call")) {
            this.Cmd_Call();
            return;
        }
        if (this.checkcommand("while")) {
            this.Cmd_While();
            return;
        }
        if (this.checkcommand("for")) {
            this.Cmd_For();
            return;
        }
        if (this.checkcommand("var")) {
            this.Cmd_Var();
            return;
        }
        if (this.checkcommand("ask")) {
            this.Cmd_Ask();
            return;
        }
        if (this.checkcommand("getitemfromnoun")) {
            this.Cmd_GetItemFromNoun();
            return;
        }
        if (this.checkcommand("outputcontentsof")) {
            this.Cmd_OutputContentsOf();
            return;
        }
        if (this.checkcommand("printallexcept")) {
            ++this.instruction;
            String pindex = this.performevaluate((String)this.codeline.get(this.instruction));
            int pind = Integer.parseInt(pindex);
            ++this.instruction;
            String expr = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            i = 1;
            player theplayer = null;
            while (i <= data.oplayers.getCount()) {
                theplayer = (player)data.oplayers.get(i);
                if (theplayer.Index == pind) {
                    vdu.TransmitAllEx(this.performevaluate(expr), theplayer);
                    return;
                }
                ++i;
            }
        }
        if (this.checkcommand("printallinexcept")) {
            ++this.instruction;
            loc = this.performevaluate((String)this.codeline.get(this.instruction));
            long locid = Long.parseLong(loc);
            ++this.instruction;
            String pindex = this.performevaluate((String)this.codeline.get(this.instruction));
            int pind = Integer.parseInt(pindex);
            ++this.instruction;
            String expr = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            int i2 = 1;
            player theplayer = null;
            while (i2 <= data.oplayers.getCount()) {
                theplayer = (player)data.oplayers.get(i2);
                if (theplayer.Index == pind) break;
                ++i2;
            }
            if (theplayer != null) {
                vdu.TransmitAllInLocation(this.performevaluate(expr), theplayer, locid);
            }
            return;
        }
        if (this.checkcommand("printallin")) {
            ++this.instruction;
            loc = this.performevaluate((String)this.codeline.get(this.instruction));
            long locid = Long.parseLong(loc);
            ++this.instruction;
            String expr = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            vdu.TransmitAllInLocation(this.performevaluate(expr), this.thisplayer, locid);
            if (this.thisplayer != null && this.thisplayer.CurrentLocation == locid) {
                vdu.Transmit(this.performevaluate(expr), this.thisplayer);
            }
            return;
        }
        if (this.checkcommand("addverb")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            String ttext = (String)this.codeline.get(this.instruction);
            verb ve = new verb();
            ve.ID = Long.parseLong(tid);
            ve.Text = ttext;
            data.overbs.add(ve);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("addadverb")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            String ttext = (String)this.codeline.get(this.instruction);
            adverb adve = new adverb();
            adve.ID = Long.parseLong(tid);
            adve.Text = ttext;
            data.oadverbs.add(adve);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("addnoun")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            String ttext = (String)this.codeline.get(this.instruction);
            noun no = new noun();
            no.ID = Long.parseLong(tid);
            no.Text = ttext;
            data.onouns.add(no);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("additem")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            item im2 = new item();
            im2.ID = Long.parseLong(tid);
            data.oitems.add(im2);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("addlocation")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            location lo = new location();
            lo.ID = Long.parseLong(tid);
            data.olocations.add(lo);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("addnpc")) {
            ++this.instruction;
            tid = (String)this.codeline.get(this.instruction);
            character cc = new character();
            cc.ID = Long.parseLong(tid);
            data.ocharacters.add(cc);
            ++this.instruction;
            return;
        }
        if (this.checkcommand("removeitem")) {
            ++this.instruction;
            tid = this.performevaluate((String)this.codeline.get(this.instruction));
            long lid = Long.parseLong(tid);
            i = 1;
            im = null;
            while (i <= data.oitems.getCount()) {
                im = (item)data.oitems.get(i);
                if (((item)im).ID == lid) {
                    data.oitems.remove(i);
                    break;
                }
                ++i;
            }
            ++this.instruction;
        }
        if (this.checkcommand("removelocation")) {
            ++this.instruction;
            tid = this.performevaluate((String)this.codeline.get(this.instruction));
            long lid = Long.parseLong(tid);
            i = 1;
            im = null;
            while (i <= data.olocations.getCount()) {
                im = (location)data.olocations.get(i);
                if (((location)im).ID == lid) {
                    data.olocations.remove(i);
                    break;
                }
                ++i;
            }
            ++this.instruction;
        }
        if (this.checkcommand("removenpc")) {
            ++this.instruction;
            tid = this.performevaluate((String)this.codeline.get(this.instruction));
            long lid = Long.parseLong(tid);
            i = 1;
            im = null;
            while (i <= data.ocharacters.getCount()) {
                im = (character)data.ocharacters.get(i);
                if (((character)im).ID == lid) {
                    data.ocharacters.remove(i);
                    break;
                }
                ++i;
            }
            ++this.instruction;
        }
        if (this.checkcommand("playsound")) {
            this.Cmd_PlaySound();
            return;
        }
        if (this.checkcommand("playmovie")) {
            this.Cmd_PlayMovie();
            return;
        }
        if (this.checkcommand("playmidi")) {
            this.Cmd_PlayMIDI();
            return;
        }
        if (this.checkcommand("stopmidi")) {
            this.Cmd_StopMIDI();
            return;
        }
        if (this.checkcommand("stopmovie")) {
            this.Cmd_StopMovie();
            return;
        }
        if (this.checkcommand("openurl")) {
            this.Cmd_OpenURL();
            return;
        }
        if (this.checkcommand("showpicture")) {
            this.Cmd_ShowPicture();
            return;
        }
        int i3 = 1;
        String varname = "";
        while (i3 <= this.localvariables.getCount()) {
            varname = (String)this.localvariables.get(i3);
            if (this.checkcommand(varname)) {
                ++this.instruction;
                ++this.instruction;
                this.localvariablevalues.set(i3, this.performevaluate((String)this.codeline.get(this.instruction)));
                break;
            }
            ++i3;
        }
        if (this.checkcommand("else")) {
            this.findendif();
            return;
        }
        if (this.checkcommand("endif")) {
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        if (this.checkcommand("endwhile")) {
            this.findwhile();
            return;
        }
        if (this.checkcommand("end")) {
            this.Cmd_End();
            return;
        }
        if (this.checkcommand("cancelevent")) {
            this.Cmd_CancelEvent();
            return;
        }
        ++this.instruction;
    }

    public long getobjectitem(String s) {
        int spos = 0;
        int epos = 0;
        long retvalue = 0L;
        boolean letget = this.isget;
        spos = s.indexOf("(");
        epos = s.indexOf(")");
        String retstr = this.performevaluate(s.substring(spos + 1, epos));
        retvalue = Long.parseLong(retstr);
        this.isget = letget;
        return retvalue;
    }

    public String getobjectcall(String s) {
        return s.substring(s.indexOf(".") + 1, s.length());
    }

    private boolean checkcommand(String ccheck) {
        String ts = (String)this.codeline.get(this.instruction);
        return (ts = data.trimstring(ts)).startsWith(ccheck);
    }

    private boolean checkwhole(String ccheck) {
        String ts = (String)this.codeline.get(this.instruction);
        ts = ts.trim();
        return ts.equalsIgnoreCase(ccheck.toLowerCase());
    }

    private boolean checkstart(String checkstr, String checkagainst) {
        checkstr = checkstr.toLowerCase();
        checkagainst = checkagainst.toLowerCase();
        return (checkagainst = data.trimstring(checkagainst)).startsWith(checkstr);
    }

    public boolean checkexistence(String ccheck, String tofind) {
        ccheck = ccheck.toLowerCase();
        return (tofind = tofind.toLowerCase()).indexOf(ccheck) != -1;
    }

    private String propertyAssign() {
        ++this.instruction;
        String ts = (String)this.codeline.get(this.instruction);
        if (ts.equals("=")) {
            ++this.instruction;
            return this.performevaluate((String)this.codeline.get(this.instruction));
        }
        data.oerror.RaiseError(this.source, "Invalid property assignment", this.programcounter, this.instruction);
        return "";
    }

    private String Obj_Message(String s) {
        int i = 1;
        message m = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count")) {
            while (i <= data.omessages.getCount()) {
                m = (message)data.omessages.get(i);
                if (m.ID == this.getobjectitem(s)) {
                    foundobj = true;
                    break;
                }
                ++i;
            }
            if (!foundobj) {
                data.oerror.RaiseError(this.source, "Message " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
                ++this.instruction;
                return "";
            }
        }
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).equals("show")) {
            vdu.Transmit(m.Text, this.thisplayer);
            executed = true;
        }
        if (tcall.equals("showothers")) {
            vdu.TransmitAllInLocation(m.Text, this.thisplayer, this.thisplayer.CurrentLocation);
        }
        if (tcall.equals("showallin")) {
            ++this.instruction;
            if (this.instruction > this.codeline.getCount()) {
                data.oerror.RaiseError(this.source, "No location specified for ShowAllIn command.", this.programcounter, this.instruction);
            } else {
                vdu.TransmitAllInLocation(m.Text, this.thisplayer, Long.parseLong((String)this.codeline.get(this.instruction)));
            }
        }
        if (tcall.equals("id")) {
            if (this.isget) {
                rval = Long.toString(m.ID);
            } else {
                m.ID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("text")) {
            if (this.isget) {
                rval = m.Text;
            } else {
                m.Text = this.propertyAssign();
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.omessages.getCount());
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Character(String s) {
        int endname;
        int startname;
        int i = 1;
        character c = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count")) {
            while (i <= data.ocharacters.getCount()) {
                c = (character)data.ocharacters.get(i);
                if (c.ID == this.getobjectitem(s)) {
                    foundobj = true;
                    break;
                }
                ++i;
            }
            if (!foundobj) {
                data.oerror.RaiseError(this.source, "Character " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
                ++this.instruction;
                return "";
            }
        }
        int x = 0;
        int y = 1;
        String flg = "";
        int flgno = 1;
        if (c != null && (x = c.CustomProperties.indexOf(this.getobjectcall(s).toLowerCase())) != -1 && (x = c.CustomProperties.indexOf(",", x)) != -1) {
            y = c.CustomProperties.indexOf("|", x);
            if (y == -1) {
                y = c.CustomProperties.length();
            }
            flg = c.CustomProperties.substring(x + 1, y);
            flgno = Integer.parseInt(flg);
            if (this.isget) {
                rval = data.oflags[flgno].Value;
            } else {
                data.oflags[flgno].Value = this.propertyAssign();
            }
            ++this.instruction;
            return rval;
        }
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).indexOf("setvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolean foundupdate = false;
            String valname = tcall.substring(startname, endname);
            ++this.instruction;
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            c.setNameValue(valname, newval);
        }
        if (tcall.indexOf("getvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            String valname = tcall.substring(startname, endname);
            rval = c.getNameValue(valname);
        }
        if (tcall.equals("codeclear")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            if ((eventname = this.performevaluate(eventname)).equalsIgnoreCase("onaction")) {
                c.OnAction = new iagecode();
            }
            if (eventname.equalsIgnoreCase("ontalk")) {
                c.OnTalk = new iagecode();
            }
            if (eventname.equalsIgnoreCase("ontimer")) {
                c.OnTimer = new iagecode();
            }
        }
        if (tcall.equals("codeaddline")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String newcode = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("onaction")) {
                c.OnAction.add(newcode);
            }
            if (eventname.equalsIgnoreCase("ontalk")) {
                c.OnTalk.add(newcode);
            }
            if (eventname.equalsIgnoreCase("ontalk")) {
                c.OnTimer.add(newcode);
            }
        }
        if (tcall.equals("fireinlineevent")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String inevent = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("OnAction")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(c.OnAction, "Character(" + c.Name + ").OnAction", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
            if (eventname.equalsIgnoreCase("OnTalk")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(c.OnTalk, "Character(" + c.Name + ").OnTalk", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
            if (eventname.equalsIgnoreCase("OnTimer")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(c.OnTimer, "Character(" + c.Name + ").OnTimer", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
        }
        if (tcall.equals("id")) {
            if (this.isget) {
                rval = Long.toString(c.ID);
            } else {
                c.ID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("name")) {
            if (this.isget) {
                rval = c.Name;
            } else {
                c.Name = this.propertyAssign();
            }
        }
        if (tcall.equals("currentlocation")) {
            if (this.isget) {
                rval = Long.toString(c.CurrentLocation);
            } else {
                c.CurrentLocation = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containerlocation") && this.isget) {
            rval = Long.toString(location.NPCBASE + c.ID);
        }
        if (tcall.equals("hitpoints")) {
            if (this.isget) {
                rval = Long.toString(c.HitPoints);
            } else {
                c.CurrentLocation = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("damageindicator")) {
            if (this.isget) {
                rval = Long.toString(c.DamageIndicator);
            } else {
                c.CurrentLocation = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("money")) {
            if (this.isget) {
                rval = Long.toString(c.Money);
            } else {
                c.Money = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("autoattack")) {
            if (this.isget) {
                rval = data.booleanToString(c.AutoAttack);
            } else {
                c.AutoAttack = Boolean.getBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("attackwhenattacked")) {
            if (this.isget) {
                rval = data.booleanToString(c.AttackWhenAttacked);
            } else {
                c.AttackWhenAttacked = Boolean.getBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("attackingwho")) {
            if (this.isget) {
                rval = Integer.toString(c.AttackingWho);
            } else {
                c.AttackingWho = Integer.parseInt(this.propertyAssign());
            }
        }
        if (tcall.equals("description")) {
            if (this.isget) {
                rval = c.Description;
            } else {
                c.Description = this.propertyAssign();
            }
        }
        if (tcall.equals("defaultexamine")) {
            if (this.isget) {
                rval = c.DefaultExamine;
            } else {
                c.DefaultExamine = this.propertyAssign();
            }
        }
        if (tcall.equals("nounid")) {
            if (this.isget) {
                rval = Long.toString(c.NounID);
            } else {
                c.NounID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("timerinterval")) {
            if (this.isget) {
                rval = Long.toString(c.TimerInterval);
            } else {
                c.TimerInterval = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("timerindex")) {
            if (this.isget) {
                rval = Long.toString(c.TimerIndex);
            } else {
                c.TimerIndex = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("timetonextrun")) {
            if (this.isget) {
                rval = Long.toString(c.TimeToNextRun);
            } else {
                c.TimeToNextRun = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("movedfromoriginallocation")) {
            if (this.isget) {
                rval = data.booleanToString(c.MovedFromOriginalLocation);
            } else {
                c.MovedFromOriginalLocation = Boolean.getBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("aimode")) {
            if (this.isget) {
                rval = Byte.toString(c.AIMode);
            } else {
                c.AIMode = Byte.parseByte(this.propertyAssign());
            }
        }
        if (tcall.equals("followplayerindex")) {
            if (this.isget) {
                rval = Long.toString(c.FollowPlayerIndex);
            } else {
                c.FollowPlayerIndex = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.ocharacters.getCount());
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Array(String s) {
        parsestring pa;
        String arrayval;
        parsestring pa2;
        String nametest;
        int i;
        String arrname;
        String rval = "";
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).equals("new")) {
            ++this.instruction;
            arrname = (String)this.codeline.get(this.instruction);
            String[] args = new String[this.codeline.getCount()];
            i = 1;
            ++this.instruction;
            while (this.instruction <= this.codeline.getCount()) {
                args[i] = this.performevaluate((String)this.codeline.get(this.instruction));
                ++this.instruction;
                ++i;
            }
            String arrvalue = "";
            if (i > 1) {
                int j = 1;
                while (j <= i) {
                    arrvalue = arrvalue + args[j];
                    if (j < i) {
                        arrvalue = arrvalue + "|";
                    }
                    ++j;
                }
            }
            this.localvariables.add(arrname);
            this.localvariablevalues.add(arrvalue);
        }
        if (tcall.equals("add")) {
            ++this.instruction;
            arrname = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            String arrvalue = this.performevaluate((String)this.codeline.get(this.instruction));
            i = 1;
            nametest = "";
            while (i <= this.localvariables.getCount()) {
                nametest = (String)this.localvariables.get(i);
                if (nametest.equalsIgnoreCase(arrname)) {
                    String arrayval2 = (String)this.localvariablevalues.get(i);
                    if (arrayval2.length() > 0) {
                        arrayval2 = arrayval2 + "|";
                    }
                    arrayval2 = arrayval2 + arrvalue;
                    this.localvariablevalues.set(i, arrayval2);
                    break;
                }
                ++i;
            }
        }
        if (tcall.equals("get")) {
            ++this.instruction;
            arrname = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            int arrnum = Integer.parseInt(this.performevaluate((String)this.codeline.get(this.instruction)));
            i = 1;
            nametest = "";
            while (i <= this.localvariables.getCount()) {
                nametest = (String)this.localvariables.get(i);
                if (nametest.equalsIgnoreCase(arrname)) {
                    String arrayval3 = (String)this.localvariablevalues.get(i);
                    pa2 = new parsestring(arrayval3, this.thisplayer, "|");
                    rval = (String)pa2.vwords.get(arrnum);
                    break;
                }
                ++i;
            }
        }
        if (tcall.equals("set")) {
            ++this.instruction;
            arrname = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            int arrnum = Integer.parseInt(this.performevaluate((String)this.codeline.get(this.instruction)));
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            int i2 = 1;
            String nametest2 = "";
            while (i2 <= this.localvariables.getCount()) {
                nametest2 = (String)this.localvariables.get(i2);
                if (nametest2.equalsIgnoreCase(arrname)) {
                    arrayval = (String)this.localvariablevalues.get(i2);
                    pa = new parsestring(arrayval, this.thisplayer, "|");
                    pa.vwords.set(arrnum, newval);
                    int j = 1;
                    arrayval = "";
                    while (j <= pa.vwords.getCount()) {
                        arrayval = arrayval + pa.vwords.get(j);
                        if (j < pa.vwords.getCount()) {
                            arrayval = arrayval + "|";
                        }
                        ++j;
                    }
                    break;
                }
                ++i2;
            }
        }
        if (tcall.equals("remove")) {
            ++this.instruction;
            arrname = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            int arrnum = Integer.parseInt(this.performevaluate((String)this.codeline.get(this.instruction)));
            int i3 = 1;
            String nametest3 = "";
            while (i3 <= this.localvariables.getCount()) {
                nametest3 = (String)this.localvariables.get(i3);
                if (nametest3.equalsIgnoreCase(arrname)) {
                    String arrayval4 = (String)this.localvariablevalues.get(i3);
                    pa2 = new parsestring(arrayval4, this.thisplayer, "|");
                    pa2.vwords.remove(arrnum);
                    int j = 1;
                    arrayval4 = "";
                    while (j <= pa2.vwords.getCount()) {
                        arrayval4 = arrayval4 + pa2.vwords.get(j);
                        if (j < pa2.vwords.getCount()) {
                            arrayval4 = arrayval4 + "|";
                        }
                        ++j;
                    }
                    this.localvariablevalues.set(i3, arrayval4);
                    break;
                }
                ++i3;
            }
        }
        if (tcall.indexOf("getcount") != -1) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            String arrname2 = tcall.substring(startname, endname);
            int i4 = 1;
            String nametest4 = "";
            while (i4 <= this.localvariables.getCount()) {
                nametest4 = (String)this.localvariables.get(i4);
                if (nametest4.equalsIgnoreCase(arrname2)) {
                    arrayval = (String)this.localvariablevalues.get(i4);
                    pa = new parsestring(arrayval, this.thisplayer, "|");
                    rval = Integer.toString(pa.vwords.getCount() - 1);
                    break;
                }
                ++i4;
            }
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_CurrentPlayer(String s) {
        player p = this.thisplayer;
        String rval = "";
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        tcall = tcall.toLowerCase();
        rval = this.Obj_PlayerAction(tcall, p);
        ++this.instruction;
        return rval;
    }

    private String Obj_Flag(String s) {
        flag f = null;
        String rval = "";
        long flagno = 0L;
        int flg = 0;
        flagno = this.getobjectitem(s);
        flg = Integer.parseInt(Long.toString(flagno));
        f = data.oflags[flg];
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).equals("value")) {
            if (this.isget) {
                rval = f.Value;
            } else {
                f.Value = this.propertyAssign();
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.oflags.length);
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Input(String s) {
        String wordval;
        int endname;
        int startname;
        String rval = "";
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).equals("verb")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Verb);
            } else {
                this.thisparser.Verb = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("verb2")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Verb2);
            } else {
                this.thisparser.Verb2 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("verb3")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Verb3);
            } else {
                this.thisparser.Verb3 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("noun")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Noun);
            } else {
                this.thisparser.Noun = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("noun2")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Noun2);
            } else {
                this.thisparser.Noun2 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("noun3")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Noun3);
            } else {
                this.thisparser.Noun3 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("adverb")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Adverb);
            } else {
                this.thisparser.Adverb = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("adverb2")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Adverb2);
            } else {
                this.thisparser.Adverb2 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("adverb3")) {
            if (this.isget) {
                rval = Long.toString(this.thisparser.Adverb3);
            } else {
                this.thisparser.Adverb3 = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("sverb")) {
            if (this.isget) {
                rval = this.thisparser.SVerb;
            } else {
                this.thisparser.SVerb = this.propertyAssign();
            }
        }
        if (tcall.equals("sverb2")) {
            if (this.isget) {
                rval = this.thisparser.SVerb2;
            } else {
                this.thisparser.SVerb2 = this.propertyAssign();
            }
        }
        if (tcall.equals("sverb3")) {
            if (this.isget) {
                rval = this.thisparser.SVerb3;
            } else {
                this.thisparser.SVerb3 = this.propertyAssign();
            }
        }
        if (tcall.equals("sadverb")) {
            if (this.isget) {
                rval = this.thisparser.SAdverb;
            } else {
                this.thisparser.SAdverb = this.propertyAssign();
            }
        }
        if (tcall.equals("sadverb2")) {
            if (this.isget) {
                rval = this.thisparser.SAdverb2;
            } else {
                this.thisparser.SAdverb2 = this.propertyAssign();
            }
        }
        if (tcall.equals("sadverb3")) {
            if (this.isget) {
                rval = this.thisparser.SAdverb3;
            } else {
                this.thisparser.SAdverb3 = this.propertyAssign();
            }
        }
        if (tcall.equals("snoun")) {
            if (this.isget) {
                rval = this.thisparser.SNoun;
            } else {
                this.thisparser.SNoun = this.propertyAssign();
            }
        }
        if (tcall.equals("snoun2")) {
            if (this.isget) {
                rval = this.thisparser.SNoun2;
            } else {
                this.thisparser.SNoun2 = this.propertyAssign();
            }
        }
        if (tcall.equals("snoun3")) {
            if (this.isget) {
                rval = this.thisparser.SNoun3;
            } else {
                this.thisparser.SNoun3 = this.propertyAssign();
            }
        }
        if (tcall.equals("isnpcaddress") && this.isget) {
            rval = data.booleanToString(this.thisparser.isnpcaddress);
        }
        if (tcall.indexOf("word") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            wordval = tcall.substring(startname, endname);
            int wordindex = (int)Long.parseLong(this.performevaluate(wordval));
            rval = (String)this.thisparser.vwords.get(wordindex);
        }
        if (tcall.equals("totalwords") && this.isget) {
            rval = Integer.toString(this.thisparser.vwords.getCount());
        }
        if (tcall.indexOf("contains") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            wordval = tcall.substring(startname, endname);
            String wordtofind = this.performevaluate(wordval);
            rval = this.thisparser.originalstring.toLowerCase().indexOf(wordtofind.toLowerCase()) != -1 ? "true" : "false";
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Item(String s) {
        String valname;
        String boolname;
        int endname;
        int startname;
        int i = 1;
        item im = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count")) {
            while (i <= data.oitems.getCount()) {
                im = (item)data.oitems.get(i);
                if (im.ID == this.getobjectitem(s)) {
                    foundobj = true;
                    break;
                }
                ++i;
            }
            if (!foundobj) {
                data.oerror.RaiseError(this.source, "Item " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
                ++this.instruction;
                return "";
            }
        }
        int x = 0;
        int y = 1;
        String flg = "";
        int flgno = 1;
        if (im != null && (x = im.CustomProperties.indexOf(this.getobjectcall(s).toLowerCase())) != -1 && (x = im.CustomProperties.indexOf(",", x)) != -1) {
            y = im.CustomProperties.indexOf("|", x);
            if (y == -1) {
                y = im.CustomProperties.length();
            }
            flg = im.CustomProperties.substring(x + 1, y);
            flgno = Integer.parseInt(flg);
            if (this.isget) {
                rval = data.oflags[flgno].Value;
            } else {
                data.oflags[flgno].Value = this.propertyAssign();
            }
            ++this.instruction;
            return rval;
        }
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).indexOf("getuserboolean") != -1) {
            startname = tcall.indexOf("(") + 1;
            boolname = tcall.substring(startname, endname = tcall.indexOf(")"));
            rval = im.UserBooleans.indexOf(boolname) != -1 ? "true" : "false";
        }
        if (tcall.indexOf("adduserboolean") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolname = tcall.substring(startname, endname);
            im.UserBooleans = im.UserBooleans + " " + boolname;
        }
        if (tcall.indexOf("removeuserboolean") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolname = tcall.substring(startname, endname);
            StringBuffer sb = new StringBuffer(im.UserBooleans);
            int spos = im.UserBooleans.indexOf(boolname);
            if (spos != -1) {
                if (im.UserBooleans.equalsIgnoreCase(boolname)) {
                    im.UserBooleans = "";
                } else {
                    sb = vdu.stringbuffreplace(sb, spos, spos + boolname.length(), "");
                    im.UserBooleans = sb.toString();
                }
            }
        }
        if (tcall.indexOf("getvaluebyexp") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            String valname2 = this.performevaluate(tcall.substring(startname, endname));
            rval = im.getNameValue(valname2);
        }
        if (tcall.indexOf("setvaluebyexp") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolean foundupdate = false;
            valname = this.performevaluate(tcall.substring(startname, endname));
            ++this.instruction;
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            im.setNameValue(valname, newval);
        }
        if (tcall.indexOf("setvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolean foundupdate = false;
            valname = tcall.substring(startname, endname);
            ++this.instruction;
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            im.setNameValue(valname, newval);
        }
        if (tcall.indexOf("getvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            String valname3 = tcall.substring(startname, endname);
            rval = im.getNameValue(valname3);
        }
        if (tcall.equals("codeclear")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            if ((eventname = this.performevaluate(eventname)).equalsIgnoreCase("onaction")) {
                im.OnAction = new iagecode();
            }
        }
        if (tcall.equals("codeaddline")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String newcode = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("onaction")) {
                im.OnAction.add(newcode);
            }
        }
        if (tcall.equals("fireinlineevent")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String inevent = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("OnAction")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
        }
        if (tcall.equals("id")) {
            if (this.isget) {
                rval = Long.toString(im.ID);
            } else {
                im.ID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("name")) {
            if (this.isget) {
                rval = im.Name;
            } else {
                im.Name = this.propertyAssign();
            }
        }
        if (tcall.equals("thename")) {
            if (this.isget) {
                rval = im.Name.substring(im.Name.indexOf(" ") + 1, im.Name.length());
            } else {
                im.Name = this.propertyAssign();
            }
        }
        if (tcall.equals("currentlocation")) {
            if (this.isget) {
                rval = Long.toString(im.CurrentLocation);
            } else {
                im.CurrentLocation = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containerlocation") && this.isget) {
            rval = Long.toString(location.CONTAINERBASE + im.ID);
        }
        if (tcall.equals("surfacelocation") && this.isget) {
            rval = Long.toString(location.SURFACEBASE + im.ID);
        }
        if (tcall.equals("description")) {
            if (this.isget) {
                rval = im.Description;
            } else {
                im.Description = this.propertyAssign();
            }
        }
        if (tcall.equals("defaultexamine")) {
            if (this.isget) {
                rval = im.DefaultExamine;
            } else {
                im.DefaultExamine = this.propertyAssign();
            }
        }
        if (tcall.equals("weight")) {
            if (this.isget) {
                rval = Long.toString(im.Weight);
            } else {
                im.Weight = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containedweight")) {
            if (this.isget) {
                rval = Long.toString(im.ContainedWeight);
            } else {
                im.ContainedWeight = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("size")) {
            if (this.isget) {
                rval = Long.toString(im.Size);
            } else {
                im.Size = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("nounid")) {
            if (this.isget) {
                rval = Long.toString(im.NounID);
            } else {
                im.NounID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containedsize")) {
            if (this.isget) {
                rval = Long.toString(im.ContainedSize);
            } else {
                im.ContainedSize = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containedweight")) {
            if (this.isget) {
                rval = Long.toString(im.ContainedWeight);
            } else {
                im.ContainedWeight = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containedsize")) {
            if (this.isget) {
                rval = Long.toString(im.ContainedSize);
            } else {
                im.ContainedSize = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("islightsource")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsLightSource);
            } else {
                im.IsLightSource = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("islit")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsLit);
            } else {
                im.IsLit = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("istransparent")) {
            if (this.isget) {
                rval = data.booleanToString(im.Transparent);
            } else {
                im.Transparent = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("iswearable")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsWearable);
            } else {
                im.IsWearable = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("isworn")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsWorn);
            } else {
                im.IsWorn = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("invisible")) {
            if (this.isget) {
                rval = data.booleanToString(im.Invisible);
            } else {
                im.Invisible = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("iscontainer")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsContainer);
            } else {
                im.IsContainer = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("isweapon")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsWeapon);
            } else {
                im.IsWeapon = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("isfixed")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsFixed);
            } else {
                im.IsWeapon = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("fixedmessage")) {
            if (this.isget) {
                rval = im.FixedMessage;
            } else {
                im.FixedMessage = this.propertyAssign();
            }
        }
        if (tcall.equals("userbooleans")) {
            if (this.isget) {
                rval = im.UserBooleans;
            } else {
                im.UserBooleans = this.propertyAssign();
            }
        }
        if (tcall.equals("hassurface")) {
            if (this.isget) {
                rval = data.booleanToString(im.HasSurface);
            } else {
                im.HasSurface = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("canbestoodon")) {
            if (this.isget) {
                rval = data.booleanToString(im.CanBeStoodOn);
            } else {
                im.CanBeStoodOn = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("canbesaton")) {
            if (this.isget) {
                rval = data.booleanToString(im.CanBeSatOn);
            } else {
                im.CanBeSatOn = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("canbelaidon")) {
            if (this.isget) {
                rval = data.booleanToString(im.CanBeLaidOn);
            } else {
                im.CanBeLaidOn = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("canbegotin")) {
            if (this.isget) {
                rval = data.booleanToString(im.CanBeGotIn);
            } else {
                im.CanBeGotIn = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("canopenclose")) {
            if (this.isget) {
                rval = data.booleanToString(im.CanOpenClose);
            } else {
                im.CanOpenClose = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("openclosestate")) {
            if (this.isget) {
                rval = data.booleanToString(im.OpenCloseState);
            } else {
                im.OpenCloseState = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("isedible")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsEdible);
            } else {
                im.IsEdible = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("ediblehitpoints")) {
            if (this.isget) {
                rval = Long.toString(im.EdibleHitPoints);
            } else {
                im.EdibleHitPoints = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("isreadable")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsReadable);
            } else {
                im.IsReadable = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("readabletext")) {
            if (this.isget) {
                rval = im.ReadableText;
            } else {
                im.ReadableText = this.propertyAssign();
            }
        }
        if (tcall.equals("issubitem")) {
            if (this.isget) {
                rval = data.booleanToString(im.IsSubItem);
            } else {
                im.IsEdible = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("subitemof")) {
            if (this.isget) {
                rval = Long.toString(im.SubItemOf);
            } else {
                im.SubItemOf = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("damageindicator")) {
            if (this.isget) {
                rval = Long.toString(im.DamageIndicator);
            } else {
                im.DamageIndicator = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("movedfromoriginallocation")) {
            if (this.isget) {
                rval = data.booleanToString(im.MovedFromOriginalLocation);
            } else {
                im.MovedFromOriginalLocation = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.oitems.getCount());
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Location(String s) {
        int endname;
        int startname;
        int i = 1;
        location l = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count")) {
            while (i <= data.olocations.getCount()) {
                l = (location)data.olocations.get(i);
                if (l.ID == this.getobjectitem(s)) {
                    foundobj = true;
                    break;
                }
                ++i;
            }
            if (!foundobj) {
                data.oerror.RaiseError(this.source, "Location " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
                ++this.instruction;
                return "";
            }
        }
        int x = 0;
        int y = 1;
        String flg = "";
        int flgno = 1;
        if (l != null && (x = l.CustomProperties.indexOf(this.getobjectcall(s).toLowerCase())) != -1 && (x = l.CustomProperties.indexOf(",", x)) != -1) {
            y = l.CustomProperties.indexOf("|", x);
            if (y == -1) {
                y = l.CustomProperties.length();
            }
            flg = l.CustomProperties.substring(x + 1, y);
            flgno = Integer.parseInt(flg);
            if (this.isget) {
                rval = data.oflags[flgno].Value;
            } else {
                data.oflags[flgno].Value = this.propertyAssign();
            }
            ++this.instruction;
            return rval;
        }
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).indexOf("setvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            boolean foundupdate = false;
            String valname = tcall.substring(startname, endname);
            ++this.instruction;
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            l.setNameValue(valname, newval);
        }
        if (tcall.indexOf("getvalue") != -1) {
            startname = tcall.indexOf("(") + 1;
            endname = tcall.indexOf(")");
            String valname = tcall.substring(startname, endname);
            rval = l.getNameValue(valname);
        }
        if (tcall.equals("codeclear")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            if ((eventname = this.performevaluate(eventname)).equalsIgnoreCase("oninput")) {
                l.OnInput = new iagecode();
            }
            if (eventname.equalsIgnoreCase("ondisplay")) {
                l.OnDisplay = new iagecode();
            }
        }
        if (tcall.equals("codeaddline")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String newcode = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("oninput")) {
                l.OnInput.add(newcode);
            }
            if (eventname.equalsIgnoreCase("ondisplay")) {
                l.OnDisplay.add(newcode);
            }
        }
        if (tcall.equals("fireinlineevent")) {
            ++this.instruction;
            String eventname = (String)this.codeline.get(this.instruction);
            eventname = this.performevaluate(eventname);
            ++this.instruction;
            String inevent = (String)this.codeline.get(this.instruction);
            if (eventname.equalsIgnoreCase("oninput")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(l.OnInput, "Location(" + l.Name + ").OnInput", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
            if (eventname.equalsIgnoreCase("ondisplay")) {
                interpreter inlevent = new interpreter(this.thisplayer, this.thisparser);
                inlevent.runcode(l.OnDisplay, "Location(" + l.Name + ").OnDisplay", inevent, new String[4], 0, "InlineEvent." + inevent, 0, 0);
            }
        }
        if (tcall.equals("id")) {
            if (this.isget) {
                rval = Long.toString(l.ID);
            } else {
                l.ID = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("name")) {
            if (this.isget) {
                rval = l.Name;
            } else {
                l.Name = this.propertyAssign();
            }
        }
        if (tcall.equals("imagepath")) {
            if (this.isget) {
                rval = l.ImagePath;
            } else {
                l.ImagePath = this.propertyAssign();
            }
        }
        if (tcall.equals("description")) {
            if (this.isget) {
                rval = l.Description;
            } else {
                l.Description = this.propertyAssign();
            }
        }
        if (tcall.equals("isdark")) {
            if (this.isget) {
                rval = data.booleanToString(l.IsDark);
            } else {
                l.IsDark = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("n")) {
            if (this.isget) {
                rval = Long.toString(l.N);
            } else {
                l.N = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("s")) {
            if (this.isget) {
                rval = Long.toString(l.S);
            } else {
                l.S = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("e")) {
            if (this.isget) {
                rval = Long.toString(l.E);
            } else {
                l.E = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("w")) {
            if (this.isget) {
                rval = Long.toString(l.W);
            } else {
                l.W = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("u")) {
            if (this.isget) {
                rval = Long.toString(l.U);
            } else {
                l.U = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("d")) {
            if (this.isget) {
                rval = Long.toString(l.D);
            } else {
                l.D = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("ne")) {
            if (this.isget) {
                rval = Long.toString(l.NE);
            } else {
                l.NE = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("nw")) {
            if (this.isget) {
                rval = Long.toString(l.NW);
            } else {
                l.NW = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("se")) {
            if (this.isget) {
                rval = Long.toString(l.SE);
            } else {
                l.SE = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("sw")) {
            if (this.isget) {
                rval = Long.toString(l.SW);
            } else {
                l.SW = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.olocations.getCount());
        }
        ++this.instruction;
        return rval;
    }

    private String Obj_Player(String s) {
        int i = 1;
        player p = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count")) {
            while (i <= data.oplayers.getCount()) {
                p = (player)data.oplayers.get(i);
                if ((long)p.Index == this.getobjectitem(s)) {
                    foundobj = true;
                    break;
                }
                ++i;
            }
            if (!foundobj) {
                data.oerror.RaiseError(this.source, "Player " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
                ++this.instruction;
                return "";
            }
        }
        String tcall = this.getobjectcall(s);
        tcall = tcall.toLowerCase();
        rval = this.Obj_PlayerAction(tcall, p);
        ++this.instruction;
        return rval;
    }

    private String Obj_PlayerArray(String s) {
        boolean i = true;
        player p = null;
        boolean foundobj = false;
        boolean executed = false;
        String rval = "";
        if (!this.getobjectcall(s = s.toLowerCase()).equals("count") && (p = (player)data.oplayers.get(Integer.parseInt(Long.toString(this.getobjectitem(s))))) == null) {
            data.oerror.RaiseError(this.source, "Player " + Long.toString(this.getobjectitem(s)) + " does not exist.", this.programcounter, this.instruction);
            ++this.instruction;
            return "";
        }
        String tcall = this.getobjectcall(s);
        tcall = tcall.toLowerCase();
        rval = this.Obj_PlayerAction(tcall, p);
        ++this.instruction;
        return rval;
    }

    private String Obj_PlayerAction(String tcall, player p) {
        item im;
        String valname;
        String password;
        String identifier;
        String rval = "";
        if (tcall.equals("quit")) {
            p.quit(false);
        }
        if (tcall.equals("showscore")) {
            p.showscore();
        }
        if (tcall.equals("showstatus")) {
            p.showstatus();
        }
        if (tcall.equals("print")) {
            vdu.Transmit(this.performevaluate((String)this.codeline.get(this.instruction + 1)), p);
            ++this.instruction;
        }
        if (tcall.equals("dropallitems")) {
            item.MoveAll((long)p.Index + location.PLAYERBASE, p.CurrentLocation);
        }
        if (tcall.equals("displaycurrentlocation")) {
            game.displaylocation(p);
        }
        if (tcall.indexOf("getfirstboolitem") != -1) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            String boolname = tcall.substring(startname, endname);
            item im2 = null;
            int i = 1;
            while (i <= data.oitems.getCount()) {
                im2 = (item)data.oitems.get(i);
                if (im2.CurrentLocation == (long)p.Index + location.PLAYERBASE && im2.UserBooleans.indexOf(boolname) != -1) {
                    return Long.toString(im2.ID);
                }
                ++i;
            }
            return "0";
        }
        if (tcall.indexOf("iscarrying") != -1) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            String itemref = tcall.substring(startname, endname);
            item im3 = null;
            long itemid = Long.parseLong(this.performevaluate(itemref));
            int i = 1;
            while (i <= data.oitems.getCount()) {
                im3 = (item)data.oitems.get(i);
                if (im3.ID == itemid && im3.CurrentLocation == (long)this.thisplayer.Index + location.PLAYERBASE) {
                    return "true";
                }
                ++i;
            }
            return "false";
        }
        if (tcall.indexOf("savestate") != -1) {
            ++this.instruction;
            identifier = this.performevaluate((String)this.codeline.get(this.instruction));
            ++this.instruction;
            password = this.performevaluate((String)this.codeline.get(this.instruction));
            p.SaveState(password, identifier);
        }
        if (tcall.indexOf("restorestate") != -1) {
            ++this.instruction;
            identifier = this.performevaluate((String)this.codeline.get(this.instruction));
            ++this.instruction;
            password = this.performevaluate((String)this.codeline.get(this.instruction));
            this.returnvalue = data.booleanToString(p.RestoreState(password, identifier));
        }
        if (tcall.indexOf("setvalue") != -1) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            valname = tcall.substring(startname, endname);
            ++this.instruction;
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            p.setNameValue(valname, newval);
        }
        if (tcall.indexOf("getvalue") != -1) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            valname = tcall.substring(startname, endname);
            rval = p.getNameValue(valname);
        }
        if (tcall.indexOf("askparserquestion") != -1) {
            ++this.instruction;
            String newval = this.performevaluate((String)this.codeline.get(this.instruction));
            p.askParserQuestion(this.thisparser, Integer.parseInt(newval));
        }
        if (tcall.equals("index")) {
            if (this.isget) {
                rval = Integer.toString(p.Index);
            } else {
                p.Index = Integer.parseInt(this.propertyAssign());
            }
        }
        if (tcall.equals("name")) {
            if (this.isget) {
                rval = p.Name;
            } else {
                p.Name = this.propertyAssign();
            }
        }
        if (tcall.equals("displayname")) {
            if (this.isget) {
                rval = p.DisplayName;
            } else {
                p.DisplayName = this.propertyAssign();
            }
        }
        if (tcall.equals("score")) {
            if (this.isget) {
                rval = Long.toString(p.Score);
            } else {
                p.Score = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("turns")) {
            if (this.isget) {
                rval = Long.toString(p.Turns);
            } else {
                p.Turns = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("currentlocation")) {
            if (this.isget) {
                rval = Long.toString(p.CurrentLocation);
            } else {
                p.CurrentLocation = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("containerlocation") && this.isget) {
            rval = Long.toString(location.PLAYERBASE + (long)p.Index);
        }
        if (tcall.equals("ipaddress")) {
            if (this.isget) {
                rval = p.IPAddress;
            } else {
                p.IPAddress = this.propertyAssign();
            }
        }
        if (tcall.equals("nounid") && this.isget) {
            rval = Long.toString((long)p.Index + noun.PLAYERNOUNBASE);
        }
        if (tcall.equals("cansee")) {
            if (this.isget) {
                rval = data.booleanToString(p.CanSee);
            } else {
                p.CanSee = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("textonly")) {
            if (this.isget) {
                rval = data.booleanToString(p.TextOnly);
            } else {
                p.TextOnly = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("outputtoplayer")) {
            if (this.isget) {
                rval = data.booleanToString(p.OutputToPlayer);
            } else {
                p.OutputToPlayer = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("state")) {
            if (this.isget) {
                rval = Byte.toString(p.State);
            } else {
                p.State = Byte.parseByte(this.propertyAssign());
            }
        }
        if (tcall.equals("stateitem")) {
            if (this.isget) {
                rval = p.StateItem == null ? "0" : Long.toString(p.StateItem.ID);
            } else {
                ++this.instruction;
                ++this.instruction;
                p.StateItem = item.getitemfromid(Long.parseLong(this.performevaluate((String)this.codeline.get(this.instruction))));
            }
        }
        if (tcall.equals("lastnoun")) {
            if (this.isget) {
                rval = Long.toString(p.LastNoun);
            } else {
                p.LastNoun = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("lastcommand")) {
            if (this.isget) {
                rval = p.LastCommand;
            } else {
                p.LastCommand = this.propertyAssign();
            }
        }
        if (tcall.equals("weightcarried") && this.isget) {
            int i = 1;
            long itemweight = 0L;
            im = null;
            while (i <= data.oitems.getCount()) {
                im = (item)data.oitems.get(i);
                if (im.CurrentLocation == (long)p.Index + location.PLAYERBASE) {
                    itemweight += im.Weight;
                }
                ++i;
            }
            rval = Long.toString(itemweight);
        }
        if (tcall.equals("itemscarried") && this.isget) {
            int i = 1;
            int itemcount = 0;
            item im4 = null;
            while (i <= data.oitems.getCount()) {
                im4 = (item)data.oitems.get(i);
                if (im4.CurrentLocation == (long)p.Index + location.PLAYERBASE) {
                    ++itemcount;
                }
                ++i;
            }
            rval = Integer.toString(itemcount);
        }
        if (tcall.equals("sizecarried") && this.isget) {
            int i = 1;
            long itemsize = 0L;
            im = null;
            while (i <= data.oitems.getCount()) {
                im = (item)data.oitems.get(i);
                if (im.CurrentLocation == (long)p.Index + location.PLAYERBASE) {
                    itemsize += im.Size;
                }
                ++i;
            }
            rval = Long.toString(itemsize);
        }
        if (tcall.equals("verbosemode")) {
            if (this.isget) {
                rval = data.booleanToString(p.VerboseMode);
            } else {
                p.VerboseMode = data.stringToBoolean(this.propertyAssign());
            }
        }
        if (tcall.equals("hitpoints")) {
            if (this.isget) {
                rval = Long.toString(p.HitPoints);
            } else {
                p.HitPoints = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("damageindicator")) {
            if (this.isget) {
                rval = Long.toString(p.DamageIndicator);
            } else {
                p.DamageIndicator = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("chanceofhitting")) {
            if (this.isget) {
                rval = Long.toString(p.ChanceOfHitting);
            } else {
                p.ChanceOfHitting = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("money")) {
            if (this.isget) {
                rval = Long.toString(p.Money);
            } else {
                p.Money = Long.parseLong(this.propertyAssign());
            }
        }
        if (tcall.equals("cp1")) {
            if (this.isget) {
                rval = p.CP1;
            } else {
                p.CP1 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp2")) {
            if (this.isget) {
                rval = p.CP2;
            } else {
                p.CP2 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp3")) {
            if (this.isget) {
                rval = p.CP3;
            } else {
                p.CP3 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp4")) {
            if (this.isget) {
                rval = p.CP4;
            } else {
                p.CP4 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp5")) {
            if (this.isget) {
                rval = p.CP5;
            } else {
                p.CP5 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp6")) {
            if (this.isget) {
                rval = p.CP6;
            } else {
                p.CP6 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp7")) {
            if (this.isget) {
                rval = p.CP7;
            } else {
                p.CP7 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp8")) {
            if (this.isget) {
                rval = p.CP8;
            } else {
                p.CP8 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp9")) {
            if (this.isget) {
                rval = p.CP9;
            } else {
                p.CP9 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp10")) {
            if (this.isget) {
                rval = p.CP10;
            } else {
                p.CP10 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp11")) {
            if (this.isget) {
                rval = p.CP11;
            } else {
                p.CP11 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp12")) {
            if (this.isget) {
                rval = p.CP12;
            } else {
                p.CP12 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp13")) {
            if (this.isget) {
                rval = p.CP13;
            } else {
                p.CP13 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp14")) {
            if (this.isget) {
                rval = p.CP14;
            } else {
                p.CP14 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp15")) {
            if (this.isget) {
                rval = p.CP15;
            } else {
                p.CP15 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp16")) {
            if (this.isget) {
                rval = p.CP16;
            } else {
                p.CP16 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp17")) {
            if (this.isget) {
                rval = p.CP17;
            } else {
                p.CP17 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp18")) {
            if (this.isget) {
                rval = p.CP18;
            } else {
                p.CP18 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp19")) {
            if (this.isget) {
                rval = p.CP19;
            } else {
                p.CP19 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp20")) {
            if (this.isget) {
                rval = p.CP20;
            } else {
                p.CP20 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp21")) {
            if (this.isget) {
                rval = p.CP21;
            } else {
                p.CP21 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp22")) {
            if (this.isget) {
                rval = p.CP22;
            } else {
                p.CP22 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp23")) {
            if (this.isget) {
                rval = p.CP23;
            } else {
                p.CP23 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp24")) {
            if (this.isget) {
                rval = p.CP24;
            } else {
                p.CP24 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp25")) {
            if (this.isget) {
                rval = p.CP25;
            } else {
                p.CP25 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp26")) {
            if (this.isget) {
                rval = p.CP26;
            } else {
                p.CP26 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp27")) {
            if (this.isget) {
                rval = p.CP27;
            } else {
                p.CP27 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp28")) {
            if (this.isget) {
                rval = p.CP28;
            } else {
                p.CP28 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp29")) {
            if (this.isget) {
                rval = p.CP29;
            } else {
                p.CP29 = this.propertyAssign();
            }
        }
        if (tcall.equals("cp30")) {
            if (this.isget) {
                rval = p.CP30;
            } else {
                p.CP30 = this.propertyAssign();
            }
        }
        if (tcall.equals("count")) {
            rval = Integer.toString(data.oplayers.getCount());
        }
        return rval;
    }

    private String Obj_Internal(String s) {
        String rval = "";
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        tcall = tcall.toLowerCase();
        int noargs = this.codeline.getCount() - this.instruction;
        String[] args = new String[6];
        int i = 1;
        ++this.instruction;
        while (i <= noargs) {
            args[i] = (String)this.codeline.get(this.instruction);
            ++this.instruction;
            ++i;
        }
        if (args[3] == null) {
            args[3] = "0";
        } else if (args[3].equals("")) {
            args[3] = "0";
        }
        parsestring np = new parsestring("D,D", this.thisplayer, ",");
        if (tcall.equals("attackplayer")) {
            np.Noun = noun.PLAYERNOUNBASE + (long)this.thisplayer.Index;
            np.Noun2 = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[3])));
            np.vAttack();
        }
        if (tcall.equals("attacknpc")) {
            np.Noun = np.getnounfromcharacterid(Long.parseLong(this.performevaluate(args[1])));
        }
        np.Noun2 = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[3])));
        np.vAttack();
        if (tcall.equals("close")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vClose();
        }
        if (tcall.equals("drop")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vDrop();
        }
        if (tcall.equals("eat")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vEat();
        }
        if (tcall.equals("examine")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vExamine();
        }
        if (tcall.equals("extinguish")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vExtinguish();
        }
        if (tcall.equals("get")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vGet(true);
        }
        if (tcall.equals("getin")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vGetInside();
        }
        if (tcall.equals("getoutof")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vGetOut();
        }
        if (tcall.equals("go")) {
            String dr = args[1].trim();
            if (dr.equalsIgnoreCase("n")) {
                np.Adverb = constant.ADVB_NORTH;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("s")) {
                np.Adverb = constant.ADVB_SOUTH;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("e")) {
                np.Adverb = constant.ADVB_EAST;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("w")) {
                np.Adverb = constant.ADVB_WEST;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("u")) {
                np.Adverb = constant.ADVB_UP;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("d")) {
                np.Adverb = constant.ADVB_DOWN;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("ne")) {
                np.Adverb = constant.ADVB_NORTHEAST;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("se")) {
                np.Adverb = constant.ADVB_SOUTHEAST;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("sw")) {
                np.Adverb = constant.ADVB_SOUTHWEST;
                np.vGo(true);
            }
            if (dr.equalsIgnoreCase("nw")) {
                np.Adverb = constant.ADVB_NORTHWEST;
                np.vGo(true);
            }
        }
        if (tcall.equals("inventory")) {
            np.vInventory();
        }
        if (tcall.equals("lieon")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vLie();
        }
        if (tcall.equals("light")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vLight();
        }
        if (tcall.equals("open")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vOpen();
        }
        if (tcall.equals("put")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.Noun2 = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[3])));
            np.Adverb = 13L;
            np.vPut();
        }
        if (tcall.equals("read")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vRead();
        }
        if (tcall.equals("remove")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.Noun2 = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[3])));
            np.vRemove();
        }
        if (tcall.equals("siton")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vSit();
        }
        if (tcall.equals("stand")) {
            np.vStand();
        }
        if (tcall.equals("unwear")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vUnwear();
        }
        if (tcall.equals("wear")) {
            np.Noun = np.getnounfromitemid(Long.parseLong(this.performevaluate(args[1])));
            np.vWear();
        }
        return rval;
    }

    private String Obj_Game(String s) {
        String rval = "";
        s = s.toLowerCase();
        String tcall = this.getobjectcall(s);
        if ((tcall = tcall.toLowerCase()).equals("displaycurrentlocation")) {
            game.displaylocation(this.thisplayer);
        }
        if (tcall.equals("displayversion")) {
            game.displayversion(this.thisplayer);
        }
        if (tcall.equals("getinventory")) {
            int startname = tcall.indexOf("(") + 1;
            int endname = tcall.indexOf(")");
            String locidexpr = tcall.substring(startname, endname);
            ++this.instruction;
            return game.getinventory(Long.parseLong(this.performevaluate(locidexpr)));
        }
        ++this.instruction;
        return rval;
    }

    private void Cmd_CancelEvent() {
        this.cancelled = true;
        this.instruction = this.codeline.getCount() + 1;
    }

    private void Cmd_End() {
        this.instruction = this.codeline.getCount() + 1;
        this.programcounter = this.thecode.getCount() + 1;
    }

    private void Cmd_For() {
    }

    private void Cmd_Goto() {
        int i = 1;
        ++this.instruction;
        String labeltogoto = (String)this.codeline.get(this.instruction);
        while (i <= this.thecode.getCount()) {
            if (this.checkexistence(":" + labeltogoto, this.thecode.get(i))) {
                this.programcounter = i - 1;
                this.instruction = this.codeline.getCount() + 1;
                return;
            }
            ++i;
        }
        data.oerror.RaiseError(this.source, "Line label " + labeltogoto + " does not exist.", this.programcounter, this.instruction);
    }

    private void Cmd_If() {
        iagecollection conditions = new iagecollection();
        String lastoperator = "";
        boolean runningstatus = false;
        boolean currentstatus = false;
        while (!this.checkexistence("then", (String)this.codeline.get(this.instruction))) {
            if (this.checkexistence("(", (String)this.codeline.get(this.instruction))) {
                ++this.instruction;
                iagecondition con = new iagecondition();
                con.Item1Value = this.performevaluate((String)this.codeline.get(this.instruction));
                ++this.instruction;
                con.Operator = (String)this.codeline.get(this.instruction);
                ++this.instruction;
                con.Item2Value = this.performevaluate((String)this.codeline.get(this.instruction));
                ++this.instruction;
                con.LogicalOperatorFromPrevious = lastoperator;
                conditions.add(con);
                if (!this.checkexistence(")", (String)this.codeline.get(this.instruction))) {
                    data.oerror.RaiseError(this.source, "Missing ')' in If.", this.programcounter, this.instruction);
                    return;
                }
                ++this.instruction;
                if (this.checkexistence("then", (String)this.codeline.get(this.instruction))) break;
                lastoperator = (String)this.codeline.get(this.instruction);
            }
            ++this.instruction;
            if (this.instruction > this.codeline.getCount()) break;
        }
        int i = 1;
        while (i <= conditions.getCount()) {
            currentstatus = false;
            iagecondition curcondition = (iagecondition)conditions.get(i);
            if (curcondition.Operator.equals("=")) {
                currentstatus = curcondition.Item1Value.equals(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("<>")) {
                boolean bl = currentstatus = !curcondition.Item1Value.equals(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals(">")) {
                boolean bl = currentstatus = Long.parseLong(curcondition.Item1Value) > Long.parseLong(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("<")) {
                boolean bl = currentstatus = Long.parseLong(curcondition.Item1Value) < Long.parseLong(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("like")) {
                currentstatus = curcondition.Item1Value.equalsIgnoreCase(curcondition.Item2Value);
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("and")) {
                boolean bl = runningstatus = runningstatus && currentstatus;
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("or")) {
                boolean bl = runningstatus = runningstatus || currentstatus;
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("")) {
                runningstatus = currentstatus;
            }
            ++i;
        }
        if (runningstatus) {
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        this.findendif();
    }

    private void Cmd_IfVerb() {
        boolean foundmatch = false;
        String verbtest = (String)this.codeline.get(this.instruction);
        verbtest = verbtest.substring(1, verbtest.length());
        parsestring ps = new parsestring(verbtest, this.thisplayer, ",");
        int z = 1;
        while (z <= ps.vwords.getCount()) {
            verb v = null;
            long verbid = 0L;
            int i = 1;
            while (i <= data.overbs.getCount()) {
                v = (verb)data.overbs.get(i);
                if (v.Text.equalsIgnoreCase((String)ps.vwords.get(z)) && (verbid = v.ID) == this.thisparser.Verb) {
                    foundmatch = true;
                    break;
                }
                ++i;
            }
            if (foundmatch) break;
            ++z;
        }
        this.instruction = this.codeline.getCount() + 1;
        if (foundmatch) {
            return;
        }
        this.findendif();
    }

    private void Cmd_IfAdverb() {
        boolean foundmatch = false;
        String adverbtest = (String)this.codeline.get(this.instruction);
        adverbtest = adverbtest.substring(1, adverbtest.length());
        parsestring ps = new parsestring(adverbtest, this.thisplayer, ",");
        int z = 1;
        while (z <= ps.vwords.getCount()) {
            adverb v = null;
            long adverbid = 0L;
            int i = 1;
            while (i <= data.oadverbs.getCount()) {
                v = (adverb)data.oadverbs.get(i);
                if (v.Text.equalsIgnoreCase((String)ps.vwords.get(z)) && (adverbid = v.ID) == this.thisparser.Adverb) {
                    foundmatch = true;
                    break;
                }
                ++i;
            }
            if (foundmatch) break;
            ++z;
        }
        this.instruction = this.codeline.getCount() + 1;
        if (foundmatch) {
            return;
        }
        this.findendif();
    }

    private String Cmd_Ask() {
        if (this.thisplayer.WaitingForAskResponse) {
            this.thisplayer.WaitingForAskResponse = false;
            this.thisplayer.AskProgramCounter = 1;
            this.thisplayer.AskCode = null;
            this.thisplayer.AskCodeSource = "";
            this.thisplayer.AskInterpreter = null;
            return this.thisplayer.UserResponseToAsk;
        }
        this.thisplayer.AskProgramCounter = this.programcounter;
        this.thisplayer.AskCode = this.thecode;
        this.thisplayer.AskCodeSource = this.source;
        this.thisplayer.AskInterpreter = this;
        this.thisplayer.WaitingForAskResponse = true;
        ++this.instruction;
        vdu.Transmit(this.performevaluate((String)this.codeline.get(this.instruction)), this.thisplayer);
        this.Cmd_End();
        return "*";
    }

    private String Cmd_GetItemFromNoun() {
        ++this.instruction;
        String nid = this.performevaluate((String)this.codeline.get(this.instruction));
        long thenounid = Long.parseLong(nid);
        int i = 1;
        item im = null;
        while (i <= data.oitems.getCount()) {
            im = (item)data.oitems.get(i);
            if (im.NounID == thenounid) {
                return Long.toString(im.ID);
            }
            ++i;
        }
        return "0";
    }

    private void Cmd_OutputContentsOf() {
        ++this.instruction;
        String pdx = this.performevaluate((String)this.codeline.get(this.instruction));
        int playerindex = Integer.parseInt(pdx);
        ++this.instruction;
        String lid = this.performevaluate((String)this.codeline.get(this.instruction));
        long locationid = Long.parseLong(pdx);
        String outstring = game.getinventory(locationid);
        int i = 1;
        player theplayer = null;
        while (i <= data.oplayers.getCount()) {
            theplayer = (player)data.oplayers.get(i);
            if (theplayer.Index == playerindex) {
                vdu.Transmit(outstring, theplayer);
                return;
            }
            ++i;
        }
    }

    private void Cmd_OpenURL() {
    }

    private void Cmd_PlayMIDI() {
    }

    private void Cmd_PlaySound() {
    }

    private void Cmd_PlayMovie() {
    }

    private void Cmd_ShowPicture() {
        ++this.instruction;
        String s = this.performevaluate((String)this.codeline.get(this.instruction));
        vdu.Transmit("<img src=" + data.ogame.MediaBase + s + ">", this.thisplayer);
    }

    private void Cmd_StopMIDI() {
    }

    private void Cmd_StopMovie() {
    }

    private void Cmd_Var() {
        ++this.instruction;
        if (this.instruction > this.codeline.getCount()) {
            data.oerror.RaiseError(this.source, "Var without variable name.", this.programcounter, this.instruction);
            return;
        }
        String varname = (String)this.codeline.get(this.instruction);
        int i = 1;
        String testval = "";
        while (i <= this.localvariables.getCount()) {
            testval = (String)this.localvariables.get(i);
            if (testval.equalsIgnoreCase(varname)) {
                this.localvariables.remove(i);
                this.localvariablevalues.remove(i);
                break;
            }
            ++i;
        }
        this.localvariables.add(varname);
        ++this.instruction;
        if (this.instruction > this.codeline.getCount()) {
            this.localvariablevalues.add(new String(""));
            return;
        }
        ++this.instruction;
        this.localvariablevalues.add(this.performevaluate((String)this.codeline.get(this.instruction)));
        this.instruction = this.codeline.getCount() + 1;
    }

    private void Cmd_While() {
        iagecollection conditions = new iagecollection();
        String lastoperator = "";
        boolean runningstatus = false;
        boolean currentstatus = false;
        while (!this.checkexistence("then", (String)this.codeline.get(this.instruction))) {
            if (this.checkexistence("(", (String)this.codeline.get(this.instruction))) {
                ++this.instruction;
                iagecondition con = new iagecondition();
                con.Item1Value = this.performevaluate((String)this.codeline.get(this.instruction));
                ++this.instruction;
                con.Operator = (String)this.codeline.get(this.instruction);
                ++this.instruction;
                con.Item2Value = this.performevaluate((String)this.codeline.get(this.instruction));
                ++this.instruction;
                con.LogicalOperatorFromPrevious = lastoperator;
                conditions.add(con);
                if (!this.checkexistence(")", (String)this.codeline.get(this.instruction))) {
                    data.oerror.RaiseError(this.source, "Missing ')' in While.", this.programcounter, this.instruction);
                    return;
                }
                ++this.instruction;
                if (this.checkexistence("then", (String)this.codeline.get(this.instruction))) break;
                lastoperator = (String)this.codeline.get(this.instruction);
            }
            ++this.instruction;
            if (this.instruction > this.codeline.getCount()) break;
        }
        int i = 1;
        while (i <= conditions.getCount()) {
            currentstatus = false;
            iagecondition curcondition = (iagecondition)conditions.get(i);
            if (curcondition.Operator.equals("=")) {
                currentstatus = curcondition.Item1Value.equals(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("<>")) {
                boolean bl = currentstatus = !curcondition.Item1Value.equals(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals(">")) {
                boolean bl = currentstatus = Long.parseLong(curcondition.Item1Value) > Long.parseLong(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("<")) {
                boolean bl = currentstatus = Long.parseLong(curcondition.Item1Value) < Long.parseLong(curcondition.Item2Value);
            }
            if (curcondition.Operator.equals("like")) {
                currentstatus = curcondition.Item1Value.equalsIgnoreCase(curcondition.Item2Value);
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("and")) {
                boolean bl = runningstatus = runningstatus && currentstatus;
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("or")) {
                boolean bl = runningstatus = runningstatus || currentstatus;
            }
            if (curcondition.LogicalOperatorFromPrevious.equals("")) {
                runningstatus = currentstatus;
            }
            ++i;
        }
        if (runningstatus) {
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        this.findendwhile();
    }

    private String Prop_ReturnValue() {
        String rval = "";
        if (this.isget) {
            rval = this.returnvalue;
        } else {
            this.returnvalue = this.propertyAssign();
        }
        ++this.instruction;
        return rval;
    }

    private String performevaluate(String s) {
        iagecollection ei = null;
        int i = 1;
        int z = 1;
        String CV = "";
        String LV = "";
        String Op = "";
        this.isget = true;
        ei = new parsestring((String)s, (player)this.thisplayer, (String)"_").vwords;
        while (i <= ei.getCount()) {
            CV = (String)ei.get(i);
            if (this.checkstart("message(", CV)) {
                CV = this.Obj_Message(CV);
                --this.instruction;
            }
            if (this.checkstart("flag(", CV)) {
                CV = this.Obj_Flag(CV);
                --this.instruction;
            }
            if (this.checkstart("game.", CV)) {
                CV = this.Obj_Game(CV);
                --this.instruction;
            }
            if (this.checkstart("currentplayer.", CV)) {
                CV = this.Obj_CurrentPlayer(CV);
                --this.instruction;
            }
            if (this.checkstart("playerarray(", CV)) {
                CV = this.Obj_PlayerArray(CV);
                --this.instruction;
            }
            if (this.checkstart("player(", CV)) {
                CV = this.Obj_Player(CV);
                --this.instruction;
            }
            if (this.checkstart("location(", CV)) {
                CV = this.Obj_Location(CV);
                --this.instruction;
            }
            if (this.checkstart("getitemfromnoun", CV)) {
                CV = this.Cmd_GetItemFromNoun();
            }
            if (this.checkstart("item(", CV)) {
                CV = this.Obj_Item(CV);
                --this.instruction;
            }
            if (this.checkstart("character(", CV)) {
                CV = this.Obj_Character(CV);
                --this.instruction;
            }
            if (this.checkstart("input.", CV)) {
                CV = this.Obj_Input(CV);
                --this.instruction;
            }
            if (this.checkstart("returnvalue", CV)) {
                CV = this.Prop_ReturnValue();
                --this.instruction;
            }
            if (this.checkstart("array.", CV)) {
                CV = this.Obj_Array(CV);
                --this.instruction;
            }
            if (this.checkstart("ask", CV)) {
                CV = this.Cmd_Ask();
                if (CV.equals("*")) {
                    return "";
                }
                --this.instruction;
            }
            if (this.checkstart("random", CV)) {
                CV = Double.toString(Math.random());
            }
            if (this.checkstart("makeinteger", CV)) {
                CV = "0";
                LV = LV.substring(0, LV.indexOf("."));
            }
            if (this.checkstart("space", CV)) {
                CV = " ";
            }
            if (this.checkstart("instr(", CV)) {
                int startname = CV.indexOf("(") + 1;
                int endname = CV.indexOf(")");
                String totalexp = CV.substring(startname, endname);
                int bpoint = totalexp.indexOf(">>");
                String exp1 = totalexp.substring(0, bpoint);
                String exp2 = totalexp.substring(bpoint + 2, totalexp.length());
                CV = (exp1 = this.performevaluate(exp1)).indexOf(exp2 = this.performevaluate(exp2)) != -1 ? "1" : "0";
            }
            z = 1;
            while (z <= this.localvariables.getCount()) {
                if (this.checkstart((String)this.localvariables.get(z), (String)ei.get(i))) {
                    CV = (String)this.localvariablevalues.get(z);
                    break;
                }
                ++z;
            }
            if (!Op.equals("")) {
                if (Op.equals("+") && (LV = Double.toString(Double.valueOf(LV) + Double.valueOf(CV))).endsWith(".0")) {
                    LV = LV.substring(0, LV.length() - 2);
                }
                if (Op.equals("-") && (LV = Double.toString(Double.valueOf(LV) - Double.valueOf(CV))).endsWith(".0")) {
                    LV = LV.substring(0, LV.length() - 2);
                }
                if (Op.equals("*") && (LV = Double.toString(Double.valueOf(LV) * Double.valueOf(CV))).endsWith(".0")) {
                    LV = LV.substring(0, LV.length() - 2);
                }
                if (Op.equals("/") && (LV = Double.toString(Double.valueOf(LV) / Double.valueOf(CV))).endsWith(".0")) {
                    LV = LV.substring(0, LV.length() - 2);
                }
                if (Op.equals("&")) {
                    LV = LV + CV;
                }
            }
            if (i < ei.getCount()) {
                Op = (String)ei.get(++i);
                if (LV.equals("")) {
                    LV = CV;
                }
            }
            ++i;
        }
        if (LV.equals("")) {
            LV = CV;
        }
        LV = LV.replace('^', ' ');
        return LV;
    }

    private void findendif() {
        int tally = 0;
        ++this.programcounter;
        while (this.programcounter <= this.thecode.getCount()) {
            if (this.checkstart("else", this.thecode.get(this.programcounter)) && tally == 0) break;
            if (this.checkstart("endif", this.thecode.get(this.programcounter))) {
                if (tally == 0) break;
                --tally;
            }
            if (this.checkstart("if ", this.thecode.get(this.programcounter))) {
                ++tally;
            }
            if (this.checkstart(";", this.thecode.get(this.programcounter))) {
                ++tally;
            }
            if (this.checkstart("#", this.thecode.get(this.programcounter))) {
                ++tally;
            }
            ++this.programcounter;
        }
        if (this.programcounter > this.thecode.getCount()) {
            data.oerror.RaiseError(this.source, "if without endif", this.programcounter, this.instruction);
            return;
        }
        this.instruction = this.codeline.getCount() + 1;
    }

    private void findendwhile() {
        int tally = 0;
        ++this.programcounter;
        while (this.programcounter <= this.thecode.getCount()) {
            if (this.checkstart("endwhile", this.thecode.get(this.programcounter))) {
                if (tally == 0) break;
                --tally;
            }
            if (this.checkstart("while ", this.thecode.get(this.programcounter))) {
                ++tally;
            }
            ++this.programcounter;
        }
        if (this.programcounter > this.thecode.getCount()) {
            data.oerror.RaiseError(this.source, "while without endwhile", this.programcounter, this.instruction);
            return;
        }
        this.instruction = this.codeline.getCount() + 1;
    }

    private void findwhile() {
        int tally = 0;
        --this.programcounter;
        while (this.programcounter > 0) {
            if (this.checkstart("endwhile", this.thecode.get(this.programcounter))) {
                ++tally;
            }
            if (this.checkstart("while ", this.thecode.get(this.programcounter))) {
                if (tally == 0) break;
                --tally;
            }
            --this.programcounter;
        }
        if (this.programcounter == 0) {
            data.oerror.RaiseError(this.source, "Endwhile without While", this.programcounter, this.instruction);
        }
        this.instruction = 1;
        String curcodeline = this.thecode.get(this.programcounter);
        curcodeline = data.removeleadingspaces(curcodeline);
        parsestring p = new parsestring(curcodeline, this.thisplayer, " ");
        this.codeline = p.vwords;
    }

    private void Cmd_Call() {
        ++this.instruction;
        String procname = (String)this.codeline.get(this.instruction);
        int argno = this.codeline.getCount() - this.instruction;
        String[] args = new String[argno + 1];
        int i = 1;
        ++this.instruction;
        while (this.instruction <= this.codeline.getCount()) {
            args[i] = this.performevaluate((String)this.codeline.get(this.instruction));
            ++i;
            ++this.instruction;
        }
        int sepchar = procname.indexOf(".");
        if (sepchar == -1) {
            data.oerror.RaiseError(this.source, "Invalid procedure call - " + procname, this.programcounter, this.instruction);
            this.instruction = this.codeline.getCount() + 1;
            return;
        }
        String modname = procname.substring(0, sepchar);
        String proc = procname.substring(sepchar + 1, procname.length());
        interpreter runproc = new interpreter(this.thisplayer, this.thisparser);
        i = 1;
        codemodule mod = null;
        while (i <= data.omodules.getCount()) {
            mod = (codemodule)data.omodules.get(i);
            if (mod.Name.trim().equalsIgnoreCase(modname.trim())) {
                runproc.runcode(mod.Code, modname, proc, args, argno, this.source, this.instruction, this.programcounter);
                this.cancelled = runproc.cancelled;
                this.returnvalue = runproc.returnvalue;
                return;
            }
            ++i;
        }
    }
}

