/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

public class WindowStyle {
    private boolean isWrapped;
    private boolean isScrolled;
    private boolean isCopiedToStream2;
    private boolean isBuffered;
    public static final int FLAG_WORD_WRAP = 1;
    public static final int FLAG_SCROLL = 2;
    public static final int FLAG_COPYTO_STREAM2 = 4;
    public static final int FLAG_BUFFEROUTPUT = 8;
    public static final int OP_SET_FLAGS = 0;
    public static final int OP_SET_BITS = 1;
    public static final int OP_CLEAR_BITS = 2;
    public static final int OP_REVERSE_BITS = 3;

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public boolean isScrolled() {
        return this.isScrolled;
    }

    public boolean isCopiedToStream2() {
        return this.isCopiedToStream2;
    }

    public boolean outputIsBuffered() {
        return this.isBuffered;
    }

    public void setIsWrapped(boolean bl) {
        this.isWrapped = bl;
    }

    public void setIsScrolled(boolean bl) {
        this.isScrolled = bl;
    }

    public void setFlags(int n, int n2) {
        switch (n2) {
            case 0: {
                this.setFlags(n);
                break;
            }
            case 1: {
                this.setBits(n);
                break;
            }
            case 2: {
                this.clearBits(n);
                break;
            }
            case 3: {
                this.reverseBits(n);
                break;
            }
        }
    }

    public int getFlags() {
        int n = 0;
        if (this.isWrapped) {
            n |= 1;
        }
        if (this.isScrolled) {
            n |= 2;
        }
        if (this.isCopiedToStream2) {
            n |= 4;
        }
        if (this.isBuffered) {
            n |= 8;
        }
        return n;
    }

    private void setFlags(int n) {
        this.isWrapped = (n & 1) > 0;
        this.isScrolled = (n & 2) > 0;
        this.isCopiedToStream2 = (n & 4) > 0;
        this.isBuffered = (n & 8) > 0;
    }

    private void setBits(int n) {
        if ((n & 1) > 0) {
            this.isWrapped = true;
        }
        if ((n & 2) > 0) {
            this.isScrolled = true;
        }
        if ((n & 4) > 0) {
            this.isCopiedToStream2 = true;
        }
        if ((n & 8) > 0) {
            this.isBuffered = true;
        }
    }

    private void clearBits(int n) {
        if ((n & 1) > 0) {
            this.isWrapped = false;
        }
        if ((n & 2) > 0) {
            this.isScrolled = false;
        }
        if ((n & 4) > 0) {
            this.isCopiedToStream2 = false;
        }
        if ((n & 8) > 0) {
            this.isBuffered = false;
        }
    }

    private void reverseBits(int n) {
        if ((n & 1) > 0) {
            boolean bl = this.isWrapped = !this.isWrapped;
        }
        if ((n & 2) > 0) {
            boolean bl = this.isScrolled = !this.isScrolled;
        }
        if ((n & 4) > 0) {
            boolean bl = this.isCopiedToStream2 = !this.isCopiedToStream2;
        }
        if ((n & 8) > 0) {
            this.isBuffered = !this.isBuffered;
        }
    }
}

