/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.swingui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JViewport;
import org.zmpp.io.OutputStream;
import org.zmpp.swingui.Canvas;
import org.zmpp.swingui.CanvasImpl;
import org.zmpp.swingui.ColorTranslator;
import org.zmpp.swingui.CursorWindow;
import org.zmpp.swingui.FontFactory;
import org.zmpp.swingui.LineEditor;
import org.zmpp.swingui.ScreenOutputStream;
import org.zmpp.swingui.Viewport;
import org.zmpp.swingui.Window6Impl;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ScreenModel6;
import org.zmpp.vm.StoryFileHeader;
import org.zmpp.vm.TextCursor;
import org.zmpp.vm.Window6;

public class Viewport6
extends JViewport
implements ScreenModel6,
Viewport {
    private static final long serialVersionUID = 1L;
    private static final int NUM_V6_WINDOWS = 8;
    private Canvas canvas;
    private BufferedImage imageBuffer;
    private FontFactory fontFactory;
    private Font fixedFont;
    private Font standardFont;
    private boolean initialized;
    private int defaultBackground;
    private int defaultForeground;
    private Window6Impl[] windows;
    private int currentwindow;
    private Machine machine;
    private LineEditor editor;
    private OutputStream outputstream;

    public Viewport6(Machine machine, LineEditor lineEditor) {
        this.machine = machine;
        this.editor = lineEditor;
        this.fontFactory = new FontFactory();
        this.windows = new Window6Impl[8];
        this.outputstream = new ScreenOutputStream(machine, this);
    }

    public CursorWindow getCurrentWindow() {
        return this.windows[this.currentwindow];
    }

    public LineEditor getLineEditor() {
        return this.editor;
    }

    public int getDefaultBackground() {
        return this.defaultBackground;
    }

    public int getDefaultForeground() {
        return this.defaultForeground;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void eraseWindow(int n) {
        if (n == -1 || n == -2) {
            Color color = ColorTranslator.getInstance().translate(this.defaultBackground);
            this.canvas.fillRect(color, 0, 0, this.getWidth(), this.getHeight());
        } else {
            this.windows[n].clear();
        }
    }

    public void eraseLine(int n) {
        this.windows[this.currentwindow].eraseLine(n);
    }

    public TextCursor getTextCursor() {
        return this.windows[this.currentwindow].getCursor();
    }

    public void setTextCursor(int n, int n2, int n3) {
        int n4 = n3 == -3 ? this.currentwindow : n3;
        this.windows[n4].getCursor().setPosition(n, n2);
    }

    public void splitWindow(int n) {
        this.windows[1].resize(n);
        int n2 = this.windows[1].getHeight();
        this.windows[0].setVerticalBounds(n2 + 1, this.getHeight() - n2);
    }

    public void setWindow(int n) {
        this.currentwindow = n;
    }

    public void setTextStyle(int n) {
        this.getOutputStream().flush();
        this.windows[this.currentwindow].setTextStyle(n);
    }

    public void setBufferMode(boolean bl) {
        this.windows[this.currentwindow].setBufferMode(bl);
    }

    public void setPaging(boolean bl) {
    }

    public void resetPagers() {
    }

    public synchronized void waitInitialized() {
        while (!this.isInitialized()) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void setInitialized() {
        this.initialized = true;
        this.notifyAll();
    }

    public OutputStream getOutputStream() {
        return this.outputstream;
    }

    public void setForegroundColor(int n, int n2) {
        if (n > 0) {
            this.getOutputStream().flush();
            int n3 = n2 == -3 ? this.currentwindow : n2;
            this.windows[n3].setForeground(n);
        }
    }

    public void setBackgroundColor(int n, int n2) {
        if (n > 0) {
            this.getOutputStream().flush();
            int n3 = n2 == -3 ? this.currentwindow : n2;
            this.windows[n3].setBackground(n);
        }
    }

    public void redraw() {
        this.repaintInUiThread();
    }

    public int setFont(int n) {
        this.getOutputStream().flush();
        return this.windows[this.currentwindow].setFont(n);
    }

    public synchronized void displayCursor(boolean bl) {
    }

    public void reset() {
        this.setScreenProperties();
    }

    public void setMouseWindow(int n) {
    }

    public Window6 getSelectedWindow() {
        return this.windows[this.currentwindow];
    }

    public Window6 getWindow(int n) {
        return this.windows[n];
    }

    public void paint(Graphics graphics) {
        if (this.imageBuffer == null) {
            this.imageBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.defaultBackground = 9;
            this.defaultForeground = 2;
            this.canvas = new CanvasImpl(this.imageBuffer, this);
            for (int i = 0; i < 8; ++i) {
                this.windows[i] = new Window6Impl(this, this.fontFactory, i);
            }
            this.windows[0].setSize(this.getWidth(), this.getHeight());
            this.windows[1].setSize(this.getWidth(), 0);
            Graphics graphics2 = this.imageBuffer.getGraphics();
            Color color = ColorTranslator.getInstance().translate(this.defaultBackground);
            graphics2.setColor(color);
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.setScreenProperties();
            for (int i = 0; i < 8; ++i) {
                this.windows[i].setFont(1);
                this.windows[i].setBackground(this.defaultBackground);
                this.windows[i].setForeground(this.defaultForeground);
            }
            this.setInitialized();
        }
        graphics.drawImage(this.imageBuffer, 0, 0, this);
    }

    private void setScreenProperties() {
        StoryFileHeader storyFileHeader = this.machine.getGameData().getStoryFileHeader();
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_BOLD, true);
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_FIXED_FONT, true);
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_ITALIC, true);
        storyFileHeader.setEnabled(StoryFileHeader.Attribute.SUPPORTS_COLOURS, true);
        storyFileHeader.setDefaultBackgroundColor(9);
        storyFileHeader.setDefaultForegroundColor(2);
        this.determineStandardFont();
        storyFileHeader.setFontWidth(this.canvas.getCharWidth(this.fixedFont, '0'));
        storyFileHeader.setFontHeight(this.canvas.getFontHeight(this.fixedFont));
        this.updateDimensionsInHeader();
    }

    private void determineStandardFont() {
        this.fixedFont = this.standardFont = new Font("Monospaced", 0, 12);
        this.fontFactory.initialize(this.standardFont, this.fixedFont);
    }

    private void updateDimensionsInHeader() {
        StoryFileHeader storyFileHeader = this.machine.getGameData().getStoryFileHeader();
        int n = this.imageBuffer.getWidth() / this.canvas.getCharWidth(this.fixedFont, '0');
        int n2 = this.imageBuffer.getHeight() / this.canvas.getFontHeight(this.fixedFont);
        storyFileHeader.setScreenWidth(n);
        storyFileHeader.setScreenHeight(n2);
        storyFileHeader.setScreenWidthUnits(this.imageBuffer.getWidth());
        storyFileHeader.setScreenHeightUnits(this.imageBuffer.getHeight());
    }

    private void repaintInUiThread() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    if (Viewport6.this.imageBuffer != null) {
                        Viewport6.this.getGraphics().drawImage(Viewport6.this.imageBuffer, 0, 0, Viewport6.this);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

