!==============================================================================
Constant HINT_NOMORE = "^^No more hints available.^";
!Constant NO_HOWTO_GRAMMAR;
Constant INCLUDE_HINTOPTION 0;
Constant HINT__TX   = "RETURN = read hint";
Constant HINT2__KY = $0D; 
Constant HINT_NOBLANKLINES 0+INCLUDE_HINTOPTION; 

Include "dmenus";
!Include "howtoplay";
#Ifdef INCLUDE_CCPL;
Include "CCPL3";
#Ifnot;
Constant LICENSE
  "This work is licensed under the Creative Commons Attribution-NoDerivs-NonCommercial License. See
  https://creativecommons.org/licenses/by-nc-nd/3.0/ to find out more about the terms of the license.^";
#Endif;

Menu HelpMenu with short_name [; print (string) Story; rtrue; ];

Menu    ->   AboutMenu
    with    short_name [; print "About ", (string) Story; rtrue; ];

Option  -> -> AboutGame "About the game"
    with    description [;
  print "I first started thinking seriously about this game in February of 2004 when I brainstormed some ideas for a sequel to Risorgimento
  Represso. My goals were to give more insight into the world of the game, to reuse some of the same characters, and to reference the events of the
  first game in humourous ways when possible. I also wanted to create a game that was similar in tone: light-hearted plot and old-fashioned puzzles.^
  ^Note that British spellings have been used throughout, given the main character's nationality. Also, in Europe, the ground level of a building is
  often referred to as the ~ground floor~, and climbing the first set of stairs takes you up to the ~first floor.~^
  ^On the main NPC: I just recently read Neil Gaiman's Coraline for the first time, and imagine my dismay at discovering
  that he had miniaturised two characters and placed them in a snow globe two years before I started this game, with its snow globe-bound
  NPC. However, I hope this can be forgiven based on the difference in the interaction, and the strength of the NPC in question.^";
  print "^Reports of bugs, problems and errors can be sent to me on intfiction.org or at my gmail address. A Google should find me. I'd also love to
    hear from you if you simply enjoyed the game, and want to let me know.^";
            ];

#Ifdef INCLUDE_CCPL;
Menu    ->  -> "License Information"
    with    before [; license_menu.select(); return 2; ];
#Endif;

LineGap    -> ->;

Option  -> -> Credits "Credits"
    with    description [;
              print "Many thanks to J. Robinson Wheeler for creating the eye-catching cover art^";
              print "^Thanks to ", (b) "Graham Nelson", " for creating Inform, not to mention the DM4.^
              ^Thanks to ", (b) "Roger Firth", " and ", (b) "Sonja Kesserich", " for creating the IBG, which got me started on this whole thing.^
                ^Many thanks to those whose library extensions I've used, specifically:^",
                (b) "Roger Firth", " (", (i) "CCPL, since updated to CCPL3)^",
                (b) "L. Ross Raszewski", " (", (i) "yesno, easydoor (basis of my own autodoor)", ")^",
                (b) "Miron Schmidt", " (", (i) "calyx_adjectives, tweaked for Glulx)^",
                "^Also, many thanks to my various beta testers:^",
                (b) "Jessica Knoch^
                Ma@{0142}gorzata Reczko^
                ShankSeattle^
                Mike Spivey^
                Marshall Tenner Winter^",
                "^
                This project uses the following sound bites from Freesound.org. Some of these sounds have been remixed with each other or cropped to
                give varying effects. All have been converted to OGG format for space purposes within the game. The given Freesound ID can be used to
                look up the sound on the Freesound website. All listed sounds licensed under https://creativecommons.org/licenses/by/3.0/ unless
                otherwise noted. Sound IDs 212710, 341604 and 388528 were licensed under https://creativecommons.org/licenses/by-nc/3.0/. Sound ID
                26868 is licensed under https://creativecommons.org/licenses/sampling+/1.0/^
                ^Some sounds licensed under https://creativecommons.org/publicdomain/zero/1.0/ were also used but not attributed, as not required.^";
                font off;
                print "Filename                                Freesound ID  Creator^
                       20060422.sewing.machine.wav             18455         dobroide^
                       20060510.hedge.ambiance.binaural.flac   18963         dobroide^
                       20061030.ambiance.pinewood.ms.01.flac   24632         dobroide^
                       20061119.pond.01.flac                   26249         dobroide^
                       t_start1.mp3                            26814         roscoetoon^
                       toy_ratchet_spin.wav                    26868         atomota^
                       door knock 2.wav                        32296         ERH^
                       columbia road flower market.wav         46879         Noise Cuisine^
                       forestsurroundings.wav                  47989         Luftrum^
                       market_2.mp3                            62839         vedas^
                       jf Glass Breaking.wav                   85168         cmusounddesign^
                       impact-metal-movie.wav                  103360        m-o-m^
                       explode.wav                             104447        dkmedic^
                       santa-falling-down-chimney.mp3          212710        Tiger_v15^
                       Ambience_BlackHole_00.wav               270526        LittleRobotSoundFactory^
                       Rumbling Rocky sound.flac               335337        Opsaaaaa^
                       Gate-Heavy-OpenClose-WAV.wav            336888        Omnisis^
                       Rushing stream 2.wav                    341604        mike_stranks^
                       Artillery Explosion (Close) (Mixed).wav 388528        EFlexTheSoundDesigner^";
                font on;
            ];

Option  -> -> RelNotes "Release Notes"
  with  description [;print "Alpha release 0, Serial 171122: initial 2017 release to JRW for art evaluation^";
                      print "Alpha release 1, Serial 171206: second 2017 release
                             ^    - automap support
                             ^    - better and simpler hints from Crystal, take us about halfway through
                             ^    - single fixed sidebar image displayed throughout
                             ^    - added hayfield and tarp
                             ^    - prettied up Town Tattler and Wizarding Weekly formatting
                             ^    - lots of bugfixes such as watching visions in a vision location (OUCH)^";
                      print "Alpha release 2, Serial 171211: third 2017 release
                             ^    - Crystal hints complete
                             ^    - moved a number of scored items around so ~official~ route through game more linear
                             ^    - added observations from Crystal each time you reach a new location
                             ^    - added comment support for transcript recording
                             ^    - first release for beta-testers^";
                      print "Alpha release 3, Serial 171215: fourth 2017 release
                             ^    - figured out how to get menus and status line looking right in Gargoyle and Git without reversing
                             ^    - revamped license, about, credits, etc to menus
                             ^    - make sure comp_mask elements are bracketed properly for TARGET_GLULX
                             ^    - when location is thedark, stop trying to set crystalvision
                             ^    - patched Autodoor so we rfalse if in a vision
                             ^    - implemented bank vault puzzle and hoop and satchel interaction
                             ^    - added beta-testers to credits^";
                      print "Alpha release 4, Serial 171221: final 2017 release
                             ^    - revamped vision stuff to use fake locations instead of real ones. If a player fiddled with the real
                                    location, changes showed up in the vision.
                             ^    - addressed a nasty bug in the library where 'undo' after replay playback causes a crash
                             ^    - lots of miscellaneous bugfixes^";
                      print "Alpha release 5, Serial 171227: post-Christmas release
                             ^    - the ~make me a liar~ final release for 2017
                             ^    - massively revamped Askables class to use consult and topics instead of a home-rolled system. Some fiddling with
                                    scope required as a result.
                             ^    - miscellaneous formatting and other bugs as discovered
                             ^    - modified how stories are added to the Tattler so each story addition creates its own timer. That way if action is
                                    compressed by a player familiar with the story, we don't restart timers and lose stories^";
                      print "Alpha release 6, Serial 180105: New Year's release
                             ^    - lots of polishing with missing synonyms, plurals, etc
                             ^    - destroy map and compass windows when entering menus
                             ^    - include support for ~graphics off~ and ~graphics on~ commands, as well as ~plain~ and ~fancy~ as synonyms.
                             ^    - spare a thought for the Z8 specification, whose bounds we have now overflown
                             ^    - remove old-fashioned key, make sturdy door of brick house just a deadbolt from the inside
                             ^    - fixed an issue with the compass rose in the first floor of the wooden house that prevented it drawing
                             ^    - changed reporting of final story so airship-free flight is only mentioned if player flew out of the tree.^";
                      print "Alpha release 7, Serial 180209: Preliminary artwork release
                             ^    - added preliminary sketch artwork for cover and opening image
                             ^    - removed compass rose (the map renders it redundant)
                             ^    - add display of Tattler stories below map^";
                      print "Release 1, Serial 180228: First release for Spring Thing
                             ^    - fixed printing of direction when looking through doors
                             ^    - fixed hang when exiting tower roof with multiple items in cannon
                             ^    - change red and blue safety deposit boxes to orange and purple respectively to avoid adjective clashes
                             ^    - fix issues with compass_look in OutroomV and RoomV classes
                             ^    - check all compass_look values in every location
                             ^    - modify cheeses so they print their associated vision in the inventory listing
                             ^    - modify cheeses so they print a brief reminder of their associated vision when examined
                             ^    - includes final cover image artwork^";
                      print "Release 2, Serial 181001: Spring Thing bugfix release
                             ^    - fix the sky after turn 900
                             ^    - fix floor in the wooden house
                             ^    - fix a whole bunch of objects that are in visions so they can be examined if they're mentioned
                             ^    - add an 'exits' verb so the player can list the exits in a room
                             ^    - fix Crystal's nomatch so we actually get all the things she's supposed to say when asked questions that don't
                             parse^";
                    ];

Option  -> -> Problems "Problems and bugs"
    with    description [;
              print "Reports of bugs, problems and errors can be sent to me via e-mail. I'm turthalion at a gmail address.^
              ^I'd also love to hear from you if you simply enjoyed the game, and want to let me know.^";
            ];

Option  -> -> Special_Features "Special Features"
    with    description [;
              print "A brief mention of some of the less common functionality this game supports that might be of interest to the player:
                  ^- graphics can be disabled and enabled with ~graphics off~ and ~graphics on~. ~Plain~ and ~fancy~ also work.
                  ^^- graphics can be disabled and enabled with ~graphics off~ and ~graphics on~. ~Plain~ and ~fancy~ also work.
                  ^^- sounds can be disabled and enabled with ~sound off~ and ~sound on~. ~Quiet~ and ~noisy~ also work.
                  ^^- compasslook (i.e. 'look ne') is supported.
                  ^^- all doors open automatically, and also unlock automatically if you're carrying the right key in your hand or the satchel.
                  ^^- when you ~open door~ in an area with more than one door, the game will choose the correct door if only one of them is closed.
                  ^^- likewise for ~close door~, as well as lock and unlock. In all other cases, disambiguation proceeds as normal.
                  ^^- you can ~look through~ most of the doors in the game to see the room beyond... you can't make out much detail, but you get some
                  information about the room you're about to step into.  Naturally, if the door is closed, you don't see much.
                  ^^- typing ~hello~ in a location with an NPC will direct the statement to them, and act as though the player typed ~say hello
                  to <NPC>~.
                  ^^- there are times when you're asked rhetorical questions by the game or an NPC. You can respond to these with a simple
                  'yes' or 'no' at the prompt if you choose.
                  ^^- the regular build of the game supports recording and replay if you wish to use them
                  ^^- comments in transcripts are supported. You may prefix any entered line with '*' to have the parser ignore it.^";
            ];

LineGap    -> ->;

Option -> -> "Go Back" with description [; return 3; ];

LineGap    ->;

Option ->   Points_Scored_in_Main "How the Points are Scored"
    with    description [;
              if (self hasnt general)
                print "[Warning: this section may contain spoilers for the game. If you haven't yet finished the game, you may not want to read these.
                  If you still want to, select this menu item again.]^";
                else {
                  font off; print
                  "ACTION                                                             POINTS^
                  Shaking the snow globe for the first time                             1^
                  Meeting Crystal                                                       1^
                  Handing in the claim ticket at the laundry                            1^
                  removing the saddle from the pterosaur                                2^
                  selling the saddle                                                    2^
                  buying the spenseweed extract                                         1^
                  healing the pterosaur                                                 2^
                  letting the pterosaur get airborne                                    3^
                  buying the Mr Wizard Portable Tyromancy Deluxe                        1^
                  using the Mr Wizard Portable Tyromancy Deluxe                         1^
                  watching the first vision                                             1^
                  watching the second vision                                            1^
                  buying the hoop                                                       2^
                  using the hoop the first time                                         2^
                  buying the white nobbler                                              1^
                  putting the white nobbler in the drink                                1^
                  getting the airship captain out of the way                            2^
                  putting on the airship captain's uniform                              2^
                  watching the third vision                                             1^
                  buying the MegaMountain Autoclimber Extreme                           1^
                  getting into the manor grounds                                        2^
                  taking the airship captain's licence                                  1^
                  taking the ornate golden key                                          1^
                  taking the cheese from the manor house                                1^
                  watching the fourth vision                                            1^
                  buying the broomstick or repairing the carpet                         1^
                  reaching the first floor of the wooden house                          1^
                  reaching the roof of the brick house                                  2^
                  freeing the anchor                                                    4^
                  getting into the airship                                              2^
                  getting the airship airborne                                          3^
                  reaching Vechlee                                                      4^
                  taking the cheese from the old scrying bowl                           1^
                  watching the fifth vision                                             1^
                  taking the cheese from Sorcery Supply                                 1^
                  watching the sixth vision                                             1^
                  reaching the Plumbers Union Building Society                          1^
                  reaching the antechamber                                              1^
                  putting the hoop or satchel in the purple safety deposit box          1^
                  reaching the vault                                                    3^
                  picking up the cheese in the vault                                    2^
                  watching the seventh vision                                           1^
                  visiting the cheese shop                                              2^
                  watching the eighth vision                                            1^
                  getting the guard down from the wall                                  1^
                  picking up the lump of lead                                           1^
                  getting into the courtyard                                            3^
                  raising the portcullis                                                1^
                  putting the label on the vat of WizStrip                              1^
                  hanging the WizStrip delivery sign on the pipe                        1^
                  getting the WizStrip delivered to the caer                            2^
                  getting the walrus out of the way                                     3^
                  reaching the main hall                                                2^
                  picking up the cheese in the kitchen                                  1^
                  watching the ninth vision                                             1^
                  making black powder                                                   3^
                  putting the purse or pouch filled with black powder into the cannon   1^
                  firing Yekcal out of the cannon                                       3^
                  closing the rift                                                      3^
                  healing Crystal                                                       5^
                  MAXIMUM POSSIBLE SCORE                                              100^";
                  font on;
                }
                give self general; rtrue; ];

Option ->   Amusement_in_Main "For your Amusement and Edification"
    with    description [;
                if (self hasnt general) {
                    give self general;
                    print "[Warning: this section may contain spoilers for the game. If you haven't yet finished the game, you may not want to read
                      these. If you still want to, select this menu item again.]^";
                }
                else {
                    print "Have you tried...^
                    1) Singing?^
                    2) Singing in the presence of the various characters in the game?^
                    3) Burning things?^
                    4) Climbing things that can't be climbed?^
                    5) Saying xyzzy, plugh or plover? Doing so in front of various NPCs?^
                    6) Trying to eat inedible things?^
                    7) Typing jump, hop, skip or jaunt? Doing so in front of NPCs?^
                    8) Kissing NPCs? Touching NPCs? Licking NPCs? Doing all the same to yourself?^
                    9) Listening to yourself?^
                    10) Smelling yourself?^
                    11) Waving things in the presence of various characters?^
                    12) Yawning in the presence of Crystal?^
                    13) Greeting all the NPCs in the game (using NPC, HELLO or SAY HELLO TO NPC)?^
                    14) Showing things to NPCs, such as your robes, socks, satchel and so on?^
                    15) Showing your plotkins to NPCs, both when you have a few and a lot?^
                    16) Greeting Betty more than once?^
                    17) Examining Betty? Asking her about her teeth?^
                    18) Asking the old crone about Ninario?^
                    19) Asking the old crone about Renaldo?^
                    20) Asking the old crone about zorkmids?^
                    21) Asking the old crone about the trophy case?^
                    22) Asking the Lonely Mountaintop shopkeeper about rope? Boots? Other climbing equipment? He's got 20 different excuses why he
                    doesn't have any.^
                    23) Giving orders to the Lonely Mountaintop shopkeeper both before and after buying the MegaMountain Autoclimber Extreme?^
                    24) Climbing the drainpipe on the brick house in Oak Street?^
                    25) Asking Crystal things while you're on the drainpipe?^
                    26) After you've seen the bronze portcullis, telling the hermit about it, both before and after getting past it?^
                    27) Referring to the pterosaur as a dinosaur in front of Crystal?^
                    28) Referring to the pterosaur as a bird multiple times in front of Crystal?^
                    29) Asking Crystal about cannons? And then the incident? And then answering yes?^
                    30) Examining Renaldo in each vision?^
                    31) Asking Crystal about the grappling hook?^
                    32) Trying to travel ~down~ while in midair?^
                    33) Setting everything up so that the WizStrip can be delivered and then watching from the bailey or road to see what happens with
                    the teamster and horses when the explosion occurs?^
                    34) Spelling Yekcal backwards?^
                    35) Asking Honest Akbar about tyromancy?^
                    36) Asking Crystal about a number of different substances? There is a list of about 26, from a to z for which she has a response
                    about a friend imprisoned in each.^
                    37) Or, if you want to do it the easier way, ask her about her friends. Then, ask her about each of the names she lists.^
                    38) Eating Wizarding Weekly?^
                    39) Eating the black powder?^
                    40) Examining the sky throughout the course of the game?^
                    41) Searching the haystack?^
                    42) Asking Honest Akbar about carpets, knots, and looms? Or mentioning the dreaded Jufti knots?^
                    43) Apologising to various NPCs? Thanking them when they do things for you?^
                    44) Asking Crystal about random items or nonsense words not in the game? It triggers her to respond with one of 11 unrelated
                    responses.^
                    ^There are a few others not mentioned in this list. Have fun finding them!^";
          !TODO          47) entering Wizardry Wooding many times to see all the messages? There are a few that only occur 1.5% of the time, and one that only occurs 0.5% of the time.^
                    ! TODO 48) hanging around in Wizardry Wooding to watch all the things Betty the shopkeeper does? There are a couple that only occur 0.67% of the time.^
                }
                rtrue;
            ];

Option ->   Callbacks_obj "Callbacks to Risorgimento Represso"
    with    description [;
              if (self hasnt general) {
                give self general;
                print "[Warning: this section may contain spoilers for the game. If you haven't yet finished the game, you may not want to read
                these. If you still want to, select this menu item again.]^";
              }
              else {
                print "As a sequel, this game contains a number of callbacks or references to Risorgimento Represso. Here's a list of all of the
                conscious ones.^
                1) Every article in ", (i) "Wizarding Weekly", " references something the player did in Risorgimento Represso.^
                2) When Betty returns you the cheese from Ninario's robes, Crystal asks ~I mean, who steals cheese?~ and then apologises to you.
                This is a reference to the player's taking all the cheese from the cheese shop in Risorgimento Represso.^
                3) The scrying bowl in the guild hall rubble was used in Risorgimento Represso for tyromancy. It consumed the cheese when used so
                a lot of players worried about using it... that's one of the reasons for the Mr Wizard Portable Tyromancy Deluxe.^
                4) The shopkeepers Betty and Robert were characters in Risorgimento Represso. Robert was the hermit on top of the mountain and
                Betty owned the Wizardry Wooding shop.^
                5) The guard Renaldo's placed on the caer wall is Ted, the brother of the Guild Hall guard Ned from Risorgimento Represso. Ted is
                decidedly less friendly than Ned.^
                6) In Risorgimento Represso, you used heavy weight to bend the tree down and fall into the yard. In this game, the tree can be used
                in a similar way, but you have to then drop the heavy weight to fling yourself out of the tree.^
                7) In the first game, you could shoot a cannonball (or yourself) out of the cannon to blast through the caer doors. In this game, you
                blast Yekcal out of the cannon. This is foreshadowed in the workshop vision.^
                8) Various locations are of course re-visited in this game, though sometimes with a bit of a twist or difference.^
                9) Some locations that seemed without purpose in Risorgimento Represso serve a more useful function in this game. For example, the
                barren plot of earth behind the tower has become a garden, and the tunnel under the shed is useful because of the walrus.^
                10) On looking under objects in the game, from time to time, the game will say ~No green glowing portal. Sigh.~ This is a reference
                to the green glowing portal that appears under your lecture hall desk in Risorgimento Represso.^";
              }
            ];

LineGap    -> ->;
Option -> -> "How the Points are Scored"
    with description [; Points_Scored_in_Main.description(); ];

Option -> -> Amusement "For your Amusement and Edification"
    with    description [;
                Amusement_in_Main.description();
            ];

LineGap    -> ->;
Option -> -> "Go Back" with description [; return 3; ];

Option -> -> Callbacks "Callbacks to Risorgimento Represso"
    with    description [;
                Callbacks_Obj.description();
            ];

LineGap    -> ->;
Option -> -> "Go Back" with description [; return 3; ];

#Ifdef GRAPHICS_ENABLED;
[ AboutSub ks;
  ks = keep_silent;
  keep_silent = true;
  <Plain>;
#Ifnot;
[ AboutSub;
#Endif;
  AboutMenu.select();
#Ifdef GRAPHICS_ENABLED;
  <Fancy>;
  keep_silent = ks;
#Endif;
];

[ CreditsSub;
    Credits.description();
];


#Ifdef GRAPHICS_ENABLED;
[ MainMenuSub ks;
  ks = keep_silent;
  keep_silent = true;
  <Plain>;
#Ifnot;
[ MainMenuSub;
#Endif;
  HelpMenu.select();
#Ifdef GRAPHICS_ENABLED;
  <Fancy>;
  keep_silent = ks;
#Endif;
];

Verb meta 'menu'
  *           ->MainMenu;

Verb meta 'about'
  *               ->About
  * 'game'        ->About
  * 'the' 'game'  ->About;

Verb meta 'credit' 'credits'
  *               ->Credits;

!====================================================================================================================================================
