//---------------------------------------------------------------------------

#ifndef glkthreadH
#define glkthreadH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <SyncObjs.hpp>
#include <clipbrd.hpp>
#include "RichEdit20.h"
#include "grid.h"
#include "bass.h"

#define WINMETHOD_LEFT 0
#define WINMETHOD_RIGHT 1
#define WINMETHOD_ABOVE 2
#define WINMETHOD_BELOW 3
#define WINMETHOD_FIXED 16
#define WINMETHOD_PROPORTIONAL 32
#define WINMETHOD_NOBORDER 256

#define WINTYPE_ALLTYPES 0
#define WINTYPE_PAIR 1
#define WINTYPE_BLANK 2
#define WINTYPE_TEXTBUFFER 3
#define WINTYPE_TEXTGRID 4
#define WINTYPE_GRAPHICS 5

#define EVTYPE_NONE 0
#define EVTYPE_TIMER 1
#define EVTYPE_CHARINPUT 2
#define EVTYPE_LINEINPUT 3
#define EVTYPE_MOUSEINPUT 4
#define EVTYPE_ARRANGE 5
#define EVTYPE_REDRAW 6
#define EVTYPE_SOUNDNOTIFY 7
#define EVTYPE_HYPERLINK 8

#define STYLE_NORMAL 0
#define STYLE_EMPHASIZED 1
#define STYLE_PREFORMATTED 2
#define STYLE_HEADER 3
#define STYLE_SUBHEADER 4
#define STYLE_ALERT 5
#define STYLE_NOTE 6
#define STYLE_BLOCKQUOTE 7
#define STYLE_INPUT 8
#define STYLE_USER1 9
#define STYLE_USER2 10

#define STYLEHINT_INDENTATION 0
#define STYLEHINT_PARAINDENTATION 1
#define STYLEHINT_JUSTIFICATION 2
#define STYLEHINT_SIZE 3
#define STYLEHINT_WEIGHT 4
#define STYLEHINT_OBLIQUE 5
#define STYLEHINT_PROPORTIONAL 6
#define STYLEHINT_TEXTCOLOR 7
#define STYLEHINT_BACKCOLOR 8
#define STYLEHINT_REVERSECOLOR 9

#define STYLEHINT_JUST_LEFTFLUSH 0
#define STYLEHINT_JUST_LEFTRIGHT 1
#define STYLEHINT_JUST_CENTERED 2
#define STYLEHINT_JUST_RIGHTFLUSH 3

#define STREAM_WINDOW 1
#define STREAM_MEMORY 2
#define STREAM_FILE 3

#define IMAGEALIGN_INLINEUP 1
#define IMAGEALIGN_INLINEDOWN 2
#define IMAGEALIGN_INLINECENTER 3
#define IMAGEALIGN_MARGINLEFT 4
#define IMAGEALIGN_MARGINRIGHT 5

#define FILEMODE_WRITE 1
#define FILEMODE_READ 2
#define FILEMODE_READWRITE 3
#define FILEMODE_WRITEAPPEND 5

#define FILEUSAGE_DATA 0
#define FILEUSAGE_SAVEGAME 1
#define FILEUSAGE_TRANSCRIPT 2
#define FILEUSAGE_INPUTRECORD 3

#define FILEUSAGE_TEXTMODE 0
#define FILEUSAGE_BINARYMODE 256

#define SEEKMODE_START 0
#define SEEKMODE_CURRENT 1
#define SEEKMODE_END 2

#define GESTALT_VERSION 0
#define GESTALT_CHARINPUT 1
#define GESTALT_LINEINPUT 2
#define GESTALT_CHAROUTPUT 3
#define GESTALT_CHAROUTPUT_CANNOTPRINT 0
#define GESTALT_CHAROUTPUT_APPROXPRINT 1
#define GESTALT_CHAROUTPUT_EXACTPRINT 2
#define GESTALT_MOUSEINPUT 4
#define GESTALT_TIMER 5
#define GESTALT_GRAPHICS 6
#define GESTALT_DRAWIMAGE 7
#define GESTALT_SOUND 8
#define GESTALT_SOUNDVOLUME 9
#define GESTALT_SOUNDNOTIFY 10
#define GESTALT_HYPERLINKS 11
#define GESTALT_HYPERLINKINPUT 12
#define GESTALT_SOUNDMUSIC 13
#define GESTALT_GRAPHICSTRANSPARENCY 14
#define GESTALT_UNICODE 15
#define GESTALT_UNICODENORM 16
#define GESTALT_LINEINPUTECHO 17
#define GESTALT_LINETERMINATORS 18
#define GESTALT_LINETERMINATORKEY 19
#define GESTALT_DATETIME 20

#define KEYCODE_LEFT 0xfffffffe
#define KEYCODE_RIGHT 0xfffffffd
#define KEYCODE_UP 0xfffffffc
#define KEYCODE_DOWN 0xfffffffb
#define KEYCODE_RETURN 0xfffffffa
#define KEYCODE_DELETE 0xfffffff9
#define KEYCODE_ESCAPE 0xfffffff8
#define KEYCODE_TAB 0xfffffff7
#define KEYCODE_PAGEUP 0xfffffff6
#define KEYCODE_PAGEDOWN 0xfffffff5
#define KEYCODE_HOME 0xfffffff4
#define KEYCODE_END 0xfffffff3
#define KEYCODE_FUNC1 0xffffffef
#define KEYCODE_FUNC2 0xffffffee
#define KEYCODE_FUNC3 0xffffffed
#define KEYCODE_FUNC4 0xffffffec
#define KEYCODE_FUNC5 0xffffffeb
#define KEYCODE_FUNC6 0xffffffea
#define KEYCODE_FUNC7 0xffffffe9
#define KEYCODE_FUNC8 0xffffffe8
#define KEYCODE_FUNC9 0xffffffe7
#define KEYCODE_FUNC10 0xffffffe6
#define KEYCODE_FUNC11 0xffffffe5
#define KEYCODE_FUNC12 0xffffffe4
#define KEYCODE_NUMPAD0 0xffffffdf
#define KEYCODE_NUMPAD1 0xffffffde
#define KEYCODE_NUMPAD2 0xffffffdd
#define KEYCODE_NUMPAD3 0xffffffdc
#define KEYCODE_NUMPAD4 0xffffffdb
#define KEYCODE_NUMPAD5 0xffffffda
#define KEYCODE_NUMPAD6 0xffffffd9
#define KEYCODE_NUMPAD7 0xffffffd8
#define KEYCODE_NUMPAD8 0xffffffd7
#define KEYCODE_NUMPAD9 0xffffffd6

//---------------------------------------------------------------------------
struct STYLE{
  int indentation;
  int para_indentation;
  int justification;
  int size;
  int weight;
  bool oblique;
  bool proportional;
  TColor text_color;
  TColor back_color;
  bool reverse_color;
};

struct WINDOW{
  TRichEdit20 *textbuffer;
  TEXTGRID *textgrid;
  TControl *window;
  int split,method,size,wintype,rock;
  TFont *font;
  int font_width,font_height;
  bool line_event,char_event;
  wchar_t *buf;
  int maxlen;
  int initlen;
  int cursor_pos;
  WideString input_text;
  STYLE style[11];
  TColor color;
  bool reverse;
  int curr_style;
  int left,top,width,height;
  bool in_use;
  int parent;
  int child1,child2;
  int stream;
  int key;
  PARAFORMAT2 para_format;
  bool hyper_linking;
  int echo_stream;
  bool line_input_echo;
  bool *term_chars;
};

struct EVENT{
  int type;
  int win;
  int val1,val2;};

struct SCHANNEL{
  bool in_use,playing;
  int rock;
  int sound;
  int notify_val;
  int volume;
  bool notify_pending;
  HMUSIC hmusic;
  HSTREAM hstream;
  int type;
  void *buffer;
  int repeats;
};

struct STREAM{
  bool in_use;
  int type;
  int rock;
  char *buf;
  int buflen;
  int fmode;
  int loc;
  int readcount,writecount;
  int win;
  TFileStream *file;
  bool text;
  int echo;
  bool unicode;
  bool script;
  int highest_point;
};

struct FILEREF{
  bool in_use;
  int usage;
  int rock;
  String filename;
};

struct STREAM_RESULT{
  int readcount,writecount;
};

struct TIME_STRUCT{
  int high_sec;
  unsigned int low_sec;
  unsigned int microsec;
};

struct DATE_STRUCT{
  int year;
  int month;
  int day;
  int weekday;
  int hour;
  int minute;
  int second;
  int microsec;
};

struct UNI_CONV{
  unsigned int code;
  unsigned int upper;
  unsigned int lower;
  unsigned int title;
};

struct UNI_CONV_MULTI{
  unsigned int code;
  unsigned int lower[3];
  unsigned int title[3];
  unsigned int upper[3];
};

struct UNI_NORM{
  unsigned int code;
  unsigned int part1;
  unsigned int part2;
};

struct UNI_ORDER{
  unsigned int code;
  unsigned int order;
};

class GLK : public TThread
{            
private:
  bool char_input;
  wchar_t key_pressed[2];
  void *args[6];
  int win_count;
  WINDOW window[49];
  int active_stream;
  SETTEXTEX unicode_text;
  bool scripted,recorded;
  TClipboard *clipboard;
  EVENT *done_event;
  bool sound_avail;
  SCHANNEL schannel[10];
  TTimer *timer;
  bool resize_pending,timer_pending;
  STREAM stream[25];
  int stream_count;
  FILEREF fileref[10];
  int file_count;
  int root_win;
  tagMSG pending_msg[100];
  int pending_loc,processed_loc;
  bool catching_up;
  bool mouse_pending;
  int pending_target;
  TPoint pending_pos;
  bool hyper_pending;
  int pending_htarget;
  int pending_linkval;
  UNI_CONV *uni_conv;
  UNI_CONV_MULTI *uni_conv_multi;
  UNI_NORM *uni_norm;
  UNI_ORDER *uni_order;

  void plant_args(void *argv0,void *argv1=NULL,void *argv2=NULL,void *argv3=NULL,void *argv4=NULL,void *argv5=NULL);
  void dig_args(void *argv0,int size0,void *argv1=NULL,int size1=0,void *argv2=NULL,int size2=0,void *argv3=NULL,int size3=0,void *argv4=NULL,int size4=0,void *argv5=NULL,int size5=0);

  int font_width(TFont *font);
  int font_height(TFont *font);
  void suspend_me();
  void do_stylehint(STYLE *style,int styl,int hint,int val);
  void do_set_style(int target,int val);
  void draw_cursor(int target);
  void erase_cursor(int target);
  void __fastcall setup_input();
  void __fastcall signal_timer(TObject *Sender);
  void size_win(int target,int left,int top,int width,int height);
  void process_line_input(int target,unsigned char term_char,EVENT *event,bool to_hist=true);
  int create_pair(int child1,int method,int size);
  int create_win(int parent,int wintype,int rock,bool borderStyle,bool scrollStyle);
  void arrange_windows(int top);
  bool descendent(int win,int ancestor);
  void do_close_win(int target);
  void window_close_loop(int target);
  static void CALLBACK sound_sync(HSYNC handle,unsigned long channel,unsigned long data,unsigned long target);
  void do_select(EVENT *event,bool suspend);
  unsigned int *flip_string(wchar_t *str);
  void tab_complete(int target,String compare);
  void time_to_date(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct,int time_zone_adjust=0);
  void simple_time_to_date(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct,int time_zone_adjust=0);
  void date_to_time(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct,int time_zone_adjust=0);
  int date_to_simple_time(DATE_STRUCT *date_struct,unsigned int factor,int time_zone_adjust=0);
  void clear_input_lines();
  unsigned int translate_keycode(unsigned char keycode);
  bool check_uni_conv();
  bool check_uni_norm();
  int decompose_char(unsigned int code,unsigned int *tmp,int len,int *pos);
  void sort_normalize(unsigned int *tmp,int limit);
  void do_window_close(int target);

  void __fastcall ImageDraw();
  void __fastcall WindowClear();
  void __fastcall WindowOpen();
  void __fastcall WindowClose();
  void __fastcall PutString();
  void __fastcall SaveFileDialog();
  void __fastcall SaveDataFileDialog();
  void __fastcall RestoreFileDialog();
  void __fastcall OpenDataFileDialog();
  void __fastcall SetStyle();
  void __fastcall ScriptFileDialog();
  void __fastcall TranscriptMenu();
  void __fastcall RecordFileDialog();
  void __fastcall PlayFileDialog();
  void __fastcall WindowSetBackgroundColor();
  void __fastcall WindowFillRect();
  void __fastcall DefaultBackgroundColor();
  void __fastcall CatchUp();
  void __fastcall TextSetHyper();
  void __fastcall ErrorMessage();
  void __fastcall FinalOutput();

protected:
  void __fastcall Execute();

public:
  __fastcall GLK(bool CreateSuspended);
  __fastcall ~GLK();
  void __fastcall resize_redraw();
  void cleanup();
  void __fastcall AppMessage(tagMSG &Msg, bool &Handled);
  void do_command(String command,bool resume);
  void save_buffers();
  void copy_text();
  void paste_text();
  bool update_input(WideString letters,bool on_screen=true);
  void select_all();
  void find_text();
  void check_focus(int win);
  void set_insert(bool mode);

  int window_open(int split,int method,int size,int wintype,int rock);
  void window_get_size(int win,int &width,int &height);
  void window_set_arrangement(int win,int method,int size,int keywin=0);
  void window_get_arrangement(int win,int &method,int &size,int &keywin);
  void window_close(int win,STREAM_RESULT &result);
  void stream_set_current(int new_stream);
  void put_string(wchar_t *s);
  void put_string_stream(int str,wchar_t *s);
  void request_line_event(int win,wchar_t *buf,int maxlen,int initlen);
  void select (EVENT *event);
  bool save_file_dialog(char *name_buffer);
  bool save_data_file_dialog(char *name_buffer);
  bool restore_file_dialog(char *name_buffer);
  bool open_data_file_dialog(char *name_buffer);
  void set_style(int val);
  void stylehint_set(int wintype,int styl,int hint,int val);
  unsigned char script_file_dialog(char *name_buffer);
  void transcript_menu(bool check);
  void window_move_cursor(int win,int xpos,int ypos);
  void window_clear(int win);
  void window_stylehint_set(int win,int styl,int hint,int val);
  void request_char_event(int win);
  unsigned char record_file_dialog(char *name_buffer);
  bool play_file_dialog(char *name_buffer);
  void flush_output();
  void signal_resize();
  int stream_get_current();
  int schannel_create(int rock);
  bool schannel_play_ext(int chan,int snd,int repeats,int notify);
  bool schannel_play(int chan,int snd);
  void schannel_stop(int chan);
  void schannel_destroy(int chan);
  void schannel_set_volume(int chan,int vol);
  void window_get_cursor(int win,int &xpos,int &ypos);
  void request_timer_events(unsigned int millisecs);
  WideString window_get_input(int win);
  void window_char_graphics(int win,bool enable);
  void window_set_background_color(int win,TColor color);
  void __fastcall setup_screen();
  void MouseDownTextBuffer(int target);
  void request_mouse_event(int win);
  void cancel_mouse_event(int win);
  void ProcessMouse(int win,TPoint pos);
  bool check_unicode(int win,wchar_t char_number);
  int stream_iterate(unsigned int str,int &rockptr);
  int schannel_iterate(unsigned int chan,int &rockptr);
  int window_iterate(int win,int &rockptr);
  int fileref_iterate(int file,int &rockptr);
  void set_window(int win);
  int stream_open_memory(char *buf,int buflen,int fmode,int rock,bool unicode=false);
  void stream_close(int closed,STREAM_RESULT &result);
  unsigned char char_to_lower(unsigned char ch);
  int window_get_current();
  int window_get_parent(int win);
  int window_get_sibling(int win);
  int window_get_type(int win);
  int fileref_create_by_prompt(int usage,int fmode,int rock);
  int fileref_create_by_name(int usage,char *name,int rock);
  int fileref_create_temp(int usage,int rock);
  int fileref_create_from_fileref(int usage,int ref,int rock);
  int stream_open_file(int ref,int fmode,int rock,bool unicode=false);
  void fileref_destroy(int ref);
  void fileref_delete_file(int ref);
  bool fileref_does_file_exist(int ref);
  void put_buffer_stream(int str,char *buf,int len,bool unicode=false);
  int get_buffer_stream(int str,char *buf,int len,bool unicode=false);
  bool image_draw(int win,int image,int x,int y);
  unsigned char char_to_upper(unsigned char ch);
  int gestalt(int sel,int val);
  int gestalt_ext(int sel,int val,int *arr,int arrlen);
  bool image_get_info(int image,int &width,int &height);
  bool style_measure(int win,int style,int hint,int &result);
  void window_fill_rect(int win,TColor color,int left,int top,int width,int height);
  void window_erase_rect(int win,int left,int top,int width,int height);
  void cancel_line_event(int win,EVENT *event);
  int window_get_stream(int win);
  void put_char(wchar_t ch);
  int window_get_root();
  void stylehint_clear(int wintype,int styl,int hint);
  bool image_draw_scaled(int win,int image,int x,int y,int width,int height);
  void set_hyperlink(int linkval);
  void set_hyperlink_stream(int str,int linkval);
  void window_set_echo_stream(int win,int str);
  int window_get_echo_stream(int win);
  void request_hyperlink_event(int win);
  void cancel_hyperlink_event(int win);
  void ProcessHyper(int target,int linkval);
  void cancel_char_event(int win);
  bool is_hyperlinking(int target);
  int get_char_stream(int str,bool unicode=false);
  void tick();
  void select_poll(EVENT *event);
  void put_char_stream(int str,wchar_t ch);
  int get_line_stream(int str,char *buf,int len,bool unicode=false);
  void put_buffer(char *buf,int len,bool unicode=false);
  void stream_set_position(int str,int pos,int seekmode);
  int stream_get_position(int str);
  int window_get_rock(int win);
  int stream_get_rock(int str);
  int fileref_get_rock(int ref);
  void set_style_stream(int str,int val);
  void error_message(char *msg);
  bool style_distinguish(int win,int style1,int style2);
  void window_flow_break(int win);
  int schannel_get_rock(int chan);
  void sound_load_hint(int snd,bool flag);
  int buffer_to_lower_case_uni(unsigned int *buf,int len,int numchars);
  int buffer_to_upper_case_uni(unsigned int *buf,int len,int numchars);
  int buffer_to_title_case_uni(unsigned int *buf,int len,int numchars,bool lowerrest);
  void current_time(TIME_STRUCT *time_struct);
  int current_simple_time(unsigned int factor);
  void time_to_date_local(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct);
  void time_to_date_utc(TIME_STRUCT *time_struct,DATE_STRUCT *date_struct);
  void simple_time_to_date_local(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct);
  void simple_time_to_date_utc(unsigned int time,unsigned int factor,DATE_STRUCT *date_struct);
  void date_to_time_utc(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct);
  int date_to_simple_time_utc(DATE_STRUCT *date_struct,unsigned int factor);
  void date_to_time_local(DATE_STRUCT *date_struct,TIME_STRUCT *time_struct);
  int date_to_simple_time_local(DATE_STRUCT *date_struct,unsigned int factor);
  void set_echo_line_event(int win,bool val);
  void set_terminators_line_event(int win,unsigned int *keycodes,int count);
  int buffer_canon_decompose_uni(unsigned int *buf,int len,int numchars);
  int buffer_canon_normalize_uni(unsigned int *buf,int len,int numchars);
  void final_output();

  TFont *prop_font,*fixed_font;
  bool mored;
  int left_margin,right_margin;
  unsigned char version;
  int active_win;
  int story_size;
  STYLE textbuffer_style[11],textgrid_style[11];
  TEvent *done;
  bool double_click;
  bool moring;
  TFileStream *story_file;
  OSVERSIONINFO win_version;         
  bool char_graphics;
  bool more_clear;
  bool blank_reverse;
  bool repaint;
  bool char_cursor;
  bool borders;
  bool saved;
  bool scrollbar;
  bool hard_quit;
  bool input_style;
  bool more_cancel;
  bool insert;
  bool need_paint;
};
//---------------------------------------------------------------------------
#endif
 