/*
 * math.c
 *
 * Arithmetic, compare and logical opcodes
 *
 */

#include "frotz.h"
#include "s5api.h"
/*
 * z_add, 16bit addition.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_add (struct sg *g)
{

    store (g,(zword) ((short) g->zargs[0] + (short) g->zargs[1]));

}/* z_add */

/*
 * z_and, bitwise AND operation.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_and (struct sg *g)
{

    store (g,(zword) (g->zargs[0] & g->zargs[1]));

}/* z_and */

/*
 * z_art_shift, arithmetic SHIFT operation.
 *
 *	zargs[0] = value
 *	zargs[1] = #positions to shift left (positive) or right
 *
 */

void z_art_shift (struct sg *g)
{

    if ((short) g->zargs[1] > 0)
	store (g,(zword) ((short) g->zargs[0] << (short) g->zargs[1]));
    else
	store (g,(zword) ((short) g->zargs[0] >> - (short) g->zargs[1]));

}/* z_art_shift */

/*
 * z_div, signed 16bit division.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_div (struct sg *g)
{

    if (g->zargs[1] == 0)
	runtime_error (g,"Division by zero");

    store (g,(zword) ((short) g->zargs[0] / (short) g->zargs[1]));

}/* z_div */

/*
 * z_je, branch if the first value equals any of the following.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value (optional)
 *	...
 *	zargs[3] = fourth value (optional)
 *
 */

void z_je (struct sg *g)
{

    branch (g,
	g->zargc > 1 && (g->zargs[0] == g->zargs[1] || (
	g->zargc > 2 && (g->zargs[0] == g->zargs[2] || (
	g->zargc > 3 && (g->zargs[0] == g->zargs[3]))))));

}/* z_je */

/*
 * z_jg, branch if the first value is greater than the second.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_jg (struct sg *g)
{

    branch (g,(short) g->zargs[0] > (short) g->zargs[1]);

}/* z_jg */

/*
 * z_jl, branch if the first value is less than the second.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_jl (struct sg *g)
{

    branch (g,(short) g->zargs[0] < (short) g->zargs[1]);

}/* z_jl */

/*
 * z_jz, branch if value is zero.
 *
 * 	zargs[0] = value
 *
 */

void z_jz (struct sg *g)
{

    branch (g,(short) g->zargs[0] == 0);

}/* z_jz */

/*
 * z_log_shift, logical SHIFT operation.
 *
 * 	zargs[0] = value
 *	zargs[1] = #positions to shift left (positive) or right (negative)
 *
 */

void z_log_shift (struct sg *g)
{

    if ((short) g->zargs[1] > 0)
	store (g,(zword) (g->zargs[0] << (short) g->zargs[1]));
    else
	store (g,(zword) (g->zargs[0] >> - (short) g->zargs[1]));

}/* z_log_shift */

/*
 * z_mod, remainder after signed 16bit division.
 *
 * 	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_mod (struct sg *g)
{

    if (g->zargs[1] == 0)
	runtime_error (g,"Division by zero");

    store (g,(zword) ((short) g->zargs[0] % (short) g->zargs[1]));

}/* z_mod */

/*
 * z_mul, 16bit multiplication.
 *
 * 	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_mul (struct sg *g)
{

    store (g,(zword) ((short) g->zargs[0] * (short) g->zargs[1]));

}/* z_mul */

/*
 * z_not, bitwise NOT operation.
 *
 * 	zargs[0] = value
 *
 */

void z_not (struct sg *g)
{

    store (g,(zword) ~(g->zargs[0]));

}/* z_not */

/*
 * z_or, bitwise OR operation.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_or (struct sg *g)
{

    store (g,(zword) (g->zargs[0] | g->zargs[1]));

}/* z_or */

/*
 * z_sub, 16bit substraction.
 *
 *	zargs[0] = first value
 *	zargs[1] = second value
 *
 */

void z_sub (struct sg *g)
{

    store (g,(zword) ((short) g->zargs[0] - (short) g->zargs[1]));

}/* z_sub */

/*
 * z_test, branch if all the flags of a bit mask are set in a value.
 *
 *	zargs[0] = value to be examined
 *	zargs[1] = bit mask
 *
 */

void z_test (struct sg *g)
{

    branch (g,(g->zargs[0] & g->zargs[1]) == g->zargs[1]);

}/* z_test */
