/*
 * main.c
 *
 * Frotz V2.32 main function
 *
 * This is an interpreter for Infocom V1 to V6 games. It also supports
 * the recently defined V7 and V8 games. Please report bugs to
 *
 *    s.jokisch@avu.de
 *
 * Frotz is freeware. It may be used and distributed freely provided
 * no commercial profit is involved. (c) 1995-1997 Stefan Jokisch
 *
 */

#include "frotz.h"
#include "S5api.h"

extern void interpret (struct sg *g);
extern void init_memory (struct sg *g);
extern void init_undo (struct sg *g);
extern void reset_memory (struct sg *g);

/*
 * runtime_error
 *
 * An error has occured. Ignore it or pass it to os_fatal.
 *
 */

void runtime_error (struct sg *g, const char *s)
{

    if (!g->option_ignore_errors)
	{ flush_buffer (g); os_fatal (g,s); }

}/* runtime_error */

/*
 * z_piracy, branch if the story file is a legal copy.
 *
 *      no zargs used
 *
 */

void z_piracy (struct sg *g)
{

    branch (g,!g->option_piracy);

}/* z_piracy */

/*
 * main
 *
 * Prepare and run the game.
 *
 */
void reset_var(struct sg *g)
{
int i;

g->input.pos = 0;
g->input.length = 0;
g->history.latest = 0;
g->history.current = 0;
for(i = 0; i < HISTORY_BUFSIZE; i++)
  g->history.buffer[i] = 0;
g->script_valid = FALSE;
g->locked = FALSE;
g->flag = FALSE;
g->pos = 1;
g->first_restart = TRUE;
g->mapper[0].story_id = ZORK_ZERO;
g->mapper[1].pic = 5;
g->mapper[2].pic1 = 497;
g->mapper[3].pic2 = 498;
g->mapper[4].story_id = ZORK_ZERO;
g->mapper[5].pic = 6;
g->mapper[6].pic1 = 501;
g->mapper[7].pic2 = 502;
g->mapper[8].story_id = ZORK_ZERO;
g->mapper[9].pic = 7;
g->mapper[10].pic1 = 499;
g->mapper[11].pic2 = 500;
g->mapper[12].story_id = ZORK_ZERO;
g->mapper[13].pic = 8;
g->mapper[14].pic1 = 503;
g->mapper[15].pic2 = 504;
g->mapper[16].story_id = ARTHUR;
g->mapper[17].pic = 54;
g->mapper[18].pic1 = 170;
g->mapper[19].pic2 = 171;
g->mapper[20].story_id = SHOGUN;
g->mapper[21].pic = 50;
g->mapper[22].pic1 = 61;
g->mapper[23].pic2 = 62;
g->mapper[24].story_id = UNKNOWN;
g->mapper[25].pic = 0;
g->mapper[26].pic1 = 0;
g->mapper[27].pic2 = 0;
g->current_bg = 0;
g->current_fg = 1;
g->current_style = 0;
g->current_font = 0;
g->text_bg = 0;
g->text_fg = 1;
g->bg = 0;
g->fg = 1;
g->scrn_attr = 0;
g->cursor_x = 0;
g->cursor_y = 0;
g->graphics_font = NULL;
g->mcga_font = NULL;
g->mcga_width = NULL;
g->serif_font = NULL;
g->serif_width = NULL;
g->limit = 0;
g->overwrite = FALSE;
g->progname = NULL;
g->display = -1;
g->user_background = -1;
g->user_foreground = -1;
g->user_emphasis = -1;
g->user_bold_typing = -1;
g->user_reverse_bg = -1;
g->user_reverse_fg = -1;
g->user_screen_height = -1;
g->user_screen_width = -1;
g->user_tandy_bit = -1;
g->user_random_seed = -1;
g->user_font = 1;
g->old_video_mode = 0;
g->op0_opcodes[0] = z_rtrue;
g->op0_opcodes[1] = z_rfalse;
g->op0_opcodes[2] = z_print;
g->op0_opcodes[3] = z_print_ret;
g->op0_opcodes[4] = z_nop;
g->op0_opcodes[5] = z_save;
g->op0_opcodes[6] = z_restore;
g->op0_opcodes[7] = z_restart;
g->op0_opcodes[8] = z_ret_popped;
g->op0_opcodes[9] = z_catch;
g->op0_opcodes[10] = z_quit;
g->op0_opcodes[11] = z_new_line;
g->op0_opcodes[12] = z_show_status;
g->op0_opcodes[13] = z_verify;
g->op0_opcodes[14] = __extended__;
g->op0_opcodes[15] = z_piracy;
g->op1_opcodes[0] = z_jz;
g->op1_opcodes[1] = z_get_sibling;
g->op1_opcodes[2] = z_get_child;
g->op1_opcodes[3] = z_get_parent;
g->op1_opcodes[4] = z_get_prop_len;
g->op1_opcodes[5] = z_inc;
g->op1_opcodes[6] = z_dec;
g->op1_opcodes[7] = z_print_addr;
g->op1_opcodes[8] = z_call_s;
g->op1_opcodes[9] = z_remove_obj;
g->op1_opcodes[10] = z_print_obj;
g->op1_opcodes[11] = z_ret;
g->op1_opcodes[12] = z_jump;
g->op1_opcodes[13] = z_print_paddr;
g->op1_opcodes[14] = z_load;
g->op1_opcodes[15] = z_call_n;

g->var_opcodes[0] = __illegal__;
g->var_opcodes[1] = z_je;
g->var_opcodes[2] = z_jl;
g->var_opcodes[3] = z_jg;
g->var_opcodes[4] = z_dec_chk;
g->var_opcodes[5] = z_inc_chk;
g->var_opcodes[6] = z_jin;
g->var_opcodes[7] = z_test;
g->var_opcodes[8] = z_or;
g->var_opcodes[9] = z_and;
g->var_opcodes[10] = z_test_attr;
g->var_opcodes[11] = z_set_attr;
g->var_opcodes[12] = z_clear_attr;
g->var_opcodes[13] = z_store;
g->var_opcodes[14] = z_insert_obj;
g->var_opcodes[15] = z_loadw;
g->var_opcodes[16] = z_loadb;
g->var_opcodes[17] = z_get_prop;
g->var_opcodes[18] = z_get_prop_addr;
g->var_opcodes[19] = z_get_next_prop;
g->var_opcodes[20] = z_add;
g->var_opcodes[21] = z_sub;
g->var_opcodes[22] = z_mul;
g->var_opcodes[23] = z_div;
g->var_opcodes[24] = z_mod;
g->var_opcodes[25] = z_call_s;
g->var_opcodes[26] = z_call_n;
g->var_opcodes[27] = z_set_colour;
g->var_opcodes[28] = z_throw;
g->var_opcodes[29] = __illegal__;
g->var_opcodes[30] = __illegal__;
g->var_opcodes[31] = __illegal__;
g->var_opcodes[32] = z_call_s;
g->var_opcodes[33] = z_storew;
g->var_opcodes[34] = z_storeb;
g->var_opcodes[35] = z_put_prop;
g->var_opcodes[36] = z_read;
g->var_opcodes[37] = z_print_char;
g->var_opcodes[38] = z_print_num;
g->var_opcodes[39] = z_random;
g->var_opcodes[40] = z_push;
g->var_opcodes[41] = z_pull;
g->var_opcodes[42] = z_split_window;
g->var_opcodes[43] = z_set_window;
g->var_opcodes[44] = z_call_s;
g->var_opcodes[45] = z_erase_window;
g->var_opcodes[46] = z_erase_line;
g->var_opcodes[47] = z_set_cursor;
g->var_opcodes[48] = z_get_cursor;
g->var_opcodes[49] = z_set_text_style;
g->var_opcodes[50] = z_buffer_mode;
g->var_opcodes[51] = z_output_stream;
g->var_opcodes[52] = z_input_stream;
g->var_opcodes[53] = z_sound_effect;
g->var_opcodes[54] = z_read_char;
g->var_opcodes[55] = z_scan_table;
g->var_opcodes[56] = z_not;
g->var_opcodes[57] = z_call_n;
g->var_opcodes[58] = z_call_n;
g->var_opcodes[59] = z_tokenise;
g->var_opcodes[60] = z_encode_text;
g->var_opcodes[61] = z_copy_table;
g->var_opcodes[62] = z_print_table;
g->var_opcodes[63] = z_check_arg_count;

g->ext_opcodes[0] = z_save;
g->ext_opcodes[1] = z_restore;
g->ext_opcodes[2] = z_log_shift;
g->ext_opcodes[3] = z_art_shift;
g->ext_opcodes[4] = z_set_font;
g->ext_opcodes[5] = z_draw_picture;
g->ext_opcodes[6] = z_picture_data;
g->ext_opcodes[7] = z_erase_picture;
g->ext_opcodes[8] = z_set_margins;
g->ext_opcodes[9] = z_save_undo;
g->ext_opcodes[10] = z_restore_undo;
g->ext_opcodes[11] = z_print_unicode;
g->ext_opcodes[12] = z_check_unicode;
g->ext_opcodes[13] = __illegal__;
g->ext_opcodes[14] = __illegal__;
g->ext_opcodes[15] = __illegal__;
g->ext_opcodes[16] = z_move_window;
g->ext_opcodes[17] = z_window_size;
g->ext_opcodes[18] = z_window_style;
g->ext_opcodes[19] = z_get_wind_prop;
g->ext_opcodes[20] = z_scroll_window;
g->ext_opcodes[21] = z_pop_stack;
g->ext_opcodes[22] = z_read_mouse;
g->ext_opcodes[23] = z_mouse_window;
g->ext_opcodes[24] = z_push_stack;
g->ext_opcodes[25] = z_put_wind_prop;
g->ext_opcodes[26] = z_print_form;
g->ext_opcodes[27] = z_make_menu;
g->ext_opcodes[28] = z_picture_table;
g->optarg = NULL;
Srvstrcpy(g->script_name,DEFAULT_SCRIPT_NAME);
Srvstrcpy(g->command_name,DEFAULT_COMMAND_NAME);
g->records[0].story_id = SHERLOCK;
g->records[0].release =  21;
Srvstrcpy((char *)g->records[0].serial, "871214");
g->records[1].story_id = SHERLOCK;
g->records[1].release =  26;
Srvstrcpy((char *)g->records[1].serial, "880127");
g->records[2].story_id = BEYOND_ZORK;
g->records[2].release =  47;
Srvstrcpy((char *)g->records[2].serial, "870915");
g->records[3].story_id = BEYOND_ZORK;
g->records[3].release =  49;
Srvstrcpy( (char *)g->records[3].serial, "870917");
g->records[4].story_id = BEYOND_ZORK;
g->records[4].release =  51;
Srvstrcpy((char *)g->records[4].serial, "870923");
g->records[5].story_id = BEYOND_ZORK;
g->records[5].release =  57;
Srvstrcpy((char *)g->records[5].serial, "871221");
g->records[6].story_id = ZORK_ZERO;
g->records[6].release = 296;
Srvstrcpy((char *)g->records[6].serial, "881019");
g->records[7].story_id = ZORK_ZERO;
g->records[7].release = 366;
Srvstrcpy((char *)g->records[7].serial, "890323");
g->records[8].story_id = ZORK_ZERO;
g->records[8].release = 383;
Srvstrcpy((char *)g->records[8].serial, "890602");
g->records[9].story_id = ZORK_ZERO;
g->records[9].release = 393;
Srvstrcpy((char *)g->records[9].serial, "890714");
g->records[10].story_id = SHOGUN;
g->records[10].release = 292;
Srvstrcpy((char *)g->records[10].serial, "890314");
g->records[11].story_id = SHOGUN;
g->records[11].release = 295;
Srvstrcpy((char *)g->records[11].serial, "890321");
g->records[12].story_id = SHOGUN;
g->records[12].release = 311;
Srvstrcpy((char *)g->records[12].serial, "890510");
g->records[13].story_id = SHOGUN;
g->records[13].release = 322;
Srvstrcpy((char *)g->records[13].serial, "890706");
g->records[14].story_id = ARTHUR;
g->records[14].release = 54;
Srvstrcpy((char *)g->records[14].serial, "890606");
g->records[15].story_id = ARTHUR;
g->records[15].release = 63;
Srvstrcpy((char *)g->records[15].serial, "890622");
g->records[16].story_id = ARTHUR;
g->records[16].release = 74;
Srvstrcpy((char *)g->records[16].serial, "890714");
g->records[17].story_id = JOURNEY;
g->records[17].release = 26;
Srvstrcpy((char *)g->records[17].serial, "890316");
g->records[18].story_id = JOURNEY;
g->records[18].release = 30;
Srvstrcpy((char *)g->records[18].serial, "890322");
g->records[19].story_id = JOURNEY;
g->records[19].release = 77;
Srvstrcpy((char *)g->records[19].serial, "890616");
g->records[20].story_id = JOURNEY;
g->records[20].release = 83;
Srvstrcpy((char *)g->records[20].serial, "890706");
g->records[21].story_id = LURKING_HORROR;
g->records[21].release = 203;
Srvstrcpy((char *)g->records[21].serial, "870506");
g->records[22].story_id = LURKING_HORROR;
g->records[22].release = 219;
Srvstrcpy((char *)g->records[22].serial, "870912");
g->records[23].story_id = LURKING_HORROR;
g->records[23].release = 221;
Srvstrcpy((char *)g->records[23].serial, "870918");
g->records[24].story_id = UNKNOWN;
g->records[24].release = 0;
Srvstrcpy((char *)g->records[24].serial, "------");
Srvstrcpy(g->save_name, DEFAULT_SAVE_NAME);
Srvstrcpy(g->auxilary_name, DEFAULT_AUXILARY_NAME);
g->story_name = 0;
g->story_size = 0;
g->h_version = 0;
g->h_config = 0;
g->h_release = 0;
g->h_resident_size = 0;
g->h_start_pc = 0;
g->h_dictionary = 0;
g->h_objects = 0;
g->h_globals = 0;
g->h_dynamic_size = 0;
g->h_flags = 0;
for(i = 0; i < 6; i++)g->h_serial[i] = 0;
g->h_abbreviations = 0;
g->h_file_size = 0;
g->h_checksum = 0;
g->h_interpreter_number = 0;
g->h_interpreter_version = 0;
g->h_screen_rows = 0;
g->h_screen_cols = 0;
g->h_screen_width = 0;
g->h_screen_height = 0;
g->h_font_height = 1;
g->h_font_width = 1;
g->h_functions_offset = 0;
g->h_strings_offset = 0;
g->h_default_background = 0;
g->h_default_foreground = 0;
g->h_terminating_keys = 0;
g->h_line_width = 0;
g->h_standard_high = 1;
g->h_standard_low = 0;
g->h_alphabet = 0;
g->h_extension_table = 0;
for(i = 0; i < 8; i++)g->h_user_name[i] = 0;
g->hx_table_size = 0;
g->hx_mouse_x = 0;
g->hx_mouse_y = 0;
g->hx_unicode_table = 0;
g->sp = 0;
g->fp = 0;
g->ostream_screen = TRUE;
g->ostream_script = FALSE;
g->ostream_memory = FALSE;
g->ostream_record = FALSE;
g->istream_replay = FALSE;
g->message = FALSE;
g->cwin = 0;
g->mwin = 0;
g->mouse_y = 0;
g->mouse_x = 0;
g->enable_wrapping = FALSE;
g->enable_scripting = FALSE;
g->enable_scrolling = FALSE;
g->enable_buffering = FALSE;
g->option_attribute_assignment = 0;
g->option_attribute_testing = 0;
g->option_context_lines = 0;
g->option_object_locating = 0;
g->option_object_movement = 0;
g->option_left_margin = 0;
g->option_right_margin = 0;
g->option_ignore_errors = 0;
g->option_piracy = 0;
g->option_undo_slots = MAX_UNDO_SLOTS;
g->option_expand_abbreviations = 0;
g->option_script_cols = 80;
g->reserve_mem = 0;
g->bufpos = 0;
g->prev_c = 0;
g->zmp = NULL;
g->pcp = NULL;
g->story_fp = NULL;
g->undo_slots = 0;
g->undo_count = 0;
g->undo_valid = 0;
g->script_width = 0;
g->sfp = NULL;
g->rfp = NULL;
g->pfp = NULL;
g->optind = 1;
g->optopt = 0;
g->finished = 0;
g->interval = 0;
g->counter = 0;
g->depth = -1;
g->font_height = 1;
g->font_width = 1;
g->input_redraw = FALSE;
g->more_prompts = TRUE;
g->discarding = FALSE;
g->cursor = TRUE;
g->input_window = 0;
}


short frotzmain (short argc, char *argv[], struct sg *g)
{

    reset_var(g);

    os_process_arguments (g, argc, argv);

    init_memory (g);

    os_init_screen (g);

    init_undo (g);

    z_restart (g);

    interpret (g);

    reset_memory (g);

    os_reset_screen (g);

    return 0;

}/* main */
