#ifndef _FROTZCEIO_H
#define _FROTZCEIO_H

#ifdef __cplusplus
extern "C"
{
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#define FILE void

typedef unsigned int size_t;

FILE *fopen( const char *filename, const char *mode );
size_t fread( void *buffer, size_t size, size_t count, FILE *stream );
int fseek( FILE *stream, long offset, int origin );
long ftell( FILE *stream );
int fclose( FILE *stream );
int fgetc( FILE *stream );
int ferror( FILE *stream );
size_t fwrite( const void *buffer, size_t size, size_t count, FILE *stream );
int fputc( int c, FILE *stream );
int fputs( const char *string, FILE *stream );

void debug_msg( const char *pszString, int nNum );

#define EOF     (-1)

#ifdef __cplusplus
}
#endif

#endif
