// FrotzCE.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "FrotzCE.h"

#include "MainFrm.h"
#include "FrotzCEDoc.h"
#include "FrotzCEView.h"
#include "ZThread.h"
#include "About.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef _WIN32_WCE_PSPC
#include <aygshell.h>
#pragma comment( lib, "aygshell" )
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp

BEGIN_MESSAGE_MAP(CFrotzCEApp, CWinApp)
	//{{AFX_MSG_MAP(CFrotzCEApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp construction

CFrotzCEApp::CFrotzCEApp(LPCTSTR lpszAppName, LPCTSTR lpszHelpName)
#if _WIN32_WCE > 200
	: CWinApp(lpszAppName)
#else
	: CWinApp(lpszAppName, lpszHelpName)
#endif
{
	m_bZmachineRunning = FALSE;

	m_nFontHeight = 0;
	m_nFontWidth = 0;

	m_nDefaultStyle = NORMAL_STYLE;

	m_bUseStyles = FALSE;

	m_bUseColours = TRUE;

	m_bUseEuroChars = TRUE;

	m_bTandy = FALSE;

	m_bInitialised = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CFrotzCEApp object

// WCE MFC apps require the application name to be specified in the CWinApp 
// constructor. A help contents filename may also be specified.

CFrotzCEApp theApp(_T("FrotzCE"), _T("FrotzCE.htc"));

/////////////////////////////////////////////////////////////////////////////
// CFrotzCEApp initialization

BOOL CFrotzCEApp::InitInstance()
{
	// Standard initialization
	SetRegistryKey(_T("Frotz"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Get defaults from registry
	m_strDefaultDir = 
		GetProfileString( TEXT( "Defaults" ), TEXT( "CurrentDir" ), TEXT( "\\" ) );
	m_nFontHeight =
		GetProfileInt( TEXT( "Defaults" ), TEXT( "FontHeight" ), 0 );
	m_nFontWidth = 		
		GetProfileInt( TEXT( "Defaults" ), TEXT( "FontWidth" ), 0 );
	m_nDefaultStyle = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "Style" ), NORMAL_STYLE );
	m_bUseStyles = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "UseStyles" ), FALSE );
	m_bUseColours = 
		GetProfileInt( TEXT( "Defaults" ), TEXT( "UseCols" ), TRUE );

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.
	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CFrotzCEDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CFrotzCEView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->SetIcon( LoadIcon( IDI_APPICON ), FALSE );
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

#ifdef _WIN32_WCE_PSPC
	SIPINFO sSIP;
	memset( &sSIP, 0, sizeof( SIPINFO ) );
	sSIP.cbSize = sizeof( SIPINFO );
	// Soft keyboard visible?
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 )
		&& !(sSIP.fdwFlags & SIPF_ON))
	{
		// Show soft keyboard
		sSIP.fdwFlags = SIPF_ON;
		::SHSipInfo( SPI_SETSIPINFO, 0, &sSIP, 0 );
	}
	// Get soft keyboard info
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 ))
	{
	CRect cVisibleRect( sSIP.rcVisibleDesktop );

		// Resize main window to visible portion of screen
		m_pMainWnd->SetWindowPos( NULL, 0, 0, cVisibleRect.Width(), 
			cVisibleRect.Height(), SWP_NOMOVE | SWP_NOZORDER );
	}
#endif

	return TRUE;
}

int CFrotzCEApp::ExitInstance() 
{
	// Write defaults to registry
	WriteProfileString( TEXT( "Defaults" ), TEXT( "CurrentDir" ), m_strDefaultDir );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "FontHeight" ), m_nFontHeight );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "FontWidth" ), m_nFontWidth );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "Style" ), m_nDefaultStyle );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "UseStyles" ), m_bUseStyles );
	WriteProfileInt( TEXT( "Defaults" ), TEXT( "UseCols" ), m_bUseColours );

#ifdef _WIN32_WCE_PSPC
	SIPINFO sSIP;
	memset( &sSIP, 0, sizeof( SIPINFO ) );
	sSIP.cbSize = sizeof( SIPINFO );
	// Soft keyboard visible?
	if (::SHSipInfo( SPI_GETSIPINFO, 0, &sSIP, 0 )
		&& (sSIP.fdwFlags & SIPF_ON) != 0)
	{
		// Hide soft keyboard
		sSIP.fdwFlags ^= SIPF_ON;
		::SHSipInfo( SPI_SETSIPINFO, 0, &sSIP, 0 );
	}
#endif

	return CWinApp::ExitInstance();
}

void CFrotzCEApp::StartZMachine( LPVOID pParam )
{
	// Start ZMachine thread
	m_pcZThread = AfxBeginThread( ZMachineThreadFunction, pParam );
}

void CFrotzCEApp::OnFileOpen()
{
	// Z machine not running?
	if (!m_bZmachineRunning)
	{
	CFileDialog dlgFile( TRUE, NULL, NULL, 0, TEXT( "All Files (*.*)|*.*||" ), m_pMainWnd );

		// Set initial directory
		dlgFile.m_ofn.lpstrInitialDir = 
			m_strDefaultDir.GetBuffer( m_strDefaultDir.GetLength() + 1 );

		// Process file dialog
		if (dlgFile.DoModal() == IDOK)
		{
			m_strDefaultDir.ReleaseBuffer();
			OpenDocumentFile( dlgFile.GetPathName() );
		}
		else m_strDefaultDir.ReleaseBuffer();
	}
}

// App command to run the dialog
void CFrotzCEApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

