/*
 * bc.h
 *
 * Borland C interface, declarations
 *
 */

#include "frotz.h"

#define byte0(v)	((byte *)&v)[0]
#define byte1(v)	((byte *)&v)[1]
#define byte2(v)	((byte *)&v)[2]
#define byte3(v)	((byte *)&v)[3]
#define word0(v)	((word *)&v)[0]
#define word1(v)	((word *)&v)[1]

#ifndef HISTORY_BUFFER_SIZE
#define HISTORY_BUFFER_SIZE 500
#endif
#ifndef HISTORY_MIN_ENTRY
#define HISTORY_MIN_ENTRY 4
#endif

#define SPECIAL_KEY_MIN 256
#define SPECIAL_KEY_HOME 256
#define SPECIAL_KEY_END 257
#define SPECIAL_KEY_WORD_LEFT 258
#define SPECIAL_KEY_WORD_RIGHT 259
#define SPECIAL_KEY_DELETE 260
#define SPECIAL_KEY_INSERT 261
#define SPECIAL_KEY_PAGE_UP 262
#define SPECIAL_KEY_PAGE_DOWN 263
#define SPECIAL_KEY_MAX 263

#define _MONO_	0
#define _TEXT_	1
#define _CGA_	2
#define _MCGA_	3
#define _EGA_	4
#define _AMIGA_	5

typedef unsigned char byte;
typedef unsigned short word;

extern display;

extern cursor_x;
extern cursor_y;

extern unsigned char euro_map[];

extern byte text_bg;
extern byte text_fg;

extern byte scrn_attr;

extern user_background;
extern user_foreground;
extern user_emphasis;
extern user_reverse_bg;
extern user_reverse_fg;
extern user_screen_height;
extern user_screen_width;
extern user_tandy_bit;
extern user_bold_typing;
extern user_random_seed;

extern char stripped_story_name[9];

extern current_bg;
extern current_fg;
extern current_style;
extern current_font;

extern scaler;

/* bc_init. */	int	dectoi (const char *);
/* bc_init. */	int	hextoi (const char *);
/* bc_mous. */	int 	detect_mouse (void);
/* bc_mous. */	int    	read_mouse (void);
/* bc_pict. */	int 	init_pictures (void);
/* bc_pict. */	void 	reset_pictures (void);
/* bc_smpl. */	int 	init_sound (void);
/* bc_smpl. */	void 	reset_sound (void);
