
/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * Sound Tools stereo swap channels
 *
 */

#include "st.h"

/* Private data for SKEL file */
/*
 * Process options
 */
swap_getopts(effp, n, argv) 
eff_t effp;
int n;
char **argv;
{
    if (n)
	fail("swap takes no arguments");
}

/*
 * Start processing
 */
void
swap_start(effp)
eff_t effp;
{
	switch (effp->outinfo.channels) {
		case 2: switch (effp->ininfo.channels) {
			case 2:
				return;
		}
	}
	fail("Can't swap except stereo to stereo");
}

/*
 * Process either isamp or osamp samples, whichever is smaller.
 */

swap_flow(effp, ibuf, obuf, isamp, osamp)
eff_t effp;
long *ibuf, *obuf;
int *isamp, *osamp;
{
	int len, done;
	long lsample, rsample;

	for (done = 0; done < *isamp/2; done++) {
	    lsample = *ibuf++;
	    rsample = *ibuf++;
	    *obuf++ = rsample;
	    *obuf++ = lsample;
	}
	return done*2;
}

/*
 * Do anything required when you stop reading samples.  
 * Don't close input file! 
 *
 * Should have statistics on right, left, and output amplitudes.
 */
swap_stop(effp)
eff_t effp;
{
	/* nothing to do */
}

