ON ERROR GOTO erh

DIM sect(16) AS STRING * 256
IF COMMAND$ = "" THEN PRINT "(Required parameters missing:3 /? for help)": END
IF COMMAND$ = "/?" THEN
PRINT "Converts an Infocom Z3-type (the most common) data file into an Apple II"
PRINT "disk image.  You need to have the 12K interpreter stub from the beginning"
PRINT "of an existing 'DOS-order' (.dsk/.do) disk image."
PRINT
PRINT "INTERL stub.bin source.dat target.dsk"
PRINT
PRINT "Example:  For interpreter stub INFOCOM.65C and data file MINIZORK.Z3 to"
PRINT "          generate MINIZORK.DSK, enter the following command:"
PRINT
PRINT "                 INTERL INFOCOM.65C MINIZORK.Z3 MINIZORK.DSK"
END
END IF
IF INSTR(COMMAND$, " ") = 0 THEN PRINT "(Required parameters missing:2 /? for help)": END
stub$ = LEFT$(COMMAND$, INSTR(COMMAND$, " ") - 1)
midd$ = MID$(COMMAND$, INSTR(COMMAND$, " ") + 1)
IF INSTR(midd$, " ") = 0 THEN PRINT "(Required parameters missing:1 /? for help)": END
src$ = LEFT$(midd$, INSTR(midd$, " ") - 1)
tgt$ = MID$(midd$, INSTR(midd$, " ") + 1)
IF INSTR(tgt$, " ") <> 0 THEN PRINT "(Too many parameters:"; MID$(tgt$, INSTR(tgt$, " ") + 1); " /? for help)": END

OPEN stub$ FOR INPUT AS 1
OPEN src$ FOR INPUT AS 2
CLOSE 1, 2
OPEN stub$ FOR BINARY AS 1
IF LOF(1) <> 12288 THEN CLOSE : PRINT "(Stub file invalid - size not 12288)": END

OPEN tgt$ FOR OUTPUT AS 2

PRINT
PRINT "  ķ  ķ ķ ķ "
PRINT "                          INFOCOM DATA FILE RE-INTERLEAVE"
PRINT "                          AND APPLE II DISK IMAGE MAKER"
PRINT "            Ķ   ҽ "
PRINT "                          WRITTEN BY THE USOTSUKI"
PRINT "                          (c) 2002 DOSIUS SOFTWARE CO."
PRINT "   Ľ      Ľ   ӽ Ľ"
PRINT
PRINT "Creating disk:  "; tgt$
PRINT "From data file: "; src$
PRINT "Using stub:     "; stub$
PRINT
a$ = INPUT$(12288, 1): PRINT #2, a$;
PRINT "Stub copied"
CLOSE 1
OPEN src$ FOR BINARY AS 1
top:
IF SEEK(1) > LOF(1) THEN GOTO btm
PRINT "Reading 4K chunk... ["; INT(100 * (SEEK(1) / LOF(1))); "%"; "]"; : LOCATE , 1
sect(1) = INPUT$(256, 1)
sect(14) = INPUT$(256, 1)
sect(12) = INPUT$(256, 1)
sect(10) = INPUT$(256, 1)
sect(8) = INPUT$(256, 1)
sect(6) = INPUT$(256, 1)
sect(4) = INPUT$(256, 1)
sect(2) = INPUT$(256, 1)
sect(15) = INPUT$(256, 1)
sect(13) = INPUT$(256, 1)
sect(11) = INPUT$(256, 1)
sect(9) = INPUT$(256, 1)
sect(7) = INPUT$(256, 1)
sect(5) = INPUT$(256, 1)
sect(3) = INPUT$(256, 1)
sect(16) = INPUT$(256, 1)
PRINT "Writing"; : LOCATE , 1
FOR i = 1 TO 16
PRINT #2, sect(i);
NEXT i
GOTO top

btm:
PRINT "Data re-interleave/copy complete."
CLOSE 1
PRINT "Padding";
IF LOF(2) / 1024 <> INT(LOF(2) / 1024) THEN PRINT #2, SPACE$(1024 - (LOF(2) MOD 1024)); : PRINT " ";
remain% = 140 - (INT(LOF(2) / 1024))
FOR i = 1 TO remain%
PRINT #2, SPACE$(1024); : PRINT ".";
NEXT i
CLOSE
PRINT "Done!"
END

erh:
SELECT CASE ERR
CASE 5: PRINT "I was passed data that I don't know how to handle"
CASE 7: PRINT "Out of memory"
CASE 14: PRINT "Cannot allocate memory for byte transfer strings"
CASE 24: PRINT "Device timeout "; ERDEV$
CASE 25: PRINT "Device fault "; ERDEV$
CASE 27: PRINT "Printer out of paper "; ERDEV$
CASE 51: PRINT "Fatal error"
CASE 52, 64: PRINT "Bad file name"
CASE 53: PRINT "File not found"
CASE 55: PRINT "File already open"
CASE 57: PRINT "Cannot read from "; ERDEV$
CASE 61: PRINT "Insufficient disk space"
CASE 62: PRINT "Attempt to seek past EOF.  DAT file should be multiple of 4096 bytes"
CASE 67: PRINT "Too many files"
CASE 68: PRINT "Device unavailable "; ERDEV$
CASE 70: PRINT "Access denied"
CASE 71: PRINT "Drive not ready "; ERDEV$
CASE 72: PRINT "Invalid media type "; ERDEV$
CASE 75: PRINT "Path/file access error"
CASE 76: PRINT "Path not found"
CASE ELSE: PRINT "INTERL System error"; ERR
END SELECT
END

