package zpplet.ops;

import zpplet.machine.ZMachine;
import zpplet.misc.*;
import zpplet.system.*;
import java.awt.*;

public class ZInstruction6
		extends ZInstruction5
	{
	private final static int CURRENT_WINDOW = -3;

	public ZInstruction6(ZMachine zm)
		{
		super(zm);
		}

	public void callMain()
		{
		noperands = 1;
		o[0] = (short)zm.hd.getInitialPC();
		doCall(false);
		}

	protected void initOps()
		{
		super.initOps();

		ops[233] = new OP_PULL();
		ops[239] = new OP_SET_CURSOR();
		ops[242] = new OP_NOP(); // BUFFER_MODE

		ops[256 + 5] = new OP_DRAW_PICTURE();
		ops[256 + 6] = new OP_PICTURE_DATA();
		ops[256 + 7] = new OP_ERASE_PICTURE();
		ops[256 + 8] = new OP_SET_MARGINS();

		ops[256 + 16] = new OP_MOVE_WINDOW();
		ops[256 + 17] = new OP_WINDOW_SIZE();
		ops[256 + 18] = new OP_WINDOW_STYLE();
		ops[256 + 19] = new OP_GET_WIND_PROP();
		ops[256 + 20] = new OP_SCROLL_WINDOW();
		ops[256 + 21] = new OP_POP_STACK();
		ops[256 + 22] = new OP_READ_MOUSE();
		ops[256 + 23] = new OP_MOUSE_WINDOW();
		ops[256 + 24] = new OP_PUSH_STACK();
		ops[256 + 25] = new OP_PUT_WIND_PROP();
		ops[256 + 26] = new OP_PRINT_FORM();
		ops[256 + 27] = new OP_MAKE_MENU();
		ops[256 + 28] = new OP_PICTURE_TABLE();
		}

	class OP_PULL
			implements IOP
		{
		public void x()
			{
			if ((noperands == 0) || (o[0] == 0))
				doStore(zm.getVariable(0));
			else
				{
				int stackbase = o[0];
				int stackcount = zm.getWord(stackbase) + 1;
				int pulled = zm.getWord(stackbase + stackcount * 2);
				zm.setWord(stackbase, stackcount);
				doStore(pulled);
				}
			}
		}

	class OP_SET_CURSOR
			implements IOP
		{
		public void x()
			{
			ZWindow window = (noperands < 3) || ((short)o[2] == CURRENT_WINDOW) ? zm.curw : zm.w[o[2]];
			// NOTE: -1, -2 for turn off/on not implemented, because cursor only
			// shows when user is keying in a line
			if ((short)o[0] >= 0)
				window.moveCursor((short)o[1], (short)o[0]);
			}
		}

	class OP_DRAW_PICTURE
			implements IOP
		{
		public void x()
			{
			int x, y;
			if (o[1] == 0)
				y = zm.curw.getPosY();
			else
				y = zm.curw.top + o[1] - 1;
			if (o[2] == 0)
				x = zm.curw.getPosX();
			else
				x = zm.curw.left + o[2] - 1;
			Image img = zm.media.getImage(o[0]);
			if (img != null)
				zm.s.drawImage(img, x, y, zm.curw);
			}
		}

	class OP_PICTURE_DATA
			implements IOP
		{
		public void x()
			{
			if (o[0] == 0)
				if (zm.media != null)
					{
					zm.setWord(o[1], zm.media.getPictureCount());
					zm.setWord(o[1] + 2, 0);
					doBranch(true);
					}
				else
					doBranch(false);
			else
				{
				Dimension p = zm.media.getImageData(o[0]);
				if (p != null)
					{
					zm.setWord(o[1], p.height);
					zm.setWord(o[1] + 2, p.width);
					doBranch(true);
					}
				else
					{
					zm.setWord(o[1], 0);
					zm.setWord(o[1] + 2, 0);
					doBranch(false);
					}
				}
			}
		}

	class OP_ERASE_PICTURE
			implements IOP
		{
		public void x()
			{
			int x, y;
			if (o[1] == 0)
				y = zm.curw.getPosY();
			else
				y = zm.curw.top + o[1] - 1;
			if (o[2] == 0)
				x = zm.curw.getPosX();
			else
				x = zm.curw.left + o[2] - 1;
			Dimension p = zm.media.getImageData(o[0]);
			if (p != null)
				zm.s.eraseRegion(x, y, p.width, p.height, zm.curw.font.getBack());
			}
		}

	class OP_SET_MARGINS
			implements IOP
		{
		public void x()
			{
			ZWindow window = (noperands < 3) || ((short)o[2] == CURRENT_WINDOW) ? zm.curw : zm.w[o[2]];
			window.setMargins(o[0], o[1]);
			}
		}

	class OP_MOVE_WINDOW
			implements IOP
		{
		public void x()
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			window.moveTo(o[2], o[1]);
			}
		}

	class OP_WINDOW_SIZE
			implements IOP
		{
		public void x()
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			window.resize(o[2], o[1]);
			}
		}

	class OP_WINDOW_STYLE
			implements IOP
		{
		public void x()
				throws ZError
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			window.setWindowStyle(o[1], o[2]);
			}
		}

	class OP_GET_WIND_PROP
			implements IOP
		{
		public void x()
				throws ZError
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			doStore(window.getProp(o[1]));
			}
		}

	class OP_SCROLL_WINDOW
			implements IOP
		{
		public void x()
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			short n = (short)o[1];
			if (n > 0)
				zm.s.scrollUp(window, n);
			else if (n < 0)
				zm.s.scrollDown(window, -n);
			}
		}

	class OP_POP_STACK
			implements IOP
		{
		public void x()
			{
			if ((noperands < 2) || (o[1] == 0))
				for (int i = 0; i < o[0]; i++)
					zm.getVariable(0); // pop the stack and toss the result
			else
				{
				int stackbase = o[1];
				int stackcount = zm.getWord(stackbase);
				zm.setWord(stackbase, stackcount + o[0]);
				}
			}
		}

	class OP_READ_MOUSE
			implements IOP
		{
		public void x()
			{
			PointerInfo pi = java.awt.MouseInfo.getPointerInfo();
			zm.setWord(o[0], pi.getLocation().y);
			zm.setWord(o[0] + 2, pi.getLocation().x);
			zm.setWord(o[0] + 4, zm.s.getMouseButtons());
			zm.setWord(o[0] + 6, 0); // TODO: menu
			}
		}

	class OP_MOUSE_WINDOW
			implements IOP
		{
		public void x()
			{
			zm.s.setMouseWindow((short)o[0]);
			}
		}

	class OP_PUSH_STACK
			implements IOP
		{
		public void x()
			{
			if ((noperands < 2) || (o[1] == 0))
				{
				zm.setVariable(0, o[0]);
				doBranch(true);
				return;
				}
			int stackbase = o[1];
			int stackcount = zm.getWord(stackbase);
			if (stackcount > 0)
				{
				zm.setWord(stackbase + stackcount * 2, o[0]);
				zm.setWord(stackbase, stackcount - 1);
				doBranch(true);
				}
			else
				doBranch(false);
			}
		}

	class OP_PUT_WIND_PROP
			implements IOP
		{
		public void x()
				throws ZError
			{
			ZWindow window = (short)o[0] == CURRENT_WINDOW ? zm.curw : zm.w[o[0]];
			window.setProp(o[1], o[2]);
			}
		}

	class OP_PRINT_FORM
			implements IOP
		{
		public void x()
			{
			int addr = zm.getWord(o[0]);
			while (true)
				{
				int len = zm.getWord(addr);
				if (len == 0)
					break;
				addr += 2;
				for (int i = 0; i < len; i++)
					zm.printAsciiChar(zm.getByte(addr + i));
				zm.printAsciiChar(ZChars.RETURN_CHAR);
				addr += len;
				}
			}
		}

	class OP_MAKE_MENU
			implements IOP
		{
		public void x()
			{
			// TODO: add menus
			System.err.println("MAKE MENU operation attempted.");
			doBranch(false);
			}
		}

	class OP_PICTURE_TABLE
			implements IOP
		{
		public void x()
			{
			// obsolete?
			}
		}

	/*
	 * Overriden methods follow
	 */

	protected void doEraseWindow()
		{
		short n = (short)o[0];
		if (n == SCREEN_UNSPLIT)
			{
			doSplitWindow(0);
			zm.s.clear();
			zm.w[0].moveCursor(1, 1);
			}
		else if (n == SCREEN_NOUNSPLIT)
			zm.s.clear();
		else
			{
			zm.w[o[0]].clear();
			zm.w[o[0]].moveCursor(1, 1);
			}
		}

	protected void doSplitWindow(int lines)
		{
		zm.w[1].moveTo(1, 1);
		zm.w[1].resize(zm.s.getBoundsWidth(), lines);

		zm.w[0].moveTo(1, 1 + lines);
		zm.w[0].resize(zm.s.getBoundsWidth(), zm.s.getBoundsHeight() - lines);
		}

	protected void doSetColour()
		{
		ZWindow w = (noperands < 3) || ((short)o[2] == CURRENT_WINDOW) ? zm.curw : zm.w[o[2]];
		w.setColor((short)o[0], (short)o[1]);
		}

	protected void doEraseLine()
		{
		if (o[0] == 1)
			zm.curw.eraseLine();
		else
			zm.curw.eraseLineTo(o[0] - 1);
		}
	}