package zpplet.ops;

import zpplet.machine.ZMachine;

public class ZInstruction3
		extends ZInstruction
	{
	public ZInstruction3(ZMachine zm)
		{
		super(zm);
		}

	protected void initOps()
		{
		super.initOps();

		ops[188] = new OP_SHOW_STATUS();
		ops[189] = new OP_VERIFY();
		ops[234] = new OP_SPLIT_WINDOW();
		ops[235] = new OP_SET_WINDOW();
		ops[243] = new OP_OUTPUT_STREAM();
		ops[244] = new OP_INPUT_STREAM();
		ops[245] = new OP_SOUND_EFFECT();
		}

	class OP_SHOW_STATUS
			implements IOP
		{
		public void x()
			{
			zm.updateStatusLine();
			}
		}

	class OP_VERIFY
			implements IOP
		{
		public void x()
			{
			doBranch(zm.verifyChecksum());
			}
		}

	class OP_SPLIT_WINDOW
			implements IOP
		{
		public void x()
			{
			doSplitWindow(o[0]);
			}
		}

	class OP_SET_WINDOW
			implements IOP
		{
		public void x()
			{
			zm.curw.flush();
			zm.curw = zm.w[o[0]];
			if (o[0] == 1) // upper window
				zm.curw.moveCursor(1, 1);
			}
		}

	class OP_OUTPUT_STREAM
			implements IOP
		{
		public void x()
			{
			if (o[0] == 0)
				return;

			short n = (short)o[0];
			boolean setting = (n > 0);
			int stream = setting ? n : -n;
			int addr = noperands < 2 ? 0 : o[1];
			int width = noperands < 3 ? 0 : o[2];
			
			zm.curw.flush();
			zm.setOutputStream(stream, setting, addr, width);
			}
		}

	class OP_INPUT_STREAM
			implements IOP
		{
		public void x()
			{
			zm.setInputStream(o[0]);
			}
		}
	
	class OP_SOUND_EFFECT
			implements IOP
		{
		public void x()
			{
			if ((noperands == 0) || (o[0] == 1) || (o[0] == 2))
				{
				zpplet.system.ZMedia.beep(o[0]);
				return;
				}
			
			if (zm.media != null)
				switch (o[1])
					{
					case 1:
						zm.media.cacheSound(o[0]);
						break;
					case 2:
						int volume = noperands < 3 ? 255 : o[2] & 0xFF;
						int loops = noperands < 3 ? 0 : o[2] >> 8;
						//int routine = noperands < 4 ? 0 : o[3];
						// TODO: handle sound routine
						zm.media.playSound(o[0], volume, loops);
						break;
					case 3:
						zm.media.stopSound();
						break;
					case 4:
						zm.media.uncacheSound(o[0]);
						break;
					}
			}
		}
	
	/*
	 * Overridable methods follow
	 */
	
	protected void doSplitWindow(int lines)
		{
		if (zm.hd.getVersion() <= 3)
			System.err.println("Splitting window while using status line");
		
		if (lines == zm.w[1].getLines())
			return;

		zm.w[1].flush();
		zm.w[0].flush();

		zm.w[0].moveTo(1, 1 + lines);
		zm.w[0].resize(zm.s.getChars(), zm.s.getLines() - lines);
		zm.w[1].resize(zm.s.getChars(), lines);
		if (zm.hd.getVersion() == 3)
			zm.w[1].clear();
		}
	}