package zpplet.machine;

import zpplet.misc.*;
import zpplet.ops.ZInstruction5;
import zpplet.system.*;
import zpplet.data.ZDictionary4;
import zpplet.data.ZObjectTree4;
import zpplet.header.ZHeader5;

public class ZMachine5
		extends ZMachine4
	{
	ZState undo = null;

	public ZMachine5(byte[] mem, ZScreen screen)
		{
		super(mem, screen);
		}
	
	protected void initStructures()
		{
		hd = new ZHeader5(m);
		objs = new ZObjectTree4(this);
		zd = new ZDictionary4(this);
		zi = new ZInstruction5(this);
		}
	
	protected void initWindows()
		{
		makeTwoWindows();
		
		// init windows
		w[0].moveTo(1, 1);
		w[0].resize(s.getChars(), s.getLines());
		w[0].moveCursor(1, 1);
		
		w[1].moveTo(1, 1);
		w[1].resize(0, 0);
		}

	public void setHeaderFlags()
		{
		super.setHeaderFlags();
		ZHeader5 header = (ZHeader5)this.hd;

		// screen model flags
		header.setColorsAvailable(true);
		header.setPicturesAvailable(media != null);
		header.setUndoAvailable(true);
		header.setMouseAvailable(true);
		header.setSoundAvailable(media != null);

		// NOTE: for V5, using unit = 1 block character
		header.setScreenHeightUnits(s.getLines());
		header.setScreenWidthUnits(s.getChars());
		header.setFontHeightUnits(1);
		header.setFontWidthUnits(1);

		ZColor z = new ZColor();
		header.setDefaultForegroundColor(z.zfg);
		header.setDefaultBackgroundColor(z.zbg);
		
		int alphabase = header.getAlphaCustomBase();
		int terminatorbase = header.getTerminatorsBase();
		int unicodebase = header.getUnicodeBase();
		zc.setCustomAddresses(alphabase, terminatorbase, unicodebase);
		}

	public void restart()
		{
		super.restart();

		w[0].moveTo(1, 1);
		w[0].resize(s.getChars(), s.getLines());
		w[0].moveCursor(1, w[0].getLines());

		w[1].moveTo(1, 1);
		w[1].resize(0, 0);
		}

	public short restoreUndo()
		{
		if (undo != null)
			{
			boolean trans = hd.getTranscripting();
			undo.restoreSnapshot();
			undo = null;
			hd.setTranscripting(trans);
			return 2; // returning from SAVE, indicate this is a restored resumption
			}
		return 0;
		}

	public short saveUndo()
		{
		undo = new ZState(this);
		return 1; // returning from SAVE, indicating success
		}
	
	public void resize()
		{
		super.resize();
		ZHeader5 h = (ZHeader5)hd;
		h.setScreenHeightUnits(s.getLines());
		h.setScreenWidthUnits(s.getChars());
		}
	}