package zpplet.machine;

import zpplet.ZUserConfig;
import zpplet.data.ZDictionary;
import zpplet.data.ZObjectTree;
import zpplet.header.ZHeader;
import zpplet.misc.*;
import zpplet.ops.ZInstruction;
import zpplet.system.*;

public class ZMachine2
		extends ZMachine
	{
	public ZMachine2(byte[] mem, ZScreen screen)
		{
		super(mem, screen);
		}

	protected void makeTwoWindows()
		{
		w = new ZWindow[2];
		if (ZUserConfig.scrollback == 0)
			w[0] = new ZWindow(this, 0);
		else
			w[0] = new ZWindow0(this);
		w[0].moveTo(1, 2);
		w[0].resize(s.getChars(), s.getLines() - 1);
		
		w[1] = new ZWindow(this, 1);
		w[1].moveTo(1, 1);
		w[1].resize(s.getChars(), 1);
		
		w[1].setScroll(false);
		w[1].setWrapMode(false);
		w[1].setBufferMode(false);
		w[1].setTranscripting(false);
		w[1].setFont(ZFont.FIXED_FONT);
		curw = w[0];
		}

	protected void initWindows()
		{
		makeTwoWindows();
		
		// init windows
		w[0].moveCursor(1, w[0].getLines());
		w[1].setStyle(ZFont.REVERSE);
		}
		
	protected void initStructures() 
		{
		hd = new ZHeader(m);
		objs = new ZObjectTree(this);
		zd = new ZDictionary(this);
		zi = new ZInstruction(this);
		}
	
	public void setHeaderFlags()
		{
		hd.setRevision(STANDARDS_VERSION_MAJOR, STANDARDS_VERSION_MINOR);
		hd.setStatusUnavailable(false);
		hd.setSplittingAvailable(false); // used to provide status instead
		hd.setVariableDefault(ZUserConfig.normalfont == ZUserConfig.variablefont);
		}

	public int unpackSAddr(int addr)
		{
		return addr * 2;
		}

	public int unpackRAddr(int addr)
		{
		return addr * 2;
		}

	public String getStringAt(int addr)
			throws ZError
		{
		StringBuilder result = new StringBuilder();

		int build_ascii = 0;
		int built_ascii = 0;
		int base_alpha = 0;
		int alphabet = 0;
		boolean shift = false;
		int abbrev_mode = 0;

		int[] zchars = new int[3];
		int zseq;

		do
			{
			zseq = getWord(addr);
			addr += 2;
			zchars[0] = (zseq >> 10) & 0x1F;
			zchars[1] = (zseq >> 5) & 0x1F;
			zchars[2] = zseq & 0x1F;
			for (int i = 0; i < 3; i++)
				{
				if (build_ascii > 0)
					{
					built_ascii = (built_ascii << 5) + zchars[i];
					if (++build_ascii == 3)
						{
						result.append((char)built_ascii);
						built_ascii = 0;
						build_ascii = 0;
						}
					}
				else if (abbrev_mode > 0)
					{
					int anum = 32 * (abbrev_mode - 1) + zchars[i];
					int aindex = hd.getAbbrevTableAddr() + anum * 2;
					int aaddr = getWord(aindex) * 2;
					result.append(getStringAt(aaddr));
					abbrev_mode = 0;
					}
				else
					{
					switch (zchars[i])
						{
						case 0:
							result.append(' ');
							break;
						case 1:
							if (abbrev_mode != 0)
								throw new ZError("Abbreviation in abbreviation");
							abbrev_mode = zchars[i];
							break;
						case 2:
						case 3:
							alphabet = (alphabet + zchars[i] - 1) % 3;
							shift = true;
							break;
						case 4:
						case 5:
							base_alpha = alphabet = (alphabet + zchars[i] - 3) % 3;
							break;
						default:
							if ((zchars[i] == 6) && (alphabet == 2))
								build_ascii = 1;
							else
								result.append(zc.fromTable(zchars[i], alphabet));
							if (shift)
								{
								alphabet = base_alpha;
								shift = false;
								}
							break;
						}
					}
				}
			}
		while ((zseq & 0x8000) == 0);
		return result.toString();
		}
	}