/***************************************************************************
 *                                                                         *
 *  DZIP v2.12 - based on JZIP 2.1 by John Holder,                         *
 *               based on ZIP 2.0 by Mark Howell.                          *
 *                                                                         *
 *  Essentially conforms to ZSPEC 1.0.  Tweaks by Steve "Dosius" Nickolas  *
 *                                                                         *
 ******************************[ osdepend.c ]*******************************
 *                                                                         *
 *  2002.0209: first build.                                                *
 *             osdepend.c - cosmetic changes; mono/black-and-white works;  *
 *                          user-configurable interpreter setting (MS-DOS  *
 *                          still the default)                             *
 *  2002.0210: additional cosmetic changes.                                *
 *  2002.0211: v2.12 (FINALLY I HOPE!) crushed the cls bug, new -x for     *
 *                   Martin Korth's style of status (Z1-Z3 only), and      *
 *                   enhanced the 40-column status line (again, Z1-Z3      *
 *                   only).                                                *
 *                                                                         *
 *                                                                         *
 ***************************************************************************/


/* $Id: osdepend.c,v 1.2 2000/05/25 22:28:56 jholder Exp $
 * --------------------------------------------------------------------
 * see doc/License.txt for License Information
 * --------------------------------------------------------------------
 *
 * File name: $Id: osdepend.c,v 1.2 2000/05/25 22:28:56 jholder Exp $
 *
 * Description:
 *
 * Modification history:
 * $Log: osdepend.c,v $
 * Revision 1.2  2000/05/25 22:28:56  jholder
 * changes routine names to reflect zmachine opcode names per spec 1.0
 *
 * Revision 1.1.1.1  2000/05/10 14:21:34  jholder
 *
 * imported
 *
 *
 * --------------------------------------------------------------------
 */

/*
 * osdepend.c
 *
 * All non screen specific operating system dependent routines.
 *
 * Olaf Barthel 28-Jul-1992
 * Modified John Holder(j-holder@home.com) 25-July-1995
 * Support for standalone storyfiles by Magnus Olsson (mol@df.lth.se) Nov.1995
 *
 */

#include "ztypes.h"
#include "jzexe.h"
#ifdef __TURBOC__
#include <conio.h> /* text_info stuff */

extern int _argc;
extern char **_argv;

char	* searchpath	(const char *__file);
static FILE * config_ptr;
static char confstr[64];
#endif

/* File names will be O/S dependent */

#if defined(AMIGA)
#define SAVE_NAME     "Story.Save" /* Default save name */
#define SCRIPT_NAME   "PRT:"    /* Default script name */
#define RECORD_NAME   "Story.Record" /* Default record name */
#define AUXILARY_NAME "Story.Aux" /* Default auxilary name */
#else /* defined(AMIGA) */
#define SAVE_NAME     "story.sav" /* Default save name */
#define SCRIPT_NAME   "story.scr" /* Default script name */
#define RECORD_NAME   "story.rec" /* Default record name */
#define AUXILARY_NAME "story.aux" /* Default auxilary name */
#endif /* defined(AMIGA) */


#ifdef STRICTZ

/* Define stuff for stricter Z-code error checking, for the generic
 * Unix/DOS/etc terminal-window interface. Feel free to change the way
 * player prefs are specified, or replace report_zstrict_error()
 * completely if you want to change the way errors are reported.
 */

/* There are four error reporting modes: never report errors;
 * report only the first time a given error type occurs; report
 * every time an error occurs; or treat all errors as fatal
 * errors, killing the interpreter. I strongly recommend
 * "report once" as the default. But you can compile in a
 * different default by changing the definition of
 * STRICTZ_DEFAULT_REPORT_MODE. In any case, the player can
 * specify a report mode on the command line by typing "-s 0"
 * through "-s 3".
 */

#define STRICTZ_REPORT_NEVER  (0)
#define STRICTZ_REPORT_ONCE   (1)
#define STRICTZ_REPORT_ALWAYS (2)
#define STRICTZ_REPORT_FATAL  (3)

#define STRICTZ_DEFAULT_REPORT_MODE STRICTZ_REPORT_NEVER

static int strictz_report_mode;
static int strictz_error_count[STRICTZ_NUM_ERRORS];

#endif /* STRICTZ */

#if !defined(AMIGA)

/* getopt linkages */

extern int optind;
extern const char *optarg;
extern ZINT16 default_fg, default_bg;

#endif /* !defined(AMIGA) */

/* GEM stuff */
#undef FAR
#undef FALSE
#undef TRUE
#undef NORMAL

#include <gem/portab.h>
#include <gem/aes.h>
#include <gem/dosbind.h>
#include <dir.h>

char path[80];            /* buffer for path name                      */
char name[20];            /* buffer for file name                      */
char fullname[100];       /* buffer for complete file name             */

/* Borrowed from a GEM sample program...sorry! :) */
WORD file_select(path,file)
BYTE *path;
BYTE *file;
{
   REG BYTE *p;
   BYTE cwd[100];
   WORD drive;
   WORD button;

/*
 * If path is not set, get current drive and path
 */
   if (path[0] == 0)
   {
      drive  = dos_gdrv();
      cwd[0] = drive + 'A';
      cwd[1] = ':';
      cwd[2] = '\\';
      dos_gdir(drive + 1, &cwd[3]);
      if (cwd[3] == '\\')
         strcpy(&cwd[2],&cwd[3]);
   }
   else
      strcpy(cwd,path);

   if (cwd[strlen(cwd) - 1] != '\\')
      strcat(cwd,"\\");

   strcat(cwd,"*.*");

/*
 * Get file from file selector box
 */
   fsel_input(cwd,file,&button);

   if (!button)
      return(FALSE);

/*
 * split path and name
 */
   p = strrchr(cwd,'\\');
   if (p)
      *p = 0;

   strcpy(path,cwd);

   return(TRUE);
}

int getfile(char* inoutname)
{
 char tmp1[80],tmp2[10];
 path[0] = name[0] = 0;
 fnsplit(inoutname,path,tmp1,name,tmp2);
 strcat(path,tmp1);
 strcat(name,tmp2);
 if (!file_select(path,name))
  return 0; /* no file */
 strcpy(fullname,path);
 strcat(fullname,"\\");
 strcat(fullname,name);
 strcpy(inoutname,fullname);
 return 1; /* file */
}

#undef FAR
#undef FALSE
#undef TRUE
#undef NORMAL
#define FAR    far
#define FALSE  0
#define TRUE   1
#define NORMAL 0

/* GEM stuff ends for now... */

#if !defined(AMIGA)

/*
 * process_arguments
 *
 * Do any argument preprocessing necessary before the game is
 * started. This may include selecting a specific game file or
 * setting interface-specific options.
 *
 */

void process_arguments( int argc, char *argv[] )
{
   int c, errflg = 0;
   int infoflag = 0;
   int size;
   int expected_args;
   int num;
#ifdef __TURBOC__
   struct text_info ti;
#endif
/* GEM stuff */
   int has_config=-1;

#ifdef STRICTZ
   /* Initialize the STRICTZ variables. */

   strictz_report_mode = STRICTZ_DEFAULT_REPORT_MODE;

   for ( num = 0; num < STRICTZ_NUM_ERRORS; num++ )
   {
      strictz_error_count[num] = 0;
   }
#endif /* STRICTZ */

   /* Parse the options */

   monochrome = 0;
   hist_buf_size = 1024;
   bigscreen = 0;
   k_statmode = 0;

   /* Automagically detect monochrome and black-and-white modes */
#ifdef __TURBOC__
   gettextinfo( &ti );
   if (ti.currmode == BW40 || ti.currmode == BW80) monochrome=2;
    else if (ti.currmode == MONO) monochrome=1;
#endif

/* GEM stuff */
   if (!searchpath("GEMDZIP.CFG")) has_config=0;
   config_ptr=fopen(searchpath("GEMDZIP.CFG"),"rt");
   if (config_ptr && has_config)
   {
    while (!feof(config_ptr))
    {
	fgets(confstr,127,config_ptr);
	switch (confstr[0])
	{
	    case 'x':
		  k_statmode = 1;
		  break;
         case 'l':             /* lines */
		  screen_rows = atoi( confstr+1 );
		  break;
	    case 'c':             /* columns */
		  screen_cols = atoi( confstr+1 );
		  break;
	    case 'r':             /* right margin */
		  right_margin = atoi( confstr+1 );
		  break;
	    case 't':             /* top margin */
		  top_margin = atoi( confstr+1 );
		  break;
	    case 'k':             /* number of K for hist_buf_size */
		  size = atoi( confstr+1 );
		  hist_buf_size = ( hist_buf_size > size ) ? hist_buf_size : size;
		  if ( hist_buf_size > 16384 )
			hist_buf_size = 16384;
		  break;
	    case 'i':             /* ZTERP code */
		  h_interpreter = atoi( confstr+1 );
		  break;
	    case 'y':             /* Tandy */
            fTandy = 1;
		  break;
         case 's':             /* strictz reporting mode */
		  strictz_report_mode = atoi( confstr+1 );
		  if ( strictz_report_mode < STRICTZ_REPORT_NEVER ||
			  strictz_report_mode > STRICTZ_REPORT_FATAL )
		  {
			errflg++;
		  }
		  break;
	  default: gemprintf ("Invalid configuration command %s\n",confstr);
			 break;
	 };
	}
	fclose (config_ptr);
    }

#ifdef STRICTZ
#if ( defined OS2 || defined __MSDOS__ )
#define GETOPT_SET  "bomxvzhy?l:c:k:r:t:s:i:"
#elif defined HARD_COLORS
#define GETOPT_SET    "mxvzhy?l:c:k:r:t:s:f:b:i:"
#else
#define GETOPT_SET    "mxvzhy?l:c:k:r:t:s:i:"
#endif
#else
#if ( defined OS2 || defined __MSDOS__ )
#define GETOPT_SET  "bomxvzhy?l:c:k:r:t:i:"
#elif defined HARD_COLORS
#define GETOPT_SET    "mxvzhy?l:c:k:r:t:f:b:i:"
#else
#define GETOPT_SET    "mxvzhy?l:c:k:r:t:i:"
#endif
#endif
   while ( ( c = getopt( argc, argv, GETOPT_SET ) ) != EOF )
   {
      switch ( c )
	 {
	    case 'x':
		  k_statmode = 1;
		  break;
         case 'l':             /* lines */
            screen_rows = atoi( optarg );
            break;
         case 'c':             /* columns */
            screen_cols = atoi( optarg );
            break;
         case 'r':             /* right margin */
            right_margin = atoi( optarg );
            break;
         case 't':             /* top margin */
            top_margin = atoi( optarg );
            break;
         case 'k':             /* number of K for hist_buf_size */
            size = atoi( optarg );
            hist_buf_size = ( hist_buf_size > size ) ? hist_buf_size : size;
            if ( hist_buf_size > 16384 )
               hist_buf_size = 16384;
		  break;
	    case 'i':             /* ZTERP code */
		  h_interpreter = atoi( optarg );
		  if (h_interpreter<1 || h_interpreter>11)
		  {
		   gemprintf ("WARNING:  Some games may crash if an interpreter code outside of the\n");
		   gemprintf ("          range 1..11 is supplied.  You may wish to try omitting the\n");
		   gemprintf ("          -i switch or using one of the values 1, 2 or 6.\n");
		   gemprintf ("          Press any key to ignore and continue.\n");
#ifdef __MSDOS__
 getch();
#else
 getchar();
 fflush(stdin);
#endif
		  }
         case 'y':             /* Tandy */
            fTandy = 1;
		  break;
/*#if ( defined OS2 || defined __MSDOS__ )
 *            case 'g':             /* Beyond Zork or other games using IBM graphics
 *                  fIBMGraphics = 1;
 *                  break;
 *#endif
 **We can't use this yet!  But soon :) */
            case 'v':             /* version information */
   appl_init();
   if (screen_rows==0 || screen_rows > 22) screen_rows=22;
   if (screen_cols==0) screen_cols=80;

   init_textmode (screen_cols,screen_rows+2,0,20);
   clrscr();


		  gemprintf ( "\nDZIP - an Infocom/Inform Z-code interpreter program \n" );
		  gemprintf ( "       %s, built %s %s\n", DZIPVER, __DATE__, __TIME__ );
		  if ( STANDALONE_FLAG )
		  {
			gemprintf ( "       Standalone game: %s\n", argv[0] );
		  }
		  gemprintf ( "---------------------------------------------------------\n" );
		  gemprintf ( "Author          :  %s\n", DZIPAUTHOR );
		  gemprintf ( "Official Webpage: %s\n", DZIPURL );
		  gemprintf ( "IF Archive      : http://www.if-archive.org/\n" );
		  gemprintf ( "         Based on ZIP 2.0 source code by Mark Howell\n" );
		  gemprintf ( "             and JZIP 2.1 source code by John Holder\n\n" );
		  gemprintf (
                     "Bugs:    Please report bugs and portability bugs to the maintainer." );
		  gemprintf ( "\n\nInterpreter:\n\n" );
		  gemprintf ( "\tThis interpreter will run all Infocom V1 to V5 and V8 games.\n" );
#ifndef USE_ZLIB
		  gemprintf (
                     "\tThis is a Z-machine standard 1.0 interpreter, including support for\n" );
		  gemprintf ( "\tthe Quetzal portable save file format, ISO 8859-1 (Latin-1)\n" );
		  gemprintf (
                     "\tinternational character support, and the extended save and load opcodes.\n" );
#else
		  gemprintf (
                     "\tThis is a Z-machine standard 1.0 interpreter, including support for\n" );
		  gemprintf ( "\tthe Quetzal portable save file format, ISO 8859-1 (Latin-1)\n" );
		  gemprintf (
                     "\tinternational character support, gzip-compressed game files, and the\n" );
		  gemprintf ( "\textended save and load opcodes.\n" );
#endif
		  gemprintf ( "\t\n" );
            infoflag++;
            break;
#if defined (HARD_COLORS)
            case 'f':
                  default_fg = atoi( optarg );
                  break;
            case 'b':
                  default_bg = atoi( optarg );
                  break;
#endif
#if ( defined OS2 || defined __MSDOS__ ) && ( !defined USOANSI )
		  case 'm':             /* monochrome */
			   monochrome = 1;
			   break;
		  case 'b':             /* black-and-white */
			   monochrome = 2;
			   break;
            case 'o':             /* color */
			   break;
#else
            case 'm':
                  monochrome = 1;
                  break;
#endif
#ifdef STRICTZ
         case 's':             /* strictz reporting mode */
            strictz_report_mode = atoi( optarg );
            if ( strictz_report_mode < STRICTZ_REPORT_NEVER ||
                 strictz_report_mode > STRICTZ_REPORT_FATAL )
            {
               errflg++;
            }
            break;
#endif /* STRICTZ */

         case 'z':
            print_license(  );
            infoflag++;
            break;

         case 'h':
         case '?':
         default:
            errflg++;
      }
   }

   if ( infoflag )
	 gabort( EXIT_SUCCESS );

   if ( STANDALONE_FLAG )
      expected_args = 0;
   else
      expected_args = 1;

   /* Display usage */

   if ( errflg || optind + expected_args != argc )
   {
	char temp[255], temp2[255];
	appl_init();
	strcpy(temp,"game.dat");
	if (getfile(temp))
	{
	 if (!_argv[0] || !*_argv[0]) execl("dzip.app","dzip.app",temp,0); else execl(_argv[0],_argv[0],temp,0);
	 strcpy(temp2,"[3][Cannot run myself (");
	 strcat(temp2,_argv[0]);
	 strcat(temp2,")|with the file ");
	 strcat(temp2,temp);
	 strcat(temp2," ...][Exit]");
	 form_alert(1,temp2);
	}
	appl_exit();
     exit(1);
   }

   /* Open the story file */

   if ( !STANDALONE_FLAG )      /* mol 951115 */
      open_story( argv[optind] );
   else
   {
      /* standalone, ie. the .exe file _is_ the story file. */
      if ( argv[0][0] == 0 )
      {
         /* some OS's (ie DOS prior to v.3.0) don't supply the path to */
         /* the .exe file in argv[0]; in that case, we give up. (mol) */
	    fatal( "process_arguments(): I don't know my own file name!  Cannot load." );
      }
      open_story( argv[0] );
   }

}                               /* process_arguments */

#endif /* !defined(AMIGA) */

#if !defined(AMIGA)

/*
 * file_cleanup
 *
 * Perform actions when a file is successfully closed. Flag can be one of:
 * GAME_SAVE, GAME_RESTORE, GAME_SCRIPT.
 *
 */

void file_cleanup( const char *file_name, int flag )
{
   UNUSEDVAR( file_name );
   UNUSEDVAR( flag );
}                               /* file_cleanup */

#endif /* !defined(AMIGA) */

#if !defined(AMIGA)

/*
 * sound
 *
 * Play a sound file or a note.
 *
 * argc = 1: argv[0] = note# (range 1 - 3)
 *
 *           Play note.
 *
 * argc = 2: argv[0] = 0
 *           argv[1] = 3
 *
 *           Stop playing current sound.
 *
 * argc = 2: argv[0] = 0
 *           argv[1] = 4
 *
 *           Free allocated resources.
 *
 * argc = 3: argv[0] = ID# of sound file to replay.
 *           argv[1] = 2
 *           argv[2] = Volume to replay sound with, this value
 *                     can range between 1 and 8.
 *
 * argc = 4: argv[0] = ID# of sound file to replay.
 *           argv[1] = 2
 *           argv[2] = Control information
 *           argv[3] = Volume information
 *
 *           Volume information:
 *
 *               0x34FB -> Fade sound in
 *               0x3507 -> Fade sound out
 *               other  -> Replay sound at maximum volume
 *
 *           Control information:
 *
 *               This word is divided into two bytes,
 *               the upper byte determines the number of
 *               cycles to play the sound (e.g. how many
 *               times a clock chimes or a dog barks).
 *               The meaning of the lower byte is yet to
 *               be discovered :)
 *
 */

void sound( int argc, zword_t * argv )
{

   /* Supply default parameters */

   if ( argc < 4 )
      argv[3] = 0;
   if ( argc < 3 )
      argv[2] = 0xff;
   if ( argc < 2 )
      argv[1] = 2;

   /* Generic bell sounder */

   if ( argc == 1 || argv[1] == 2 )
      display_char( '\007' );

}                               /* sound */

#endif /* !defined(AMIGA) */

/*
 * get_file_name
 *
 * Return the name of a file. Flag can be one of:
 *    GAME_SAVE     - Save file (write only)
 *    GAME_RESTORE  - Save file (read only)
 *    GAME_SCRIPT   - Script file (write only)
 *    GAME_RECORD   - Keystroke record file (write only)
 *    GAME_PLABACK  - Keystroke record file (read only)
 *    GAME_SAVE_AUX - Auxilary (preferred settings) file (write only)
 *    GAME_LOAD_AUX - Auxilary (preferred settings) file (read only)
 */

int get_file_name( char *file_name, char *default_name, int flag )
{
   char buffer[127 + 2];        /* 127 is the biggest positive char */
   int status = 0;

   /* If no default file name then supply the standard name */

   if ( default_name[0] == '\0' )
   {
      if ( flag == GAME_SCRIPT )
         strcpy( default_name, SCRIPT_NAME );
      else if ( flag == GAME_RECORD || flag == GAME_PLAYBACK )
         strcpy( default_name, RECORD_NAME );
      else if ( flag == GAME_SAVE_AUX || GAME_LOAD_AUX )
         strcpy( default_name, AUXILARY_NAME );
      else                      /* (flag == GAME_SAVE || flag == GAME_RESTORE) */
         strcpy( default_name, SAVE_NAME );
   }

   /* Prompt for the file name */

// output_string( "Enter a file name (default is \"" );
// output_string( default_name );
// output_string( "\"): " );

   buffer[0] = 127;
   buffer[1] = 0;
// ( void ) get_line( buffer, 0, 0 );
   strcpy(&buffer[2],default_name);
   if (getfile(&buffer[2])==0) return 1;
   buffer[1]=strlen(&(buffer[2]));

   /* Copy file name from the input buffer */

   if ( h_type > V4 )
   {
      unsigned char len = buffer[1];

      memcpy( file_name, &buffer[2], len );
      file_name[len] = '\0';
   }
   else
      strcpy( file_name, &buffer[1] );

   /* If nothing typed then use the default name */

   if ( file_name[0] == '\0' )
      strcpy( file_name, default_name );

#if !defined(VMS)               /* VMS has file version numbers, so cannot overwrite */

   /* Check if we are going to overwrite the file */

   if ( flag == GAME_SAVE || flag == GAME_SCRIPT || flag == GAME_RECORD || flag == GAME_SAVE_AUX )
   {
      FILE *tfp;

#if defined BUFFER_FILES
      char tfpbuffer[BUFSIZ];
#endif
      char c;

      /* Try to access the file */

      tfp = fopen( file_name, "r" );
      if ( tfp != NULL )
      {
         /* If it succeeded then prompt to overwrite */

#if defined BUFFER_FILES
         setbuf( tfp, tfpbuffer );
#endif

	    output_string( "Overwrite existing file? (Y/N) " );

         do
         {
            c = ( char ) input_character( 0 );
            c = ( char ) toupper( c );
         }
         while ( c != 'Y' && c != 'N' );

         output_char( c );
         output_new_line(  );

         /* If no overwrite then fail the routine */

         if ( c == 'N' )
            status = 1;

         fclose( tfp );
      }
   }
#endif /* !defined(VMS) */

   /* Record the file name if it was OK */

   if ( status == 0 )
      record_line( file_name );

   return ( status );

}                               /* get_file_name */

#if !defined(AMIGA)

/*
 * fatal
 *
 * Display message and stop interpreter.
 *
 */

void fatal( const char *s )
{
   char myerr[512], myerr1[512];
   reset_screen(  );
   sprintf ( myerr1, "%s|PC = 0x%08lX", s, pc );
   strcpy(myerr,"[3][Fatal Error!|");
   strcat(myerr,myerr1);
   strcat(myerr,"][Exit]");
   form_alert(1,myerr);
   appl_exit();
   exit(1);
}                               /* fatal */

#endif /* !defined(AMIGA) */

/*
 * report_strictz_error
 *
 * This handles Z-code error conditions which ought to be fatal errors,
 * but which players might want to ignore for the sake of finishing the
 * game.
 *
 * The error is provided as both a numeric code and a string. This allows
 * us to print a warning the first time a particular error occurs, and
 * ignore it thereafter.
 *
 * errnum : Numeric code for error (0 to STRICTZ_NUM_ERRORS-1)
 * errstr : Text description of error
 *
 */

#ifdef STRICTZ

void report_strictz_error( int errnum, const char *errstr )
{
   int wasfirst;
   char buf[256] = { 0 };

   if ( errnum <= 0 || errnum >= STRICTZ_NUM_ERRORS )
      return;

   if ( strictz_report_mode == STRICTZ_REPORT_FATAL )
   {
      sprintf( buf, "STRICTZ: %s (PC = %lx)", errstr, pc );
      fatal( buf );
      return;
   }

   wasfirst = ( strictz_error_count[errnum] == 0 );
   strictz_error_count[errnum]++;

   if ( ( strictz_report_mode == STRICTZ_REPORT_ALWAYS ) ||
        ( strictz_report_mode == STRICTZ_REPORT_ONCE && wasfirst ) )
   {
	 sprintf( buf, "STRICTZ Warning: %s (PC = %lx)", errstr, pc );
	 write_string( buf );

      if ( strictz_report_mode == STRICTZ_REPORT_ONCE )
      {
         write_string( " (will ignore further occurrences)" );
      }
      else
      {
         sprintf( buf, " (occurrence %d)", strictz_error_count[errnum] );
         write_string( buf );
      }
      z_new_line(  );
   }

}                               /* report_strictz_error */

#endif /* STRICTZ */


#if !defined(AMIGA)

/*
 * fit_line
 *
 * This routine determines whether a line of text will still fit
 * on the screen.
 *
 * line : Line of text to test.
 * pos  : Length of text line (in characters).
 * max  : Maximum number of characters to fit on the screen.
 *
 */
int fit_line( const char *line_buffer, int pos, int max )
{
   UNUSEDVAR( line_buffer );

   return ( pos < max );
}                               /* fit_line */

#endif /* !defined(AMIGA) */

#if !defined(AMIGA)

/*
 * print_status
 *
 * Print the status line (type 3 games only).
 *
 * argv[0] : Location name
 * argv[1] : Moves/Time
 * argv[2] : Score
 *
 * Depending on how many arguments are passed to this routine
 * it is to print the status line. The rendering attributes
 * and the status line window will be have been activated
 * when this routine is called. It is to return FALSE if it
 * cannot render the status line in which case the interpreter
 * will use display_char() to render it on its own.
 *
 * This routine has been provided in order to support
 * proportional-spaced fonts.
 *
 */

int print_status( int argc, char *argv[] )
{
   UNUSEDVAR( argc );
   UNUSEDVAR( argv );

   return ( FALSE );
}                               /* print_status */

#endif /* !defined(AMIGA) */

#if !defined(AMIGA)

/*
 * set_font
 *
 * Set a new character font. Font can be either be:
 *
 *    TEXT_FONT (1)     = normal text character font
 *    GRAPHICS_FONT (3) = graphical character font
 *
 */

void set_font( int font_type )
{
   UNUSEDVAR( font_type );
}                               /* set_font */

#endif /* !defined(AMIGA) */

#if !defined MSDOS && !defined OS2 && !defined AMIGA && !defined HARD_COLORS && !defined ATARIST

/*
 * set_colours
 *
 * Sets screen foreground and background colours.
 *
 */

void set_colours( zword_t foreground, zword_t background )
{

}                               /* set_colours */

#endif  /* !defined MSDOS && !defined OS2 && !defined AMIGA !defined HARD_COLORS && !defined ATARIST */

#if !defined VMS && !defined MSDOS && !defined OS2 && !defined POSIX

/*
 * codes_to_text
 *
 * Translate Z-code characters to machine specific characters. These characters
 * include line drawing characters and international characters.
 *
 * The routine takes one of the Z-code characters from the following table and
 * writes the machine specific text replacement. The target replacement buffer
 * is defined by MAX_TEXT_SIZE in ztypes.h. The replacement text should be in a
 * normal C, zero terminated, string.
 *
 * Return 0 if a translation was available, otherwise 1.
 *
 *  Arrow characters (0x18 - 0x1b):
 *
 *  0x18 Up arrow
 *  0x19 Down arrow
 *  0x1a Right arrow
 *  0x1b Left arrow
 *
 *  International characters (0x9b - 0xa3):
 *
 *  0x9b a umlaut (ae)
 *  0x9c o umlaut (oe)
 *  0x9d u umlaut (ue)
 *  0x9e A umlaut (Ae)
 *  0x9f O umlaut (Oe)
 *  0xa0 U umlaut (Ue)
 *  0xa1 sz (ss)
 *  0xa2 open quote (>>)
 *  0xa3 close quota (<<)
 *
 *  Line drawing characters (0xb3 - 0xda):
 *
 *  0xb3 vertical line (|)
 *  0xba double vertical line (#)
 *  0xc4 horizontal line (-)
 *  0xcd double horizontal line (=)
 *  all other are corner pieces (+)
 *
 */

int codes_to_text( int c, char *s )
{
   return 1;
}                               /* codes_to_text */

#endif  /* !defined VMS && !defined MSDOS && !defined OS2 && !defined POSIX */
