/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import terminal.MyRecordStore;

public class Settings
extends MyRecordStore {
    public String storyfile = "file://localhost/root1/zork2.z3";
    public String storydir = "file://localhost/root1/";
    public static final int DEFAULT_BGCOLOR = 0xFFFFFF;
    public static final int DEFAULT_FGCOLOR = 0;
    public static final int ROT_NORMAL = 0;
    public static final int ROT_270 = 1;
    public static final int ROT_90 = 2;
    public static final int FONT_NORMAL = 0;
    private static final String RMS_NAME = "settings";
    public static int bgcolor;
    public static int fgcolor;
    public static int terminalCols;
    public static int terminalRows;
    public static String terminalType;
    public static int terminalRotated;
    public static int fontMode;
    public static byte lcdFontMode;
    private static Settings me;
    public static boolean terminalFullscreen;
    public static String sessionsImportUrl;
    public static int sshVersionPreferred;
    public static boolean ssh2StoreKey;
    public static byte[] ssh2x;
    public static byte[] ssh2y;
    public static byte[] x;
    public static byte[] y;
    public static int ssh2KeySize;
    public static boolean pollingIO;
    public static boolean predictiveText;
    public static String httpProxy;
    public static int httpProxyMode;

    static {
        me = new Settings();
    }

    public static void init() {
        Settings.defaults();
        me.load(RMS_NAME, false);
    }

    public static void saveSettings() {
        Vector<Object> v = new Vector<Object>();
        v.addElement(null);
        me.save(RMS_NAME, v);
    }

    public static void defaults() {
        bgcolor = 0xFFFFFF;
        fgcolor = 0;
        terminalCols = 0;
        terminalRows = 0;
        terminalType = "";
        terminalRotated = 0;
        fontMode = 4;
        terminalFullscreen = true;
        sshVersionPreferred = 1;
        sessionsImportUrl = "http://";
        ssh2StoreKey = true;
        ssh2x = null;
        ssh2y = null;
        ssh2KeySize = 512;
        pollingIO = false;
        predictiveText = true;
        x = null;
        y = null;
        lcdFontMode = 1;
        httpProxy = "";
        httpProxyMode = 0;
    }

    protected Object read(DataInputStream in) throws IOException {
        fgcolor = in.readInt();
        bgcolor = in.readInt();
        terminalCols = in.readInt();
        terminalRows = in.readInt();
        terminalType = in.readUTF();
        terminalRotated = in.readInt();
        fontMode = in.readInt();
        terminalFullscreen = in.readBoolean();
        sshVersionPreferred = in.readInt();
        sessionsImportUrl = in.readUTF();
        ssh2StoreKey = in.readBoolean();
        ssh2x = this.readByteArray(in);
        ssh2y = this.readByteArray(in);
        ssh2KeySize = in.readInt();
        pollingIO = in.readBoolean();
        predictiveText = in.readBoolean();
        x = this.readByteArray(in);
        y = this.readByteArray(in);
        lcdFontMode = in.readByte();
        httpProxy = in.readUTF();
        httpProxyMode = in.readByte();
        return null;
    }

    protected void write(DataOutputStream out, Object ob) throws IOException {
        out.writeInt(fgcolor);
        out.writeInt(bgcolor);
        out.writeInt(terminalCols);
        out.writeInt(terminalRows);
        out.writeUTF(terminalType);
        out.writeInt(terminalRotated);
        out.writeInt(fontMode);
        out.writeBoolean(terminalFullscreen);
        out.writeInt(sshVersionPreferred);
        out.writeUTF(sessionsImportUrl);
        out.writeBoolean(ssh2StoreKey);
        this.writeByteArray(out, ssh2x);
        this.writeByteArray(out, ssh2y);
        out.writeInt(ssh2KeySize);
        out.writeBoolean(pollingIO);
        out.writeBoolean(predictiveText);
        this.writeByteArray(out, x);
        this.writeByteArray(out, y);
        out.writeByte(lcdFontMode);
        out.writeUTF(httpProxy);
        out.writeByte(httpProxyMode);
    }

    private byte[] readByteArray(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        byte[] buf = new byte[length];
        in.readFully(buf);
        return buf;
    }

    private void writeByteArray(DataOutputStream out, byte[] ray) throws IOException {
        if (ray != null) {
            out.writeInt(ray.length);
            ((OutputStream)out).write(ray);
        } else {
            out.writeInt(0);
        }
    }
}

