/*
 * Decompiled with CFR 0.152.
 */
package com.zaxsoft.zmachine;

import com.zaxsoft.zmachine.ZUserInterface;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

class ZMemory {
    private ZUserInterface zui;
    byte[] data;
    int dataLength;

    ZMemory() {
    }

    void initialize(ZUserInterface ui, String storyFile) {
        this.zui = ui;
        File f = new File(storyFile);
        if (!(f.exists() && f.canRead() && f.isFile())) {
            this.zui.fatal("Storyfile " + storyFile + " not found.");
        }
        this.dataLength = (int)f.length();
        this.data = new byte[this.dataLength];
        try {
            FileInputStream fis = new FileInputStream(f);
            DataInputStream dis = new DataInputStream(fis);
            dis.readFully(this.data, 0, this.dataLength);
            fis.close();
        }
        catch (IOException ioex) {
            this.zui.fatal("I/O error loading storyfile.");
        }
    }

    int fetchByte(int addr) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        int i = this.data[addr] & 0xFF;
        return i;
    }

    void putByte(int addr, int b) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        this.data[addr] = (byte)(b & 0xFF);
    }

    int fetchWord(int addr) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        int i = (this.data[addr] << 8 | this.data[addr + 1] & 0xFF) & 0xFFFF;
        return i;
    }

    void putWord(int addr, int w) {
        if (addr > this.dataLength - 1) {
            this.zui.fatal("Memory fault: address " + addr);
        }
        this.data[addr] = (byte)(w >> 8 & 0xFF);
        this.data[addr + 1] = (byte)(w & 0xFF);
    }

    void dumpMemory(DataOutputStream dos, int addr, int len) throws IOException {
        dos.write(this.data, addr, len);
    }

    void readMemory(DataInputStream dis, int addr, int len) throws IOException {
        dis.read(this.data, addr, len);
    }
}

