; NSIS script

!include "MUI.nsh"

Name "Zroft"
!Include "version.nsh"
; !define VERSION "0.1" ; defined in version.nsh
OutFile "Zroft-${VERSION}.exe"
InstallDir $PROGRAMFILES\Zroft
InstallDirRegKey HKLM "Software\Vladimir Korablin\Zroft" "InstallPath"

SetCompressor lzma

!define MUI_ABORTWARNING

Var SMFOLDER

!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Header\orange.bmp"
!define MUI_HEADERIMAGE_UNBITMAP "${NSISDIR}\Contrib\Graphics\Header\orange-uninstall.bmp"

!insertmacro MUI_PAGE_LICENSE "..\GPL.txt"
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_STARTMENU Application $SMFOLDER
!insertmacro MUI_PAGE_INSTFILES
!define MUI_FINISHPAGE_SHOWREADME $INSTDIR\Zroft_Readme.txt
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Show Zroft Readme"
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

ShowInstDetails nevershow

Section "Main"
	SetOutPath $INSTDIR
	File ..\Zroft_Readme.txt
	File ..\Frostz_Readme.txt
	File "..\Device CAB\Zroft.CAB"
	File Zroft.ini
	ReadRegStr $1 HKEY_LOCAL_MACHINE "Software\Microsoft\Windows\CurrentVersion\App Paths\CEAppMgr.exe" ""
	StrCpy $0 "$INSTDIR\Zroft.ini"
	Call InstallCAB
	; Write the installation path into the registry
	WriteRegStr HKLM "Software\Vladimir Korablin\Zroft" "InstallPath" "$INSTDIR"
	; Write the uninstall keys for Windows
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Zroft" "DisplayName" "Zroft"
	WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Zroft" "UninstallString" '"$INSTDIR\uninstall.exe"'
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Zroft" "NoModify" 1
	WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Zroft" "NoRepair" 1
	!insertmacro MUI_STARTMENU_WRITE_BEGIN Application
		CreateDirectory "$SMPROGRAMS\$SMFOLDER"
		CreateShortCut "$SMPROGRAMS\Zroft\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
	!insertmacro MUI_STARTMENU_WRITE_END
	WriteUninstaller "Uninstall.exe"
SectionEnd

Section "Uninstall"
    DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Zroft"
    DeleteRegKey HKLM "Software\Vladimir Korablin\Zroft"

    Delete $INSTDIR\Zroft.cab
    Delete $INSTDIR\Zroft.ini
    Delete $INSTDIR\Uninstall.exe

    ; Remove shortcuts, if any
    !insertmacro MUI_STARTMENU_GETFOLDER Application $R0
    Delete "$SMPROGRAMS\$R0\*.*"

    RMDir "$SMPROGRAMS\Zroft"
    RMDir "$INSTDIR"
SectionEnd

Function InstallCAB
	;MessageBox MB_OK '"$1" "$0"'
	ExecWait '"$1" "$0"'
FunctionEnd
