/*
CoverPage.cpp: the 'about this game' dialog.

Copyright (C) 2007 Vladimir Korablin

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/

#include "CoverPage.h"
#include "ZroftApp.h"
#include "BabelZroft.h"

extern "C" {
#include "blorb/blorb.h"
}

//extern "C" {
#include "Utils.h"
//}

#include <aygshell.h>

extern ZroftApp Application;

static void SwitchToDescription(HWND hDlg)
{
    ShowWindow(GetDlgItem(hDlg, IDC_COVERPAGE_DESC), SW_SHOW);
    ShowWindow(GetDlgItem(hDlg, IDC_COVER_IMAGE), SW_HIDE);
    SetWindowText(GetDlgItem(hDlg, IDC_BUTTON_TOGGLE), L"Cover art");
}
static void SwitchToImage(HWND hDlg)
{
    ShowWindow(GetDlgItem(hDlg, IDC_COVERPAGE_DESC), SW_HIDE);
    ShowWindow(GetDlgItem(hDlg, IDC_COVER_IMAGE), SW_SHOW);
    SetWindowText(GetDlgItem(hDlg, IDC_BUTTON_TOGGLE), L"Description");
    SendMessage(hDlg, WM_PAINT, 0, 0);
}

static HBITMAP LoadBitmap()
{
    // 1. Get cover image.
    bb_map_t* blorb_map;

    FILE *fp = fopen(Application.sStoryFile, "rb");
    if(!fp) return NULL;

    bb_create_map(fp, &blorb_map);
    HBITMAP hBmp = load_cover_page(blorb_map);
    bb_destroy_map(blorb_map);
    fclose(fp);
    return hBmp;
}


//****************************************************************************
//		DlgCoverPage
//	Dialog Box event handling procedure
//****************************************************************************
LRESULT CALLBACK DlgCoverPage (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    HDC hdc;
    PAINTSTRUCT ps;
    SHINITDLGINFO shidi;
    static int BmpId = IDB_FROSTZ;
    static int IntBmpId = IDB_IBM_PC;
    static HBITMAP hCoverBmp;
    static HWND hPreviousDialog;
    static HFONT hSmallishFont;

    switch (message)
    {	
    case WM_DESTROY:
        DeleteObject(hSmallishFont);
        Application.disregardWmSize = false;
        Application.Message(WM_SIZE);
        break;

    case WM_KILLBITMAP:
        CloseHandle(hCoverBmp);
        hCoverBmp = NULL;
        break;

    case WM_LOADBITMAP:
        if(!hCoverBmp) {
            hCoverBmp = LoadBitmap();
        }

    case WM_INITDIALOG:
        hPreviousDialog = hDlg;
        SHFullScreen(Application.GetMainWnd(), SHFS_SHOWTASKBAR);
        shidi.dwMask = SHIDIM_FLAGS;
        shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
        shidi.hDlg = hDlg;
        SHInitDialog (&shidi);

        SetDlgItemTextW(hDlg, IDC_GAMETITLE, (Application.storyInfo.title != L"") ? 
            Application.storyInfo.title : L"(Unknown title)");
        SetDlgItemTextW(hDlg, IDC_COVERPAGE_DESC, Application.storyInfo.description);

        {
            // Set font.
            LOGFONT logFont;
            memset(&logFont, 0, sizeof(logFont));
            HWND hDescText = GetDlgItem(hDlg, IDC_COVERPAGE_DESC);
            HDC hDC = GetDC(hDescText);
            // Set size of 8 pt. See MSDN.
            logFont.lfHeight = -(8 * GetDeviceCaps(hDC, LOGPIXELSY) / 72);
            ReleaseDC(hDescText, hDC);
            hSmallishFont = CreateFontIndirect(&logFont);
            SendMessage(hDescText, WM_SETFONT, (WPARAM)hSmallishFont, 0);
            CloseHandle(hDescText);
        }

        // So that WM_SIZE handling code won't attempt to restore SIP.
        Application.disregardWmSize = true;
        SipShowIM(SIPF_OFF);
        return TRUE;

    case WM_PAINT:
        SipShowIM (SIPF_OFF);
        if(!hCoverBmp) {
            hCoverBmp = LoadBitmap();
        }
        {
            if(!hCoverBmp) {
                SwitchToDescription(hDlg);
                EnableWindow(GetDlgItem(hDlg, IDC_BUTTON_TOGGLE), FALSE);
                return FALSE;
            }

            // Get image control.
            HWND hImageControl = GetDlgItem (hDlg, IDC_COVER_IMAGE);
            RECT picRect;
            GetWindowRect(hImageControl, &picRect);
            POINT point;
            point.x = picRect.left;
            point.y = picRect.top;
            ScreenToClient(hDlg, &point);
            // Resize image control.
            MoveWindow(hImageControl, 
                point.x, point.y, // Upper left corner relative to dialog's client area
                205, 205, // Lower right
                TRUE); // repaint?

            // Begin painting
            hdc = BeginPaint (hImageControl, &ps);
            BITMAPINFO binfo;
            GetObject(hCoverBmp, sizeof(binfo), &binfo);
            HDC hdcMem = CreateCompatibleDC (NULL);
            HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, hCoverBmp);

            // Find out target width and height.
            int targHeight;
            int targWidth;
            if(binfo.bmiHeader.biWidth > binfo.bmiHeader.biHeight) {
                // Width > Height
                targWidth = 200;
                targHeight = (int)((double)targWidth /
                    (double)binfo.bmiHeader.biWidth *
                    binfo.bmiHeader.biHeight);
            } else {
                targHeight = 200;
                targWidth = (int)((double)targHeight /
                    (double)binfo.bmiHeader.biHeight *
                    binfo.bmiHeader.biWidth);
            }

            // Draw and resize.
            int stretchResult = StretchBlt (hdc, 
                0, 0,
                targWidth, targHeight,
                hdcMem, 
                0, 0,
                binfo.bmiHeader.biWidth, binfo.bmiHeader.biHeight,
                SRCCOPY);
            SelectObject (hdcMem, hOldBmp);
            DeleteDC (hdcMem);
            CloseHandle(hImageControl);
            EndPaint (hImageControl, &ps);
        }
        break;

    case WM_COMMAND:
        if (LOWORD (wParam) == IDOK)
        {
            if(hCoverBmp) {
                CloseHandle(hCoverBmp);
            }
            EndDialog (hDlg, LOWORD(wParam));
            return TRUE;
        } else if (LOWORD (wParam) == IDC_BUTTON_TOGGLE)
        {
            if(IsWindowVisible(GetDlgItem(hDlg, IDC_COVERPAGE_DESC))) {
                SwitchToImage(hDlg);
            } else {
                SwitchToDescription(hDlg);
            }
            return TRUE;
        }
        break;
    }
    return FALSE;
}
