/*
About.cpp: the about dialog.
Copyright (C) 2005 Fabio Concas
Copyright (C) 2007 Vladimir Korablin

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/
#include "Zroft.h"
//#include "ZroftApp.h"
extern "C" {
#include "Frotz/frotz.h"
};

#include "version.h"

static int GetBmpIdByStoryName(wchar_t *wStoryName) {
    if (!wcsncmp (wStoryName, L"Advent", 6)) // Colossal Cave Adventure
        return IDB_ADVENT;
    else if (!wcsncmp (wStoryName, L"A mind", 6)) // A Mind Forever Voyaging
        return IDB_AMFV;
    else if (!wcsncmp (wStoryName, L"Arthur", 6)) // Arthur - Quest for Excalibur
        return IDB_ARTHUR;
    else if (!wcsncmp (wStoryName, L"Ballyh", 6)) // Ballyhoo
        return IDB_BALLY;
    else if (!wcsncmp (wStoryName, L"Beyond", 6)) // Beyond Zork
        return IDB_BZORK;
    else if (!wcsncmp (wStoryName, L"Border", 6)) // Border Zone
        return IDB_BORDERZ;
    else if (!wcsncmp (wStoryName, L"Bureau", 6)) // Bureaucracy
        return IDB_BUREAU;
    else if (!wcsncmp (wStoryName, L"Cutthr", 6)) // Cuttrhoats
        return IDB_CUTTHROA;
    else if (!wcsncmp (wStoryName, L"Deadli", 6)) // Deadline
        return IDB_DEAD;
    else if (!wcsncmp (wStoryName, L"Enchan", 6)) // Enchanter
        return IDB_ENCHANT;
    else if (!wcsncmp (wStoryName, L"HitchH", 6)) // HitchHiker's Guide to the Galaxy
        return IDB_HITCH;
    else if (!wcsncmp (wStoryName, L"Hollyw", 6)) // Hollywood Hijinks
        return IDB_HOLLY;
    else if (!wcsncmp (wStoryName, L"Infide", 6)) // Infidel
        return IDB_INFIDEL;
    else if (!wcsncmp (wStoryName, L"Journe", 6)) // Journey
        return IDB_JOURNEY;
    else if (!wcsncmp (wStoryName, L"Leathe", 6)) // Leather Goddesses Of Phobos
        return IDB_LEATHER;
    else if (!wcsncmp (wStoryName, L"Lurkin", 6)) // Lurking Horror
        return IDB_LURKING;
    else if (!wcsncmp (wStoryName, L"Mini-Z", 6)) // Mini-Zork I
        return IDB_ZORK1;
    else if (!wcsncmp (wStoryName, L"Moonmi", 6)) // Moonmist
        return IDB_MOON;
    else if (!wcsncmp (wStoryName, L"Nord a", 6)) // Nord and Bert
        return IDB_NORDANDB;
    else if (!wcsncmp (wStoryName, L"Planetf", 7)) // Planetfall
        return IDB_PLANETF;
    else if (!wcsncmp (wStoryName, L"Plunde", 6)) // Plundered Hearts
        return IDB_PLUNDER;
    else if (!wcsncmp (wStoryName, L"Seasta", 6)) // Seastalker
        return IDB_SEASTALK;
    else if (!wcsncmp (wStoryName, L"Sherlo", 6)) // Sherlock - Riddle of the Crown Jewels
        return IDB_SHERLOCK;
    else if (!wcsncmp (wStoryName, L"Shogun", 6)) // Shogun
        return IDB_SHOGUN;
    else if (!wcsncmp (wStoryName, L"Sorcer", 6)) // Sorcerer
        return IDB_SORCERER;
    else if (!wcsncmp (wStoryName, L"Spellb", 6)) // Spellbreaker
        return IDB_SPELLBR;
    else if (!wcsncmp (wStoryName, L"Starcr", 6)) // Starcross
        return IDB_STARCR;
    else if (!wcsncmp (wStoryName, L"Statio", 6)) // Stationfall
        return IDB_STATIONF;
    else if (!wcsncmp (wStoryName, L"Suspec", 6)) // Suspect
        return IDB_SUSPECT;
    else if (!wcsncmp (wStoryName, L"Suspen", 6)) // Suspended
        return IDB_SUSPEND;
    else if (!wcsncmp (wStoryName, L"Trinit", 6)) // Trinity
        return IDB_TRINITY;
    else if (!wcsncmp (wStoryName, L"Wishbr", 6)) // Wishbringer
        return IDB_WISHBRING;
    else if (!wcsncmp (wStoryName, L"Witnes", 6)) // Witness
        return IDB_WITNESS;
    else if (!wcsncmp (wStoryName, L"Zork III", 8)) // Zork III - Dungeon Master
        return IDB_ZORK3;
    else if (!wcsncmp (wStoryName, L"Zork II", 7)) // Zork II - Wizard of Frobozz
        return IDB_ZORK2;
    else if (!wcsncmp (wStoryName, L"Zork I", 6)) // Zork I - Great Underground Empire
        return IDB_ZORK1;
    else if (!wcsncmp (wStoryName, L"Zork -", 6)) // Zork - Undiscovered Underground
        return IDB_ZORKUU;
    else if (!wcsncmp (wStoryName, L"Zork Z", 6)) // Zork Zero - Revenge of Megaboz
        return IDB_ZORK0;
    else
        return IDB_FROSTZ;
}

//****************************************************************************
//		About
//	Dialog Box event handling procedure
//****************************************************************************
LRESULT CALLBACK DlgAbout (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    HWND hFrame = GetDlgItem (hDlg, IDC_GAMEICON);
    HWND hIntFrame = GetDlgItem (hDlg, IDC_INTERPBMP);
    HDC hdc;
    PAINTSTRUCT ps;
    SHINITDLGINFO shidi;
    wchar_t wGameInfo[1024];
    wchar_t wInterpName[256];
    static int BmpId = IDB_FROSTZ;
    static int IntBmpId = IDB_IBM_PC;

    switch (message)
    {	
    case WM_DESTROY:
        Application.GoFullScreen ();
        break;

    case WM_INITDIALOG:
        shidi.dwMask = SHIDIM_FLAGS;
        shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
        shidi.hDlg = hDlg;
        SHInitDialog (&shidi);

        // Write something on the static text dlg items
        if (!Application.isZmachineRunning)
        {
            wsprintf (wGameInfo, L"No story loaded.");
            BmpId = IDB_FROSTZ;

            wsprintf (wInterpName, L"\0");
            IntBmpId = 0;
            ShowWindow (hIntFrame, SW_HIDE);
        }
        else
        {
            wchar_t wSerial[16];
            memset (wSerial, 0, sizeof (wchar_t) * 16);
            mbstowcs (wSerial, (const char*)h_serial, 16);

            //GetWindowText (Application.GetMainWnd (), wStoryName, 64);
            wsprintf (wGameInfo, L"\"%s\"\nRelease: %d, Serial: %s,\nZ-Code V%d (Std %d.%d)",
                Application.storyInfo.title, h_release, wSerial, h_version, h_standard_high, h_standard_low);
            // Choose the right image for the story
            BmpId = GetBmpIdByStoryName(Application.wStoryName);

            //*** Now interpreter info and picture ***
            ShowWindow (hIntFrame, SW_SHOW);
            if (Application.InterpreterNumber == INTERP_DEC_20)
            {
                wcscpy (wInterpName, L"DECSystem 20 Interpreter");
                IntBmpId = IDB_DECSYSTEM_20;
            }
            else if (Application.InterpreterNumber == INTERP_APPLE_IIE)
            {
                wcscpy (wInterpName, L"Apple //e Interpreter");
                IntBmpId = IDB_APPLE_IIE;
            }
            else if (Application.InterpreterNumber == INTERP_MACINTOSH)
            {
                wcscpy (wInterpName, L"Macintosh Interpreter");
                IntBmpId = IDB_MACINTOSH;
            }
            else if (Application.InterpreterNumber == INTERP_AMIGA)
            {
                wcscpy (wInterpName, L"Commodore Amiga Interpreter");
                IntBmpId = IDB_AMIGA;
            }
            else if (Application.InterpreterNumber == INTERP_ATARI_ST)
            {
                wcscpy (wInterpName, L"Atari ST Interpreter");
                IntBmpId = IDB_ATARI_ST;
            }
            else if (Application.InterpreterNumber == INTERP_MSDOS)
            {
                wcscpy (wInterpName, L"IBM PC MS/DOS Interpreter");
                IntBmpId = IDB_IBM_PC;
            }
            else if (Application.InterpreterNumber == INTERP_CBM_128)
            {
                wcscpy (wInterpName, L"Commodore 128 Interpreter");
                IntBmpId = IDB_CBM_128;
            }
            else if (Application.InterpreterNumber == INTERP_CBM_64)
            {
                wcscpy (wInterpName, L"Commodore 64 Interpreter");
                IntBmpId = IDB_CBM_64;
            }
            else if (Application.InterpreterNumber == INTERP_APPLE_IIC)
            {
                wcscpy (wInterpName, L"Apple //c Interpreter");
                IntBmpId = IDB_APPLE_IIC;
            }
            else if (Application.InterpreterNumber == INTERP_APPLE_IIGS)
            {
                wcscpy (wInterpName, L"Apple //gs Interpreter");
                IntBmpId = IDB_APPLE_IIGS;
            }
            else if (Application.InterpreterNumber == INTERP_TANDY)
            {
                wcscpy (wInterpName, L"Tandy Color Interpreter");
                IntBmpId = IDB_TANDY_COLOR;
            }
            else
            {
                wcscpy (wInterpName, L"Unknown Interpreter");
                IntBmpId = 0;
                ShowWindow (hIntFrame, SW_HIDE);
            }

        }

        SetDlgItemTextW(hDlg, IDC_ZROFT_DESC, L"Zroft v" ZROFT_VERSION L"\n(c) 2007 Vladimir Korablin");
        SetDlgItemTextW(hDlg, IDC_GAMEINFO, wGameInfo);
        SetDlgItemTextW(hDlg, IDC_TXT_INTERP, wInterpName);
        return TRUE;

    case WM_PAINT:
        {
            hdc = BeginPaint (hFrame, &ps);

            // Change bitmap icon if a story is loaded
            HBITMAP hBMP = LoadBitmap(Application.GetAppInstance (),
                MAKEINTRESOURCE(BmpId));

            HDC hdcMem = CreateCompatibleDC (NULL);
            HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, hBMP);

            BitBlt (hdc, 0, 0, 32, 32, hdcMem, 0, 0, SRCCOPY);

            SelectObject (hdcMem, hOldBmp);
            DeleteObject (hBMP);
            DeleteDC (hdcMem);

            EndPaint (hFrame, &ps);
        }
        //*** Paint another bitmap for the interpreter
        if (IntBmpId)
        {
            hdc = BeginPaint (hIntFrame, &ps);

            HBITMAP hBMP = LoadBitmap (Application.GetAppInstance (),
                MAKEINTRESOURCE (IntBmpId));
            HDC hdcMem = CreateCompatibleDC (NULL);
            HBITMAP hOldBmp = (HBITMAP)SelectObject (hdcMem, hBMP);

            BitBlt (hdc, 0, 0, 48, 48, hdcMem, 0, 0, SRCCOPY);
            SelectObject (hdcMem, hOldBmp);
            DeleteObject (hBMP);
            DeleteDC (hdcMem);

            EndPaint (hIntFrame, &ps);
        }
        break;

    case WM_COMMAND:
        if (LOWORD (wParam) == IDOK)
        {
            EndDialog (hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }
    return FALSE;
}
