/*
 * redirect.c
 *
 * Output redirection to Z-machine memory
 *
 */

#include "frotz.h"
#include "s5api.h"

extern zword get_max_width (struct sg *g, zword);



/*
 * memory_open
 *
 * Begin output redirection to the memory of the Z-machine.
 *
 */

void memory_open (struct sg *g, zword table, zword xsize, short buffering)
{

    if (++(g->depth) < MAX_NESTING) {

	if (!buffering)
	    xsize = 0xffff;
	if (buffering && (short) xsize <= 0)
	    xsize = get_max_width (g,(zword) (- (short) xsize));

	storew (g,table, 0);

	g->redirect[g->depth].table = table;
	g->redirect[g->depth].width = 0;
	g->redirect[g->depth].total = 0;
	g->redirect[g->depth].xsize = xsize;

	g->ostream_memory = TRUE;

   } else runtime_error (g,"Nesting stream #3 too deep");

}/* memory_open */

/*
 * memory_new_line
 *
 * Redirect a newline to the memory of the Z-machine.
 *
 */

void memory_new_line (struct sg *g)
{
    zword size;
    zword addr;

    g->redirect[g->depth].total += g->redirect[g->depth].width;
    g->redirect[g->depth].width = 0;

    addr = g->redirect[g->depth].table;

    LOW_WORD (addr, size)
    addr += 2;

    if (g->redirect[g->depth].xsize != 0xffff) {

	g->redirect[g->depth].table = addr + size;
	size = 0;

    } else storeb (g,(zword) (addr + (size++)), 13);

    storew (g,g->redirect[g->depth].table, size);

}/* memory_new_line */

/*
 * memory_word
 *
 * Redirect a string of characters to the memory of the Z-machine.
 *
 */

void memory_word (struct sg *g, const zchar *s)
{
    zword size;
    zword addr;
    zchar c;

    if (g->h_version == V6) {

	short width = os_string_width (g,s);

	if (g->redirect[g->depth].xsize != 0xffff)

	    if (g->redirect[g->depth].width + width > g->redirect[g->depth].xsize) {

		if (*s == ' ' || *s == ZC_INDENT || *s == ZC_GAP)
		    width = os_string_width (g,++s);

		memory_new_line (g);

	    }

	g->redirect[g->depth].width += width;

    }

    addr = g->redirect[g->depth].table;

    LOW_WORD (addr, size)
    addr += 2;

    while ((c = *s++) != 0)
	storeb (g,(zword) (addr + (size++)), (unsigned char)translate_to_zscii (g,c));

    storew (g,g->redirect[g->depth].table, size);

}/* memory_word */

/*
 * memory_close
 *
 * End of output redirection.
 *
 */

void memory_close (struct sg *g)
{

    if (g->depth >= 0) {

	if (g->redirect[g->depth].xsize != 0xffff)
	    memory_new_line (g);

	if (g->h_version == V6) {

	    g->h_line_width = (g->redirect[g->depth].xsize != 0xffff) ?
		g->redirect[g->depth].total : g->redirect[g->depth].width;

	    SET_WORD (H_LINE_WIDTH, g->h_line_width)

	}

	if (g->depth == 0)
	    g->ostream_memory = FALSE;

	(g->depth)--;

    }

}/* memory_close */
