// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib includes
// ----------------------------------------------------------------------------

#include <PA9.h>
#include <stdio.h> 

// ----------------------------------------------------------------------------
// project includes
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"
#include "sound.h"

#include "frotz.h"

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------

#include "gfx/all_gfx.h"

// ----------------------------------------------------------------------------
// GLOBAL VARIABLES
// ----------------------------------------------------------------------------

int								gDSdebugMode			= 0;

int								gDSDebugPosY			= 999;
char							gDebugBuffer[1024];

char							gGameName[40];
int								gGameID;
void*							gGameData;
int								gGameDataSize;

char							gGameSavFileFormat[80];

// ----------------------------------------------------------------------------
// EXTERNALS
// ----------------------------------------------------------------------------

extern void 					interpret 		( void );
extern void 					init_memory 	( void );
extern void 					init_undo 		( void );
extern void 					reset_memory 	( void );

extern void 					StartRainbow	( void );
extern void 					PlayRainbow		( void );
extern void 					EndRainbow		( void );

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

void SetGameName( char* _name )
{
	strcpy( gGameName, _name );
}

char* GetGameName( void )
{
	return gGameName;
}

// ----------------------------------------------------------------------------
// GAME DATA MANAGEMENT
// ----------------------------------------------------------------------------

void GetGameNameFromIndex( char* _name, int _index )
{
	if ( _index > -1 )
	{ 
		strcpy( _name, gAdventureDescriptions[_index].name );
	}
	else
	{
		strcpy( _name, "" );
	}
}

// ----------------------------------------------------------------------------
// GAME DATA MANAGEMENT
// ----------------------------------------------------------------------------

bool GetGameDataFromName( char* _name, void** _dataPtr, int*  _dataSize )
{
	int		i = 0;
	
	while( gAdventureDescriptions[i].title1 != NULL )
	{
		if ( (gAdventureDescriptions[i].name != NULL) && !strcmp( gAdventureDescriptions[i].name, _name ) )
		{
			*_dataPtr 	= gAdventureDescriptions[i].data;
			*_dataSize	= gAdventureDescriptions[i].dataSize;
			return true;
		}
		i ++;
	}
	
	*_dataPtr 	= NULL; 				
	*_dataSize	= 0;
	return false;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// GAMES MENU PAGE
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

int mainStartPage( int choice )
{
	bool	redrawTop		= true;
	bool	redrawBottom	= true;
	int		stylusPosY		= -1;
	int		skipLines 		= 0;
	int		origSkipLines 	= 0;

	SoundPlay		( SOUND_INTRO );

	while( true )
	{
		if ( redrawTop )
		{
			LoadBackgroundImageFromIndex( choice );
			redrawTop = false;
		}
			
		if ( redrawBottom )
		{
			FILL_SCREEN		( BOTTOM_SCREEN, 17 );
			DRAW_RECT		( BOTTOM_SCREEN, 8, 6, 247, 46, 19 );
			DRAW_HLINE		( BOTTOM_SCREEN, 10, 248, 47, 7 );
			DRAW_VLINE		( BOTTOM_SCREEN, 248, 8, 47, 7 );
			if ( gAdventureDescriptions[choice].title1[0] && gAdventureDescriptions[choice].title2[0] )
			{
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].title1, 		12, 31, 7, 240 );
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].title2, 		32, 33, 7, 240 );
			}
			else
			{
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].title1, 		22, 31, 7, 240 );
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].title2, 		22, 33, 7, 240 );
			}
			
			int yy = 60;
			if ( gAdventureDescriptions[choice].authors[0] )
			{ 
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].authors, 	yy, 31,7, 240 ); yy += 20;
			}
			if ( gAdventureDescriptions[choice].editor[0] )
			{ 
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].editor, 	yy, 31,7, 240 ); yy += 20;
			}
			if ( gAdventureDescriptions[choice].date[0] )
			{ 
				PRINT_CSTRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].date, 		yy, 31,7, 240 ); yy += 20;
			}
			SkipLines( skipLines );
			PRINT_STRING	( BOTTOM_SCREEN, gAdventureDescriptions[choice].desc , 			12, yy, 31 , 7, 240 );
			SkipLines( 0 );
			redrawBottom	= false;
		}

		if ( Stylus.Newpress )
		{
			stylusPosY	= -1;
		}
		else if ( Stylus.Held )
		{	
			PA_WaitForVBL();
			if ( stylusPosY < 0 ) { origSkipLines = skipLines; stylusPosY = Stylus.Y; }
			int newSkipLines = origSkipLines + (stylusPosY - Stylus.Y) / 10;
			if ( newSkipLines < 0 ) newSkipLines = 0;
			if ( newSkipLines != skipLines )
			{
				skipLines		= newSkipLines;
				redrawBottom	= true;
			}
		}
		else if ( Pad.Newpress.Down || Pad.Held.Down )
		{	
			PA_WaitForVBL();
			skipLines ++;
			redrawBottom	= true;
		}
		else if ( Pad.Newpress.Up || Pad.Held.Up )
		{	
			PA_WaitForVBL();
			if ( skipLines > 0 )
			{
				skipLines --;
				redrawBottom	= true;
			}
		}
		else if ( Pad.Newpress.L || Pad.Newpress.Left )
		{
			choice 			= (choice + (gNbMenuPages-1)) % gNbMenuPages;
			skipLines 		= 0;
			redrawTop		= true;
			redrawBottom	= true;
		}
		else if ( Pad.Newpress.R || Pad.Newpress.Right )	//|| Stylus.Newpress )
		{
			choice 			= (choice + 1) % gNbMenuPages;
			skipLines 		= 0;
			redrawTop		= true;
			redrawBottom	= true;
		}
		else if ( Pad.Newpress.A || Pad.Newpress.Start )
		{
			if ( gAdventureDescriptions[choice].data ) 	// if game data is valid, choose it...
			{
				PA_WaitForVBL();
				break;
			}
			else if ( Pad.Newpress.A )
			{
				choice 			= (choice + 1) % gNbMenuPages;
				skipLines 		= 0;
				redrawTop		= true;
				redrawBottom	= true;
			}
		}
		PlayRainbow();
		PA_WaitForVBL();
	}

	PA_DeleteBg		( TOP_SCREEN, TILED_BG_INDEX );
	FILL_SCREEN		( BOTTOM_SCREEN, 12 );
	SoundStop		( SOUND_INTRO );
	
	return choice;
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// MAIN END PAGE
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

int mainEndPage( void )
{
	HideSprites();

	FILL_SCREEN		( TOP_SCREEN, 12 );

	PA_DeleteBg		( BOTTOM_SCREEN, TILED_BG_INDEX );
	FILL_SCREEN		( BOTTOM_SCREEN, 12 );
	PRINT_CSTRING	( BOTTOM_SCREEN, "- it is the end -", 	90, 31, 7, 256 );

	while( true )
	{
		if ( Pad.Newpress.Start || Pad.Newpress.A )
		{
			break;
		}
		else if ( Stylus.Newpress )
		{
			while( Stylus.Held ) { PA_WaitForVBL(); }
			break;
		}
		PA_WaitForVBL();
	}

	return 1;
}

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// MAIN PLAYING LOOP
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------


int mainPlayingLoop( char *_story_name, void* data )
{
	InitGFX			();
	
    init_err		();

    init_memory		();

    os_init_screen	();

    init_undo		();

    z_restart		();

    interpret		();

    reset_memory	();

    os_reset_screen	();

	mainEndPage		();

	return 1;
} 

// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// MAIN ENTRY POINT
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

int main( int argc, char ** argv )
{
	// Initializes PA_Lib

	PA_Init();  
  
	// Initializes a standard VBL
	
	PA_InitVBL(); 

	// Init the random

	PA_InitRand();

	// Init the SCREENS

	InitScreens();

	// Init the sound system
DBG_MSG(  "PA_InitSound %d", 0 );
	PA_InitSound();  
	
DBG_MSG(  "SOUND INIT %d", 0 );
	Sounds_Init();

	// Init the FAT
DBG_MSG(  "PF_InitFat%d", 0 );
	PF_InitFat();

	// Infinite loop to keep the program running

	int adventureIndex = 1;
	
	while( 1 )
	{
		strcpy( gGameName, "" );
		gGameID 		= 0;
		gGameData		= NULL;
		gGameDataSize	= 0;

		adventureIndex = mainStartPage( adventureIndex );

		GetGameNameFromIndex( gGameName, adventureIndex );

		GetGameDataFromName( gGameName, &gGameData, &gGameDataSize );

		sprintf( gGameSavFileFormat, "%s_%%d.sav", gGameName );
		
		if ( !strcmp( gGameName, "Freefall" ) )
		{
			gGameID = GAME_ID_FREEFALL;
		}

		if ( gGameData )
		{
			mainPlayingLoop( gGameName, gGameData );

			SetFatalMessage	( "" );
			SetMessage		( "" );
			SetOrder		( "", false );
		}
	}
	
	return 0;
} 

// ----------------------------------------------------------------------------
// (c) papafuji - 2006 - using PAlib
// ----------------------------------------------------------------------------
