
#ifndef routine_h_INCLUDED
#define routine_h_INCLUDED

#include "types.h"

#ifndef routine_c_INCLUDED
extern int16_t number_of_stack_frames;
#endif /* routine_c_INCLUDED */

void return_from_routine(int16_t result_value);
void call_routine(uint32_t target_routine_address,
    uint8_t result_variable_number, bool discard_result,
    uint8_t number_of_arguments);
void opcode_call(void);
void opcode_ret(void);
void opcode_rfalse(void);
void opcode_rtrue(void);
void opcode_jump(void);
void opcode_ret_popped(void);
void opcode_quit(void);
void opcode_call_2s(void);
void opcode_call_2n(void);
void opcode_call_1s(void);
void opcode_call_1n(void);
void opcode_nop(void);
void opcode_call_vn(void);
void opcode_throw(void);
void opcode_catch(void);
void opcode_call_vs2(void);
void opcode_call_vn2(void);

#endif /* routine_h_INCLUDED */

