
#ifndef fizmo_h_INCLUDED 
#define fizmo_h_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "../c/screen_interface.h"
#include "../c/sound_interface.h"
#include "blockbuf.h"

#define FIZMO_VERSION "0.6.1"

#define FIZMO_INTERPRETER_NUMBER 6
/*
From: http://www.logicalshift.demon.co.uk/unix/zoom/manual/configXwin.html
 1 - Infocom's internal debugging interpreter
 2 - Applie IIe interpreter
 3 - Macintosh
 4 - Amiga (colour behaviour can change if you specify this)
 5 - Atari ST
 6 - IBM PC
 7 - Commodore 128
 8 - Commodore 64
 9 - Apple IIc
10 - Apple IIgs
11 - Tandy Color
*/

#define FIZMO_INTERPRETER_REVISION 'b';

#define SCORE_MODE_UNKNOWN 0
#define SCORE_MODE_SCORE_AND_TURN 1
#define SCORE_MODE_TIME 2

#define OBEYS_SPEC_MAJOR_REVISION_NUMER 1
#define OBEYS_SPEC_MINOR_REVISION_NUMER 0


void fizmo_register_screen_interface(
    struct z_screen_interface *screen_interface);
void fizmo_register_sound_interface(
    struct z_sound_interface *sound_interface);
void link_active_interface_to_story(bool set_only_restart_flags);
void fizmo_start(char* z_story_filename, char *blorb_filename,
    char *restore_on_start_filename);
void fizmo_new_screen_size(uint8_t width, uint8_t height);
int close_interface(z_ucs /*@null@*/ *error_message);
void *fizmo_malloc(size_t size);
void *fizmo_realloc(void *ptr, size_t size);
char *fizmo_strdup(char *s1);
int ensure_mem_size(char **ptr, int *current_size, int size);
char *get_fizmo_config_dir_name();
void ensure_dot_fizmo_dir_exists();
int parse_fizmo_config_files();
char *quote_special_chars(char *s);
char *unquote_special_chars(char *s);
struct z_story_blorb_image *get_image_blorb_index(struct z_story *story,
    int resource_number);
struct z_story_blorb_sound *get_sound_blorb_index(struct z_story *story,
    int resource_number);

#ifndef fizmo_c_INCLUDED 
extern struct commandline_parameter *interpreter_commandline_parameters[];
extern struct z_screen_interface *active_interface;
extern struct z_sound_interface *active_sound_interface;
extern struct z_story *active_z_story;
extern uint8_t ver;
extern uint8_t *header_extension_table;
extern uint8_t header_extension_table_size;

#ifndef DISABLE_BLOCKBUFFER
/*@null@*/ extern BLOCKBUF *upper_window_buffer;
#endif /* DISABLE_BLOCKBUFFER */

#endif /* fizmo_c_INCLUDED */

#endif /* fizmo_h_INCLUDED */

