
#ifndef filelist_h_INCLUDED
#define filelist_h_INCLUDED

#include "types.h"

struct z_story_list
{
  struct z_story_list_entry **entries;
  int nof_entries_allocated;
  int nof_entries;
};

struct z_story_list_entry
{
  uint16_t release_number;
  char *serial;
  int length;
  uint16_t checksum;
  uint8_t z_code_version;
  char *title;
  char *author;
  char *description;
  char *filename;
  char *blorbfile;
  char *filetype;
  long storyfile_timestamp;
};

void free_z_story_list(struct z_story_list *story_list);
void free_z_story_list_entry(struct z_story_list_entry *entry);
struct z_story_list *get_z_story_list();
struct z_story_list_entry *get_z_story_entry_from_list(char *serial,
    uint16_t release, uint16_t checksum);
//void build_filelist(char *root_dir, struct z_story_list *story_list,
//    bool recursive);
struct z_story_list *update_fizmo_story_list(char *fizmo_dir);
void detect_and_add_single_z_file(char *input_filename, char *blorb_filename);
void search_directory(char *absolute_dirname, bool recursive);

#endif /* filelist_h_INCLUDED */

